<?php

$idioma = "es";
if (isset($_COOKIE["idioma"])) {
    $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
}

?>
<div id="mainTwo" v-cloak>
	<div class="animated fadeIn">
		<div class="col s12 card-panel white dv-content" style="margin-top: 75px;">
			<h5>{{traducirFrase("Reporte de Salientes por Hora de Servicio")}}</h5>
			<div id="spinner">
				<center><img src="<?=IMG_ADMIN;?>spinner.gif" id='barrita'></center>
			</div>
			<div class="row no-bottom dv-flex dv-centered">
				<div class="col dv-flex-grow-1 input-field">
					<label class="active">{{traducirFrase("Fecha")}}</label>
					<input type="text" autocomplete="off" class=" datepicker-here" data-range="true" data-multiple-dates-separator=" - " data-date-format="yyyy-mm-dd" data-language="<?=$idioma;?>" class="datepicker-here" id="fechaReporte" />
				</div>
				<div class="col dv-flex-grow-1 input-field">
					<select v-model="campana" id="campanaReporte" class="browser-default">
						<option v-for="op in options" :value="op.value">{{op.label}}</option>
					</select>
					<label for="selectCampana" class="active">{{traducirFrase("Campaña")}}</label>
				</div>
				<div class="col">
					<button class="waves-effect waves-light btn teal" @click="load()">
						{{traducirFrase("Generar reporte")}}
					</button>
					<div class="waves-effect waves-light btn blue" @click="descargar()">
						{{traducirFrase("Descargar reporte")}}
					</div>
				</div>
			</div>
			<div class="row no-bottom">
				<div class="col s12">
					<label for='archived'>
						<input type="checkbox" v-model="archived" id="archived" />
						<span>{{traducirFrase("Información archivada")}}</span>
					</label>
				</div>
			</div>
			<div class="row dv-flex dv-centered">
				<div id="dv-contenedor-grafica" ref="grafica" style="max-width: 100%;flex-grow: 1;">
				</div>
			</div>
			<div class="row">
				<div class="col s12">
					<div class="row col s12">
						<h6>
							{{traducirFrase("General acumulado")}}
						</h6>
					</div>
					<div class="row col s12">
						<div class="row">
							<div class="col s4">
								<div class="card teal lighten-5">
									<div class="card-content">
										<h6 class="center-align teal-text text-darken-3">
											{{general.Totales}}
										</h6>
										<p class="center-align teal-text text-darken-3">
											{{traducirFrase("Llamadas totales")}}
										</p>
									</div>
								</div>
							</div>
							<div class="col s4">
								<div class="card cyan lighten-5">
									<div class="card-content">
										<h6 class="center-align cyan-text text-darken-3">
											{{general.TotalSistema}}
										</h6>
										<p class="center-align cyan-text text-darken-3">
											{{traducirFrase("Llamadas del sistema")}}
										</p>
									</div>
								</div>
							</div>
							<div class="col s4">
								<div class="card light-blue lighten-5">
									<div class="card-content">
										<h6 class="center-align light-blue-text text-darken-3">
											{{general.TotalAgentCalls}}
										</h6>
										<p class="center-align light-blue-text text-darken-3">
											{{traducirFrase("Llamadas de agente")}}
										</p>
									</div>
								</div>
							</div>
						</div>
						<div class="row dv-flex dv-stretch">
							<div class="col s2 dv-flex dv-stretch" v-for="tarjeta in tarjetasGeneral">
								<div class="card dv-flex dv-centered" style="width: 100%;">
									<div class="card-content">
										<h6 class="center-align">
											{{general[tarjeta.value]}}
										</h6>
										<p class="center-align">
											{{tarjeta.label}}
										</p>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="row col s12">
						<h6>
							{{traducirFrase("Desglose por horas")}}
						</h6>
					</div>
					<div class="row col s12">
						<table-dialvox :headers="headers" :data="desglose" :hsearch="true" />
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<!-- END MAIN -->
<!-- ================================================
    Scripts
    ================================================ -->
<?php require_once "script.php";?>