<?php

$idioma = "es";
if (isset($_COOKIE["idioma"])) {
    $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
}

?>
<div id="mainTwo" v-cloak>
	<div class="animated fadeIn">
		<div class="col s12 card-panel white dv-content">
			<h5>{{traducirFrase("Reporte de Salientes por Hora de Servicio")}}</h5>
			<div v-if="loading">
				<center><img src="<?=IMG_ADMIN;?>spinner.gif" ></center>
			</div>
			<div class="row no-bottom dv-flex dv-centered">
				<div class="col dv-flex-grow-1 input-field">
					<select v-model="encuesta" class="browser-default">
						<option v-for="op in encuestas" :value="op.value">{{op.label}}</option>
					</select>
					<label for="selectCampana" class="active">{{traducirFrase("Encuestas")}}</label>
				</div>
				<div class="col dv-flex-grow-1 input-field">
					<label class="active">{{traducirFrase("Fecha")}}</label>
					<input type="text" autocomplete="off" class=" datepicker-here" data-range="true" data-multiple-dates-separator=" - " data-date-format="yyyy-mm-dd" data-language="<?=$idioma;?>" class="datepicker-here" id="fecha" />
				</div>
				<div class="col dv-flex-grow-1 input-field">
					<label class="active">{{traducirFrase("Campaña")}}</label>
					<select id="selectCampanas" multiple v-model="campana">
						<option disabled>Selecciona una campaña</option>
						<option v-for="val in campanas" :value="val.value"> {{ val.label }} </option>
					</select>
				</div>
				<div class="col">
					<button class="waves-effect waves-light btn teal" @click="load()">
						{{traducirFrase("Cargar")}}
					</button>
					<div class="waves-effect waves-light btn blue" @click="descargar()">
						{{traducirFrase("Descargar reporte")}}
					</div>
				</div>
			</div>
			<div class="row no-bottom">
				<div class="col s12">
					<label for='archived'>
						<input type="checkbox" v-model="hideInvalidAnswer" id="archived" />
						<span>{{traducirFrase("Excluir respuestas inválidas en la gráfica")}}</span>
					</label>
				</div>
			</div>
			<div class="row dv-flex dv-centered">
				<div id="dv-sunburst" style="width: 100%; flex-grow: 1; height: 70vh;"></div>
			</div>
		</div>
	</div>
</div>
<!-- END MAIN -->
<!-- ================================================
    Scripts
    ================================================ -->
<?php require_once "script.php";?>