<script>
	var banderaEditar = true;
	var app = new Vue({
		el: '#main',
		data: {
			ls: localStorage.getItem('background'),
			pagina: 1,
			dataTable: {},
			dataBufferEdit: {
				list_id: "",
				list_name: "",
				campaign_id: "",
				list_description: ""
			},
			value: true,
			componenteActivo: 'campaigntable',
			dataBuffer: {},
			dataForm: [],
			leadData: {},
			campanas: {},
			listaActiva: 1,
			relaciones: [],
			responseResult: {
				erroneos: [],
				total: 0,
				estado: "ok",
				lista: ""
			},
			responseDeleteResult: {
				Errores: [],
				estado: "ok",
				lista: ""
			},
			listaActual: {
				list_id: "",
				list_name: "",
				list_description: "",
				campaign_id: ""
			},
			leadFlag: true,
			listActive: "",
			nombreLista: "",
			i18n: i18n,
			// =======================================================
			// Variables para las fechas del reporte de lista
			modalReporte: false,
			linkReporte: "",
			// =======================================================
			// =======================================================
			// Variables para el CRM
			tieneCrmCrear: false,
			tieneCrmEditar: false,
			crmCrear: "",
			crmEditar: "",
			crms: [],
			// =======================================================
		},
		mounted: function() {
			var bla;
			$('.tooltipped').tooltip();

			function cambiarAOscuro() {

				for (let i = 0; i < bla.length; i++) {
					bla[i].classList.remove('white');
					bla[i].classList.add('grey');
					bla[i].classList.add('lighten-1');
					bla[i].style.filter = 'invert(100%)';
				}
			}

			if (localStorage.getItem('background') == "black") {
				bla = document.getElementsByClassName('card-panel')
				bla = Array.prototype.slice.call(bla)
				cambiarAOscuro();
			}
		},
		methods: {
			renderModCamp: function(comp, id) {
				this.componenteActivo = comp;
				this.dataBuffer = id;
			},
			anadirLead: function(nombre, id) {
				limpiar();
				$("#spinnerParte1").hide();
				$('#modalFormLead').modal('open');
				this.listaActiva = id;
				document.getElementById('plantilla').checked = false;
			},
			eliminarLead: function(comp, id){
				limpiar();
				$("#spinnerParte3").hide();
				$('#modalDeleteLeadForm').modal('open');
				this.listaActiva = id;
			},
			bajarLead: function(){
				$("#spinnerParte3").show();
				var fd = new FormData(document.getElementById('deleteFormFiles'));
				fd.append("lista", app._data.listaActiva);
				$.ajax({
					url: 'listas/deleteLeads',
					type: 'POST',
					data: fd,
					cache: false,
					contentType: false,
					processData: false,
					dataType: 'text'
				}).done(function(resp) {
					var res = JSON.parse(resp);
					if (res.Estado == "ok") {
						M.toast({
							'html': traducirFrase('Archivo cargado correctamente')
						});
						app.responseDeleteResult = res;
						$("#deleteFormFiles").val("");
						$("#archivocsvDeleteInput").val("");
						$("#inputMaterial").val("");
						$('#modalDeleteResult').modal('open');
						$("#spinnerParte3").hide();
					} else {
						M.toast({
							'html': res.Descripcion
						});
					}
					console.log(res);
				}).fail(function() {
					M.toast({
						'html': traducirFrase('Archivo invalido')
					});
				}).always(function() {
					$("#deleteFormFiles").val("");
					$("#archivocsvDeleteInput").val("");
					$("#inputMaterial").val("");
					$("#spinnerParte3").hide();
					$('#modalDeleteLeadForm').modal('close');
				});

			},
			reiniciarLista: function(nombre, id) {
				Swal.fire({
					title: i18n.gettext("Reiniciar lista"),
					text: i18n.gettext("¿Desea reiniciar la lista") + ' : ' + nombre + '?\n.',
					type: 'question',
					showCancelButton: true,
					confirmButtonColor: '#3085d6',
					cancelButtonColor: '#d33',
					confirmButtonText: i18n.gettext("Si"),
					cancelButtonText: i18n.gettext("No")
				}).then((result) => {
					if (result.value) {
						M.toast({
							'html': traducirFrase('Reiniciando lista, por favor espere.')
						});
						$.ajax({
							url: "listas/resetList",
							type: "POST",
							data: {
								lista: id
							},
							dataType: "text",
							success: function(response) {
								refresca();
								var res = {};
								try {
									res = JSON.parse(response);
								} catch (e) {
									M.toast({
										'html': traducirFrase('Error al reiniciar la lista')
									});
									console.error(e);
									console.log(response);
								}
								if (res.Estado == 'ok') {
									M.toast({
										'html': traducirFrase('Lista reiniciada exitosamente')
									});

								} else {
									M.toast({
										'html': res.Descripcion
									});
								}
							}
						});
					}
				});
			},
			duplicarLista: function(nombre, id) {
				Swal.fire({
					title: i18n.gettext("Duplicar lista"),
					text: i18n.gettext("¿Desea duplicar la lista") + ' : ' + nombre + '?\n.',
					type: 'question',
					showCancelButton: true,
					confirmButtonColor: '#3085d6',
					cancelButtonColor: '#d33',
					confirmButtonText: i18n.gettext("Si"),
					cancelButtonText: i18n.gettext("No")
				}).then((result) => {
					if (result.value) {
						M.toast({
							'html': traducirFrase('Duplicando lista, por favor espere.')
						});
						$.ajax({
							url: "listas/duplicateList",
							type: "POST",
							data: {
								lista: id
							},
							dataType: "text",
							success: function(response) {
								refresca();
								var res = {};
								try {
									res = JSON.parse(response);
								} catch (e) {
									M.toast({
										'html': traducirFrase('Error al duplicar la lista')
									});
									console.error(e);
									console.log(response);
								}
								if (res.Estado == 'ok') {
									M.toast({
										'html': traducirFrase('Lista duplicada exitosamente')
									});

								} else {
									M.toast({
										'html': res.Descripcion
									});
								}
							}
						});
					}
				});
			},
			editarLista: function(id) {
				dameCampanas();
				this.seleccionarCRM()
				M.toast({
					'html': i18n.gettext('Cargando datos')
				});
				if (banderaEditar) {

					$.ajax({
						url: "listas/getListDetails",
						type: "POST",
						data: {
							lista: id
						},
						dataType: "text",
						success: function(response) {
							var res = JSON.parse(response);
							if (res.Estado == "ok") {
								if (banderaEditar) {
									app.dataBuffer = res.Lista;
									app.dataBufferEdit = res.Lista;
									app.tieneCrmEditar = false
									if (res.CRM) {
										app.crmEditar = res.CRM.id
										app.tieneCrmEditar = true
									}
									$('#modalEditar').modal('open');
								}
							} else {
								M.toast({
									'html': res.Descripcion
								});
							}
						}
					});
				}
			},
			resetListStatus: function(id, nombre) {
				Swal.fire({
					type: 'warning',
					title: traducirFrase('Reencolar lista'),
					text: traducirFrase('¿Desea reencolar los estatus de: ') + nombre + '?\n'+traducirFrase('Esta acción no se puede deshacer'),
					showCancelButton: true,
					confirmButtonColor: '#3085d6',
					cancelButtonColor: '#d33',
					confirmButtonText: 'Si',
					cancelButtonText: "Cancelar",
					preConfirm: () => {
						$.ajax({
							url: "listas/resetList",
							type: "POST",
							data: {
								status: id,
								lista: app.listActive
							},
							dataType: "text",
							success: function(response) {
								var res = JSON.parse(response);
								if (res.Estado == 'ok') {
									M.toast({
										html: traducirFrase("Los registros con el status ") + nombre + traducirFrase(" han sido reiniciados")
									});
								} else {
									M.toast({
										html: res.Descripcion
									});
								}
							}
						});
					}
				});

			},
			swipeComponent: function(component, id, nombreLista) {
				M.toast({
					'html': i18n.gettext('Cargando datos')
				});
				if (component == "settings") {
					dameCampanas();
					app.listActive = id;
					$.ajax({
						url: "listas/getListDetails",
						type: "POST",
						data: {
							lista: id
						},
						dataType: "text",
						success: function(response) {
							var res = JSON.parse(response);
							console.log(res)
							if (res.Estado == "ok") {
								app.dataBuffer = res;
								app.componenteActivo = component;
								app.nombreLista = nombreLista;
							} else {
								M.toast({
									'html': res.Descripcion
								});
							}
						}
					});

				} else {
					if (component == 'settingsDef') {
						app.componenteActivo = 'campaigntable';
					} else {
						app.componenteActivo = component;
					}

				}

			},
			downloadStatusList: function(idStatus, idLista) {
				window.location.assign(`<?=MODULOS;?>Listas/getLeads?csv=true&status=${idStatus}&lista=${idLista}`);
			},
			deleteList: function(nombre, id) {
				Swal.fire({
						title: i18n.gettext("Eliminar lista"),
						text: i18n.gettext("¿Desea borrar la lista") + ' : ' + nombre + '?\n ' + i18n.gettext("Esta acción no se puede deshacer"),
						type: 'warning',
						showCancelButton: true,
						confirmButtonColor: '#3085d6',
						cancelButtonColor: '#d33',
						confirmButtonText: i18n.gettext("Continuar"),
						cancelButtonText: i18n.gettext("Cancelar")
					})
					.then((result) => {
						if (result.value) {
							$.ajax({
								url: "listas/deleteList",
								type: "POST",
								data: {
									lista: id
								},
								dataType: "text",
								success: function(response) {
									refresca();
									var res = JSON.parse(response);
									if (res.Estado == "error") {
										M.toast({
											'html': res.Descripcion
										});
									} else {
										M.toast({
											'html': traducirFrase('Lista eliminada')
										});
									}
								}
							});
							Swal.fire(traducirFrase("Borrado"));
						}
					});

			},
			activaCampana: function(id) {
				$("#paginacion").hide();
				$("#spinnerPagination").show();
				M.toast({
					'html': traducirFrase('Modificando lista, porfavor espere.')
				});
				$.ajax({
					url: "listas/changeListStatus",
					type: "POST",
					data: {
						idLista: id
					},
					dataType: "text",
					success: function(response) {
						try {
							var res = JSON.parse(response);
						} catch (e) {
							M.toast({
								'html': traducirFrase('Error al modificar lista')
							});
							setTimeout(function() { $("#paginacion").show(); }, 4000);
							setTimeout(function() { $("#spinnerPagination").hide(); }, 4000);
							return console.error(e);

						}
						if (res.Estado == 'ok') {
							M.toast({
								'html': traducirFrase('Lista modificada')
							});
							setTimeout(function() { $("#paginacion").show(); }, 4000);
							setTimeout(function() { $("#spinnerPagination").hide(); }, 4000);

						} else {
							M.toast({
								'html': res.Descripcion
							});
						}
					}
				});
				$.ajax({
					url: "listas/getLists",
					type: "POST",
					data: {
						pagina: app.pagina
					},
					dataType: "text",
					success: function(response) {
						var res = JSON.parse(response);

						if (res.Estado == 'ok') {
							app.dataTable = res;
						} else {
							M.toast({
								html: res.Descripcion
							});
						}

					}
				});
			},
			cambia: function(cual) {
				this.relaciones[cual] = $('[name="' + cual + '"]').val();
			},
			// =======================================================
			// Funciones para las fechas en los reportes de lista
			downloadListReport(link) {
				this.linkReporte = link
				this.modalReporte = true
				document.getElementById("datepickers-container").style.zIndex = "10000"
			},
			downloadFile() {
				let datesValues = $("#downloadDateList").val().split(" - ")
				let strDate = ""
				let url = this.linkReporte
				if (datesValues[0]) {
					strDate += `&fechaIni=${datesValues[0]}`
				}
				if (datesValues[1]) {
					strDate += `&fechaFin=${datesValues[1]}`
				}
				url += strDate
				window.location.href = url
				this.linkReporte = ""
				this.modalReporte = false
			},
			// =======================================================

			// =======================================================
			// Funciones para del CRM de la lista
			seleccionarCRM() {
				const self = this
				gen_rpost("CustomerRM/listarCRMs", {}).then(r => {
					self.crms = r.CRMS.map(crm => ({
						value: crm.id,
						label: crm.Nombre,
					}))
				}).catch(console.log)
			},
			// =======================================================
		},
		created: function() {

		},
		computed: {
			classObject: function() {
				if (this.ls == 'white') {
					return 'black-text';
				} else {
					return 'white-text';
				}
			}

		},
		mounted: function() {
			M.toast({
				'html': i18n.gettext("Cargando listas, por favor espere") + "."
			});
		}
	});

	var leadData = {};

	function subirDefinitivo() {
		function getVa(o) {
			if (o == "on") {
				return 'Y';
			} else {
				return 'N'
			}
		}
		$("#botonParte2").prop("disabled", true);
		var fd = new FormData(document.getElementById('formuFiles1'));
		var fd1 = new FormData(document.getElementById('formuFiles'));
		fd.append('csv', fd1.get('csv'));
		fd.append('estricto', getVa(fd1.get('estricto')));
		fd.append('duplicado', document.getElementById('checkboxListaDuplicado').checked ? '1' : '0')
		$("#spinnerParte2").show();
		$.ajax({
			url: 'listas/uploadLeads',
			type: 'POST',
			data: fd,
			cache: false,
			contentType: false,
			processData: false,
			dataType: 'text',
		}).done(function(resp) {
			var res = JSON.parse(resp);
			if (res.Estado == "ok") {
				M.toast({
					'html': traducirFrase('Archivo cargado correctamente')
				});
				app.responseResult = res;
				$('#modalResult').modal('open');
				$("#formuFiles").val("");
				$("#formuFiles1").val("");
			} else {
				M.toast({
					'html': res.Descripcion
				});
			}
		}).fail(function() {
			M.toast({
				'html': traducirFrase('Archivo invalido')
			});
		}).always(function() {
			$("#formuFiles").val("");
			$("#formuFiles1").val("");
			$('#modalFormLead2').modal('close');
			$("#spinnerParte2").hide();
			$("#botonParte2").prop("disabled", false);
		});
	}

	function subirLead() {
		$("#botonParte1").prop("disabled", true);
		$("#spinnerParte1").show();
		var fd = new FormData(document.getElementById('formuFiles'));
		fd.append("lista", app._data.listaActiva);
		$.ajax({
			url: 'listas/analizeFile',
			type: 'POST',
			data: fd,
			cache: false,
			contentType: false,
			processData: false,
			dataType: 'text'
		}).done(function(resp) {
			var res = JSON.parse(resp);
			if (res.Estado == "ok") {
				app.relaciones = []
				for (var i = 0; i < res.estados.length; i++) {
					if (res.estados[i].Equivalencia == null) {
						app._data.relaciones[res.estados[i].Nombre] = -1;
					} else {
						app._data.relaciones[res.estados[i].Nombre] = res.estados[i].Equivalencia;
					}
				}
				console.log(app.relaciones)
				M.toast({
					'html': traducirFrase('Archivo cargado correctamente')
				});
				$("#formuFiles").val("");
				app.leadData = res;
				console.log(app.leadData)
				$("#spinnerParte2").hide();
				if (!document.getElementById('plantilla').checked) {
					$('#modalFormLead2').modal('open');
				} else {
					setTimeout(function() {
						subirDefinitivo();
					}, 2000);
				}
			} else {
				M.toast({
					'html': res.Descripcion
				});
			}
		}).fail(function() {
			M.toast({
				'html': traducirFrase('Archivo invalido')
			});
		}).always(function() {
			$("#formuFiles").val("");
			$("#spinnerParte1").hide();
			$('#modalFormLead').modal('close');
			$("#botonParte1").prop("disabled", false);
		});

	}

	function limpiar() {
		$("#nombreLista").val("");
		$("#campana").val("");
		$("#descripcionLista").val("");
		document.getElementById('formuFiles1').reset();
		document.getElementById('formuFiles').reset();
	}

	function dameCampanas() {
		app.seleccionarCRM()
		$.ajax({
			url: "campanas/getCampaignsSelect",
			type: "POST",
			data: {},
			dataType: "text",
			success: function(response) {
				var res = JSON.parse(response);
				if (res.Estado == 'ok') {
					app._data.campanas = res.Campanas;
				} else {
					M.toast({
						html: res.Descripcion
					});
				}
			}
		});
	}
	var flagCarga = true;

	function getRandomColor() {
		var colores = ["0,122,255", "162,132,94", "142, 142, 147", "40, 205, 65", "88,86,214", "255,149,0", "255,45,85", "175,82,222", "255,59,48", "90,200,250", "255,204,0"];
		return "rgba(" + colores[Math.floor(Math.random() * colores.length)] + ",0.2)";
	}
	var mapa = [{
		color: "inherit",
		estado: "NEW"
	}];

	function refresca() {
		if (flagCarga) {
			$("#barrita").hide();
			flagCarga = false;
			$.ajax({
				url: "listas/getLists",
				type: "POST",
				data: {
					texto: $("#busqueda").val(),
					pagina: app.pagina
				},
				dataType: "text",
				success: function(response) {
					flagCarga = true;
					var res = JSON.parse(response);
					if (res.Estado == 'ok') {
						for (let i = 0; i < res.Listas.length; i++) {
							let total = 0;
							for (let j = 0; j < res.Listas[i].Status.length; j++) {
								total += parseInt(res.Listas[i].Status[j].cuenta);
							}
							for (let j = 0; j < res.Listas[i].Status.length; j++) {
								res.Listas[i].Status[j].porcentaje = (parseInt(res.Listas[i].Status[j].cuenta) * 100) / total;
								let color = null;
								for (let k = 0; k < mapa.length; k++) {
									if (mapa[k].estado == res.Listas[i].Status[j].estado) {
										color = mapa[k].color;
										break;
									}
								}
								if (color == null) {
									color = getRandomColor();
									mapa.push({
										color: color,
										estado: res.Listas[i].Status[j].estado
									});
								}
								res.Listas[i].Status[j].color = color;
							}
							res.Listas[i].totalRegistros = total;
						}
						app.dataTable = res;
						$("#paginacion").html("");
						var Anterior = res.Cuenta;
						res.Cuenta /= 10;
						res.Cuenta = Math.floor(res.Cuenta);
						if (Anterior % 10 != 0) {
							res.Cuenta++;
						}
						if (app.pagina == 1) {
							$("#paginacion").append(
								"<li class='disabled'><a href='#!'><i class='material-icons'>chevron_left</i></a></li>");
						} else {
							$("#paginacion").append("<li class='waves-effect'><a href='javascript:cambiaPagina(" + (app.pagina - 1) +
								")'><i class='material-icons'>chevron_left</i></a></li>");
						}
						for (var i = 0; i < res.Cuenta; i++) {
							if (app.pagina == (i + 1)) {
								$("#paginacion").append("<li class='active blue lighten-2 '><a href='javascript:cambiaPagina(" + (i + 1) +
									")'>" + (i + 1) + "</a></li>");
							} else {
								$("#paginacion").append("<li class='waves-effect'><a href='javascript:cambiaPagina(" + (i + 1) + ")'>" + (i +
									1) + "</a></li>");
							}
						}
						if (app.pagina == res.Cuenta || res.Cuenta == 0) {
							$("#paginacion").append(
								"<li class='disabled'><a href='#!'><i class='material-icons'>chevron_right</i></a></li>");
						} else {
							$("#paginacion").append("<li class='waves-effect'><a href='javascript:cambiaPagina(" + (app.pagina + 1) +
								")'><i class='material-icons'>chevron_right</i></a></li>");
						}
						setTimeout(() => {
							$('.tooltipped').tooltip();
						}, 1000);
					} else {
						M.toast({
							html: res.Descripcion
						});
					}
				}
			});
		}
	}
	setInterval(function() {
		refresca();
	}, 5000);

	function edita() {
		$("#botonEdita").prop('disabled', true);
		$.ajax({
			url: "listas/updateList",
			type: "POST",
			data: {
				id: app._data.dataBufferEdit.list_id,
				nombre: $("#nombreListaEditar").val(),
				campana: $("#campanaEditar").val(),
				descripcion: $("#descripcionListaEditar").val(),
			},
			dataType: "text",
			success: function(response) {
				var res = JSON.parse(response);
				if (res.Estado == "error") {
					M.toast({
						'html': res.Descripcion
					});
				} else {
					$("#nombreListaEditar").val("");
					$("#campanaEditar").val("");
					$("#descripcionListaEditar").val("");
					app.crmEditar = "";
					app.tieneCrmEditar = false;
					M.toast({
						'html': traducirFrase('Lista editada')
					});
					$('#modalEditar').modal('close');
				}
				$("#botonEdita").prop('disabled', false);
				refresca();
			}
		});
	}

	function cambiaPagina(pag) {
		app.pagina = pag;
		refresca();
	}

	function creaLista() {
		$("#botonCrea").prop('disabled', true);
		$.ajax({
			url: "listas/addList",
			type: "POST",
			data: {
				id: $("#idLista").val(),
				nombre: $("#nombreLista").val(),
				campana: $("#campana").val(),
				activa: $("#activa").val(),
				descripcion: $("#descripcionLista").val(),
				crm: app.tieneCrmCrear ? app.crmCrear : "",
			},
			dataType: "text",
			success: function(response) {
				var res = JSON.parse(response);
				if (res.Estado == "error") {
					M.toast({
						'html': res.Descripcion
					});
				} else {
					$("#nombreListaEditar").val("");
					$("#campanaEditar").val("");
					$("#descripcionListaEditar").val("");
					app.crmCrear = "";
					app.tieneCrmCrear = false;
					M.toast({
						'html': traducirFrase('Lista creada')
					});
					$('#formuModal').modal('close');
				}
				$("#botonCrea").prop('disabled', false);
				refresca();
			}
		});

	}

	function cambiaNombre() {
		var save = app._data.dataBuffer;
		app._data.dataBufferEdit.list_name = $("#nombreListaEditar").val();
		app._data.dataBufferEdit.list_description = $("#descripcionListaEditar").val();
		app._data.dataBufferEdit.campaign_id = $("#campanaEditar").val();
		app._data.dataBuffer = save;
	}
</script>