<?php

$idioma = "es";
if (isset($_COOKIE["idioma"])) {
    $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
}

?>
<?php require_once "style.php";?>
<div id="mainTwo" v-cloak>

	<div class="animated fadeIn">
        <div class="row col s12 card-panel white dv-content" style="margin-top: 75px;">
            <h5>{{traducirFrase("Encuestas")}}</h5>
            <div class="row no-bottom dv-flex dv-centered">
                <div class="col dv-flex-grow-1 input-field">
                    <label class="active">
                        {{ traducirFrase("Encuestas") }}
                    </label>
                    <select class="browser-default" v-model="id_encuesta" :placeholder="traducirFrase('Encuestas')">
                        <option :value="''">
                            {{ traducirFrase("Selecciona una encuesta") }}
                        </option>
                        <option v-for="v in encuestas" :key="v.value" :value="v.value">
                            {{ v.label }}
                        </option>
                    </select>
                </div>
                <div class="col dv-flex input-field justify-content-center panelDerecho">
                    <p class="radioPregunta">
                        <label> 
                            <input name="group1" type="radio" :value="'preguntas'" v-model="tabla" />
                            <span>{{traducirFrase("Preguntas")}}</span>
                        </label>
                    </p>
                    <p class="radioPregunta">
                        <label>
                            <input name="group1" type="radio" :value="'decisiones'" v-model="tabla" />
                            <span>{{traducirFrase("Decisión")}}</span>
                        </label>
                    </p>
                    <!-- <a class="waves-effect waves-light btn" href="#" @click.prevent="openAdd">{{traducirFrase("Agregar Encuesta")}}</a>
                    <a class="waves-effect waves-light btn" href="#" @click.prevent="openEdit" v-if="id_encuesta !== ''">{{traducirFrase("Editar Encuesta")}}</a>
                    <a class="waves-effect waves-light btn" href="#" @click.prevent="openReport" v-if="id_encuesta !== ''">{{traducirFrase("Descargar Reporte")}}</a>
                    <a class="waves-effect waves-light btn" href="#" @click.prevent="del" v-if="id_encuesta !== ''">{{traducirFrase("Eliminar Encuesta")}}</a> -->
                    <a class="anchorMargin tooltipped" data-position="top" :data-tooltip="traducirFrase('Agregar Encuesta')" href="#" @click.prevent="openAdd"><i class="customSize material-icons">add</i></a>
                    <a class="anchorMargin tooltipped" data-position="top" :data-tooltip="traducirFrase('Editar Encuesta')" href="#" @click.prevent="openEdit" v-if="id_encuesta !== ''"><i class="customSize material-icons">edit</i></a>
                    <a class="anchorMargin tooltipped" data-position="top" :data-tooltip="traducirFrase('Descargar Reporte')" href="#" @click.prevent="openReport" v-if="id_encuesta !== ''"><i class="customSize material-icons">file_download</i></a>
                    <a class="anchorMargin tooltipped" data-position="top" :data-tooltip="traducirFrase('Eliminar Encuesta')" href="#" @click.prevent="del" v-if="id_encuesta !== ''"><i class="customSize material-icons">delete</i></a>
                </div>
            </div>
            <div class="row">
                <div class="row col s12">
                    <table-dialvox
                        :headers="headers[tabla]"
                        :options="options[tabla]"
                        :hsearch="true"
                        :data="registros"
                        @marcarprimera="marcarPrimerPregunta"
                        @deletepregunta="deletePregunta"
                        @editdecision="openEditDecision"
                        @deletedecision="deleteDecision"
                        @tablarespuestas="tablaRespuestas"
                        @tablarangos="tablaRangos"
                    >
                        {{ id_encuesta === "" ? traducirFrase("No has seleccionado una encuesta") : traducirFrase("No hay informacion que mostrar") }}
                    </table-dialvox>
                    <br>
                    <pagination-dialvox v-model="pagina" :count="cuenta"></pagination-dialvox>
                    <br>
                    <?php if ($_SESSION["Grupo"] == GRUPO_ADMINS) { ?>
                        <div class="center" id="botonCrear" v-if="id_encuesta !== ''">
                            <a v-if="tabla === 'preguntas'" class="waves-effect waves-light btn blue lighten-2 " href="#" @click.prevent="openAddPregunta">{{traducirFrase("Nueva Pregunta")}}</a>
                            <a v-else class="waves-effect waves-light btn blue lighten-2 " href="#" @click.prevent="openAddDecision">{{traducirFrase("Nueva Decisión")}}</a>
                        </div>
			        <?php } ?>
			        <ul class="pagination center" id='paginacion'>
                </div>
            </div>
        </div>
	</div>
    <?php require_once "modals" . DIRECTORY_SEPARATOR . "add.php";?>
    <?php require_once "modals" . DIRECTORY_SEPARATOR . "edit.php";?>
    <?php require_once "modals" . DIRECTORY_SEPARATOR . "report.php";?>
    <?php require_once "modals" . DIRECTORY_SEPARATOR . "addQuestion.php";?>
    <?php require_once "modals" . DIRECTORY_SEPARATOR . "addDecision.php";?>
    <?php require_once "modals" . DIRECTORY_SEPARATOR . "editDecision.php";?>
    <?php require_once "modals" . DIRECTORY_SEPARATOR . "tablaRangos.php";?>
    <?php require_once "modals" . DIRECTORY_SEPARATOR . "tablaRespuestas.php";?>

</div>
<!-- END MAIN -->
<!-- ================================================
    Scripts
    ================================================ -->
    <?php require_once "script.php";?>
