<script>

	document.addEventListener("DOMContentLoaded", function () {
		var elems2 = document.querySelectorAll('.modal');
		$('#selectTipoSubida').formSelect();
		var instances2 = M.Modal.init(elems2, {
			dismissible: false,
		});
	});

	var app = new Vue({
		el: '#main',
		data: {
			statusCampaignShow: false,
			ls: localStorage.getItem('background'),
			pagina: 1,
			Registros: [],
			gaugeVal: 2,
			// Variables para seleccion de tipo de subida
            valorSelect: "",
			// Variables para subida por seleccion de archivo
            nombreArchivo: traducirFrase("Selecciona un audio para subir"),
            sePuedeEnviar: false,
			// Variables para subida por grabacion de audio
			blob: null,
			isRecording: false,
			time: "00:00",
			stop: false,
			typeStop: 0,
			// Variables para indicar la subida
            enviando: false,
			disabled: false
		},
		methods: {
			calcularTiempo: function(segs){
				let mins = 0
				let secs = 0
				let str = ""
				mins = Math.floor(segs/(60*1000))
				secs = Math.floor((segs - mins*(60*1000))/1000)
				mins <= 10 ? str+=`0${mins}` : str +=`${mins}`
				str+=":"
				secs <= 10 ? str+=`0${secs}` : str +=`${secs}`
				app.tiempo = str
        	},
			carga: function(){
				$('.barrita').show();
                $.ajax({
                    url: "<?=MODULOS;?>IVR/listarAudios",
                    type: "POST",
                    data: {
                        pagina: this.pagina-1,
						texto: $("#texto").val()
                    },
                    dataType: "text",
                    success: function (response) {
                        document.getElementById("barrita").style.display = "none";
						var res = JSON.parse(response.split(">").pop());
                        if(res.Estado == "ok"){
							app.Registros = res.Archivos;
                        }else{
                            M.toast({
        						'html': resp.Descripcion,
								classes: 'red darken-1 white-text'
		        			});
                        }
                    },
					error: function(res){
						console.log(res)
					},
            	});
			},
			cambiar: function () {
            	app.fileRead = false
            	$("#fileLabel").text($("#archivo")[0].files[0].name)
        	},
			convertDate(date){
				var today= new Date(date);
					var dd = today.getDate();
					var mm = today.getMonth() + 1;
					var yyyy = today.getFullYear();
					if (dd < 10) {
						dd = '0' + dd;
					}
					if (mm < 10) {
						mm = '0' + mm;
				}
					var hour  = today.getHours();
				var min   = today.getMinutes();
				if(hour<10){ hour='0'+hour;}
				if(min<10){ min='0'+min;}
				if(isNaN(today)){
				return today="";
				}else{
				return today = yyyy+ '-' + mm + '-' + dd + '\n' + hour + ':' + min;
				}
			},
			deleteAudio: function(nombre, id){
				Swal.fire({
					type: "warning",
					title: traducirFrase("Eliminar audio"),
					text: traducirFrase("¿Desea borrar el audio")+" : " + nombre + "?\n "+traducirFrase("Esta acción no se puede deshacer"),
					showCancelButton: true,
					confirmButtonColor: '#3085d6',
					cancelButtonColor: '#d33',
					confirmButtonText: "Sí",
					cancelButtonText: "Cancelar",
					preConfirm: () => {
						$.ajax({
							url: "<?=MODULOS;?>IVR/eliminarAudio",
							type: "POST",
							data: {
								audio: id
							},
							dataType: "text",
							success: function (response) {
								var res = JSON.parse(response.split(">").pop());
								app.carga();
								console.log(res)
								if (res.Estado == "error") {
									M.toast({
										'html': 'Error: ' + res.Descripcion,
										classes: 'red darken-1 white-text'
									});
								} else {
									app.carga();
									M.toast({
										'html': traducirFrase('Audio eliminado'),
										classes: 'green darken-1 white-text'
									});
								}
							}
						});
						Swal.fire(
							traducirFrase('Borrado'),
							traducirFrase('La campaña fue borrada'),
							'success'
						);
					}
				});
			},
			modalRegistrar: function(){
				$("#formuModal").modal("open");
			},
            enviarAudio: function(){
                this.enviando = true
				this.disabled = true
                let formData = new FormData()
                if(this.valorSelect == 1){
                    let file = document.getElementById("audioInput").files[0]
                    formData.append("audio", file, file.name)
                } else if(this.valorSelect == 2){
					this.stop = false
                    formData.append("audio", this.blob, "grabacion_"+(new Date()).getTime())
                }
                $.ajax({
                    url: "<?=MODULOS;?>/IVR/subirAudio",
                    type: "POST",
                    data: formData,
                    processData: false,
                    contentType: false,
                    dataType: 'text',
                    enctype: "multipart/form-data",
                    success: function(res){
                        app.enviando = false
						app.disabled = true
                        res = JSON.parse(res.split(">").pop())
                        if (res.Estado == "ok") {
                            app.cerrarModal()
                            app.carga()
                        } else {
							app.enviando = false
							app.disabled = false
                            M.toast({
								html: res.Descripcion,
								classes: "red darken-1 white-text"
							})
                        }
                    }
                })
            },
            cerrarModal: function(){
                this.valorSelect = ""
                this.enviando = false
				this.disabled = false
				this.time = "00:00"
                this.sePuedeEnviar = false
                this.nombreArchivo = "Selecciona un audio para subir"
                $("#formuModal").modal("close");
            },
            seleccionarAudio: function(){
                $("#audioInput").click()
            },
            cambiarNombre: function(){
                console.log("Cambia")
                let file = document.getElementById("audioInput").files[0]
                if(file){
                    this.nombreArchivo = file.name
                    this.sePuedeEnviar = true
                    this.enviando = false
                }
            },
			grabar: function () {
				let inicioGrabacion = new Date()
				navigator.mediaDevices.getUserMedia({
					audio: true,
					video: false
				}).then(stream => {

					let chunks = []
					let recorder = new MediaRecorder(stream, {})

					let inicio = new Date();
					recorder.addEventListener('dataavailable', function(e){
						chunks.push(e.data)
						let time = Math.floor(((new Date()).getTime() - inicio.getTime())/1000)
						let hours = Math.floor(time/60)
						let minutes = time - hours*60
						let newTime = ""
						if(hours < 10) newTime += '0' + hours
						else newTime += hours
						newTime +=":"
						if(minutes < 10) newTime += '0' + minutes
						else newTime += minutes

						app.time = newTime

						if(app.stop && recorder.state == 'recording'){
							recorder.stop()
						}
					})

					recorder.addEventListener('stop', function(e){
						let audio = document.getElementById('grabacionAudio')
						if(app.typeStop == 1){
							console.log("Grabacion terminada")
							let blob = new Blob(chunks)
							app.blob = blob
							audio.src = URL.createObjectURL(blob)
							app.sePuedeEnviar = true
						} else {
							app.blob = null
							audio.src = null
						}
					})
					recorder.start(100)
				})
				.catch(err => console.log(err))
        	},
			comienzaGrabacion: function(){
				console.log("Comienza")
				let audio = document.getElementById('grabacionAudio')
				audio.src = null
				this.isRecording = true
				this.stop = false
				this.blob = null
				this.grabar()
			},
			detenGrabacion: function(tipo){
				this.typeStop = tipo
				this.isRecording = false
				this.blob = null
				this.stop = true
				if(tipo == 0){
					this.time = "00:00"
				}
			}
		},
		computed: {
			classObject: function () {
				if (this.ls == 'white') {
					return 'black-text';
				} else {
					return 'white-text';
				}
			}
		}
	});
	$('.tooltipped').tooltip();
	var flagBanderaShida = true;
	var gauge;
	function cambiaPagina2(pag, id) {
		app.paginaEstatus = pag;
		app.obtenEstatus(id);
	}
	function cambiarAOscuro() {
        for (let i = 0; i < bla.length; i++) {
            bla[i].classList.remove('white');
            bla[i].classList.add('grey');
            bla[i].classList.add('lighten-1');
            bla[i].style.filter = 'invert(100%)';
        }
    }
    if (localStorage.getItem('background') == "black") {
				bla = document.getElementsByClassName('card-panel')
				bla = Array.prototype.slice.call(bla)
				cambiarAOscuro();
        }
	app.carga();
</script>