<?php

require_once "BASEPATH.php";

class Voz extends MY_Controller
{

    public function getVozSelect()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('voz', "spanish");
                break;
            case "en":
                $this->lang->load('voz', "english");
                break;
            default:
                $this->lang->load('voz', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $sal["Registros"] = array();
            $query = "SELECT id_voz,nombre FROM dialvox_voces ";
            $result = sv_mysqli_query($con, $query);
            while ($row = sv_mysqli_fetch_array($result)) {
                $sal["Registros"][] = $row;
            }
            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function getVoz()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('voz', "spanish");
                break;
            case "en":
                $this->lang->load('voz', "english");
                break;
            default:
                $this->lang->load('voz', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $pagina = limpia($_POST["pagina"]) - 1;
            $sal["Registros"] = array();
            $query = "SELECT id_voz,nombre FROM dialvox_voces LIMIT " . ($pagina * 10) . ",10";
            $result = sv_mysqli_query($con, $query);
            while ($row = sv_mysqli_fetch_array($result)) {
                $sal["Registros"][] = $row;
            }
            $query = "SELECT COUNT(id_voz) AS CANT FROM dialvox_voces ";
            $result = sv_mysqli_query($con, $query);
            if ($row = sv_mysqli_fetch_array($result)) {
                $sal["Cant"] = $row["CANT"];
            }
            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function deleteVoz()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('voz', "spanish");
                break;
            case "en":
                $this->lang->load('voz', "english");
                break;
            default:
                $this->lang->load('voz', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_voz = limpia($_POST["id_voz"]);

            $query = "SELECT idAudio FROM dialvox_voces WHERE id_voz='$id_voz'";
            $result = sv_mysqli_query($con, $query);
            if ($row = sv_mysqli_fetch_array($result)) {
                $query = "DELETE FROM bd_ivr.tbl_audio WHERE id='{$row["idAudio"]}'";
                sv_mysqli_query($con, $query);
            }

            $query = "DELETE FROM dialvox_voces WHERE id_voz='$id_voz'";
            sv_mysqli_query($con, $query);

            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function addVoz()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('voz', "spanish");
                break;
            case "en":
                $this->lang->load('voz', "english");
                break;
            default:
                $this->lang->load('voz', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_voz = limpia($_POST["id_voz"]);
            $nombre = limpia($_POST["nombre"]);

            $idAudio = 0;
            $aleatorio = rand(10000, 2000000000);
            $query = "SELECT id FROM bd_ivr.tbl_audio ORDER BY id DESC LIMIT 1";
            $result = sv_mysqli_query($con, $query);
            if ($row = sv_mysqli_fetch_array($result)) {
                $idAudio = $row["id"];
            }
            $idAudio++;

            $query = "INSERT INTO bd_ivr.tbl_audio(id,aleatorio,voz,mensaje,generado,cpuname) VALUES('$idAudio','$aleatorio','$id_voz','Opcion invalida','0',NULL)";
            sv_mysqli_query($con, $query);

            $query = "INSERT INTO dialvox_voces(id_voz,nombre,idAudio) VALUES('$id_voz','$nombre','$idAudio')";
            sv_mysqli_query($con, $query);

            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }

    public function index()
    {
        $this->load->view('voz/head');
        $this->load->view('voz/vw_voz');
        $this->load->view('voz/foot');
    }
}
