<?php

require_once "BASEPATH.php";

class EstadosPausa extends MY_Controller
{

    public function trata(&$out, $arreglo, &$lastLinePrinted)
    {
        $llaves = array_keys($arreglo);
        //fputcsv($out,array_values($llaves));
        $llavesNoArreglos = array();
        for ($i = 0; $i < count($llaves); $i++) {
            if (!is_array($arreglo[$llaves[$i]])) {
                //$this->trata($out,$arreglo[$llaves[$i]]);
                $llavesNoArreglos[] = $llaves[$i];
            }
        }
        $temp = array();
        for ($i = 0; $i < count($llaves); $i++) {
            if (!is_array($arreglo[$llaves[$i]])) {
                $temp[] = $arreglo[$llaves[$i]];
            }
        }
        if (count($temp) > 0) {
            if ($llavesNoArreglos != $lastLinePrinted) {
                fputcsv($out, array_values($llavesNoArreglos));
                $lastLinePrinted = $llavesNoArreglos;
            }
            fputcsv($out, array_values($temp));
        }
        for ($i = 0; $i < count($llaves); $i++) {
            if (is_array($arreglo[$llaves[$i]])) {
                $temp2 = array();
                $temp2[0] = $llaves[$i];
                if (!is_numeric($temp2[0])) {
                    fputcsv($out, array_values($temp2));
                }

                $this->trata($out, $arreglo[$llaves[$i]], $lastLinePrinted);
            }
        }
    }
    public function resumePause()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('estadospausa', "spanish");
                break;
            case "en":
                $this->lang->load('estadospausa', "english");
                break;
            default:
                $this->lang->load('estadospausa', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $con = getConnection();
            $donde = "";
            $cliente = $_SESSION["Cliente"];
            $pausa = limpia($_POST["codigoPausa"]);
            $usuarioLiberar = limpia($_POST["usuario"]);
            $sal["Estado"] = "ok";
            if ($cliente != -1) {
                $donde = "AND user_group = '$cliente'";
            }

            $query = "SELECT esGlobal FROM dialvox_pausas WHERE pause_code = '$pausa' LIMIT 1";
            $result = sv_mysqli_query($con, $query);
            $esGlobal = false;
            if ($row = sv_mysqli_fetch_array($result)) {
                $esGlobal = $row["esGlobal"];
            }

            if ($esGlobal) {
                $campana = limpia($_POST["campana"]);
                $tiempo = intval(limpia($_POST["tiempo"]));
                $query = "SELECT tiempoTotal,cantidad FROM dialvox_pausa_agente WHERE  agente='$usuarioLiberar' AND pause_code='$pausa' AND campaign_id='$campana' AND DATE(fecha)=CURRENT_DATE LIMIT 1";
                $result = sv_mysqli_query($con, $query);
                if ($row = sv_mysqli_fetch_array($result)) {
                    $tiempoTotal = $row["tiempoTotal"] + $tiempo;
                    $cantidadTotal = $row["cantidad"] + 1;
                    $query = "UPDATE dialvox_pausa_agente SET fecha=CURRENT_TIMESTAMP,tiempoTotal=$tiempoTotal,cantidad=$cantidadTotal WHERE pause_code='$pausa' AND campaign_id='$campana' AND agente='$usuarioLiberar'";
                    sv_mysqli_query($con, $query);
                } else {
                    $query = "SELECT tiempoTotal, cantidad FROM dialvox_pausa_agente WHERE pause_code='$pausa' AND campaign_id='$campana' AND agente='$usuarioLiberar' LIMIT 1";
                    $result2 = sv_mysqli_query($con, $query);
                    if ($row = sv_mysqli_fetch_array($result2)) {
                        $tiempoTotal = $row["tiempoTotal"] + $tiempo;
                        $cantidadTotal = $row["cantidad"] + 1;
                        $query = "UPDATE dialvox_pausa_agente SET fecha=CURRENT_TIMESTAMP,tiempoTotal=$tiempoTotal,cantidad=$cantidadTotal WHERE pause_code='$pausa' AND campaign_id='$campana' AND agente='$usuarioLiberar'";
                        sv_mysqli_query($con, $query);
                    } else {
                        $query = "INSERT INTO dialvox_pausa_agente(pause_code,campaign_id,agente,tiempoTotal,cantidad) VALUES('$pausa','$campana','$usuarioLiberar',$tiempo,1)";
                        sv_mysqli_query($con, $query);
                    }

                }

            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }

    }
    public function getStatusesSelect()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('estadospausa', "spanish");
                break;
            case "en":
                $this->lang->load('estadospausa', "english");
                break;
            default:
                $this->lang->load('estadospausa', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $con = getConnection();
            $donde = "";
            $cliente = $_SESSION["Cliente"];
            $necesitaCantidad = false;
            if ($_SESSION["Grupo"] == GRUPO_AGENTES) {
                $necesitaCantidad = true;
                $campana = $_SESSION["Campana"];
            } else {
                $campana = limpia($_POST["campana"]);
            }
            if ($cliente != -1) {
                $donde = "AND user_group = '$cliente'";
            }
            $query = "SELECT campaign_id FROM vicidial_campaigns WHERE campaign_id = '$campana' $donde";
            $result = sv_mysqli_query($con, $query);
            if ($row = sv_mysqli_fetch_array($result)) {
                $query = "SELECT vpc.pause_code, vpc.pause_code_name, vpc.billable, vpc.time_limit, vpc.require_mgr_approval,dp.tiempo_limite,dp.requiere_password,dp.cantidadMaxima,dp.esGlobal FROM vicidial_pause_codes AS vpc INNER JOIN dialvox_pausas AS dp ON dp.campaign_id=vpc.campaign_id AND dp.pause_code=vpc.pause_code WHERE vpc.campaign_id = '$campana' ORDER BY vpc.pause_code";
                $result = sv_mysqli_query($con, $query);
                $donde = 0;
                $sal["Registros"] = array();
                $sal["Estado"] = "ok";
                // Unknown column 'dpc.campaign_id' in 'on clause'
                while ($row = sv_mysqli_fetch_array($result)) {
                    $codigoPausa = $sal["Registros"][$donde]["estado"] = $row["pause_code"];
                    $sal["Registros"][$donde]["nombre"] = $row["pause_code_name"];
                    $sal["Registros"][$donde]["tiempo_limite"] = $row["tiempo_limite"];
                    $sal["Registros"][$donde]["requiere_aprovacion"] = $row["requiere_password"];
                    $esGlobal = $sal["Registros"][$donde]["esGlobal"] = $row["esGlobal"];
                    if ($necesitaCantidad && $esGlobal) {
                        $query = "SELECT tiempoTotal, cantidad FROM dialvox_pausa_agente WHERE pause_code='$codigoPausa' AND campaign_id='$campana' AND DATE(fecha)=CURRENT_DATE AND agente='$usuario' LIMIT 1";
                        $result2 = sv_mysqli_query($con, $query);
                        if ($row2 = sv_mysqli_fetch_array($result2)) {
                            $tiempoRestante = $row["tiempo_limite"] - $row2["tiempoTotal"];
                            if ($tiempoRestante <= 0) {
                                $tiempoRestante = 1;
                            }
                            $cantidad = $row["cantidadMaxima"] - $row2["cantidad"];
                            if ($cantidad <= 0) {
                                $cantidad = 0;
                            }
                            $sal["Registros"][$donde]["tiempo_limite"] = $tiempoRestante;
                            $sal["Registros"][$donde]["cantidad"] = $cantidad;

                        } else {
                            $query = "SELECT tiempoTotal, cantidad FROM dialvox_pausa_agente WHERE pause_code='$codigoPausa' AND campaign_id='$campana' AND agente='$usuario' LIMIT 1";
                            $result2 = sv_mysqli_query($con, $query);
                            if ($row2 = sv_mysqli_fetch_array($result2)) {
                                $tiempoRestante = $row["tiempo_limite"];
                                $cantidad = $row["cantidadMaxima"];
                                $sal["Registros"][$donde]["tiempo_limite"] = $tiempoRestante;
                                $sal["Registros"][$donde]["cantidad"] = $cantidad;

                                $query = "UPDATE dialvox_pausa_agente SET fecha=CURRENT_TIMESTAMP,tiempoTotal=0,cantidad=0 WHERE pause_code='$codigoPausa' AND campaign_id='$campana' AND agente='$usuario'";
                                sv_mysqli_query($con, $query);
                            } else {
                                $query = "INSERT INTO dialvox_pausa_agente(pause_code,campaign_id,agente,tiempoTotal,cantidad) VALUES('$codigoPausa','$campana','$usuario',0,0)";
                                sv_mysqli_query($con, $query);
                                $sal["Registros"][$donde]["tiempo_limite"] = $row["tiempo_limite"];
                                $sal["Registros"][$donde]["cantidad"] = $row["cantidadMaxima"];
                            }
                        }
                    } else {
                        if ($esGlobal && $necesitaCantidad) {
                            $sal["Registros"][$donde]["tiempo_limite"] = $row["tiempo_limite"];
                            $sal["Registros"][$donde]["cantidad"] = 69;

                        }
                    }
                    $donde++;
                }
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_permisosEstado");
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function resolvePauseByManager()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('estadospausa', "spanish");
                break;
            case "en":
                $this->lang->load('estadospausa', "english");
                break;
            default:
                $this->lang->load('estadospausa', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $con = getConnection();
            $donde = "";
            $cliente = $_SESSION["Cliente"];
            $tiempo = intval(limpia($_POST["tiempo"]));
            $campana = limpia($_POST["campana"]);
            $pausa = limpia($_POST["codigoPausa"]);
            if ($_SESSION["Grupo"] == GRUPO_AGENTES) {
                $usuarioLiberar = $usuario;
            } else {
                $usuarioLiberar = limpia($_POST["usuario"]);
            }
            if ($cliente != -1) {
                $donde = "AND user_group = '$cliente'";
            }
            $query = "UPDATE dialvox_pausa_report SET resuelto=1 WHERE agente='$usuarioLiberar' AND DATE(fecha)=CURRENT_DATE AND resuelto=0";
            sv_mysqli_query($con, $query);
            $query = "SELECT tiempoTotal,cantidad FROM dialvox_pausa_agente WHERE  agente='$usuarioLiberar' AND pause_code='$pausa' AND campaign_id='$campana' AND DATE(fecha)=CURRENT_DATE LIMIT 1";
            $result = sv_mysqli_query($con, $query);
            if ($row = sv_mysqli_fetch_array($result)) {
                $tiempoTotal = $row["tiempoTotal"] + $tiempo;
                $cantidadTotal = $row["cantidad"] + 1;
                $query = "UPDATE dialvox_pausa_agente SET fecha=CURRENT_TIMESTAMP,tiempoTotal=$tiempoTotal,cantidad=$cantidadTotal WHERE pause_code='$codigoPausa' AND campaign_id='$campana' AND agente='$usuarioLiberar'";
                sv_mysqli_query($con, $query);
            } else {
                $query = "SELECT tiempoTotal, cantidad FROM dialvox_pausa_agente WHERE pause_code='$pausa' AND campaign_id='$campana' AND agente='$usuarioLiberar' LIMIT 1";
                $result2 = sv_mysqli_query($con, $query);
                if ($row = sv_mysqli_fetch_array($result2)) {
                    $tiempoTotal = $row["tiempoTotal"] + $tiempo;
                    $cantidadTotal = $row["cantidad"] + 1;
                    $query = "UPDATE dialvox_pausa_agente SET fecha=CURRENT_TIMESTAMP,tiempoTotal=$tiempoTotal,cantidad=$cantidadTotal WHERE pause_code='$pausa' AND campaign_id='$campana' AND agente='$usuarioLiberar'";
                    sv_mysqli_query($con, $query);
                } else {
                    $query = "INSERT INTO dialvox_pausa_agente(pause_code,campaign_id,agente,tiempoTotal,cantidad) VALUES('$pausa','$campana','$usuarioLiberar',$tiempo,1)";
                    sv_mysqli_query($con, $query);
                }

            }
            $sal["Estado"] = "ok";

            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }

    public function getStatuses()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('estadospausa', "spanish");
                break;
            case "en":
                $this->lang->load('estadospausa', "english");
                break;
            default:
                $this->lang->load('estadospausa', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && ($_SESSION["Grupo"] == GRUPO_ADMINS || $_SESSION["Grupo"] == GRUPO_SUPERVISORES)) {
            include_once RUTA_APP . 'Sesiones.php';
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $con = getConnection();
            $donde = "";
            $cliente = $_SESSION["Cliente"];
            $pagina = 0;
            if (isset($_POST["pagina"]) && intval($_POST["pagina"]) >= 1) {
                $pagina = intval(limpia($_POST["pagina"]) - 1);
            }
            $registros = 10;
            $skip = $pagina * $registros;
            $campana = limpia($_POST["campana"]);
            if ($cliente != -1) {
                $donde = "AND user_group = '$cliente'";
            }
            $query = "SELECT campaign_id FROM vicidial_campaigns WHERE campaign_id = '$campana' $donde";
            $result = sv_mysqli_query($con, $query);
            if ($row = sv_mysqli_fetch_array($result)) {
                $query = "SELECT vpc.pause_code, vpc.pause_code_name, vpc.billable, vpc.time_limit, vpc.require_mgr_approval,dp.tiempo_limite,dp.requiere_password,dp.cantidadMaxima,dp.esGlobal FROM vicidial_pause_codes AS vpc INNER JOIN dialvox_pausas AS dp ON dp.campaign_id=vpc.campaign_id AND dp.pause_code=vpc.pause_code WHERE vpc.campaign_id = '$campana' ORDER BY pause_code LIMIT $skip,$registros";
                $result = sv_mysqli_query($con, $query);
                $donde = 0;
                $sal["Registros"] = array();
                $sal["Estado"] = "ok";
                while ($row = sv_mysqli_fetch_array($result)) {
                    $sal["Registros"][$donde]["estado"] = $row["pause_code"];
                    $sal["Registros"][$donde]["nombre"] = $row["pause_code_name"];
                    $sal["Registros"][$donde]["billable"] = $row["billable"];
                    $sal["Registros"][$donde]["tiempo"] = $row["time_limit"];
                    $sal["Registros"][$donde]["aprovacion"] = $row["require_mgr_approval"];
                    $sal["Registros"][$donde]["tiempo_limite"] = $row["tiempo_limite"];
                    $sal["Registros"][$donde]["requiere_aprovacion"] = $row["requiere_password"];
                    $sal["Registros"][$donde]["cantidadMaxima"] = $row["cantidadMaxima"];
                    $sal["Registros"][$donde]["esGlobal"] = $row["esGlobal"];
                    $donde++;
                }
                $result = sv_mysqli_query($con, "SELECT COUNT(pause_code) FROM vicidial_pause_codes WHERE campaign_id = '$campana'");
                $row = sv_mysqli_fetch_array($result);
                $sal["Cuenta"] = $row[0];
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_permisosEstado");
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function addStatus()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('estadospausa', "spanish");
                break;
            case "en":
                $this->lang->load('estadospausa', "english");
                break;
            default:
                $this->lang->load('estadospausa', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && ($_SESSION["Grupo"] == GRUPO_ADMINS || $_SESSION["Grupo"] == GRUPO_SUPERVISORES)) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $con = getConnection();
            $donde = "";
            $cliente = $_SESSION["Cliente"];
            $campana = limpia($_POST["campana"]);
            if ($cliente != -1) {
                $donde = "AND user_group = '$cliente'";
            }
            $query = "SELECT campaign_id FROM vicidial_campaigns WHERE campaign_id = '$campana' $donde";
            $result = sv_mysqli_query($con, $query);
            if ($row = sv_mysqli_fetch_array($result)) {
                $estado = limpia($_POST["estado"]);
                $query = "SELECT pause_code FROM vicidial_pause_codes WHERE campaign_id = '$campana' AND pause_code = '$estado' LIMIT 1";
                $result = sv_mysqli_query($con, $query);
                if ($row = sv_mysqli_fetch_array($result)) {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("desc_estadoExistente");
                } else {
                    $nombre = limpia($_POST["nombre"]);
                    if (strlen($estado) < 1 || strlen($estado) > 6) {
                        $sal["Estado"] = "error";
                        $sal["Descripcion"] = $this->lang->line("desc_estadoCaracteres");
                    } else {
                        if (strlen($nombre) < 2) {
                            $sal["Estado"] = "error";
                            $sal["Descripcion"] = $this->lang->line("desc_estadoCaracteres2");
                        } else {
                            $tiempo = 65000;
                            if (isset($_POST["tiempo"]) && intval($_POST["tiempo"]) > 0) {
                                $tiempo = intval($_POST["tiempo"]);
                            }
                            $billable = "NO";
                            $aprovacion = "NO";
                            if (isset($_POST["aprovacion"]) && $_POST["aprovacion"] == "YES") {
                                $aprovacion = "YES";
                            }

                            if (isset($_POST["billable"]) && ($_POST["billable"] == "YES" || $_POST["billable"] == "NO" || $_POST["billable"] == "HALF")) {
                                $billable = $_POST["billable"];
                            }

                            $stmt = "INSERT INTO vicidial_pause_codes(campaign_id,pause_code,pause_code_name,billable,time_limit,require_mgr_approval) values('$campana','$estado','$nombre','$billable','$tiempo','$aprovacion')";

                            $tiempo_limite = $_POST["tiempo_limite"];
                            $requiere_password = (isset($_POST["requiere_password"]) && $_POST["requiere_password"] == 1) ? 1 : 0;
                            $cantidadMaxima = (isset($_POST["cantidadMaxima"]) && is_numeric($_POST["cantidadMaxima"])) ? intval($_POST["cantidadMaxima"]) : 3;
                            $esGlobal = (isset($_POST["esGlobal"]) && $_POST["esGlobal"] == 1) ? 1 : 0;
                            $result = sv_mysqli_query($con, $stmt);
                            $SQL_log = "$stmt|";
                            $stmt = "INSERT INTO dialvox_pausas(campaign_id,pause_code,tiempo_limite,requiere_password,cantidadMaxima,esGlobal) values('$campana','$estado','$tiempo_limite','$requiere_password',$cantidadMaxima,'$esGlobal')";
                            $result = sv_mysqli_query($con, $stmt);
                            $SQL_log = preg_replace('/;/', '', $SQL_log);
                            $SQL_log = addslashes($SQL_log);
                            $ip = $_SERVER["REMOTE_ADDR"];
                            $stmt = "INSERT INTO vicidial_admin_log set event_date=NOW(), user='$usuario', ip_address='$ip', event_section='CAMPAIGN_PAUSECODE', event_type='ADD', record_id='$campana', event_code='ADMIN ADD CAMPAIGN PAUSE CODE', event_sql=\"$SQL_log\", event_notes='Pause Code: $estado'";
                            $result = sv_mysqli_query($con, $stmt);
                            $sal["Estado"] = "ok";
                        }
                    }
                }
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_permisosAgregarEstado");
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function deleteStatus()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('estadospausa', "spanish");
                break;
            case "en":
                $this->lang->load('estadospausa', "english");
                break;
            default:
                $this->lang->load('estadospausa', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && ($_SESSION["Grupo"] == GRUPO_ADMINS || $_SESSION["Grupo"] == GRUPO_SUPERVISORES)) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $con = getConnection();
            $donde = "";
            $cliente = $_SESSION["Cliente"];
            $campana = limpia($_POST["campana"]);
            if ($cliente != -1) {
                $donde = "AND user_group = '$cliente'";
            }
            $query = "SELECT campaign_id FROM vicidial_campaigns WHERE campaign_id = '$campana' $donde";
            $result = sv_mysqli_query($con, $query);
            if ($row = sv_mysqli_fetch_array($result)) {
                $estado = limpia($_POST["estado"]);
                $query = "SELECT pause_code FROM vicidial_pause_codes WHERE campaign_id = '$campana' AND pause_code = '$estado' LIMIT 1";
                $result = sv_mysqli_query($con, $query);
                if ($row = sv_mysqli_fetch_array($result)) {
                    $stmt = "DELETE FROM vicidial_pause_codes WHERE campaign_id = '$campana' AND pause_code = '$estado' LIMIT 1";
                    $result = sv_mysqli_query($con, $stmt);
                    $SQL_log = "$stmt|";
                    $stmt = "DELETE FROM dialvox_pausa WHERE campaign_id = '$campana' AND pause_code = '$estado' LIMIT 1";
                    $result = sv_mysqli_query($con, $stmt);
                    $SQL_log = preg_replace('/;/', '', $SQL_log);
                    $SQL_log = addslashes($SQL_log);
                    $ip = $_SERVER["REMOTE_ADDR"];
                    $stmt = "INSERT INTO vicidial_admin_log set event_date=NOW(), user='$usuario', ip_address='$ip', event_section='CAMPAIGN_PAUSECODE', event_type='DELETE', record_id='$campana', event_code='ADMIN DELETE CAMPAIGN PAUSE CODE', event_sql=\"$SQL_log\", event_notes='Pause Code: $estado'";
                    $result = sv_mysqli_query($con, $stmt);
                    $sal["Estado"] = "ok";
                } else {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("desc_estadoInexistente");
                }
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_permisosEliminarEstado");
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function editStatus()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('estadospausa', "spanish");
                break;
            case "en":
                $this->lang->load('estadospausa', "english");
                break;
            default:
                $this->lang->load('estadospausa', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && ($_SESSION["Grupo"] == GRUPO_ADMINS || $_SESSION["Grupo"] == GRUPO_SUPERVISORES)) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $con = getConnection();
            $donde = "";
            $cliente = $_SESSION["Cliente"];
            $campana = limpia($_POST["campana"]);
            if ($cliente != -1) {
                $donde = "AND user_group = '$cliente'";
            }
            $query = "SELECT campaign_id FROM vicidial_campaigns WHERE campaign_id = '$campana' $donde";
            $result = sv_mysqli_query($con, $query);
            if ($row = sv_mysqli_fetch_array($result)) {
                $estado = limpia($_POST["estado"]);
                $query = "SELECT pause_code FROM vicidial_pause_codes WHERE campaign_id = '$campana' AND pause_code = '$estado' LIMIT 1";
                $result = sv_mysqli_query($con, $query);
                if ($row = sv_mysqli_fetch_array($result)) {
                    $nombre = limpia($_POST["nombre"]);
                    if (strlen($estado) < 1 || strlen($estado) > 6) {
                        $sal["Estado"] = "error";
                        $sal["Descripcion"] = $this->lang->line("desc_estadoCaracteres");
                    } else {
                        if (strlen($nombre) < 2) {
                            $sal["Estado"] = "error";
                            $sal["Descripcion"] = $this->lang->line("desc_estadoCaracteres2");
                        } else {
                            $tiempo = 65000;
                            if (isset($_POST["tiempo"]) && intval($_POST["tiempo"]) > 0) {
                                $tiempo = intval($_POST["tiempo"]);
                            }
                            $billable = "";
                            $aprovacion = "NO";
                            if (isset($_POST["aprovacion"]) && $_POST["aprovacion"] == "YES") {
                                $aprovacion = "YES";
                            }

                            if (isset($_POST["billable"]) && ($_POST["billable"] == "YES" || $_POST["billable"] == "NO" || $_POST["billable"] == "HALF")) {
                                $billable = $_POST["billable"];
                            }

                            $stmt = "UPDATE vicidial_pause_codes SET pause_code_name = '$nombre',billable = '$billable', time_limit = '$tiempo', require_mgr_approval = '$aprovacion' WHERE campaign_id = '$campana' AND pause_code = '$estado' LIMIT 1";
                            $result = sv_mysqli_query($con, $stmt);
                            $tiempo_limite = limpia($_POST["tiempo_limite"]);
                            $requiere_password = (isset($_POST["requiere_password"]) && $_POST["requiere_password"] == 1) ? 1 : 0;
                            $cantidadMaxima = (isset($_POST["cantidadMaxima"]) && is_numeric($_POST["cantidadMaxima"])) ? intval($_POST["cantidadMaxima"]) : 3;
                            $esGlobal = (isset($_POST["esGlobal"]) && $_POST["esGlobal"] == 1) ? 1 : 0;
                            $SQL_log = "$stmt|";
                            $stmt = "UPDATE dialvox_pausas SET tiempo_limite = '$tiempo_limite',requiere_password = '$requiere_password',esGlobal=$esGlobal,cantidadMaxima=$cantidadMaxima WHERE campaign_id = '$campana' AND pause_code = '$estado' LIMIT 1";
                            $result = sv_mysqli_query($con, $stmt);
                            $SQL_log = preg_replace('/;/', '', $SQL_log);
                            $SQL_log = addslashes($SQL_log);
                            $ip = $_SERVER["REMOTE_ADDR"];
                            $stmt = "INSERT INTO vicidial_admin_log set event_date=NOW(), user='$usuario', ip_address='$ip', event_section='CAMPAIGN_PAUSECODE', event_type='EDIT', record_id='$campana', event_code='ADMIN EDIT CAMPAIGN PAUSE CODE', event_sql=\"$SQL_log\", event_notes='Pause Code: $estado'";
                            $result = sv_mysqli_query($con, $stmt);
                            $sal["Estado"] = "ok";
                        }
                    }
                } else {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("desc_estadoInexistente");
                }
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_permisosEditarEstado");
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function generateReport()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('estadospausa', "spanish");
                break;
            case "en":
                $this->lang->load('estadospausa', "english");
                break;
            default:
                $this->lang->load('estadospausa', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && ($_SESSION["Grupo"] == GRUPO_ADMINS || $_SESSION["Grupo"] == GRUPO_SUPERVISORES)) {
            include_once RUTA_APP . 'Sesiones.php';
            $usuario = $_SESSION["Usuario"];
            $cliente = $_SESSION["Cliente"];
            $sal = array();
            $con = getConnection();
            $donde = "";
            if ($cliente != -1) {
                $donde = "AND user_group = '$cliente'";
            }
            $fechaInicio = limpia($_GET["fechaIni"]);
            $fechaFin = limpia($_GET["fechaFin"]);
            $cliente = $_SESSION["Cliente"];
            $usuarios = array();
            $result = sv_mysqli_query($con, "SELECT user, full_name FROM vicidial_users WHERE user_group='" . $cliente . "_AGENTES'");
            $usuarioSQL = "";
            while ($row = sv_mysqli_fetch_array($result)) {
                $usuarios[] = array("usuario" => $row["user"], "nombre" => $row["full_name"]);
                $usuarioSQL .= "'" . $row["user"] . "',";
            }
            if (strlen($usuarioSQL) > 0) {
                $usuarioSQL = substr($usuarioSQL, 0, -1);
            }
            $result = sv_mysqli_query($con, "SELECT dpr.agente,dpr.fecha, dpr.supervisor,dpr.pause_code FROM dialvox_pausa_report AS dpr WHERE dpr.agente IN ($usuarioSQL) AND DATE('$fechaInicio')<=DATE(dpr.fecha) AND DATE('$fechaFin')>=DATE(dpr.fecha)");
            $sal["Registros"] = array();
            while ($row = sv_mysqli_fetch_array($result)) {
                $sal["Registros"][] = $row;
            }
            if (isset($_GET["csv"])) {
                header("Content-type: text/csv");
                header("Content-Disposition: attachment; filename=" . $this->lang->line("report_nombre") . "(" . $fechaInicio . "-" . $fechaFin . ").csv");
                header("Pragma: no-cache");
                header("Expires: 0");
                $out = fopen('php://output', 'w');
                ob_clean();
                fwrite($out, "{$this->lang->line('header_1')},{$this->lang->line('header_2')},{$this->lang->line('header_3')},{$this->lang->line('header_4')}\n");
                foreach ($sal["Registros"] as $value) {
                    fwrite($out, "{$value['agente']},{$value['fecha']},{$value['supervisor']},{$value['pause_code']}\n");
                }
                fclose($out);
            } else {
                header('Content-type: application/json');
                $sal["Estado"] = "ok";
                $this->output->set_output(json_encode($sal));
            }

            sv_mysqli_close($con);
        } else {
            header('Content-type: application/json');
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }

    }
    public function index()
    {
        $this->load->view('estadosPausa/head');
        $this->load->view('estadosPausa/vw_estadosPausa');
        $this->load->view('estadosPausa/foot');
    }
    public function reportePausa()
    {
        $this->load->view('reportePausa/head');
        $this->load->view('reportePausa/vw_reportePausa');
        $this->load->view('reportePausa/foot');
    }
}