<?php	
	require_once RUTA_APP.'Conexion.php';
	require_once 'MenuDatos.php';
	require_once 'Opcion.php';
	class OpcionDatos{
		public static $OPCIONES_DISPONIBLES = ["0","1","2","3","4","5","6,","7","8","9","HASH","STAR","A","B","C","D","TIMECHECK","TIMEOUT","INVALID","INVALID_2ND","INVALID_3RD"];
		public static $RUTAS_DISPONIBLES = ["AGI","VMAIL_NO_INST","VOICEMAIL","PHONE","EXTENSION","HANGUP","DID","INGROUP","CALLMENU"];
		public static function getOpcionByOpcionAndMenu($opcion, $menu){
			$con = getConnection();			
			$query = "SELECT * FROM vicidial_call_menu_options WHERE menu_id = '".limpia($menu->getId())."' AND option_value = '".limpia($opcion)."' LIMIT 1";
			$result = sv_mysqli_query($con,$query);
			$resp = NULL;
			if($row = sv_mysqli_fetch_array($result)){
				$resp = new Opcion($menu, $row["option_value"], $row["option_description"], $row["option_route"],$row["option_route_value"],$row["option_route_value_context"]);
			}
			sv_mysqli_close($con);
			return $resp;
		}
		public static function getRemaningOpcionesByMenu($menu){
			$opciones = self::getAllOpcionesByMenu($menu);
			$resp = self::$OPCIONES_DISPONIBLES;
			for($i = 0;$i<count($opciones);$i++){
				$resp = array_diff($resp, [$opciones[$i]->getOpcion()]);
			}
			return $resp;
		}
		public static function getOpcionesByMenu($menu, $pagina, $limite, $texto){
			$con = getConnection();			
			$query = "SELECT * FROM vicidial_call_menu_options WHERE menu_id = '".limpia($menu->getId())."' AND option_value LIKE '%".$texto."%' LIMIT ".($pagina*$limite).",".$limite;			
			$result = sv_mysqli_query($con,$query);
			$resp = [];
			while($row = sv_mysqli_fetch_array($result)){
				array_push($resp,new Opcion($menu, $row["option_value"], $row["option_description"], $row["option_route"],$row["option_route_value"],$row["option_route_value_context"]));
			}
			sv_mysqli_close($con);
			return $resp;
		}
		public static function countOpcionesByMenu($menu,$texto){
			$con = getConnection();			
			$query = "SELECT COUNT(menu_id) AS CUENTA FROM vicidial_call_menu_options WHERE menu_id = '".limpia($menu->getId())."' AND option_value LIKE '%".$texto."%'";
			$result = sv_mysqli_query($con,$query);			
			$resp = 0;
			if($row = sv_mysqli_fetch_array($result)){
				$resp = $row["CUENTA"];
			}
			sv_mysqli_close($con);
			return $resp;
		}
		public static function getAllOpcionesByMenu($menu){
			$con = getConnection();			
			$query = "SELECT * FROM vicidial_call_menu_options WHERE menu_id = '".limpia($menu->getId())."'";
			$result = sv_mysqli_query($con,$query);
			$resp = [];			
			while($row = sv_mysqli_fetch_array($result)){
				array_push($resp,new Opcion($menu, $row["option_value"], $row["option_description"], $row["option_route"],$row["option_route_value"],$row["option_route_value_context"]));
			}
			sv_mysqli_close($con);
			return $resp;
		}
		public static function insertOpcion($opcion){	
			if(self::getOpcionByOpcion($opcion) == NULL){
				$con = getConnection();			
				$query = "INSERT INTO vicidial_call_menu_options (menu_id, option_value, option_description, option_route, option_route_value, option_route_value_context) VALUES (".
				"'".limpia($opcion->getMenu()->getId())."',".
				"'".limpia($opcion->getOpcion())."',".
				"'".limpia($opcion->getDescripcion())."',".
				"'".limpia($opcion->getRuta())."',".
				"'".limpia($opcion->getValor())."',".
				"'".limpia($opcion->getContexto())."'".
				")";				
				$resp = 0;				
				if(sv_mysqli_query($con,$query)){
					sv_mysqli_query($con,"UPDATE servers set rebuild_conf_files='Y' where generate_vicidial_conf='Y' and active_asterisk_server='Y'");
					$resp = 0;
				}else{
					$resp = -1;
				}
				sv_mysqli_close($con);
				return $resp;
			}else{
				return -1;
			}							
		}
		public static function updateOpcion($opcion){
			if(self::getOpcionByOpcion($opcion) != NULL){
				$con = getConnection();			
				$query = "UPDATE vicidial_call_menu_options 
				SET 				
					option_description = '".limpia($opcion->getDescripcion())."',
					option_route = '".limpia($opcion->getRuta())."',
					option_route_value = '".limpia($opcion->getValor())."',
					option_route_value_context = '".limpia($opcion->getContexto())."' 
				WHERE 
					option_value = '".limpia($opcion->getOpcion())."' 
				AND 
					menu_id = '".limpia($opcion->getMenu()->getId())."'";
				sv_mysqli_query($con,$query);
				sv_mysqli_query($con,"UPDATE servers set rebuild_conf_files='Y' where generate_vicidial_conf='Y' and active_asterisk_server='Y'");
				sv_mysqli_close($con);
				return 0;
			}else{
				return -1;
			}
		}
		public static function deleteOpcion($opcion){
			if(self::getOpcionByOpcion($opcion) != NULL){
				$con = getConnection();
				$query = "DELETE FROM vicidial_call_menu_options WHERE menu_id = '".limpia($opcion->getMenu()->getId())."' AND option_value = '".limpia($opcion->getOpcion())."'";				
				$resCode = 0;
				if(!sv_mysqli_query($con,$query)){
					$resCode = -2;
				}
				sv_mysqli_close($con);
				return $resCode;
			}else{	
				return -1;
			}
		}
		public static function getOpcionByOpcion($opcion){
			$con = getConnection();			
			$query = "SELECT * FROM vicidial_call_menu_options WHERE menu_id = '".limpia($opcion->getMenu()->getId())."' AND option_value = '".limpia($opcion->getOpcion())."' LIMIT 1";						
			$result = sv_mysqli_query($con,$query);
			$resp = NULL;
			if($row = sv_mysqli_fetch_array($result)){
				$resp = new Opcion(MenuDatos::getMenuById($row["menu_id"]), $row["option_value"], $row["option_description"], $row["option_route"],$row["option_route_value"],$row["option_route_value_context"]);
			}
			sv_mysqli_close($con);
			return $resp;
		}
	}
?>