

function sweetToast(type, title, timer) {
    let toast = Swal.mixin({
        toast: true,
        position: 'center',
        showConfirmButton: false,
        timer: timer ? timer : 3000,
        timerProgressBar: true,
        onOpen: (toast) => {
            toast.addEventListener('mouseenter', Swal.stopTimer)
            toast.addEventListener('mouseleave', Swal.resumeTimer)
        }
    })
    toast.fire({
        icon: type,
        title: title
    })
}

function swalStepped(type, title, html, steps) {
    Swal.fire({
        icon: type,
        title: title,
        html: html,
        cancelButtonText: traducirFrase("Cancelar"),
        showCancelButton: true,
        showConfirmButton: false,
        onOpen: steps,
        customContainerClass: "bg-light"
    })
}

async function transferirModales() {
    await cargaIngroupsYAgentes();
    swalStepped(
        "question",
        traducirFrase("Como quieres transferir"),
        '<br><div class="row"><div class="col-sm-12 d-flex justify-content-around"><button class="grupoTransfer btn btn-info p-3 col mx-2">'+("Grupo de entrada")+'</button><button class="agentesTransfer btn btn-info p-3 col mx-2">'+traducirFrase("Agente")+'</button></div></div>',
        function () {
            $(".grupoTransfer").click(function () {
                let cadena = ``;// se debe generar la string con los grupos de entrada
                IngroupsTransfer.forEach((val, index) => {
                    cadena = cadena.concat(`
							<button class="grupoTransferId${index + 1} grupoTransferButtons font-weight-bold btn btn-light col" style="font-size: 0.9rem;font-weight: bold !important;">
								${val.Nombre}
							</button>
						`);
                });
                cadena = cadena.concat(`
					<button class="grupoTransferIdES grupoTransferButtons font-weight-bold btn btn-light col" style="font-size: 0.9rem;font-weight: bold !important;">
						${traducirFrase("Transferir a grupo default (Si no tiene uno seleccionado esto hara que la llamada se cuelge)")}
					</div>
					`)
                swalStepped(
                    "question",
                    "Que grupo de entrada",
                    `'	<br>
							<div class="row px-4" style="width: 100%; height: auto; max-height: 20rem !important;overflow: auto;margin: 0px;">
								${cadena}
							</div>`,
                    function () {
                        // Cada boton tendra la clase .grupoTransferID donde ID es el id del
                        // grupo de entrada
                        // Aqui se iteran los ids o lo que sea de los grupos de entrada
                        IngroupsTransfer.forEach((val, index) => {
                            $(`.grupoTransferId${index + 1}`).click(function () {
                                if ($(this).hasClass("btn-light")) {
                                    $(".grupoTransferButtons").addClass("btn-light")
                                    $(".grupoTransferButtons").removeClass("btn-info")
                                    $(this).removeClass("btn-light")
                                    $(this).toggleClass("btn-info")
                                } else {
                                    transfiereLocalCloser(1, val.id);
                                    Swal.close()
                                }
                            })
                        })
                        $(`.grupoTransferIdES`).click(function () {
                            if ($(this).hasClass("btn-light")) {
                                $(".grupoTransferButtons").addClass("btn-light")
                                $(".grupoTransferButtons").removeClass("btn-info")
                                $(this).removeClass("btn-light")
                                $(this).toggleClass("btn-info")
                            } else {
                                transfiereLocalCloser(3);
                                Swal.close()
                            }
                        })

                    }
                )
                //
            }
            )
            $(".agentesTransfer").click(function () {
                let cadena = ``;// se debe generar la string con los grupos de entrada
                AgentesTransfer.forEach((val, index) => {
                    cadena = cadena.concat(`
							<button class="grupoTransferId${index + 1} grupoTransferButtons font-weight-bold btn btn-light col" style="font-size: 0.9rem;font-weight: bold !important;">
								${val}
							</button>
						`);
                });

                swalStepped(
                    "question",
                    traducirFrase("A que agente se transferira"),
                    `'	<br>
							<div class="row px-4" style="width: 100%; height: auto; max-height: 20rem !important;overflow: auto;margin: 0px;">
								${cadena}
							</div>`,
                    function () {

                        AgentesTransfer.forEach((val, index) => {
                            $(`.grupoTransferId${index + 1}`).click(function () {
                                if ($(this).hasClass("btn-light")) {
                                    $(".grupoTransferButtons").addClass("btn-light")
                                    $(".grupoTransferButtons").removeClass("btn-info")
                                    $(this).removeClass("btn-light")
                                    $(this).toggleClass("btn-info")
                                } else {
                                    transfiereLocalCloser(2, val);
                                    Swal.close()
                                }
                            })
                        })

                    }
                )
                //
            }
            )

        }
    )
}