<?php

$idioma = "es";
if (isset($_COOKIE["idioma"])) {
    $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
}

?>
<div id="mainTwo" v-cloak>
	<div class="animated fadeIn">
		<div class="col s12 card-panel white" style="margin-top: 75px;">
			<h4>{{traducirFrase("Reporte de pausa")}}</h4>
			<div class="row">
				<div class="col s9 input-field">
					<label class="active">{{traducirFrase("Fecha")}}</label>
					<input
						type="text"
						autocomplete="off"
						start-date="new Date()"
						class=" datepicker-here"
						data-range="true"
						data-multiple-dates-separator=" - "
						data-date-format="yyyy-mm-dd"
						data-language="<?=$idioma;?>"
						class="datepicker-here"
						id="fechaReportePausa"
					/>
				</div>
				<div class="col s3 input-field" style="display: flex;flex-direction: row;justify-content: space-around;">
					<button class="btn blue waves-effect waves-light" @click="generateReport">
						{{traducirFrase("Generar reporte")}}
					</button>
					<button class="btn teal waves-effect waves-light" @click="downloadReport">
						<i class="material-icons">get_app</i>
					</button>
				</div>
			</div>
			<div class="row">
				<div class="row col s12 blue lighten-4 pt-1 pb-1 mb-0">
					<div class="col s3">
						{{traducirFrase("Agente")}}
					</div>
					<div class="col s3">
						{{traducirFrase("Fecha")}}
					</div>
					<div class="col s3">
						{{traducirFrase("Codigo de pausa")}}
					</div>
					<div class="col s3">
						{{traducirFrase("Supervisor")}}
					</div>
				</div>
				<div class="row col s12 pt-1 pb-1 mb-0 hoverable" v-for="registro in registros" :key="registro.fecha">
					<div class="col s3">
						{{ registro.agente }}
					</div>
					<div class="col s3">
						{{ registro.fecha }}
					</div>
					<div class="col s3">
						{{ registro.pause_code }}
					</div>
					<div class="col s3">
						{{ registro.supervisor === "" ? traducirFrase("No se requirio supervisor") : registro.supervisor }}
					</div>
				</div>
				<div class="row col s12 pt-1 pb-1 hoverable" v-if="registros.length === 0">
					<div class="col s12">
						<h4>
							{{traducirFrase("No hay reporte en este rango de fechas")}}
						</h4>
					</div>
				</div>
			</div>
			<br>
		</div>
	</div>
</div>
<!-- END MAIN -->
<!-- ================================================
    Scripts
    ================================================ -->
<?php require_once "script.php";?>