<modal-dialvox v-model="modalCamposCRM" small cancel="Cerrar" :disabled="true">
    <h4>{{traducirFrase("Campos del CRM")}}</h4>
    <br><br>
    <div class="container">
        <div class="row" v-for="(campo, index) in campos">
            <div class="col s12" :key="index">
                <div class="card">
                    <div class="card-content" v-if="campo.EnEdicion">
                        <div class="row">
                            <div class="input-field col s12">
                                <input type="text" v-bind:placeholder="traducirFrase('Nombre del campo')" v-model="campo.Nombre" />
                                <label class="active">{{traducirFrase("Nombre")}}</label>
                            </div>
                            <div class="input-field col s6">
                                <label class="active">{{traducirFrase("Tipo del campo")}}</label>
                                <select class="browser-default" v-model="campo.Tipo">
                                    <option v-for="item in tiposCampo" :value="item.value" :key="item.value">
                                        {{ item.label }}
                                    </option>
                                </select>
                            </div>
                            <div class="input-field col s6">
                                <label class="active">{{traducirFrase("Edicion")}}</label>
                                <select class="browser-default" v-model="campo.Edicion">
                                    <option v-for="item in valoresEdicion" :value="item.value" :key="item.value">
                                        {{ item.label }}
                                    </option>
                                </select>
                            </div>
                            <div class="input-field col s12" v-if="campo.Tipo === 1">
                                <textarea rows="3" class="materialize-textarea" v-model="campo.Valor"></textarea>
                                <label class="active">{{traducirFrase("Valor por defecto")}}</label>
                            </div>
                            <div class="input-field col s12" v-else-if="campo.Tipo === 2">
                                <input type="text" v-bind:placeholder="traducirFrase('Valor por defecto')" v-model="campo.Valor"/>
                                <label class="active">{{traducirFrase("Valor por defecto")}}</label>
                            </div>
                            <div class="input col s12 row" v-else-if="campo.Tipo === 3">
                                <div class="col s12">
                                    {{traducirFrase("Opciones del select")}}
                                </div>
                                <div class="col s12 row" v-for="(opcion, opcion_index) in campo.Opciones">
                                    <div class="input-field col s5">
                                        <input type="text" v-model="opcion.label">
                                        <label class="active">{{traducirFrase("Nombre")}}</label>
                                    </div>
                                    <div class="input-field col s5">
                                        <input type="text" v-model="opcion.value">
                                        <label class="active">{{traducirFrase("Valor")}}</label>
                                    </div>
                                    <div class="col s2 right-align">
                                        <button class="btn waves-effect waves-light red" @click="eliminarOpcionACampo(index, opcion_index)">
                                            <i class="material-icons">delete</i>
                                        </button>
                                    </div>
                                </div>
                                <div class="col s12 right-align">
                                    <button class="btn waves-effect waves-light primary" @click="agregarOpcionACampo(index)">
                                        {{traducirFrase("Agregar opcion")}}
                                    </button>
                                </div>
                            </div>
                            <div class="input-field col s12" v-else-if="campo.Tipo === 4">
                                <p>
                                    <label>
                                        <input type="checkbox" v-model="campo.Valor">
                                        <span>{{traducirFrase("Valor por defecto")}}</span>
                                    </label>
                                </p>
                            </div>
                            <div class="input-field col s12">
                                <label class="active">{{traducirFrase("Categoria")}}</label>
                                <select class="browser-default" v-model="campo.Categoria">
                                    <option v-for="item in selectCategorias" :value="item.value" :key="item.value">
                                        {{ item.label }}
                                    </option>
                                </select>
                            </div>
                            <div class="input-field col s12">
                                <p>
                                    <label>
                                        <input type="checkbox" v-model="campo.Busqueda"/>
                                        <span>{{traducirFrase("Campo para busqueda")}}</span>
                                    </label>
                                </p>
                            </div>
                            <div class="input-field col s12">
                                <p>
                                    <label>
                                        <input type="checkbox" v-model="campo.Requerido"/>
                                        <span>{{traducirFrase("Campo obligatorio (No se va a poder dejar el campo en blanco)")}}</span>
                                    </label>
                                </p>
                            </div>
                            <div class="input-field col s12 right-align">
                                <button class="btn blue darken-1 waves-effect waves-light" @click="guardarCampo(index)" type="button">
                                    {{traducirFrase("Guardar")}}
                                </button>
                                <button class="btn red waves-effect waves-light" @click="cancelarEdicionCampo(index)" type="button">
                                    {{traducirFrase("Cancelar")}}
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="card-content" v-else>
                        <div class="row" style="display: flex">
                            <h6 style="flex-grow: 1;margin: 0px 8px;">{{ campo.Nombre }}</h6>
                            <button class="btn blue darken-1 waves-effect waves-light" style="margin: 0px 4px;" @click="editarCampo(index)">
                                <i class="material-icons">edit</i>
                            </button>
                            <button class="btn red darken-1 waves-effect waves-light" style="margin: 0px 4px;" @click="eliminarCampo(index)">
                                <i class="material-icons">delete</i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row align-right">
            <button class="btn blue darken-1" @click="agregarCampo">
                {{traducirFrase("Agregar campo")}}
            </button>
        </div>
    </div>
</modal-dialvox>
