<?php
$idioma = "es";
if (isset($_COOKIE["idioma"])) {
    $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
}
?>
<modal-dialvox v-model="targets.holidays" small @submit="targets.holidays = false" :send="traducirFrase('Cerrar')" :disabled="true">
    <h4>{{traducirFrase("Dias festivos")}}</h4>
    <br><br>
    <div class="container">
        <div class="row" style="display: flex; flex-direction: row; gap: 0.75rem;align-items: center;">
            <div class="input-field" style="flex-grow: 1;">
                <select v-model="holiday" class="browser-default">
                    <option v-for="opt in holidaysByCalltime" :key="opt.value" :value="opt.value">
                        {{opt.label}}
                    </option>
                </select>
                <label class="active">{{traducirFrase("Selecciona un dia festivo")}}</label>
            </div>
            <button class="btn waves-effect waves-light blue lighten-2" @click="addHoliday">
                Agregar
            </button>
        </div>
        <div class="row">
            <table-dialvox :headers="holidaysHeaders" :hsearch="true" :data="calltimeHolidays" <?php if ($_SESSION["Grupo"] == GRUPO_ADMINS) {?> :options="holidaysOptions" :loading="loading" <?php }?> @delete="deleteHoliday($event)"></table-dialvox>
        </div>
    </div>
</modal-dialvox>