<?php
$idioma = "es";
if (isset($_COOKIE["idioma"])) {
    $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
}
?>
<modal-dialvox v-model="targets.add" small @submit="add('addCallTime', 'add')" :disabled="!validForm">
    <h4>{{traducirFrase("Registrar horario de llamada")}}</h4>
    <br><br>
    <div class="container">
        <div class="row">
            <div class="input-field col s12">
                <input id="call_time_id" type="text" class="validate" placeholder="Identificador" v-model = "one.call_time_id">
                <label for="call_time_id">{{traducirFrase("Identificador (Debe ser único)")}}</label>
            </div>
        </div>
        <div class="row">
            <div class="input-field col s12">
                <input id="call_time_name" type="text" class="validate" placeholder="Nombre" v-model = "one.call_time_name">
                <label for="call_time_name">{{traducirFrase("Nombre")}}</label>
            </div>
        </div>
        <div class="row">
            <div class="input-field col s12">
                <input id="call_time_comments" type="text" class="validate" placeholder="Comentarios" v-model = "one.call_time_comments">
                <label for="call_time_comments">{{traducirFrase("Comentarios")}}</label>
            </div>
        </div>

        <!-- Valores por defecto -->
        <div class="row">
            <div class="input-field col s4">
                <!-- <input id="ct_default_start" type="text" class="validate" placeholder="Hora de inicio por defecto" v-model = "one.ct_default_start"> -->
                <input id="ct_default_start" type="text" class="timepicker">
                <label for="ct_default_start">{{traducirFrase("Hora de inicio por defecto")}}</label>
            </div>
            <div class="input-field col s4">
                <!-- <input id="ct_default_stop" type="text" class="validate" placeholder="Hora de fin por defecto" v-model = "one.ct_default_stop"> -->
                <input id="ct_default_stop" type="text" class="timepicker">
                <label for="ct_default_stop">{{traducirFrase("Hora de fin por defecto")}}</label>
            </div>
            <div class="input-field col s4">
                <select id="default_afterhours_filename_override" class="browser-default" v-model = "one.default_afterhours_filename_override">
                    <option v-for="audio in audios" :key="audio.value" :value="audio.value">
                        {{audio.label}}
                    </option>
                </select>
                <label class="active">{{traducirFrase("Audio")}}</label>
                <span class="helper-text" data-error="wrong" data-success="right">{{traducirFrase("Audio que sonará fuera de las horas registradas")}}</span>
            </div>
        </div>

        <div class="row">
            <div class="col s12" style="display: flex;">
                <ul class="tabs" style="min-height: 65px">
                    <li class="tab" style="flex: 1;"><a style="margin-left: 1.4rem;" href="#sunday">{{traducirFrase("Domingo")}}</a></li>
                    <li class="tab" style="flex: 1;"><a class="rightMargin" href="#monday">{{traducirFrase("Lunes")}}</a></li>
                    <li class="tab" style="flex: 1;"><a class="rightMargin" href="#tuesday">{{traducirFrase("Martes")}}</a></li>
                    <li class="tab" style="flex: 1;"><a class="rightMargin" href="#wednesday">{{traducirFrase("Miércoles")}}</a></li>
                    <li class="tab" style="flex: 1;"><a class="rightMargin" href="#thursday">{{traducirFrase("Jueves")}}</a></li>
                    <li class="tab" style="flex: 1;"><a class="rightMargin" href="#friday">{{traducirFrase("Viernes")}}</a></li>
                    <li class="tab" style="flex: 1;"><a class="rightMargin" href="#saturday">{{traducirFrase("Sábado")}}</a></li>
                </ul>
            </div>

            <!-- Valores del Domingo -->
            <div id="sunday" class="col s12 mt-3">
                <div class="input-field col s4">
                    <!-- <input id="ct_sunday_start" type="text" class="validate" placeholder="Hora de inicio por defecto" v-model = "one.ct_sunday_start"> -->
                    <input id="ct_sunday_start" type="text" class="timepicker">
                    <label for="ct_sunday_start">{{traducirFrase("Hora de inicio por defecto")}}</label>
                </div>
                <div class="input-field col s4">
                    <!-- <input id="ct_sunday_stop" type="text" class="validate" placeholder="Hora de fin por defecto" v-model = "one.ct_sunday_stop"> -->
                    <input id="ct_sunday_stop" type="text" class="timepicker">
                    <label for="ct_sunday_stop">{{traducirFrase("Hora de fin por defecto")}}</label>
                </div>
                <div class="input-field col s4">
                    <select id="sunday_afterhours_filename_override" class="browser-default" v-model = "one.sunday_afterhours_filename_override">
                        <option v-for="audio in audios" :key="audio.value" :value="audio.value">
                            {{audio.label}}
                        </option>
                    </select>
                    <label class="active">{{traducirFrase("Audio")}}</label>
                    <span class="helper-text">{{traducirFrase("Audio que sonará fuera de las horas registradas")}}</span>
                </div>
            </div>

            <!-- Valores del Lunes -->
            <div id="monday" class="col s12 mt-3">
                <div class="input-field col s4">
                    <!-- <input id="ct_monday_start" type="text" class="validate" placeholder="Hora de inicio por defecto" v-model = "one.ct_monday_start"> -->
                    <input id="ct_monday_start" type="text" class="timepicker">
                    <label for="ct_monday_start">{{traducirFrase("Hora de inicio por defecto")}}</label>
                </div>
                <div class="input-field col s4">
                    <!-- <input id="ct_monday_stop" type="text" class="validate" placeholder="Hora de fin por defecto" v-model = "one.ct_monday_stop"> -->
                    <input id="ct_monday_stop" type="text" class="timepicker">
                    <label for="ct_monday_stop">{{traducirFrase("Hora de fin por defecto")}}</label>
                </div>
                <div class="input-field col s4">
                    <select id="monday_afterhours_filename_override" class="browser-default" v-model = "one.monday_afterhours_filename_override"> 
                        <option v-for="audio in audios" :key="audio.value" :value="audio.value">
                            {{audio.label}}
                        </option>
                    </select>
                    <label class="active">Audio</label>
                    <span class="helper-text">{{traducirFrase("Audio que sonará fuera de las horas registradas")}}</span>
                </div>
            </div>

            <!-- Valores del Martes -->
            <div id="tuesday" class="col s12 mt-3">
                <div class="input-field col s4">
                    <!-- <input id="ct_tuesday_start" type="text" class="validate" placeholder="Hora de inicio por defecto" v-model = "one.ct_tuesday_start"> -->
                    <input id="ct_tuesday_start" type="text" class="timepicker">
                    <label for="ct_tuesday_start">{{traducirFrase("Hora de inicio por defecto")}}</label>
                </div>
                <div class="input-field col s4">
                    <!-- <input id="ct_tuesday_stop" type="text" class="validate" placeholder="Hora de fin por defecto" v-model = "one.ct_tuesday_stop"> -->
                    <input id="ct_tuesday_stop" type="text" class="timepicker">
                    <label for="ct_tuesday_stop">{{traducirFrase("Hora de fin por defecto")}}</label>
                </div>
                <div class="input-field col s4">
                    <select id="tuesday_afterhours_filename_override" class="browser-default" v-model = "one.tuesday_afterhours_filename_override">
                        <option v-for="audio in audios" :key="audio.value" :value="audio.value">
                            {{audio.label}}
                        </option>
                    </select>
                    <label class="active">Audio</label>
                    <span class="helper-text">{{traducirFrase("Audio que sonará fuera de las horas registradas")}}</span>
                </div>
            </div>

            <!-- Valores del Miércoles -->
            <div id="wednesday" class="col s12 mt-3">
                <div class="input-field col s4">
                    <!-- <input id="ct_wednesday_start" type="text" class="validate" placeholder="Hora de inicio por defecto" v-model = "one.ct_wednesday_start"> -->
                    <input id="ct_wednesday_start" type="text" class="timepicker">
                    <label for="ct_wednesday_start">{{traducirFrase("Hora de inicio por defecto")}}</label>
                </div>
                <div class="input-field col s4">
                    <!-- <input id="ct_wednesday_stop" type="text" class="validate" placeholder="Hora de fin por defecto" v-model = "one.ct_wednesday_stop"> -->
                    <input id="ct_wednesday_stop" type="text" class="timepicker">
                    <label for="ct_wednesday_stop">{{traducirFrase("Hora de fin por defecto")}}</label>
                </div>
                <div class="input-field col s4">
                    <select id="wednesday_afterhours_filename_override" class="browser-default" v-model = "one.wednesday_afterhours_filename_override">
                        <option v-for="audio in audios" :key="audio.value" :value="audio.value">
                            {{audio.label}}
                        </option>
                    </select>
                    <label class="active">Audio</label>
                    <span class="helper-text">{{traducirFrase("Audio que sonará fuera de las horas registradas")}}</span>
                </div>
            </div>

            <!-- Valores del Jueves -->
            <div id="thursday" class="col s12 mt-3">
                <div class="input-field col s4">
                    <!-- <input id="ct_thursday_start" type="text" class="validate" placeholder="Hora de inicio por defecto" v-model = "one.ct_thursday_start"> -->
                    <input id="ct_thursday_start" type="text" class="timepicker">
                    <label for="ct_thursday_start">{{traducirFrase("Hora de inicio por defecto")}}</label>
                </div>
                <div class="input-field col s4">
                    <!-- <input id="ct_thursday_stop" type="text" class="validate" placeholder="Hora de fin por defecto" v-model = "one.ct_thursday_stop"> -->
                    <input id="ct_thursday_stop" type="text" class="timepicker">
                    <label for="ct_thursday_stop">{{traducirFrase("Hora de fin por defecto")}}</label>
                </div>
                <div class="input-field col s4">
                    <select id="thursday_afterhours_filename_override" class="browser-default" v-model = "one.thursday_afterhours_filename_override">
                        <option v-for="audio in audios" :key="audio.value" :value="audio.value">
                            {{audio.label}}
                        </option>
                    </select>
                    <label class="active">Audio</label>
                    <span class="helper-text">{{traducirFrase("Audio que sonará fuera de las horas registradas")}}</span>
                </div>
            </div>

            <!-- Valores del Viernes -->
            <div id="friday" class="col s12 mt-3">
                <div class="input-field col s4">
                    <!-- <input id="ct_friday_start" type="text" class="validate" placeholder="Hora de inicio por defecto" v-model = "one.ct_friday_start"> -->
                    <input id="ct_friday_start" type="text" class="timepicker">
                    <label for="ct_friday_start">{{traducirFrase("Hora de inicio por defecto")}}</label>
                </div>
                <div class="input-field col s4">
                    <!-- <input id="ct_friday_stop" type="text" class="validate" placeholder="Hora de fin por defecto" v-model = "one.ct_friday_stop"> -->
                    <input id="ct_friday_stop" type="text" class="timepicker">
                    <label for="ct_friday_stop">{{traducirFrase("Hora de fin por defecto")}}</label>
                </div>
                <div class="input-field col s4">
                    <select id="friday_afterhours_filename_override" class="browser-default" v-model = "one.friday_afterhours_filename_override">
                        <option v-for="audio in audios" :key="audio.value" :value="audio.value">
                            {{audio.label}}
                        </option>
                    </select>
                    <label class="active">Audio</label>
                    <span class="helper-text">{{traducirFrase("Audio que sonará fuera de las horas registradas")}}</span>
                </div>
            </div>

            <!-- Valores del Sábado -->
            <div id="saturday" class="col s12 mt-3">
                <div class="input-field col s4">
                    <!-- <input id="ct_saturday_start" type="text" class="validate" placeholder="Hora de inicio por defecto" v-model = "one.ct_saturday_start"> -->
                    <input id="ct_saturday_start" type="text" class="timepicker">
                    <label for="ct_saturday_start">{{traducirFrase("Hora de inicio por defecto")}}</label>
                </div>
                <div class="input-field col s4">
                    <!-- <input id="ct_saturday_stop" type="text" class="validate" placeholder="Hora de fin por defecto" v-model = "one.ct_saturday_stop"> -->
                    <input id="ct_saturday_stop" type="text" class="timepicker">
                    <label for="ct_saturday_stop">{{traducirFrase("Hora de fin por defecto")}}</label>
                </div>
                <div class="input-field col s4">
                    <select id="saturday_afterhours_filename_override" class="browser-default" v-model = "one.saturday_afterhours_filename_override">
                        <option v-for="audio in audios" :key="audio.value" :value="audio.value">
                            {{audio.label}}
                        </option>
                    </select>
                    <label class="active">Audio</label>
                    <span class="helper-text">{{traducirFrase("Audio que sonará fuera de las horas registradas")}}</span>
                </div>
            </div>
        </div>
    </div>
</modal-dialvox>