<?php
require_once "BASEPATH.php";

class GrupoAgentes extends MY_Controller
{
    public function addGroup()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('grupoagentes', "spanish");
                break;
            case "en":
                $this->lang->load('grupoagentes', "english");
                break;
            default:
                $this->lang->load('grupoagentes', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && $_SESSION["Grupo"] == GRUPO_ADMINS) {
            include_once RUTA_APP . 'Sesiones.php';
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $con = getConnection();
            $nombre = limpia($_POST["nombre"]);
            $cliente = $_SESSION["Cliente"];
            $query = "INSERT INTO dialvox_grupos(Cliente,Grupo) VALUES ('$cliente','$nombre')";
            $result = sv_mysqli_query($con, $query);
            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function getGroupsSelect()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('grupoagentes', "spanish");
                break;
            case "en":
                $this->lang->load('grupoagentes', "english");
                break;
            default:
                $this->lang->load('grupoagentes', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && ($_SESSION["Grupo"] == GRUPO_ADMINS || $_SESSION["Grupo"] == GRUPO_SUPERVISORES)) {
            include_once RUTA_APP . 'Sesiones.php';
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $query = "SELECT id,Grupo FROM dialvox_grupos WHERE Cliente = '$cliente' ORDER BY Grupo";
            $result = sv_mysqli_query($con, $query);
            $sal["Estado"] = "ok";
            $sal["Registros"] = array();
            while ($row = sv_mysqli_fetch_array($result)) {
                $sal["Registros"][] = $row;
            }
            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function getGroups()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('grupoagentes', "spanish");
                break;
            case "en":
                $this->lang->load('grupoagentes', "english");
                break;
            default:
                $this->lang->load('grupoagentes', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && ($_SESSION["Grupo"] == GRUPO_ADMINS || $_SESSION["Grupo"] == GRUPO_SUPERVISORES)) {
            include_once RUTA_APP . 'Sesiones.php';
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $con = getConnection();
            $texto = limpia($_POST["texto"]);
            $cliente = $_SESSION["Cliente"];
            $pagina = $_POST["pagina"] - 1;
            $registros = 15;
            $skip = $pagina * $registros;
            $whCliente = "";
            if ($cliente != -1) {
                $whCliente = "Cliente = '$cliente' AND ";
            }

            $query = "SELECT id,Grupo FROM dialvox_grupos WHERE $whCliente Grupo LIKE '%$texto%' ORDER BY Grupo LIMIT $skip,$registros";
            $result = sv_mysqli_query($con, $query);
            $sal["Estado"] = "ok";
            $sal["Registros"] = array();
            while ($row = sv_mysqli_fetch_array($result)) {
                $sal["Registros"][] = $row;
            }
            $sal["Estado"] = "ok";
            $query = "SELECT COUNT(id) FROM dialvox_grupos WHERE $whCliente Grupo LIKE '%$texto%'";
            $result = sv_mysqli_query($con, $query);
            if ($row = sv_mysqli_fetch_array($result)) {
                $sal["Cuenta"] = $row[0];
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function editGroup()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('grupoagentes', "spanish");
                break;
            case "en":
                $this->lang->load('grupoagentes', "english");
                break;
            default:
                $this->lang->load('grupoagentes', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && ($_SESSION["Grupo"] == GRUPO_ADMINS)) {
            include_once RUTA_APP . 'Sesiones.php';
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $con = getConnection();

            $id = limpia($_POST["grupo"]);
            $cliente = $_SESSION["Cliente"];
            $nombre = limpia($_POST["nombre"]);
            $andGrupo = "";
            if ($cliente != -1) {
                $andGrupo = "AND Cliente = '$cliente'";
            }
            $query = "SELECT id FROM dialvox_grupos WHERE id = '$id' $andGrupo";
            $result = sv_mysqli_query($con, $query);
            if ($row = sv_mysqli_fetch_array($result)) {
                $query = "UPDATE dialvox_grupos SET Grupo = '$nombre' WHERE id = '$id' LIMIT 1";
                sv_mysqli_query($con, $query);
                $sal["Estado"] = "ok";
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_permisosEditarGrupo");
            }
            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function index()
    {
        $this->load->view('grupoAgentes/head');
        $this->load->view('grupoAgentes/vw_grupoAgentes');
        $this->load->view('grupoAgentes/foot');
    }
}
