<?php
    /*
      CREATE TABLE dialvox_crm_categoria(
        id INT NOT NULL PRIMARY KEY AUTO_INCREMENT,
        CRM INT NOT NULL,
        Nombre VARCHAR(50) NOT NULL,
        Posicion INT NOT NULL DEFAULT 1,
        Contraido BOOLEAN NOT NULL DEFAULT TRUE,
        Visible BOOLEAN NOT NULL DEFAULT TRUE     
      );
    */
    require_once 'CRM.php';
    class Categoria{
        private $id;
        private $crm;
        private $nombre;
        private $posicion;        
        private $contraido;
        private $visible;        
        public function __construct(?int $id, CRM $crm, string $nombre, string $posicion, bool $contraido, bool $visible){
            $this->id = $id;
            $this->crm = $crm;
            $this->nombre = $nombre;
            $this->posicion = $posicion;
            $this->contraido = $contraido;
            $this->visible = $visible;            
        }
        public function getId():int{
            return $this->id;
        }
        public function setId(int $id):void{
            $this->id = $id;
        }

        
        public function getCRM():CRM{
            return $this->crm;
        }
        
        public function getNombre():string{
            return $this->nombre;
        }
        public function setNombre(string $nombre):void{
            $this->nombre = $nombre;
        }

        public function getPosicion():int{
            return $this->posicion;
        }
        public function setPosicion(int $posicion):void{
            $this->posicion = $posicion;
        }

        public function getContraido():int{
            return $this->contraido;
        }
        public function setContraido(int $contraido):void{
            $this->contraido = $contraido;
        }


        public function getVisible():int{
            return $this->visible;
        }
        public function setVisible(int $visible):void{
            $this->visible = $visible;
        }
        public function toJSON():array{
            $resp = array();
            $resp["id"] = $this->id;
            $resp["CRM"] = $this->crm->toJSON();
            $resp["Nombre"] = $this->nombre;
            $resp["Posicion"] = $this->posicion;
            $resp["Contraido"] = $this->contraido;
            $resp["Visible"] = $this->visible;
            return $resp;
        }
    }    
?>