<script>
    function MToastError(message) {
        M.toast({
            'html': 'Error: ' + message,
            classes: 'red darken-1 white-text'
        });
    }

    function MToastSuccess(message) {
        M.toast({
            'html': message ? message : 'Acción realizada con éxito',
            classes: "green darken-1 white-text"
        });
    }

    function rpost(url, data, file) {
        return new Promise((solve, reject) => {
            
            const obj = {
                url: `<?=MODULOS?>${url}`,
                type: "POST",
                data: data,
                dataType: "text",
                success: function (response) {
                    var res = JSON.parse(response.split(">").pop());
                    if (res.Estado == "ok") {
                        solve(res)
                    } else {
                        reject(res)
                    }
                },
                error: function (err) {
                    reject(err)
                }
            };

            if (file) {
                obj["contentType"] = false;
                obj["processData"] = false;
                obj["enctype"] = "multipart/form-data";
            }

            $.ajax(obj);
        })
    }

    function gen_geturl(url, params) {
        const reduced_params = Object.keys(params).map(key => `${key}=${params[key]}`)
        return `<?= MODULOS?>${url}?${reduced_params.join("&")}`
    }

    function rget(url, params) {
        return new Promise((solve, reject) => {
            $.ajax({
                url: "<?=MODULOS?>" + url + "?" + $.param(params),
                type: "GET",
                dataType: "text",
                success: function (response) {
                    var res = JSON.parse(response.split(">").pop());
                    if (res.Estado == "ok") {
                        solve(res)
                    } else {
                        reject(res)
                    }
                },
                error: function (err) {
                    reject(err)
                }
            });
        })
    }

    function gen_rpost(url, data, file) {
        return new Promise((solve, reject) => {
            rpost(url, data, file).then(res => {
                solve(res)
            }).catch(err => {
                if (err.Estado) {
                    M.toast({
                        'html': err.Descripcion,
                        classes: "red darken-1 white-text"
                    });
                } else {
                    M.toast({
                        'html': traducirFrase("Ha ocurrido un error inesperado"),
                        classes: "red darken-1 white-text"
                    });
                }
                reject(err)
            })
        })
    }

    function gen_rget(url, data, file) {
        return new Promise((solve, reject) => {
            rget(url, data).then(res => {
                solve(res)
            }).catch(err => {
                if (err.Estado) {
                    M.toast({
                        'html': err.Descripcion,
                        classes: "red darken-1 white-text"
                    });
                } else {
                    M.toast({
                        'html': traducirFrase("Ha ocurrido un error inesperado"),
                        classes: "red darken-1 white-text"
                    });
                }
                reject(err)
            })
        })
    }

    function handled_rpost(url, data, file) {
        return new Promise((solve, reject) => {
            rpost(url, data, file).then(res => {
                M.toast({
                    'html': traducirFrase('Accion realizada con exito'),
                    classes: "green darken-1 white-text"
                });
                solve(res)
            }).catch(err => {
                if (err.Estado) {
                    M.toast({
                        'html': err.Descripcion,
                        classes: "red darken-1 white-text"
                    });
                } else {
                    M.toast({
                        'html': traducirFrase("Ha ocurrido un error inesperado"),
                        classes: "red darken-1 white-text"
                    });
                }
                reject(err)
            })
        })
    }

    function conf_rpost(url, data, text, type, confirm, cancel) {
        return Swal.fire({
            title: traducirFrase("¿Estas seguro?"),
            text: text,
            type: type ? type : "warning",
            showCancelButton: true,
            showConfirmButton: true,
            confirmButtonText: confirm ? confirm : traducirFrase("Continuar"),
            cancelButtonText: cancel ? cancel : traducirFrase("Cancelar"),
        }).then(result => {
            if (result.value) {
                return gen_rpost(url, data)
            } else {
                return Promise.reject("cancelled")
            }
        })
    }

    function selectCampanas() {
        return gen_rpost("Campanas/getCampaignsSelect", {})
            .then((r) => {
                return r.Campanas.map((campana) => ({
                    value: campana.campaign_id,
                    label: campana.campaign_name,
                }));
            }).catch(e => null)
    }

    function selectAgentes() {
        return gen_rpost('Usuarios/getAgentSelect', {})
            .then((rusuarios) => {
                return rusuarios.usuarios.map(
                    (usuario) => ({
                        value: usuario.user,
                        label: usuario.full_name,
                    })
                );
            })
            .catch(e => null);
    }

    function selectAudios() {
        return gen_rpost("IVR/seleccionarAudios", {})
            .then((r) => {
                return r.Archivos.map((audio) => ({
                    value: audio.Hash,
                    label: audio.Nombre,
                }));
            })
            .catch(console.log);
    }

    function selectHolidays() {
        return gen_rpost("Holiday/getAllHolidaysSelect", {})
            .then((r) => {
                return r.Registros.map((v) => ({
                    value: v.holiday_id,
                    label: v.holiday_name,
                }));
            })
            .catch(console.log);
    }

    function selectCallTimes() {
        return gen_rpost("CallTime/getAllCallTimeSelect", {})
            .then((r) => {
                return r.Registros.map((v) => ({
                    value: v.call_time_id,
                    label: v.call_time_name,
                }));
            })
            .catch(console.log);
    }

</script>