<?php

$idioma = "es";
if (isset($_COOKIE["idioma"])) {
    $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
}

?>
<div id="mainTwo" v-cloak>
	<div class="animated fadeIn">
		<div class="col s12 card-panel white dv-content" style="margin-top: 75px;">
			<h5>{{traducirFrase("Reporte de Entrantes por DID")}}</h5>
			<div id="spinner">
				<center><img src="<?=IMG_ADMIN;?>spinner.gif" id='barrita'></center>
			</div>
			<div class="row no-bottom dv-flex dv-centered">
				<div class="col dv-flex-grow-1 input-field">
					<label class="active">{{traducirFrase("Fecha")}}</label>
					<input type="text" autocomplete="off" class=" datepicker-here" data-range="true" data-multiple-dates-separator=" - " data-date-format="yyyy-mm-dd" data-language="<?=$idioma;?>" class="datepicker-here" id="fechaReporte" />
				</div>
				<div class="col dv-flex-grow-1 input-field">
					<label for="ingroupReporte" class="active">DID</label>
					<select v-model="ingroups" id="ingroupReporte" multiple>
						<option value="" disabled selected >{{traducirFrase("Selecciona los dids")}}</option>
						<option v-for="op in options" :value="op.value">{{op.label}}</option>
					</select>
					<span class="helper-text">
						{{traducirFrase("Si no seleccionas un did se buscara en todos los dids.")}}
					</span>
				</div>
				<div class="col">
					<button class="waves-effect waves-light btn teal" @click="load()">
						{{traducirFrase("Generar reporte")}}
					</button>
					<div class="waves-effect waves-light btn blue" @click="descargar()">
						{{traducirFrase("Descargar reporte")}}
					</div>
				</div>
			</div>
			<div class="row no-bottom">
				<div class="col s12">
					<label for='archived'>
						<input type="checkbox" v-model="archived" id="archived" />
						<span>{{traducirFrase("Información archivada")}}</span>
					</label>
				</div>
			</div>
			<div class="row">
				<div class="row col s12">
					<h5>{{traducirFrase("Conteo general")}}</h5>
					<table-dialvox
						:headers="headersGeneral"
						:data="registrosGeneral"
						:hsearch="true" />
				</div>
				<div class="row col s12">
					<h5>{{traducirFrase("Conteo por dia")}}</h5>
					<table-dialvox
						:headers="headersFecha"
						:data="registrosFecha"
						:hsearch="true" />
				</div>
				<div class="row col s12">
					<h5>{{traducirFrase("Conteo por hora")}}</h5>
					<table-dialvox
						:headers="headersHoras"
						:data="registrosHoras"
						:hsearch="true" />
				</div>
			</div>
		</div>
	</div>
</div>
<!-- END MAIN -->
<!-- ================================================
    Scripts
    ================================================ -->
<?php require_once "script.php";?>