<?php

$idioma = "es";
if (isset($_COOKIE["idioma"])) {
    $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
}

?>
<div id="mainTwo" v-cloak>
	<div class="animated fadeIn">
		<div class="col s12 ">
			<div class="row">
				<div class="card col s12" style="margin-top: 75px;">
					<div class="card-content">
						<div class="row valign-wrapper">
							<div class="col s2 center-align" v-if="tipo === 'outbound'">
								<label class="active">{{traducirFrase("Campañas")}}</label>
								<select class="browser-default" v-model="filtro">
									<option :value="''" selected>
										{{traducirFrase("Selecciona una campaña")}}
									</option>
									<option v-for="item in campanasSelect" :key="item.value" :value="item.value">
										{{item.label}}
									</option>
								</select>
							</div>
							<div class="col s2 center-align" v-else>
								<label class="active">{{traducirFrase("Grupos de entrada")}}</label>
								<select class="browser-default" v-model="filtro">
									<option :value="''" selected>
										{{traducirFrase("Selecciona una grupo de entrada")}}
									</option>
									<option v-for="item in ingroupsSelect" :key="item.value" :value="item.value">
										{{item.label}}
									</option>
								</select>
							</div>
							<div class="col s3 center-align">
								<label for="fechaReporteStatusAgenteLabel">{{traducirFrase("Fecha")}}</label>
								<input type="text" autocomplete="off" start-date="new Date()" class="datepicker-here" data-range="true" data-multiple-dates-separator=" - " data-date-format="yyyy-mm-dd" data-language="<?=$idioma;?>" id="fechaReporteStatusAgente" />
							</div>
							<div class="col s2 center-align">
								<label class="active">{{traducirFrase("Tipo")}}</label>
								<select class="browser-default" v-model="tipo">
									<option :value="'outbound'">
										{{traducirFrase("Salientes")}}
									</option>
									<option :value="'inbound'">
										{{traducirFrase("Entrantes")}}
									</option>
								</select>
							</div>
							<div class="col s3 center-align">
								<p class="tooltipped" data-position="bottom" v-bind:data-tooltip="traducirFrase('Se incluirán los registros que han sido archivados')">
									<label for="checkboxArchiveStatusAgente">
										<input type="checkbox" id="checkboxArchiveStatusAgente">
										<span>{{traducirFrase("Información archivada")}}</span>
									</label>
								</p>
							</div>
							<div class="col s2 center-align">
								<button class="btn waves-effect waves-light blue tooltipped" @click="load" data-position="bottom" v-bind:data-tooltip="traducirFrase('Generar reporte')">
									<i class="material-icons">search</i>
								</button>
								<button class="btn waves-effect waves-light teal tooltipped" @click="descargar" data-position="bottom" v-bind:data-tooltip="traducirFrase('Descargar reporte')">
									<i class="material-icons">file_download</i>
								</button>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="col s12 card-panel white">
			<h4 id="InGroupstitle">{{traducirFrase("Reporte de status por agente")}}</h4>

			<!--Tabla de registros-->
			<br>
			<table-dialvox :headers="headers" :data="registros" :loading="loading" :hsearch="true"></table-dialvox>
			<br>
		</div>
	</div>
</div>
<!-- END MAIN -->
<!-- ================================================
    Scripts
    ================================================ -->
<?php require_once "script.php";?>