window.app_vue = new Vue({
	el: '#app',
	vuetify: new Vuetify(),
	data() {
		return {
			categorias: [], // Categorias de campos
			campos: [], // Campos para el CRM
			panels: [], // Paneles que se estan mostrando
			respuesta: [], // La informacion del crm que se tiene
			perfilVicidial: null,
			busqueda: '',
			campo: '',
			loading: false,
			telefonoGestion: '',
			resultadosBusqueda: [],
			crm: -1,
			color: 'teal',
			resultadoBusqueda: false,
			lead: window.DIALVOX_LEAD_ID,
			ocultarInfo: false,
			historial: [],
			errorRequerido: '',
			panelsHistorial: [],
			idGestion: '',
		}
	},
	methods: {
		obtenerRespuestasPorCategoria(categoria) {
			const respuestas = this.respuesta.filter(
				resp =>
					resp.Campo.Categoria === categoria &&
					resp.Campo.Edicion !== 0
			)
			return respuestas
		},
		generarOpciones(str) {
			const obj = JSON.parse(str)
			const items = []
			Object.keys(obj).forEach(key => {
				items.push({
					value: obj[key],
					text: key,
				})
			})
			return items
		},
		togglecategoria(num_index) {
			if (!this.panels.includes(num_index)) {
				this.categorias[num_index].Contraido = false
				this.panels.push(num_index)
			} else {
				this.categorias[num_index].Contraido = true
				this.panels = this.panels.filter(panel => panel !== num_index)
			}
		},
		inicializarPanels() {
			this.panels = this.categorias
				.map((categoria, i) => {
					if (!categoria.Contraido) {
						return i
					}
					return null
				})
				.filter(cat => cat !== null)
		},
		inicializarRespuesta(r) {
			this.busqueda = ''
			this.campo = ''
			this.telefonoGestion = r.UltimaGestion.Telefono
			this.respuesta = this.campos.map(campo => {
				return {
					Campo: campo,
					Categoria: campo.Categoria,
					Respuesta: campo.Tipo === 3 ? '' : campo.Valor,
					Id: -1,
				}
			})
			r.Respuestas.forEach(respuesta => {
				const elem = this.respuesta.find(
					val => val.Campo.id === respuesta.Campo.id
				)
				if (elem) {
					elem.Respuesta =
						elem.Campo.Tipo === 4
							? respuesta.Respuesta === 'false'
								? false
								: true
							: respuesta.Respuesta
					elem.Id = respuesta.id
				}
			})
			if (r.PerfilVicidial) {
				const perfilVicidial = {}
				Object.keys(r.PerfilVicidial).forEach(v => {
					if (r.PerfilVicidial[v] !== '' && v !== 'Lista') {
						perfilVicidial[v] = r.PerfilVicidial[v]
					}
				})
				this.perfilVicidial = perfilVicidial
			} else {
				this.perfilVicidial = null
			}
		},
		crearGestion() {
			this.inicializarRespuesta({
				UltimaGestion: { Telefono: window.DIALVOX_PHONE },
				Respuestas: [],
			})
			this.resultadoBusqueda = false
		},
		obtenerGestion(r) {
			this.busqueda = ''
			this.campo = ''
			this.lead = r.Gestion.Lead
			this.resultadoBusqueda = false
			this.iniciar()
		},
		buscarRegistro(inicial) {
			const self = this
			this.loading = true
			console.log(this.busqueda)
			rpost('CustomerRM/buscarGestion', {
				Campo: this.campo,
				Texto: this.busqueda,
			})
				.then(r => {
					this.resultadoBusqueda = true
					this.resultadosBusqueda = r.Resultados.map(res => {
						const respuesta = res.Respuestas.find(
							elem => elem.Campo.id === this.campo
						)
						return {
							Valor: respuesta
								? respuesta.Respuesta
								: traducirFrase('Telefono') +
								  ':' +
								  self.busqueda,
							Nombre: res.PerfilVicidial.Nombre,
							Telefonos: [
								traducirFrase('Tel.') +
									': ' +
									res.PerfilVicidial.Telefono1,
								traducirFrase('Alt.') +
									': ' +
									res.PerfilVicidial.Telefono2,
								traducirFrase('Alt. 2') +
									': ' +
									res.PerfilVicidial.Telefono3,
							],
							Gestion: res.Gestion.id,
							Original: res,
						}
					})
					this.campo = ''
					this.busqueda = ''
					this.loading = false

					if (inicial && this.resultadosBusqueda.length === 1) {
						this.obtenerGestion(this.resultadosBusqueda[0].Original)
					}
				})
				.catch(e => {
					if (e.Estado === 'error') {
						this.resultadoBusqueda = true
						this.resultadosBusqueda = []
					}
					this.loading = false
				})
		},
		guardarInformacion() {
			const self = this

			for (let i = 0; i < this.respuesta.length; i++) {
				const respuesta = this.respuesta[i]
				if (respuesta.Campo.Requerido && respuesta.Campo.Tipo !== 4) {
					if (respuesta.Respuesta === '') {
						this.errorRequerido =
							'Hay algún campo requerido en blanco'

						return
					}
				}
			}

			this.loading = true
			this.errorRequerido = ''

			if (this.idGestion === '') {
				rpost('CustomerRM/agregarGestion', {
					crm: this.crm,
					Telefono: this.telefonoGestion,
					lead: this.lead,
				})
					.then(rgestion => {
						self.idGestion = rgestion.Gestion.id
						rpost('CustomerRM/guardarRespuestas', {
							Gestion: rgestion.Gestion.id,
							Respuestas: this.respuesta.map(resp => ({
								...resp,
								Campo: resp.Campo.id,
							})),
						})
							.then(r => {
								self.loading = false
								self.cargarHistorial()
								self.respuesta.forEach(obj => {
									const newId = r.IdRespuestas.find(
										v => v.Campo === obj.Campo.id
									)
									if (newId) {
										obj.Id = newId.Id
									}
								})
							})
							.catch(e => {
								console.log(e)
								self.loading = false
							})
					})
					.catch(e => {
						console.log(e)
						self.loading = false
					})
			} else {
				this.actualizarRespuestas()
			}
		},
		actualizarRespuestas() {
			// TODO: Actualizar respuestas
			const self = this
			console.log(this.respuesta)
			rpost('CustomerRM/actualizarRespuestas', {
				Gestion: this.idGestion,
				Respuestas: this.respuesta.map(resp => ({
					...resp,
					Campo: resp.Campo.id,
				})),
			})
				.then(r => {
					console.log(this.respuesta)
					self.loading = false
					self.cargarHistorial()
				})
				.catch(e => {
					console.log(e)
					self.loading = false
				})
		},
		iniciar(inicial) {
			let telefono = ''
			const self = this
			this.loading = true
			if (window.DIALVOX_PHONE !== '{{ phone_number }}') {
				telefono = window.DIALVOX_PHONE
			}
			rpost('CustomerRM/obtenerCRMAgente', {
				lead: this.lead,
				telefono,
			})
				.then(r => {
					console.log(r)
					self.categorias = r.Categorias
					self.campos = r.Campos.map(campo =>
						Object.assign(campo, {
							Categoria: campo.Categoria.id,
						})
					)
					self.crm = r.CRM.id
					self.color = r.CRM.Color
					self.ocultarInfo = r.CRM.OcultarInfo
					// Revisar con el back, validar si
					// se recibe la gestion
					if (r.UltimaGestion) {
						self.inicializarRespuesta(r)
						self.cargarHistorial()
					} else {
						self.inicializarRespuesta({
							UltimaGestion: { Telefono: window.DIALVOX_PHONE },
							Respuestas: [],
						})
					}

					self.inicializarPanels()
					self.loading = false
				})
				.catch(e => {
					console.log('ERROR INICIO: ', e, window.DIALVOX_PHONE)
					self.loading = false
					if (window.DIALVOX_PHONE !== '{{ phone_number }}') {
						self.busqueda = window.DIALVOX_PHONE
						self.buscarRegistro(inicial)
					}
				})
		},
		cargarHistorial() {
			const self = this

			rpost('CustomerRM/listarGestionesPorLeadConRespuestas', {
				// TODO: Ruta de crm
				crm: this.crm,
				lead: this.lead,
			})
				.then(({ Estado, Gestiones }) => {
					if (Estado === 'ok') {
						self.historial = Gestiones.map(
							({ Gestion: { Agente, Fecha }, Respuestas }) => {
								return {
									agent: Agente
										? Agente.Nombre
										: 'Sin agente',
									date: Fecha,
									info: Respuestas.map(
										({ Campo: { Nombre }, Respuesta }) => ({
											field: Nombre,
											value: Respuesta,
										})
									),
								}
							}
						)
					}
				})
				.catch(e => {
					if (e.Estado === 'error') {
						console.log('Estado: error')
					}
					console.log(e)
				})
		},
	},
	watch: {
		panels(newVal) {
			this.categorias.forEach((categoria, index) => {
				if (newVal.includes(index)) {
					categoria.Contraido = false
				} else {
					categoria.Contraido = true
				}
			})
		},
	},
	computed: {
		selectCampos() {
			return [
				{ value: '', text: traducirFrase('Telefono (por Campaña)') },
				...this.campos
					.filter(campo => campo.Busqueda)
					.map(campo => ({
						value: campo.id,
						text: campo.Nombre,
					})),
			]
		},
	},
	mounted() {
		const url = new URL(window.location.href)

		console.log('SEARCH PARAMS', url.searchParams.toString())

		if (url.searchParams.has('buscarPrimero')) {
			this.busqueda = window.DIALVOX_PHONE
			console.log('BUSQUEDA', this.busqueda)
			this.buscarRegistro()
		} else {
			console.log('ejecuta iniciar')
			this.iniciar(true)
		}

		const self = this
		if (url.searchParams.has('autoguardado')) {
			setInterval(() => {
				if (self.crm !== -1 && !self.resultadoBusqueda) {
					self.guardarInformacion()
				}
			}, 10000)
		}
	},
})
