<modal-dialvox 
    v-model="targets.secciones" 
    :cancel="traducirFrase('Cancelar')" 
    :disabled="true" 
    @closed="closeSections()"
>
    <h4>{{traducirFrase('Configuracion "Otros"')}}</h4>
    <br>
    <div class="container" style="display:flex;flex-direction:column;">
        <div style="display: flex; flex-direction:column; padding: 0.8rem 0.2rem; border-bottom:solid 1px #eaeaea; border-top:solid 1px #eaeaea;" v-for="config in configSecciones">
            <div style="display: flex; flex-direction:row; gap: 1rem;">
                <div class="input-field" style="flex-grow:1;">
                    <input type="text" v-model="config.label" placeholder="Nombre" :readonly="!config.isEditing">
                    <label class="active">{{traducirFrase("Nombre")}}</label>
                </div>
                <div class="input-field" style="flex-grow:1;">
                    <input type="text" v-model="config.url" placeholder="URL" :readonly="!config.isEditing">
                    <label class="active">{{traducirFrase("URL")}}</label>
                </div>
            </div>
            <div style="display: flex; flex-direction:row; gap: 1rem;">
                <div class="input-field">
                    <i class='material-icons prefix'>{{config.icon}}</i>
                    <input type="text" v-model="config.icon" placeholder="Icono" :readonly="!config.isEditing">
                    <label for="" class="active">{{traducirFrase("Icono")}}</label>
                    <span class="helper-text">
                        {{traducirFrase("Icono que aparece en la barra de navegación para la sección")}}
                    </span>
                </div>
                <div class="input-field" style="flex-grow:1;">
                    <input type="text" v-model="config.script" placeholder="Script" :readonly="!config.isEditing">
                    <label class="active">{{traducirFrase("Script")}}</label>
                    <span class="helper-text">
                        {{traducirFrase("URL del script que se incluye en la pagina con el iframe")}}
                    </span>
                </div>
            </div>
            <div style="display: flex; flex-direction: row; justify-content:flex-end; gap: 1rem; margin: 0.2rem 0;" v-if="!config.isEditing">
                <button class="btn-small z-depth-0 grey lighten-4 waves-effect waves-teal" @click="config.isEditing = true">
                    <i class="material-icons teal-text">edit</i>
                </button>
                <button class="btn-small z-depth-0 grey lighten-4 waves-effect waves-red" @click="deleteSection(config)">
                    <i class="material-icons red-text">delete</i>
                </button>
            </div>
            <div style="display: flex; flex-direction: row; gap: 1rem; justify-content:flex-end; margin: 0.2rem 0;" v-if="config.isEditing">
                <button class="btn-small z-depth-0 grey lighten-4 waves-effect waves-light blue-grey-text" @click="secciones(id_cliente)">
                    Cancelar
                </button>
                <button class="btn-small z-depth-0 grey lighten-4 waves-effect waves-teal teal-text" @click="saveSection(config)">
                    Guardar
                </button>
            </div>
        </div>
        <div style="display: flex; flex-direction:column; gap: 0.2rem; padding: 0.8rem 0.2rem;">
            <div style="display: flex; flex-direction: row; gap: 1rem; justify-content:flex-end; margin: 0.2rem 0;">
                <button class="btn-small z-depth-0 grey lighten-4 waves-effect waves-light blue-grey-text" @click="addSection(false)">
                    Nueva seccion
                </button>
            </div>
        </div>
    </div>
</modal-dialvox>