<?php
require_once "BASEPATH.php";
include_once RUTA_APP . 'Conexion.php';
include_once RUTA_APP . 'Sesiones.php';
require_once 'Clases/Cliente.php';
require_once 'Clases/ClienteDatos.php';
require_once 'Clases/Encuesta/Encuesta.php';
require_once 'Clases/Encuesta/EncuestaDatos.php';
require_once 'Clases/Encuesta/RespuestaCliente.php';
require_once 'Clases/Encuesta/RespuestaClienteDatos.php';
require_once 'Clases/Encuesta/Pregunta.php';
require_once 'Clases/Encuesta/PreguntaDatos.php';

use Encuesta\EncuestaDatos;
use Encuesta\PreguntaDatos;
use Encuesta\RespuestaClienteDatos;

class ReporteEncuestas extends MY_Controller
{

    public function index()
    {
        $this->load->view('reporteEncuestas/head');
        $this->load->view('reporteEncuestas/vw_content');
        $this->load->view('reporteEncuestas/foot');
    }

    public function reporteDetallado()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('reporteencuestas', "spanish");
                break;
            case "en":
                $this->lang->load('reporteencuestas', "english");
                break;
            default:
                $this->lang->load('reporteencuestas', "spanish");
                break;
        }
        $fechaInicio = "";
        $idEncuesta = "";
        $fechaFin = "";
        $nombreEncuesta = "";
        if (!empty($_SESSION["Usuario"]) && ($_SESSION["Grupo"] == GRUPO_ADMINS || $_SESSION["Grupo"] == GRUPO_SUPERVISORES)) {
            $con = getConnection();
            $sal = array();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            if (isset($_POST["encuesta"]) && isset($_POST["fechaInicio"]) && isset($_POST["fechaFin"])) {
                $fechaInicio = $_POST["fechaInicio"];
                $idEncuesta = $_POST["encuesta"];
                $fechaFin = $_POST["fechaFin"];
                $listaCampanas = $_POST["campanas"];
                $campanas = [];
                if (strlen($listaCampanas) > 0) {
                    $campanas = explode(",", $listaCampanas);
                }
                $sal["Respuesta"] = array();
                $sal["Encuestas"] = array();
                $encuesta = EncuestaDatos::getEncuestaById($idEncuesta, $con);
                if ($encuesta != null) {
                    if ($cliente->esRoot() || ClienteDatos::compareCliente($cliente, $encuesta)) {
                        $preguntas = PreguntaDatos::getPreguntasByEncuesta($encuesta, $con);
                        for ($i = 0; $i < count($preguntas); $i++) {
                            $respuestas = RespuestaClienteDatos::getRespuestasByPreguntaBetweenDateRange($preguntas[$i], $fechaInicio, $fechaFin, $con, $campanas);
                            for ($j = 0; $j < count($respuestas); $j++) {
                                $loAgrege = false;
                                for ($k = 0; $k < count($sal["Encuestas"]); $k++) {
                                    if (strcmp($sal["Encuestas"][$k]["Telefono"], $respuestas[$j]->getTelefono()) == 0) {
                                        $fechaMenorActual = $sal["Encuestas"][$k]["FechaMenor"];
                                        $fechaMayorActual = $sal["Encuestas"][$k]["FechaMayor"];
                                        $fechaEvaluada = $respuestas[$j]->getTimestamp();

                                        $fechaMas5 = clone $fechaMayorActual;
                                        $fechaMas5 = $fechaMas5->add(new \DateInterval('PT5M'));

                                        $fechaMenos5 = clone $fechaMenorActual;
                                        $fechaMenos5 = $fechaMenos5->sub(new \DateInterval('PT5M'));
                                        if ($fechaEvaluada >= $fechaMenorActual && $fechaEvaluada <= $fechaMayorActual) {
                                            //Coincidio, entonces lo inserto, y puedo salirme del ciclo
                                            $posicion = 0;
                                            for ($l = 0; $l < count($sal["Encuestas"][$k]["Respuestas"]); $l++) {
                                                if ($sal["Encuestas"][$k]["Respuestas"][$l]->getTimestamp() > $fechaEvaluada) {
                                                    $posicion = $l - 1;
                                                    break;
                                                }
                                            }
                                            array_splice($sal["Encuestas"][$k]["Respuestas"], $posicion, 0, array($respuestas[$j]));
                                            $loAgrege = true;
                                        } else {
                                            //No coincidio, puede que sea de una nueva encuesta o este en otro rango
                                            if ($fechaEvaluada >= $fechaMenos5 && $fechaEvaluada < $fechaMenorActual) {
                                                //Es el nuevo punto minimo de comparacion
                                                $sal["Encuestas"][$k]["FechaMenor"] = $fechaEvaluada;
                                                array_splice($sal["Encuestas"][$k]["Respuestas"], 0, 0, array($respuestas[$j]));
                                                $loAgrege = true;

                                            } elseif ($fechaEvaluada <= $fechaMas5 && $fechaEvaluada > $fechaMayorActual) {
                                                //Es el nuevo punto maximo de comparacion
                                                $sal["Encuestas"][$k]["FechaMayor"] = $fechaEvaluada;
                                                $sal["Encuestas"][$k]["Respuestas"][] = $respuestas[$j];
                                                $loAgrege = true;
                                            }
                                        }
                                        if ($loAgrege) {
                                            break;
                                        }

                                    }
                                }
                                if (!$loAgrege) {
                                    $sal["Encuestas"][] = array(
                                        "FechaMayor" => $respuestas[$j]->getTimestamp(),
                                        "FechaMenor" => $respuestas[$j]->getTimestamp(),
                                        "Telefono" => $respuestas[$j]->getTelefono(),
                                        "Respuestas" => array($respuestas[$j]),
                                    );
                                }
                            }
                        }
                        $nombreEncuesta = $encuesta->getNombre();
                        $sal["Estado"] = "ok";
                    } else {
                        $sal["Estado"] = "error";
                        $sal["Descripcion"] = $this->lang->line("detallado_error_encuestaCliente"); //Aqui mostrar el error de que la encuesta no pertenece al cliente
                    }
                } else {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("detallado_error_encuestaNoEncontrada"); //Aqui mostrar el error de que no se encontro la encuesta
                }
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("detallado_error_faltanParametros"); //Aqui mostrar el error de faltan parametros
            }
            sv_mysqli_close($con);
        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("detallado_error_noEstaLogueado"); //Aqui mostrar el error de que el usuario no esta logueado
        }
        ob_clean();
        if ($sal["Estado"] == "ok") {
            header("Content-type: text/csv");
            header("Content-Disposition: attachment; filename=\"Reporte De Encuestas Detallado " . $nombreEncuesta . " (" . $fechaInicio . "-" . $fechaFin . ").csv\"");
            header("Pragma: no-cache");
            header("Expires: 0");
            $out = fopen('php://output', 'w');
            $txtTelefono = $this->lang->line("detallado_telefono");
            $txtFecha = $this->lang->line("detallado_fecha");
            $txtPregunta = $this->lang->line("detallado_pregunta");
            $txtRespuesta = $this->lang->line("detallado_respuesta");
            $txtAccion = $this->lang->line("detallado_accion");
            $txtAgente = $this->lang->line("detallado_agente");
            $txtCampana = $this->lang->line("detallado_campania");
            fputcsv($out, array($txtTelefono, $txtAgente, $txtCampana, $txtFecha, $txtPregunta, $txtRespuesta, $txtAccion));
            for ($i = 0; $i < count($sal["Encuestas"]); $i++) {
                for ($j = 0; $j < count($sal["Encuestas"][$i]["Respuestas"]); $j++) {
                    $respuesta = $sal["Encuestas"][$i]["Respuestas"][$j];
                    $accion = $this->lang->line("detallado_colgar");
                    if ($j < count($sal["Encuestas"][$i]["Respuestas"]) - 1) {
                        if ($sal["Encuestas"][$i]["Respuestas"][$j + 1]->getPregunta()->getId() == $respuesta->getPregunta()->getId()) {
                            $accion = $this->lang->line("detallado_repetirPregunta");
                        } else {
                            $accion = $this->lang->line("detallado_siguientePregunta");
                        }
                    }
                    $arrPoner = array(
                        $sal["Encuestas"][$i]["Telefono"],
                        ($respuesta->getAgente() != null ? $respuesta->getAgente()->getNombre() : ""),
                        $respuesta->getCampana()->getNombre(),
                        date_format($respuesta->getTimestamp(), 'd/m/Y H:i:s'),
                        $respuesta->getPregunta()->getNombre(),
                        $respuesta->getRespuesta()->getNombre(),
                        $accion,
                    );
                    fputcsv($out, $arrPoner);
                }
            }
            fclose($out);
        } else {
            header('Content-Type: application/json');
            $this->output->set_output(json_encode($sal));
        }
    }
    public function reporteGeneral()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('reporteencuestas', "spanish");
                break;
            case "en":
                $this->lang->load('reporteencuestas', "english");
                break;
            default:
                $this->lang->load('reporteencuestas', "spanish");
                break;
        }
        $fechaInicio = "";
        $idEncuesta = "";
        $fechaFin = "";
        $nombreEncuesta = "";
        if (!empty($_SESSION["Usuario"]) && ($_SESSION["Grupo"] == GRUPO_ADMINS || $_SESSION["Grupo"] == GRUPO_SUPERVISORES)) {
            $con = getConnection();
            $sal = array();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            if (isset($_POST["encuesta"]) && isset($_POST["fechaInicio"]) && isset($_POST["fechaFin"])) {
                $fechaInicio = $_POST["fechaInicio"];
                $idEncuesta = $_POST["encuesta"];
                $fechaFin = $_POST["fechaFin"];
                $listaCampanas = $_POST["campanas"];
                $campanas = [];
                if (strlen($listaCampanas) > 0) {
                    $campanas = explode(",", $listaCampanas);
                }

                $sal["Respuestas"] = array();
                $sal["Respuestas"][0] = $this->lang->line("detallado_pregunta");
                $sal["Cuenta"] = array();
                $sal["Totales"] = array();
                $encuesta = EncuestaDatos::getEncuestaById($idEncuesta, $con);
                if ($encuesta != null) {
                    if ($cliente->esRoot() || ClienteDatos::compareCliente($cliente, $encuesta)) {
                        $preguntas = PreguntaDatos::getPreguntasByEncuesta($encuesta, $con);
                        for ($i = 0; $i < count($preguntas); $i++) {
                            $sal["Cuenta"][$i] = array();
                            $sal["Cuenta"][$i][0] = $preguntas[$i]->getNombre();
                            $respuestas = RespuestaClienteDatos::getRespuestasByPreguntaBetweenDateRange($preguntas[$i], $fechaInicio, $fechaFin, $con, $campanas);
                            $sal["Totales"][$i] = count($respuestas);
                            for ($j = 0; $j < count($respuestas); $j++) {
                                $nombreABuscar = $respuestas[$j]->getRespuesta()->getNombre();
                                if (strlen($nombreABuscar) == 0) {
                                    $nombreABuscar = $this->lang->line("general_invalida");
                                }
                                $loAgrego = true;
                                for ($k = 0; $k < count($sal["Respuestas"]); $k++) {
                                    if (strcasecmp($nombreABuscar, $sal["Respuestas"][$k]) == 0) {
                                        $loAgrego = false;
                                        break;
                                    }
                                }
                                if ($loAgrego) {
                                    $sal["Respuestas"][] = $nombreABuscar;
                                }
                                if (array_key_exists($nombreABuscar, $sal["Cuenta"][$i])) {
                                    $sal["Cuenta"][$i][$nombreABuscar] += 1;
                                } else {
                                    $sal["Cuenta"][$i][$nombreABuscar] = 1;
                                }
                            }
                        }
                        $nombreEncuesta = $encuesta->getNombre();
                        $sal["Estado"] = "ok";
                    } else {
                        $sal["Estado"] = "error";
                        $sal["Descripcion"] = $this->lang->line("detallado_error_encuestaCliente"); //Aqui mostrar el error de que la encuesta no pertenece al cliente
                    }
                } else {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("detallado_error_encuestaNoEncontrada"); //Aqui mostrar el error de que no se encontro la encuesta
                }
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("detallado_error_faltanParametros"); //Aqui mostrar el error de faltan parametros
            }
            sv_mysqli_close($con);
        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("detallado_error_noEstaLogueado"); //Aqui mostrar el error de que el usuario no esta logueado
        }
        ob_clean();
        if ($sal["Estado"] == "ok") {
            if (isset($_POST["json"])) {
                header('Content-Type: application/json');
                $this->output->set_output(json_encode($sal));
            } else {
                header("Content-type: text/csv");
                header("Content-Disposition: attachment; filename=\"Reporte De Encuestas General " . $nombreEncuesta . " (" . $fechaInicio . "-" . $fechaFin . ").csv\"");
                header("Pragma: no-cache");
                header("Expires: 0");
                $out = fopen('php://output', 'w');
                $arrayHeader = array();
                $sal["Respuestas"][] = $this->lang->line("detallado_total");
                fputcsv($out, $sal["Respuestas"]);
                for ($i = 0; $i < count($sal["Cuenta"]); $i++) {
                    $porcentajes = array();
                    $cantidades = array();
                    $porcentajes[0] = "%";
                    $cantidades[0] = $sal["Cuenta"][$i][0];
                    for ($j = 1; $j < count($sal["Respuestas"]) - 1; $j++) {
                        if (array_key_exists($sal["Respuestas"][$j], $sal["Cuenta"][$i])) {
                            $cantidades[$j + 1] = $sal["Cuenta"][$i][$sal["Respuestas"][$j]];
                            $porcentajes[$j + 1] = round((($cantidades[$j + 1] * 100) / $sal["Totales"][$i]), 2) . "%";
                        } else {
                            $porcentajes[$j + 1] = "0%";
                            $cantidades[$j + 1] = "0";
                        }
                    }
                    $porcentajes[] = "100%";
                    $cantidades[] = $sal["Totales"][$i];
                    fputcsv($out, $cantidades);
                    fputcsv($out, $porcentajes);
                }
                fclose($out);
            }
        } else {
            header('Content-Type: application/json');
            $this->output->set_output(json_encode($sal));
        }
    }
}
