<?php

require_once "BASEPATH.php";

class Rango extends MY_Controller
{

    public function getRangosSelect()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('rango', "spanish");
                break;
            case "en":
                $this->lang->load('rango', "english");
                break;
            default:
                $this->lang->load('rango', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_decision = limpia($_POST["id_decision"]);
            $sal["Registros"] = array();
            $query = "SELECT id_rango,limite_Izq,incluido_Izq,limite_Der,incluido_Der FROM dialvox_rangos WHERE id_decision='$id_decision' ";
            $result = sv_mysqli_query($con, $query);
            while ($row = sv_mysqli_fetch_array($result)) {
                $sal["Registros"][] = $row;
            }
            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function getRangos()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('rango', "spanish");
                break;
            case "en":
                $this->lang->load('rango', "english");
                break;
            default:
                $this->lang->load('rango', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $pagina = limpia($_POST["pagina"]) - 1;
            $id_decision = limpia($_POST["id_decision"]);
            $sal["Registros"] = array();
            $query = "SELECT id_rango,limite_Izq,incluido_Izq,limite_Der,incluido_Der FROM dialvox_rangos WHERE id_decision='$id_decision' LIMIT " . ($pagina * 10) . ",10";
            $result = sv_mysqli_query($con, $query);
            while ($row = sv_mysqli_fetch_array($result)) {
                $sal["Registros"][] = $row;
            }
            $query = "SELECT COUNT(id_rango) AS CANT FROM dialvox_rangos WHERE id_decision='$id_decision' ";
            $result = sv_mysqli_query($con, $query);
            if ($row = sv_mysqli_fetch_array($result)) {
                $sal["Cant"] = $row["CANT"];
            }

            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function deleteRango()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('rango', "spanish");
                break;
            case "en":
                $this->lang->load('rango', "english");
                break;
            default:
                $this->lang->load('rango', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_decision = limpia($_POST["id_decision"]);
            $id_rango = limpia($_POST["id_rango"]);

            $query = "DELETE FROM dialvox_rangos WHERE id_decision='$id_decision' AND id_rango='$id_rango'";
            sv_mysqli_query($con, $query);

            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function addRango()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('rango', "spanish");
                break;
            case "en":
                $this->lang->load('rango', "english");
                break;
            default:
                $this->lang->load('rango', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_decision = limpia($_POST["id_decision"]);
            $limite_Izq = limpia($_POST["limite_Izq"]);
            $incluido_Izq = limpia($_POST["incluido_Izq"]);
            $limite_Der = limpia($_POST["limite_Der"]);
            $incluido_Der = limpia($_POST["incluido_Der"]);
            $tipoDeAccion = limpia($_POST["tipoDeAccion"]);
            $valorDeAccion = limpia($_POST["valorDeAccion"]);

            $query = "INSERT INTO dialvox_rangos(id_decision,limite_Izq,incluido_Izq,limite_Der,incluido_Der,tipoDeAccion,valorDeAccion) VALUES('$id_decision','$limite_Izq','$incluido_Izq','$limite_Der','$incluido_Der','$tipoDeAccion','$valorDeAccion')";
            sv_mysqli_query($con, $query);

            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function editRango()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('rango', "spanish");
                break;
            case "en":
                $this->lang->load('rango', "english");
                break;
            default:
                $this->lang->load('rango', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_rango = limpia($_POST["id_rango"]);
            $id_decision = limpia($_POST["id_decision"]);
            $limite_Izq = limpia($_POST["limite_Izq"]);
            $incluido_Izq = limpia($_POST["incluido_Izq"]);
            $limite_Der = limpia($_POST["limite_Der"]);
            $incluido_Der = limpia($_POST["incluido_Der"]);
            $tipoDeAccion = limpia($_POST["tipoDeAccion"]);
            $valorDeAccion = limpia($_POST["valorDeAccion"]);

            $query = "UPDATE dialvox_rangos SET id_decision='$id_decision',limite_Izq='$limite_Izq',incluido_Izq='$incluido_Izq',limite_Der='$limite_Der',incluido_Der='$incluido_Der',tipoDeAccion='$tipoDeAccion',valorDeAccion='$valorDeAccion' WHERE id_rango='$id_rango'";
            sv_mysqli_query($con, $query);

            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function getRangoDetails()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('rango', "spanish");
                break;
            case "en":
                $this->lang->load('rango', "english");
                break;
            default:
                $this->lang->load('rango', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_rango = limpia($_POST["id_rango"]);
            $query = "SELECT * FROM dialvox_rangos WHERE id_rango='$id_rango'";
            $result = sv_mysqli_query($con, $query);
            if ($row = sv_mysqli_fetch_array($result)) {
                $sal["Respuesta"] = $row;
                $sal["Estado"] = "ok";

            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");

            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);

        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }

    public function index()
    {
        $this->load->view('rango/head');
        $this->load->view('rango/vw_categorias');
        $this->load->view('rango/foot');
    }
}
