<?php

require_once "BASEPATH.php";
class ListasNegras extends MY_Controller
{
    public function trata(&$out, $arreglo, &$lastLinePrinted)
    {
        $llaves = array_keys($arreglo);
        //fputcsv($out,array_values($llaves));
        $llavesNoArreglos = array();
        for ($i = 0; $i < count($llaves); $i++) {
            if (!is_array($arreglo[$llaves[$i]])) {
                //$this->trata($out,$arreglo[$llaves[$i]]);
                // $llavesNoArreglos[] = $llaves[$i];
            }
        }
        $temp = array();
        for ($i = 0; $i < count($llaves); $i++) {
            if (!is_array($arreglo[$llaves[$i]])) {
                $temp[] = $arreglo[$llaves[$i]];
            }
        }
        if (count($temp) > 0) {
            if ($llavesNoArreglos != $lastLinePrinted) {
                fputcsv($out, array_values($llavesNoArreglos));
                $lastLinePrinted = $llavesNoArreglos;
            }
            fputcsv($out, array_values($temp));
        }
        for ($i = 0; $i < count($llaves); $i++) {
            if (is_array($arreglo[$llaves[$i]])) {
                $temp2 = array();
                $temp2[0] = $llaves[$i];
                if (!is_numeric($temp2[0])) {
                    fputcsv($out, array_values($temp2));
                }

                $this->trata($out, $arreglo[$llaves[$i]], $lastLinePrinted);
            }
        }
    }
    public function downloadBlackList()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('listasnegras', "spanish");
                break;
            case "en":
                $this->lang->load('listasnegras', "english");
                break;
            default:
                $this->lang->load('listasnegras', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && ($_SESSION["Grupo"] == GRUPO_ADMINS || $_SESSION["Grupo"] == GRUPO_SUPERVISORES)) {
            include_once RUTA_APP . 'Sesiones.php';
            $idLista = limpia($_GET["idBlackList"]);
            $query = "SELECT nombre FROM blacklist WHERE idblacklist=$idLista";
            $sal = array();
            $con = getConnection();
            $result = sv_mysqli_query($con, $query);
            if ($result && $row = sv_mysqli_fetch_array($result)) {
                $query = "SELECT number FROM blacklisted_numbers WHERE idblacklist='$idLista'";
                $resul = sv_mysqli_query($con, $query);
                $sal["Registros"] = array();
                $sal["Registros"][] = array("Numeros");
                while ($row2 = sv_mysqli_fetch_array($resul)) {
                    $sal["Registros"][] = array($row2["number"]);
                }
                $query = "SELECT vendor_lead_code FROM blacklisted_lead_code WHERE idblacklist='$idLista'";
                $resul = sv_mysqli_query($con, $query);
                $sal["Registros"][] = array("Vendor Lead Code");
                while ($row2 = sv_mysqli_fetch_array($resul)) {
                    $sal["Registros"][] = array($row2["vendor_lead_code"]);
                }
                header("Content-type: text/csv");
                header("Content-Disposition: attachment; filename=\"Numeros en Lista Negra " . $row["nombre"] . ".csv\"");
                header("Pragma: no-cache");
                header("Expires: 0");
                ob_start();
                $out = fopen('php://output', 'w');
                $test = array();
                $this->trata($out, $sal["Registros"], $test);
                fclose($out);
                $str = ob_get_contents();
                ob_end_clean();
                $this->output->set_output($str);
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_listaInexistente");
                $this->output->set_output(json_encode($sal));
            }
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function getBlackListDetails()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('listasnegras', "spanish");
                break;
            case "en":
                $this->lang->load('listasnegras', "english");
                break;
            default:
                $this->lang->load('listasnegras', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && ($_SESSION["Grupo"] == GRUPO_ADMINS || $_SESSION["Grupo"] == GRUPO_SUPERVISORES)) {
            include_once RUTA_APP . 'Sesiones.php';
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $con = getConnection();
            $lista = limpia($_POST["lista"]);
            $and = "AND cliente = '" . $_SESSION["Cliente"] . "'";
            if ($_SESSION["Cliente"] == -1) {
                $and = "";
            }
            $query = "SELECT idblacklist,nombre,descripcion FROM blacklist WHERE idblacklist = $lista $and LIMIT 1";
            $result = sv_mysqli_query($con, $query);
            if ($row = sv_mysqli_fetch_array($result)) {

                $sal["Estado"] = "ok";
                $sal["Lista"] = $row;
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_listaNoEncontrada");
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }

    public function getBlackLists()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('listasnegras', "spanish");
                break;
            case "en":
                $this->lang->load('listasnegras', "english");
                break;
            default:
                $this->lang->load('listasnegras', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && ($_SESSION["Grupo"] == GRUPO_ADMINS || $_SESSION["Grupo"] == GRUPO_SUPERVISORES)) {
            include_once RUTA_APP . 'Sesiones.php';
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $con = getConnection();
            $pagina = $_POST["pagina"] - 1;
            $registros = 10;
            $campana = "campaign_id";
            $skip = $registros * $pagina;
            $and = "AND cliente = '" . $_SESSION["Cliente"] . "'";
            if ($_SESSION["Cliente"] == -1) {
                $and = "";
            }
            $textoBusqueda = "";
            if (isset($_POST["texto"])) {
                $textoBusqueda = limpia($_POST["texto"]);
            }
            $query = "SELECT idblacklist,nombre,descripcion FROM blacklist WHERE nombre LIKE '%$textoBusqueda%' $and ORDER BY idblacklist DESC LIMIT $skip,$registros";
            $result = sv_mysqli_query($con, $query);
            $sal["Estado"] = "ok";
            $sal["Listas"] = array();
            while ($row = $result->fetch_assoc()) {
                $sal["Listas"][] = $row;
            }
            $query = "SELECT COUNT(idblacklist) AS Cuenta FROM blacklist WHERE nombre LIKE '%$textoBusqueda%' $and";
            $result = sv_mysqli_query($con, $query);
            $row = sv_mysqli_fetch_array($result);
            $sal["Cuenta"] = $row["Cuenta"];
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function getBlackListsSelect()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('listasnegras', "spanish");
                break;
            case "en":
                $this->lang->load('listasnegras', "english");
                break;
            default:
                $this->lang->load('listasnegras', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && ($_SESSION["Grupo"] == GRUPO_ADMINS || $_SESSION["Grupo"] == GRUPO_SUPERVISORES)) {
            include_once RUTA_APP . 'Sesiones.php';
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $con = getConnection();
            $and = "AND cliente = '" . $_SESSION["Cliente"] . "'";
            if ($_SESSION["Cliente"] == -1) {
                $and = "";
            }
            $query = "SELECT idblacklist,nombre,descripcion FROM blacklist WHERE 1=1 $and ORDER BY idblacklist DESC ";
            $result = sv_mysqli_query($con, $query);
            $sal["Estado"] = "ok";
            $sal["Listas"] = array();
            while ($row = sv_mysqli_fetch_array($result)) {
                $sal["Listas"][] = $row;
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }

    public function deleteBlackList()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('listasnegras', "spanish");
                break;
            case "en":
                $this->lang->load('listasnegras', "english");
                break;
            default:
                $this->lang->load('listasnegras', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && $_SESSION["Grupo"] == GRUPO_ADMINS) {
            include_once RUTA_APP . 'Sesiones.php';
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $con = getConnection();
            $linea = 0;
            $list_id = limpia($_POST["lista"]);
            $sal = array();
            $con = getConnection();
            $and = "AND cliente = '" . $_SESSION["Cliente"] . "'";
            if ($_SESSION["Cliente"] == -1) {
                $and = "";
            }
            $query = "SELECT idblacklist FROM blacklist WHERE idblacklist = '$list_id' $and LIMIT 1";
            $result = sv_mysqli_query($con, $query);
            if ($row = sv_mysqli_fetch_array($result)) {
                if (strlen($list_id) >= 0) {
                    sv_mysqli_query($con, "UPDATE vicidial_tables_windows SET idblacklist=NULL WHERE idblacklist='$list_id'");
                    sv_mysqli_query($con, "DELETE FROM blacklisted_numbers WHERE idblacklist='$list_id'");
                    sv_mysqli_query($con, "DELETE FROM blacklisted_lead_code WHERE idblacklist='$list_id'");
                    sv_mysqli_query($con, "DELETE FROM blacklist WHERE idblacklist='$list_id'");
                    $sal["Estado"] = "ok";
                } else {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("desc_idLista2");
                }
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_permisosEliminar");
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function deleteNumber()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('listasnegras', "spanish");
                break;
            case "en":
                $this->lang->load('listasnegras', "english");
                break;
            default:
                $this->lang->load('listasnegras', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && $_SESSION["Grupo"] == GRUPO_ADMINS || $_SESSION["Grupo"] == GRUPO_SUPERVISORES) {
            include_once RUTA_APP . 'Sesiones.php';
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $con = getConnection();
            $donde = "";
            $list_id = limpia($_POST["lista"]);
            $cliente = $_SESSION["Cliente"];
            if ($cliente != -1) {
                $donde = "AND cliente = '$cliente'";
            }
            $query = "SELECT idblacklist FROM blacklist WHERE idblacklist= '$list_id' $donde LIMIT 1";
            $result = sv_mysqli_query($con, $query);
            if ($row = sv_mysqli_fetch_array($result)) {
                $phone_number = limpia($_POST["phone_number"]);
                $phone_number = preg_replace('/[^0-9]/', '', $phone_number);
                if (strlen($phone_number) >= 1 && strlen($phone_number) <= TELEFONO_LIMITE && preg_match('/^[0-9]{1,' . TELEFONO_LIMITE . '}$/', $phone_number)) {
                    $list_id = limpia($_POST["lista"]);
                    $result2 = sv_mysqli_query($con, "SELECT * FROM blacklisted_numbers WHERE idblacklist='$list_id' AND number='$phone_number'");
                    if (!($row = sv_mysqli_fetch_array($result2))) {
                        $sal["Estado"] = "error";
                        $sal["Descripcion"] = $this->lang->line("desc_numeroSinRegistrar");
                    } else {
                        $query = "DELETE FROM blacklisted_numbers WHERE idblacklist='$list_id' AND
                        number='$phone_number'";
                        sv_mysqli_query($con, $query);
                        $affected_rows = mysqli_affected_rows($con);
                        if ($affected_rows > 0) {
                            $sal["Estado"] = "ok";
                        } else {
                            $sal["Estado"] = "error";
                            $sal["Descripcion"] = $this->lang->line("desc_registroEliminado");
                        }
                    }
                } else {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("desc_telefonoInvalido");
                }
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_permisosAgregar");
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function deleteLeadCode()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('listasnegras', "spanish");
                break;
            case "en":
                $this->lang->load('listasnegras', "english");
                break;
            default:
                $this->lang->load('listasnegras', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && $_SESSION["Grupo"] == GRUPO_ADMINS || $_SESSION["Grupo"] == GRUPO_SUPERVISORES) {
            include_once RUTA_APP . 'Sesiones.php';
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $con = getConnection();
            $donde = "";
            $list_id = limpia($_POST["lista"]);
            $cliente = $_SESSION["Cliente"];
            if ($cliente != -1) {
                $donde = "AND cliente = '$cliente'";
            }
            $query = "SELECT idblacklist FROM blacklist WHERE idblacklist= '$list_id' $donde LIMIT 1";
            $result = sv_mysqli_query($con, $query);
            if ($row = sv_mysqli_fetch_array($result)) {
                $phone_number = limpia($_POST["phone_number"]);
                $list_id = limpia($_POST["lista"]);
                $result2 = sv_mysqli_query($con, "SELECT * FROM blacklisted_lead_code WHERE idblacklist='$list_id' AND vendor_lead_code='$phone_number'");
                if (!($row = sv_mysqli_fetch_array($result2))) {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("desc_leadCodeNoRegistrado");
                } else {
                    $query = "DELETE FROM blacklisted_lead_code WHERE idblacklist='$list_id' AND
                    vendor_lead_code='$phone_number'";
                    sv_mysqli_query($con, $query);
                    $affected_rows = mysqli_affected_rows($con);
                    if ($affected_rows > 0) {
                        $sal["Estado"] = "ok";
                    } else {
                        $sal["Estado"] = "error";
                        $sal["Descripcion"] = $this->lang->line("desc_registroEliminado");
                    }
                }
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_permisosAgregar");
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function uploadNumbers()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('listasnegras', "spanish");
                break;
            case "en":
                $this->lang->load('listasnegras', "english");
                break;
            default:
                $this->lang->load('listasnegras', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && $_SESSION["Grupo"] == GRUPO_ADMINS || $_SESSION["Grupo"] == GRUPO_SUPERVISORES) {
            include_once RUTA_APP . 'Sesiones.php';
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $con = getConnection();
            $donde = "";
            $list_id = limpia($_POST["lista"]);
            $cliente = $_SESSION["Cliente"];
            if ($cliente != -1) {
                $donde = "AND cliente = '$cliente'";
            }
            $modoEstricto = limpia($_POST["estricto"]);
            if ($modoEstricto == "Y") {
                $modoEstricto = true;
            } else {
                $modoEstricto = false;
            }
            $phone_number = -1;
            $query = "SELECT idblacklist FROM blacklist WHERE idblacklist= '$list_id' $donde LIMIT 1";
            $result = sv_mysqli_query($con, $query);
            $linea = 0;
            $phone_numbers = array();
            $querys = array();
            $sal["Estado"] = "ok";
            if ($row = sv_mysqli_fetch_array($result)) {
                if (($gestor = fopen($_FILES['csv']['tmp_name'], "r")) !== false) {
                    $sal["erroneos"] = array();
                    while (($datos = fgetcsv($gestor, 100000, ",")) !== false) {
                        $fallo = false;
                        if ($linea != 0) {
                            if (array_key_exists($phone_number, $datos)) {
                                if ($phone_number != -1 && (strlen($datos[$phone_number]) >= 1 && strlen($datos[$phone_number]) <= TELEFONO_LIMITE) && preg_match('/^[0-9]{1,' . TELEFONO_LIMITE . '}$/', $datos[$phone_number])) {
                                    $query = "INSERT INTO blacklisted_numbers SET idblacklist='$list_id',
                                        number={$datos[$phone_number]}";
                                    $result2 = sv_mysqli_query($con, "SELECT number FROM blacklisted_numbers WHERE idblacklist='$list_id' AND number={$datos[$phone_number]}");
                                    if ($row = sv_mysqli_fetch_array($result2)) {
                                        $fallo = true;
                                    }
                                    if ($modoEstricto) {
                                        $querys[] = $query;
                                    } else {

                                        if (!$fallo) {
                                            array_push($phone_numbers, $datos[$phone_number]);
                                            sv_mysqli_query($con, $query);
                                            $affected_rows = mysqli_affected_rows($con);
                                            if ($affected_rows <= 0) {
                                                $fallo = true;
                                                $objeto = array();
                                                $objeto["Linea"] = ($linea + 1);
                                                $objeto["Razon"] = $this->lang->line("desc_registroNumero");
                                                if ($phone_number != -1) {
                                                    $objeto["Telefono"] = $datos[$phone_number];
                                                } else {
                                                    $objeto["Telefono"] = "";
                                                }
                                                $sal["erroneos"][] = $objeto;
                                            }
                                        } else {
                                            $fallo = true;
                                            $objeto = array();
                                            $objeto["Linea"] = ($linea + 1);
                                            $objeto["Razon"] = $this->lang->line("desc_numeroExistente");
                                            if ($phone_number != -1) {
                                                $objeto["Telefono"] = $datos[$phone_number];
                                            } else {
                                                $objeto["Telefono"] = "";
                                            }
                                            $sal["erroneos"][] = $objeto;
                                        }
                                    }
                                } else {
                                    $fallo = true;
                                    $objeto = array();
                                    $objeto["Linea"] = ($linea + 1);
                                    $objeto["Razon"] = $this->lang->line("desc_telefonoInvalido");
                                    if ($phone_number != -1) {
                                        $objeto["Telefono"] = $datos[$phone_number];
                                    } else {
                                        $objeto["Telefono"] = "";
                                    }

                                    $sal["erroneos"][] = $objeto;
                                }
                            } else {
                                $fallo = true;
                                $objeto = array();
                                $objeto["Linea"] = ($linea + 1);
                                if ($phone_number != -1) {
                                    $objeto["Telefono"] = $datos[$phone_number];
                                } else {
                                    $objeto["Telefono"] = "";
                                }

                                $sal["erroneos"][] = $objeto;
                            }
                        } else {
                            for ($i = 0; $i < count($datos); $i++) {
                                if (strtolower($datos[$i]) == "telefono") {
                                    $phone_number = $i;
                                }
                            }
                            if ($phone_number == -1) {
                                $sal["Estado"] = "error";
                                $sal["Descripcion"] = $this->lang->line("desc_noTelefono");
                                $this->output->set_output(json_encode($sal));
                                sv_mysqli_close($con);
                                return;
                            }
                        }
                        $linea++;
                        if ($fallo && $modoEstricto) {
                            $sal["Estado"] = "error";
                            $sal["Descripcion"] = $this->lang->line("desc_registrosErroneos");
                            break;
                        }
                    }
                    fclose($gestor);
                    if ($sal["Estado"] != "error") {
                        $sal["Estado"] = "ok";
                        $sal["total"] = $linea - 1;
                        $sal["lista"] = $list_id;
                        foreach ($querys as $q) {
                            sv_mysqli_query($con, $q);
                        }
                        $result = sv_mysqli_query($con, "SELECT campaign_id FROM vicidial_tables_windows where idblacklist='$list_id'");
                        $cambios = array();
                        while ($row = sv_mysqli_fetch_array($result)) {
                            $result2 = sv_mysqli_query($con, "SELECT dial_statuses FROM vicidial_campaigns WHERE campaign_id = {$row["campaign_id"]}");
                            while ($row2 = sv_mysqli_fetch_array($result2)) {
                                $statusDial = trim(substr($row2["dial_statuses"], 0, -1));
                                $result3 = sv_mysqli_query($con, "SELECT list_id FROM vicidial_lists WHERE campaign_id = {$row["campaign_id"]}");
                                while ($row3 = sv_mysqli_fetch_array($result3)) {
                                    $cambios[] = array("statuses" => $statusDial, "list_id" => $row3["list_id"]);
                                }
                            }
                        }
                        foreach ($cambios as $cambio) {
                            $statusArray = explode(" ", $cambio["statuses"]);
                            foreach ($statusArray as $status) {
                                foreach ($phone_numbers as $numero) {
                                    sv_mysqli_query($con, "UPDATE vicidial_list SET status='DNC' WHERE list_id='{$cambio["list_id"]}' AND status='$status' AND phone_number='$numero'");
                                }
                            }
                        }
                    }
                } else {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("desc_archivoInvalido");
                }
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_permisosAgregarLista");
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }

    public function uploadLeadCode()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('listasnegras', "spanish");
                break;
            case "en":
                $this->lang->load('listasnegras', "english");
                break;
            default:
                $this->lang->load('listasnegras', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && $_SESSION["Grupo"] == GRUPO_ADMINS || $_SESSION["Grupo"] == GRUPO_SUPERVISORES) {
            include_once RUTA_APP . 'Sesiones.php';
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $con = getConnection();
            $donde = "";
            $list_id = limpia($_POST["lista"]);
            $cliente = $_SESSION["Cliente"];
            if ($cliente != -1) {
                $donde = "AND cliente = '$cliente'";
            }
            $modoEstricto = limpia($_POST["estricto"]);
            if ($modoEstricto == "Y") {
                $modoEstricto = true;
            } else {
                $modoEstricto = false;
            }
            $phone_number = -1;
            $query = "SELECT idblacklist FROM blacklist WHERE idblacklist= '$list_id' $donde LIMIT 1";
            $result = sv_mysqli_query($con, $query);
            $linea = 0;
            $phone_numbers = array();
            $querys = array();
            $sal["Estado"] = "ok";
            if ($row = sv_mysqli_fetch_array($result)) {
                if (($gestor = fopen($_FILES['csv']['tmp_name'], "r")) !== false) {
                    $sal["erroneos"] = array();
                    while (($datos = fgetcsv($gestor, 100000, ",")) !== false) {
                        $fallo = false;
                        if ($linea != 0) {
                            if (array_key_exists($phone_number, $datos)) {
                                if ($phone_number != -1) {
                                    $query = "INSERT INTO blacklisted_lead_code SET idblacklist='$list_id',
                                        vendor_lead_code='{$datos[$phone_number]}'";
                                    $result2 = sv_mysqli_query($con, "SELECT vendor_lead_code FROM blacklisted_lead_code WHERE idblacklist='$list_id' AND vendor_lead_code='{$datos[$phone_number]}'");
                                    if ($row = sv_mysqli_fetch_array($result2)) {
                                        $fallo = true;
                                    }
                                    if ($modoEstricto) {
                                        $querys[] = $query;
                                    } else {

                                        if (!$fallo) {
                                            array_push($phone_numbers, $datos[$phone_number]);
                                            sv_mysqli_query($con, $query);
                                            $affected_rows = mysqli_affected_rows($con);
                                            if ($affected_rows <= 0) {
                                                $fallo = true;
                                                $objeto = array();
                                                $objeto["Linea"] = ($linea + 1);
                                                $objeto["Razon"] = "Ocurrio un error guardando el registro";
                                                if ($phone_number != -1) {
                                                    $objeto["Telefono"] = $datos[$phone_number];
                                                } else {
                                                    $objeto["Telefono"] = "";
                                                }
                                                $sal["erroneos"][] = $objeto;
                                            }
                                        } else {
                                            $fallo = true;
                                            $objeto = array();
                                            $objeto["Linea"] = ($linea + 1);
                                            $objeto["Razon"] = $this->lang->line("desc_registroExistente");
                                            if ($phone_number != -1) {
                                                $objeto["Telefono"] = $datos[$phone_number];
                                            } else {
                                                $objeto["Telefono"] = "";
                                            }
                                            $sal["erroneos"][] = $objeto;
                                        }
                                    }
                                } else {
                                    $fallo = true;
                                    $objeto = array();
                                    $objeto["Linea"] = ($linea + 1);
                                    $objeto["Razon"] = $this->lang->line("desc_noCampo");
                                    if ($phone_number != -1) {
                                        $objeto["Telefono"] = $datos[$phone_number];
                                    } else {
                                        $objeto["Telefono"] = "";
                                    }

                                    $sal["erroneos"][] = $objeto;
                                }
                            } else {
                                $fallo = true;
                                $objeto = array();
                                $objeto["Linea"] = ($linea + 1);
                                $objeto["Razon"] = $this->lang->line("desc_noCampo");
                                if ($phone_number != -1) {
                                    $objeto["Telefono"] = $datos[$phone_number];
                                } else {
                                    $objeto["Telefono"] = "";
                                }

                                $sal["erroneos"][] = $objeto;
                            }
                        } else {
                            for ($i = 0; $i < count($datos); $i++) {
                                if (strtolower($datos[$i]) == "leadcode") {
                                    $phone_number = $i;
                                }
                            }
                            if ($phone_number == -1) {
                                $sal["Estado"] = "error";
                                $sal["Descripcion"] = $this->lang->line("desc_noLeadCode");
                                $this->output->set_output(json_encode($sal));
                                sv_mysqli_close($con);
                                return;
                            }
                        }
                        $linea++;
                        if ($fallo && $modoEstricto) {
                            $sal["Estado"] = "error";
                            $sal["Descripcion"] = $this->lang->line("desc_registrosErroneos");
                            break;
                        }
                    }
                    fclose($gestor);
                    if ($sal["Estado"] != "error") {
                        $sal["Estado"] = "ok";
                        $sal["total"] = $linea - 1;
                        $sal["lista"] = $list_id;
                        foreach ($querys as $q) {
                            sv_mysqli_query($con, $q);
                        }
                        $result = sv_mysqli_query($con, "SELECT campaign_id FROM vicidial_tables_windows where idblacklist='$list_id'");
                        $cambios = array();
                        while ($row = sv_mysqli_fetch_array($result)) {
                            $result2 = sv_mysqli_query($con, "SELECT dial_statuses FROM vicidial_campaigns WHERE campaign_id = {$row["campaign_id"]}");
                            while ($row2 = sv_mysqli_fetch_array($result2)) {
                                $statusDial = trim(substr($row2["dial_statuses"], 0, -1));
                                $result3 = sv_mysqli_query($con, "SELECT list_id FROM vicidial_lists WHERE campaign_id = {$row["campaign_id"]}");
                                while ($row3 = sv_mysqli_fetch_array($result3)) {
                                    $cambios[] = array("statuses" => $statusDial, "list_id" => $row3["list_id"]);
                                }
                            }
                        }
                        foreach ($cambios as $cambio) {
                            $statusArray = explode(" ", $cambio["statuses"]);
                            foreach ($statusArray as $status) {
                                foreach ($phone_numbers as $numero) {
                                    sv_mysqli_query($con, "UPDATE vicidial_list SET status='DNC' WHERE list_id='{$cambio["list_id"]}' AND status='$status' AND vendor_lead_code='$numero'");
                                }
                            }
                        }
                    }
                } else {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("desc_archivoInvalido");
                }
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_permisosAgregarLista");
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function deleteNumbers()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('listasnegras', "spanish");
                break;
            case "en":
                $this->lang->load('listasnegras', "english");
                break;
            default:
                $this->lang->load('listasnegras', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && $_SESSION["Grupo"] == GRUPO_ADMINS || $_SESSION["Grupo"] == GRUPO_SUPERVISORES) {
            include_once RUTA_APP . 'Sesiones.php';
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $con = getConnection();
            $donde = "";
            $list_id = limpia($_POST["lista"]);
            $cliente = $_SESSION["Cliente"];
            if ($cliente != -1) {
                $donde = "AND cliente = '$cliente'";
            }
            $modoEstricto = limpia($_POST["estricto"]);
            if ($modoEstricto == "Y") {
                $modoEstricto = true;
            } else {
                $modoEstricto = false;
            }
            $phone_number = -1;
            $query = "SELECT idblacklist FROM blacklist WHERE idblacklist= '$list_id' $donde LIMIT 1";
            $result = sv_mysqli_query($con, $query);
            $linea = 0;
            $querys = array();
            $sal["Estado"] = "ok";
            if ($row = sv_mysqli_fetch_array($result)) {
                if (($gestor = fopen($_FILES['csv']['tmp_name'], "r")) !== false) {
                    $sal["erroneos"] = array();
                    while (($datos = fgetcsv($gestor, 100000, ",")) !== false) {
                        $fallo = false;
                        if ($linea != 0) {
                            if (array_key_exists($phone_number, $datos)) {
                                if ($phone_number != -1 && (strlen($datos[$phone_number]) > 1 && strlen($datos[$phone_number]) <= TELEFONO_LIMITE) &&
                                    preg_match('/^[0-9]{1,' . TELEFONO_LIMITE . '}$/', $datos[$phone_number])) {
                                    $query = "DELETE FROM blacklisted_numbers WHERE idblacklist='$list_id' AND number={$datos[$phone_number]}";
                                    $result2 = sv_mysqli_query($con, "SELECT number FROM blacklisted_numbers WHERE idblacklist='$list_id' AND number={$datos[$phone_number]}");
                                    if (!($row = sv_mysqli_fetch_array($result2))) {
                                        $fallo = true;
                                    }
                                    if ($modoEstricto) {
                                        $querys[] = $query;
                                    } else {

                                        if (!$fallo) {
                                            sv_mysqli_query($con, $query);
                                            $affected_rows = mysqli_affected_rows($con);
                                            if ($affected_rows <= 0) {
                                                $fallo = true;
                                                $objeto = array();
                                                $objeto["Linea"] = ($linea + 1);
                                                $objeto["Razon"] = $this->lang->line("desc_noActualizo");
                                                if ($phone_number != -1) {
                                                    $objeto["Telefono"] = $datos[$phone_number];
                                                } else {
                                                    $objeto["Telefono"] = "";
                                                }
                                                $sal["erroneos"][] = $objeto;
                                            }
                                        } else {
                                            $fallo = true;
                                            $objeto = array();
                                            $objeto["Linea"] = ($linea + 1);
                                            $objeto["Razon"] = $this->lang->line("desc_registroInexistente");
                                            if ($phone_number != -1) {
                                                $objeto["Telefono"] = $datos[$phone_number];
                                            } else {
                                                $objeto["Telefono"] = "";
                                            }
                                            $sal["erroneos"][] = $objeto;
                                        }
                                    }
                                } else {
                                    $fallo = true;
                                    $objeto = array();
                                    $objeto["Linea"] = ($linea + 1);
                                    $objeto["Razon"] = $this->lang->line("desc_noCampo");
                                    if ($phone_number != -1) {
                                        $objeto["Telefono"] = $datos[$phone_number];
                                    } else {
                                        $objeto["Telefono"] = "";
                                    }

                                    $sal["erroneos"][] = $objeto;
                                }
                            } else {
                                $fallo = true;
                                $objeto = array();
                                $objeto["Linea"] = ($linea + 1);
                                $objeto["Razon"] = $this->lang->line("desc_noCampo");
                                if ($phone_number != -1) {
                                    $objeto["Telefono"] = $datos[$phone_number];
                                } else {
                                    $objeto["Telefono"] = "";
                                }

                                $sal["erroneos"][] = $objeto;
                            }
                        } else {
                            for ($i = 0; $i < count($datos); $i++) {
                                if (strtolower($datos[$i]) == "telefono") {
                                    $phone_number = $i;
                                }
                            }
                            if ($phone_number == -1) {
                                $sal["Estado"] = "error";
                                $sal["Descripcion"] = $this->lang->line("desc_noLeadCode");
                                $this->output->set_output(json_encode($sal));
                                sv_mysqli_close($con);
                                return;
                            }
                        }
                        $linea++;
                        if ($fallo && $modoEstricto) {
                            $sal["Estado"] = "error";
                            $sal["Descripcion"] = $this->lang->line("desc_registrosErroneos");
                            break;
                        }
                    }
                    fclose($gestor);
                    if ($sal["Estado"] != "error") {
                        $sal["Estado"] = "ok";
                        $sal["total"] = $linea - 1;
                        $sal["lista"] = $list_id;
                        foreach ($querys as $q) {
                            sv_mysqli_query($con, $q);
                        }
                    }
                } else {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("desc_archivoInvalido");
                }
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_permisosAgregarLista");
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function deleteLeadCodes()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('listasnegras', "spanish");
                break;
            case "en":
                $this->lang->load('listasnegras', "english");
                break;
            default:
                $this->lang->load('listasnegras', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && $_SESSION["Grupo"] == GRUPO_ADMINS || $_SESSION["Grupo"] == GRUPO_SUPERVISORES) {
            include_once RUTA_APP . 'Sesiones.php';
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $con = getConnection();
            $donde = "";
            $list_id = limpia($_POST["lista"]);
            $cliente = $_SESSION["Cliente"];
            if ($cliente != -1) {
                $donde = "AND cliente = '$cliente'";
            }
            $modoEstricto = limpia($_POST["estricto"]);
            if ($modoEstricto == "Y") {
                $modoEstricto = true;
            } else {
                $modoEstricto = false;
            }
            $phone_number = -1;
            $query = "SELECT idblacklist FROM blacklist WHERE idblacklist= '$list_id' $donde LIMIT 1";
            $result = sv_mysqli_query($con, $query);
            $linea = 0;
            $querys = array();
            $sal["Estado"] = "ok";
            if ($row = sv_mysqli_fetch_array($result)) {
                if (($gestor = fopen($_FILES['csv']['tmp_name'], "r")) !== false) {
                    $sal["erroneos"] = array();
                    while (($datos = fgetcsv($gestor, 100000, ",")) !== false) {
                        $fallo = false;
                        if ($linea != 0) {
                            if (array_key_exists($phone_number, $datos)) {
                                if ($phone_number != -1) {
                                    $query = "DELETE FROM blacklisted_lead_code WHERE idblacklist='$list_id' AND vendor_lead_code='{$datos[$phone_number]}'";
                                    $result2 = sv_mysqli_query($con, "SELECT vendor_lead_code FROM blacklisted_lead_code WHERE idblacklist='$list_id' AND vendor_lead_code='{$datos[$phone_number]}'");
                                    if (!($row = sv_mysqli_fetch_array($result2))) {
                                        $fallo = true;
                                    }
                                    if ($modoEstricto) {
                                        $querys[] = $query;
                                    } else {

                                        if (!$fallo) {
                                            sv_mysqli_query($con, $query);
                                            $affected_rows = mysqli_affected_rows($con);
                                            if ($affected_rows <= 0) {
                                                $fallo = true;
                                                $objeto = array();
                                                $objeto["Linea"] = ($linea + 1);
                                                $objeto["Razon"] = $this->lang->line("desc_noActualizo");
                                                if ($phone_number != -1) {
                                                    $objeto["Telefono"] = $datos[$phone_number];
                                                } else {
                                                    $objeto["Telefono"] = "";
                                                }
                                                $sal["erroneos"][] = $objeto;
                                            }
                                        } else {
                                            $fallo = true;
                                            $objeto = array();
                                            $objeto["Linea"] = ($linea + 1);
                                            $objeto["Razon"] = $this->lang->line("desc_registroInexistente");
                                            if ($phone_number != -1) {
                                                $objeto["Telefono"] = $datos[$phone_number];
                                            } else {
                                                $objeto["Telefono"] = "";
                                            }
                                            $sal["erroneos"][] = $objeto;
                                        }
                                    }
                                } else {
                                    $fallo = true;
                                    $objeto = array();
                                    $objeto["Linea"] = ($linea + 1);
                                    $objeto["Razon"] = $this->lang->line("desc_noCampo");
                                    if ($phone_number != -1) {
                                        $objeto["Telefono"] = $datos[$phone_number];
                                    } else {
                                        $objeto["Telefono"] = "";
                                    }

                                    $sal["erroneos"][] = $objeto;
                                }
                            } else {
                                $fallo = true;
                                $objeto = array();
                                $objeto["Linea"] = ($linea + 1);
                                $objeto["Razon"] = $this->lang->line("desc_noCampo");
                                if ($phone_number != -1) {
                                    $objeto["Telefono"] = $datos[$phone_number];
                                } else {
                                    $objeto["Telefono"] = "";
                                }

                                $sal["erroneos"][] = $objeto;
                            }
                        } else {
                            for ($i = 0; $i < count($datos); $i++) {
                                if (strtolower($datos[$i]) == "leadcode") {
                                    $phone_number = $i;
                                }
                            }
                            if ($phone_number == -1) {
                                $sal["Estado"] = "error";
                                $sal["Descripcion"] = $this->lang->line("desc_noLeadCode");
                                $this->output->set_output(json_encode($sal));
                                sv_mysqli_close($con);
                                return;
                            }
                        }
                        $linea++;
                        if ($fallo && $modoEstricto) {
                            $sal["Estado"] = "error";
                            $sal["Descripcion"] = $this->lang->line("desc_registrosErroneos");
                            break;
                        }
                    }
                    fclose($gestor);
                    if ($sal["Estado"] != "error") {
                        $sal["Estado"] = "ok";
                        $sal["total"] = $linea - 1;
                        $sal["lista"] = $list_id;
                        foreach ($querys as $q) {
                            sv_mysqli_query($con, $q);
                        }
                    }
                } else {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("desc_archivoInvalido");
                }
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_permisosAgregarLista");
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }

    public function addNumber()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('listasnegras', "spanish");
                break;
            case "en":
                $this->lang->load('listasnegras', "english");
                break;
            default:
                $this->lang->load('listasnegras', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && $_SESSION["Grupo"] == GRUPO_ADMINS || $_SESSION["Grupo"] == GRUPO_SUPERVISORES) {
            include_once RUTA_APP . 'Sesiones.php';
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $con = getConnection();
            $donde = "";
            $list_id = limpia($_POST["lista"]);
            $cliente = $_SESSION["Cliente"];
            if ($cliente != -1) {
                $donde = "AND cliente = '$cliente'";
            }
            $query = "SELECT idblacklist FROM blacklist WHERE idblacklist= '$list_id' $donde LIMIT 1";
            $result = sv_mysqli_query($con, $query);
            if ($row = sv_mysqli_fetch_array($result)) {
                $phone_number = limpia($_POST["phone_number"]);
                $phone_number = preg_replace('/[^0-9]/', '', $phone_number);
                if (strlen($phone_number) >= 1 && strlen($phone_number) <= TELEFONO_LIMITE && preg_match('/^[0-9]{1,' . TELEFONO_LIMITE . '}$/', $phone_number)) {
                    $list_id = limpia($_POST["lista"]);
                    $result2 = sv_mysqli_query($con, "SELECT FROM blacklisted_numbers WHERE idblacklist='$list_id' AND
                        number='$phone_number'");
                    if ($row = sv_mysqli_fetch_array($result2)) {
                        $sal["Estado"] = "error";
                        $sal["Descripcion"] = "Este numero ya esta registrado";
                    } else {
                        $query = "INSERT INTO blacklisted_numbers SET idblacklist='$list_id',
                        number='$phone_number'";
                        sv_mysqli_query($con, $query);
                        $affected_rows = mysqli_affected_rows($con);
                        if ($affected_rows > 0) {
                            $sal["Estado"] = "ok";
                        } else {
                            $sal["Estado"] = "error";
                            $sal["Descripcion"] = $this->lang->line("desc_registroNoAgregado");
                        }
                    }
                } else {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("desc_telefonoInvalido");
                }
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_permisosAgregar");
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function updateBlackList()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('listasnegras', "spanish");
                break;
            case "en":
                $this->lang->load('listasnegras', "english");
                break;
            default:
                $this->lang->load('listasnegras', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && $_SESSION["Grupo"] == GRUPO_ADMINS) {
            include_once RUTA_APP . 'Sesiones.php';
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $con = getConnection();
            $donde = "";
            $cliente = $_SESSION["Cliente"];
            if ($cliente != -1) {
                $donde = "AND cliente = '$cliente'";
            }
            $list_id = $_POST["id"];
            $list_name = $_POST["nombre"];
            $list_description = $_POST["descripcion"];
            $stmt = "SELECT count(idblacklist) from blacklist where idblacklist=$list_id $donde";
            $rslt = sv_mysqli_query($con, $stmt);
            if ($row = sv_mysqli_fetch_array($rslt)) {
                if ($row[0] <= 0) {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("desc_listaInexistente");
                } else {
                    $stmt = "UPDATE blacklist SET nombre = '$list_name', descripcion = '$list_description' WHERE idblacklist = '$list_id' LIMIT 1";
                    sv_mysqli_query($con, $stmt);
                    $sal["Estado"] = "ok";
                }
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_permisosAgregar");
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function duplicateBlackList()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('listasnegras', "spanish");
                break;
            case "en":
                $this->lang->load('listasnegras', "english");
                break;
            default:
                $this->lang->load('listasnegras', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && $_SESSION["Grupo"] == GRUPO_ADMINS) {
            //header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $lista = limpia($_POST["lista"]);
            $con = getConnection();
            $donde = "";
            $cliente = $_SESSION["Cliente"];
            if ($cliente != -1) {
                $donde = "AND cliente = '$cliente'";
            }
            $query = "SELECT idblacklist FROM blacklist WHERE idblacklist= '$lista' $donde LIMIT 1";
            $result = sv_mysqli_query($con, $query);
            if ($row = sv_mysqli_fetch_array($result)) {
                $stmt = "INSERT INTO blacklist(nombre,descripcion,cliente) SELECT nombre,descripcion,cliente FROM blacklist WHERE idblacklist = '$lista' LIMIT 1";
                sv_mysqli_query($con, $stmt);
                $id = mysqli_insert_id($con);
                sv_mysqli_query($con, "UPDATE blacklist SET nombre=CONCAT(nombre,'_copia') WHERE idblacklist='$id'");
                sv_mysqli_query($con, "INSERT blacklisted_numbers (idblacklist,number) SELECT '$id',number FROM blacklisted_numbers WHERE idblacklist='$lista'");
                sv_mysqli_query($con, "INSERT blacklisted_lead_code (idblacklist,vendor_lead_code) SELECT '$id',vendor_lead_code FROM blacklisted_lead_code WHERE idblacklist='$lista'");
                $sal["Estado"] = "ok";
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_permisosAgregar");
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function addBlackList()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('listasnegras', "spanish");
                break;
            case "en":
                $this->lang->load('listasnegras', "english");
                break;
            default:
                $this->lang->load('listasnegras', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && $_SESSION["Grupo"] == GRUPO_ADMINS) {
            //header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $con = getConnection();
            $list_name = limpia($_POST["nombre"]);
            $list_description = limpia($_POST["descripcion"]);
            $cliente = $_SESSION["Cliente"] == -1 ? $_POST["cliente"] : $_SESSION["Cliente"];
            $stmt = "INSERT INTO blacklist(nombre,descripcion,cliente) values('$list_name','$list_description','$cliente')";
            $rslt = sv_mysqli_query($con, $stmt);
            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function index()
    {
        $this->load->view('listasNegras/head');
        $this->load->view('listasNegras/vw_listasnegras');
        $this->load->view('listasNegras/foot');
    }
}
