<?php
require_once "BASEPATH.php";
include_once RUTA_APP . 'Sesiones.php';
include_once "Clases/AudioDatos.php";
include_once "Clases/ClienteDatos.php";
include_once "Clases/MenuDatos.php";
include_once "Clases/OpcionDatos.php";
include_once "Clases/TelefonoDIDDatos.php";
class IVR extends MY_Controller
{
    public function index()
    {
        $this->load->view('ivr/head');
        $this->load->view('ivr/vw_ivr');
        $this->load->view('ivr/foot');
    }
    public function indexAudios()
    {
        $this->load->view("audiosDID/head");
        $this->load->view('audiosDID/vw_audios_did');
        $this->load->view('audiosDID/foot');
    }
    public function indexTelefonos()
    {
        $this->load->view("telefonosDID/head");
        $this->load->view('telefonosDID/vw_telefonos_did');
        $this->load->view('telefonosDID/foot');
    }
    public function indexMenu()
    {
        $this->load->view("menuDID/head");
        $this->load->view("menuDID/vw_menu_did");
        $this->load->view("menuDID/foot");
    }

    // Vista para el dragndrop del IVR

    public function indexCanvas()
    {
        $this->load->view("canvasDID/head");
        $this->load->view("canvasDID/vw_canvas_did");
        $this->load->view("canvasDID/foot");
    }

    public function canvasFrame()
    {
        $this->load->view("canvasFrame/vw_canvas_frame");
    }

    //Aqui van todas las funciones del CRUD de Audios
    //Subir
    public function subirAudio()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('ivr', "spanish");
                break;
            case "en":
                $this->lang->load('ivr', "english");
                break;
            default:
                $this->lang->load('ivr', "spanish");
                break;
        }
        $sal = array();
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $a = new Audio($cliente, $_FILES['audio']["name"], file_get_contents($_FILES['audio']['tmp_name']));
            if (AudioDatos::insertAudio($a) == -1) {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_subirAudio");
            } else {
                $sal["Estado"] = "ok";
            }
        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($sal));
    }
    //Descargar
    public function obtenerAudioStream()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('ivr', "spanish");
                break;
            case "en":
                $this->lang->load('ivr', "english");
                break;
            default:
                $this->lang->load('ivr', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            $usuario = $_SESSION["Usuario"];
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $archivo = AudioDatos::getAudioById($_GET["id"]);
            if ($archivo != null && ($archivo->getCliente()->getId() == $cliente->getId() || $cliente->getId() == -1)) {
                header('Content-type: ' . $archivo->getMimeType());
                echo ($archivo->getBinario());
            }
        } else {
            $this->output->set_output("ERROR");
        }
    }
    //Borrar
    public function eliminarAudio()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('ivr', "spanish");
                break;
            case "en":
                $this->lang->load('ivr', "english");
                break;
            default:
                $this->lang->load('ivr', "spanish");
                break;
        }
        $sal = array();
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $archivo = AudioDatos::getAudioById($_POST["audio"]);
            if ($archivo == null || ($archivo->getCliente()->getId() != $cliente->getId() && ($cliente->getId() != "-1" || $cliente->getId() != -1))) {
                $sal["Estado"] = "error";
            } else {
                if (AudioDatos::deleteAudio($archivo) != 0) {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("desc_eliminarAudio");
                } else {
                    $sal["Estado"] = "ok";
                }
            }
        }
        $this->output->set_output(json_encode($sal));
    }
    //Listar
    public function listarAudios()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('ivr', "spanish");
                break;
            case "en":
                $this->lang->load('ivr', "english");
                break;
            default:
                $this->lang->load('ivr', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $sal = array();
            $archivos = [];
            $cuenta = 0;
            if ($cliente->getId() == "-1") {
                $archivos = AudioDatos::getAudios($_POST["pagina"], 15, $_POST["texto"]);
                $cuenta = AudioDatos::countArchivos($_POST["texto"]);
            } else {
                $archivos = AudioDatos::getAudiosByCliente($cliente, $_POST["pagina"], 15, $_POST["texto"]);
                $cuenta = AudioDatos::countAudiosByCliente($cliente, $_POST["texto"]);
            }
            $sal["Cuenta"] = $cuenta;
            $sal["Archivos"] = array();
            $sal["Estado"] = "ok";
            for ($i = 0; $i < count($archivos); $i++) {
                $sal["Archivos"][$i] = $archivos[$i]->toJSON();
            }
            $this->output->set_output(json_encode($sal));
        }
    }
    //Seleccionar
    public function seleccionarAudios()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('ivr', "spanish");
                break;
            case "en":
                $this->lang->load('ivr', "english");
                break;
            default:
                $this->lang->load('ivr', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $sal = array();
            $archivos = [];
            $cuenta = 0;
            if ($cliente->getId() == "-1") {
                $archivos = AudioDatos::getAllArchivos();
            } else {
                $archivos = AudioDatos::getAllAudiosByCliente($cliente);
            }
            $sal["Estado"] = "ok";
            $sal["Archivos"] = array();
            for ($i = 0; $i < count($archivos); $i++) {
                $sal["Archivos"][$i] = $archivos[$i]->toJSON();
            }
            $this->output->set_output(json_encode($sal));
        }
    }
    //Aqui van todas las funciones del CRUD de Menus
    //Crear
    public function crearMenu()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('ivr', "spanish");
                break;
            case "en":
                $this->lang->load('ivr', "english");
                break;
            default:
                $this->lang->load('ivr', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $audioPrincipal = AudioDatos::getAudioById($_POST["audioPrincipal"]);
            $audioTLE = AudioDatos::getAudioById($_POST["audioTLE"]);
            $audioOpcionInvalida = AudioDatos::getAudioById($_POST["audioOpcionInvalida"]);
            $call_time_id = $_POST["call_time_id"];
            if ($audioPrincipal != null && $audioPrincipal->getCliente()->getId() != $cliente->getId() && $cliente->getId() != "-1" && $cliente->getId() != -1) {
                $audioPrincipal = null;
            }

            if ($audioTLE != null && $audioTLE->getCliente()->getId() != $cliente->getId() && $cliente->getId() != "-1" && $cliente->getId() != -1) {
                $audioTLE = null;
            }

            if ($audioOpcionInvalida != null && $audioOpcionInvalida->getCliente()->getId() != $cliente->getId() && $cliente->getId() != "-1" && $cliente->getId() != -1) {
                $audioOpcionInvalida = null;
            }

            $menu = new Menu(
                $_POST["nombreMenu"],
                $cliente,
                $audioOpcionInvalida,
                $audioPrincipal,
                $audioTLE
            );
            $menu->setCallTimeId($call_time_id);

            if (MenuDatos::insertMenu($menu) == -1) {
                $sal["Estado"] = "error";
            } else {
                $sal["Id"] = MenuDatos::getLastId();
                $sal["Estado"] = "ok";
            }
            $this->output->set_output(json_encode($sal));
        }
    }
    //Editar
    public function editarMenu()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('ivr', "spanish");
                break;
            case "en":
                $this->lang->load('ivr', "english");
                break;
            default:
                $this->lang->load('ivr', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $menu = MenuDatos::getMenuById($_POST["menu"]);
            if ($menu == null || ($menu->getCliente()->getId() != $cliente->getId() && $cliente->getId() != -1 && $cliente->getId() != "-1")) {
                $sal["Estado"] = "error";
            } else {
                $audioPrincipal = AudioDatos::getAudioById($_POST["audioPrincipal"]);
                $audioTLE = AudioDatos::getAudioById($_POST["audioTLE"]);
                $audioOpcionInvalida = AudioDatos::getAudioById($_POST["audioOpcionInvalida"]);
                if ($audioPrincipal != null && $audioPrincipal->getCliente()->getId() != $cliente->getId() && $cliente->getId() != "-1" && $cliente->getId() != -1) {
                    $audioPrincipal = null;
                }

                if ($audioTLE != null && $audioTLE->getCliente()->getId() != $cliente->getId() && $cliente->getId() != "-1" && $cliente->getId() != -1) {
                    $audioTLE = null;
                }

                if ($audioOpcionInvalida != null && $audioOpcionInvalida->getCliente()->getId() != $cliente->getId() && $cliente->getId() != "-1" && $cliente->getId() != -1) {
                    $audioOpcionInvalida = null;
                }
                $menu->setNombre($_POST["nombreMenu"]);
                $menu->setAudioPrincipal($audioPrincipal);
                $menu->setAudioTLE($audioTLE);
                $menu->setAudioOpcionInvalida($audioOpcionInvalida);
                $menu->setCallTimeId($_POST["call_time_id"]);
                if (MenuDatos::updateMenu($menu) == -1) {
                    $sal["Estado"] = "error";
                } else {
                    $sal["Estado"] = "ok";
                }
            }
            $this->output->set_output(json_encode($sal));
        }
    }
    //Borrar
    public function borrarMenu()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('ivr', "spanish");
                break;
            case "en":
                $this->lang->load('ivr', "english");
                break;
            default:
                $this->lang->load('ivr', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $menu = MenuDatos::getMenuById($_POST["menu"]);
            if ($menu == null || ($menu->getCliente()->getId() != $cliente->getId() && $cliente->getId() != -1 && $cliente->getId() != "-1")) {
                $sal["Estado"] = "error";
            } else {
                if (MenuDatos::deleteMenu($menu) != 0) {
                    $sal["Estado"] = "error";
                } else {
                    $sal["Estado"] = "ok";
                }
            }
            $this->output->set_output(json_encode($sal));
        }
    }
    //Listar
    public function listarMenus()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('ivr', "spanish");
                break;
            case "en":
                $this->lang->load('ivr', "english");
                break;
            default:
                $this->lang->load('ivr', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            if ($cliente->getId() == "-1" || $cliente->getId() == -1) {
                $menus = MenuDatos::getMenus($_POST["pagina"], 15, $_POST["texto"]);
                $cuenta = MenuDatos::countMenus($_POST["texto"]);
            } else {
                $menus = MenuDatos::getMenusByCliente($cliente, $_POST["pagina"], 15, $_POST["texto"]);
                $cuenta = MenuDatos::countMenusByCliente($cliente, $_POST["texto"]);
            }
            $sal["Estado"] = "ok";
            $sal["Cuenta"] = $cuenta;
            $sal["Menus"] = array();
            for ($i = 0; $i < count($menus); $i++) {
                $sal["Menus"][$i] = $menus[$i]->toJSON();
            }
            $this->output->set_output(json_encode($sal));
        }
    }
    //Seleccionar
    public function seleccionarMenus()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('ivr', "spanish");
                break;
            case "en":
                $this->lang->load('ivr', "english");
                break;
            default:
                $this->lang->load('ivr', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            if ($cliente->getId() == "-1" || $cliente->getId() == -1) {
                $menus = MenuDatos::getAllMenus();
            } else {
                $menus = MenuDatos::getAllMenusByCliente($cliente);
            }
            $sal["Estado"] = "ok";
            $sal["Menus"] = array();
            for ($i = 0; $i < count($menus); $i++) {
                $sal["Menus"][$i] = $menus[$i]->toJSON();
            }
            $this->output->set_output(json_encode($sal));
        }
    }
    //Obtener solo un menu
    public function obtenerMenu()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('ivr', "spanish");
                break;
            case "en":
                $this->lang->load('ivr', "english");
                break;
            default:
                $this->lang->load('ivr', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $menu = MenuDatos::getMenuById($_POST["menu"]);
            if ($cliente->getId() == "-1" || $cliente->getId() == -1 || $cliente->getId() == $menu->getCliente()->getId()) {
                $sal["Estado"] = "ok";
                $sal["Menu"] = $menu->toJSON();
            } else {
                $sal["Estado"] = "error";
            }
            $this->output->set_output(json_encode($sal));
        }
    }
    //Aqui van todas las funciones del CRUD de Opciones
    //listar
    public function listarOpciones()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('ivr', "spanish");
                break;
            case "en":
                $this->lang->load('ivr', "english");
                break;
            default:
                $this->lang->load('ivr', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $menu = MenuDatos::getMenuById($_POST["menu"]);
            if ($menu == null || ($menu->getCliente()->getId() != $cliente->getId() && $cliente->getId() != -1 && $cliente->getId() != "-1")) {
                $sal["Estado"] = "error";
            } else {
                $sal["Estado"] = "ok";
                $sal["Opciones"] = array();
                $opciones = OpcionDatos::getOpcionesByMenu($menu, $_POST["pagina"], 15, $_POST["texto"]);
                for ($i = 0; $i < count($opciones); $i++) {
                    $sal["Opciones"][$i] = $opciones[$i]->toJSON();
                }
                $sal["Cuenta"] = OpcionDatos::countOpcionesByMenu($menu, $_POST["texto"]);
            }
            $this->output->set_output(json_encode($sal));
        }
    }
    //Seleccionar
    public function seleccionarOpciones()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('ivr', "spanish");
                break;
            case "en":
                $this->lang->load('ivr', "english");
                break;
            default:
                $this->lang->load('ivr', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $menu = MenuDatos::getMenuById($_POST["menu"]);
            if ($menu == null || ($menu->getCliente()->getId() != $cliente->getId() && $cliente->getId() != -1 && $cliente->getId() != "-1")) {
                $sal["Estado"] = "error";
            } else {
                $sal["Estado"] = "ok";
                $opciones = OpcionDatos::getRemaningOpcionesByMenu($menu);
                $sal["Opciones"] = $opciones;
            }
            $this->output->set_output(json_encode($sal));
        }
    }
    //Crear opciones
    public function crearOpcion()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('ivr', "spanish");
                break;
            case "en":
                $this->lang->load('ivr', "english");
                break;
            default:
                $this->lang->load('ivr', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $menu = MenuDatos::getMenuById($_POST["menu"]);
            if ($menu == null || ($menu->getCliente()->getId() != $cliente->getId() && $cliente->getId() != -1 && $cliente->getId() != "-1")) {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_menuInexistente");
            } else {
                if (array_search($_POST["opcion"], OpcionDatos::getRemaningOpcionesByMenu($menu)) === null || array_search($_POST["ruta"], OpcionDatos::$RUTAS_DISPONIBLES) == null) {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("desc_opcionIncorrecta");
                } else {
                    $opcion = new Opcion($menu, $_POST["opcion"], $_POST["descripcion"], $_POST["ruta"], $_POST["valor"], $_POST["contexto"]);
                    if (OpcionDatos::insertOpcion($opcion) == 0) {
                        $sal["Estado"] = "ok";
                    } else {
                        $sal["Estado"] = "error";
                        $sal["Descripcion"] = $this->lang->line("desc_registrarOpcion");
                    }
                }
            }
            $this->output->set_output(json_encode($sal));
        }
    }
    //Editar opciones
    public function editarOpcion()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('ivr', "spanish");
                break;
            case "en":
                $this->lang->load('ivr', "english");
                break;
            default:
                $this->lang->load('ivr', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $menu = MenuDatos::getMenuById($_POST["menu"]);
            if ($menu == null || ($menu->getCliente()->getId() != $cliente->getId() && $cliente->getId() != -1 && $cliente->getId() != "-1")) {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_menuInexistente");
            } else {
                if (array_search($_POST["opcion"], OpcionDatos::getRemaningOpcionesByMenu($menu)) != null || array_search($_POST["opcion"], OpcionDatos::$OPCIONES_DISPONIBLES) == null || array_search($_POST["ruta"], OpcionDatos::$RUTAS_DISPONIBLES) == null) {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("desc_opcionInexistente");
                } else {
                    $opcion = OpcionDatos::getOpcionByOpcionAndMenu($_POST["opcion"], $menu);
                    if ($opcion != null) {
                        $opcion->setContexto($_POST["contexto"]);
                        $opcion->setDescripcion($_POST["descripcion"]);
                        $opcion->setRuta($_POST["ruta"]);
                        $opcion->setValor($_POST["valor"]);
                        if (OpcionDatos::updateOpcion($opcion) == 0) {
                            $sal["Estado"] = "ok";
                        } else {
                            $sal["Estado"] = "error";
                            $sal["Descripcion"] = $this->lang->line("desc_errorActualizando");
                        }
                    } else {
                        $sal["Estado"] = "error";
                        $sal["Descripcion"] = $this->lang->line("desc_sinMenuOpcion");
                    }
                }
            }
            $this->output->set_output(json_encode($sal));
        }
    }
    //Borrar opcion
    public function borrarOpcion()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('ivr', "spanish");
                break;
            case "en":
                $this->lang->load('ivr', "english");
                break;
            default:
                $this->lang->load('ivr', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $menu = MenuDatos::getMenuById($_POST["menu"]);
            if ($menu == null || ($menu->getCliente()->getId() != $cliente->getId() && $cliente->getId() != -1 && $cliente->getId() != "-1")) {
                $sal["Estado"] = "error";
            } else {
                $opcion = OpcionDatos::getOpcionByOpcionAndMenu($_POST["opcion"], $menu);
                if ($opcion != null) {
                    if (OpcionDatos::deleteOpcion($opcion) == 0) {
                        $sal["Estado"] = "ok";
                    } else {
                        $sal["Estado"] = "error";
                    }
                } else {
                    $sal["Estado"] = "error";
                }
            }
            $this->output->set_output(json_encode($sal));
        }
    }
    //Obtener solo una opcion
    public function obtenerOpcion()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('ivr', "spanish");
                break;
            case "en":
                $this->lang->load('ivr', "english");
                break;
            default:
                $this->lang->load('ivr', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $menu = MenuDatos::getMenuById($_POST["menu"]);
            if ($menu == null || ($menu->getCliente()->getId() != $cliente->getId() && $cliente->getId() != -1 && $cliente->getId() != "-1")) {
                $sal["Estado"] = "error";
            } else {
                $opcion = OpcionDatos::getOpcionByOpcionAndMenu($_POST["opcion"], $menu);
                if ($opcion == null) {
                    $sal["Estado"] = "error";
                } else {
                    $sal["Estado"] = "ok";
                    $sal["Opcion"] = $opcion->toJSON();
                }
            }
            $this->output->set_output(json_encode($sal));
        }
    }
    //Aqui van todas las funciones del CRUD de TelefonosDID
    //Listar
    public function listarTelefonosDID()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('ivr', "spanish");
                break;
            case "en":
                $this->lang->load('ivr', "english");
                break;
            default:
                $this->lang->load('ivr', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $sal["Estado"] = "ok";
            $telefonosDID = [];
            $cuenta = 0;
            if ($cliente->getId() == '-1' && $cliente->getId() == -1) {
                $telefonosDID = TelefonoDIDDatos::getTelefonosDID($_POST["pagina"], 15, $_POST["texto"]);
                $cuenta = TelefonoDIDDatos::countTelefonosDID($_POST["texto"]);
            } else {
                $telefonosDID = TelefonoDIDDatos::getTelefonosDIDByCliente($cliente, $_POST["pagina"], 15, $_POST["texto"]);
                $cuenta = TelefonoDIDDatos::countTelefonosDIDByCliente($cliente, $_POST["texto"]);
            }
            $sal["TelefonosDID"] = array();
            for ($i = 0; $i < count($telefonosDID); $i++) {
                $sal["TelefonosDID"][$i] = $telefonosDID[$i]->toJSON();
            }
            $sal["Cuenta"] = $cuenta;
            $this->output->set_output(json_encode($sal));
        }
    }
    //Seleccionar
    public function seleccionarTelefonosDID()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('ivr', "spanish");
                break;
            case "en":
                $this->lang->load('ivr', "english");
                break;
            default:
                $this->lang->load('ivr', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $sal = array();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $sal["Estado"] = "ok";
            $telefonosDID = [];
            if ($cliente->getId() == '-1' && $cliente->getId() == -1) {
                $telefonosDID = TelefonoDIDDatos::getAllTelefonosDID();
            } else {
                $telefonosDID = TelefonoDIDDatos::getAllTelefonosDIDByCliente($cliente);
            }
            $sal["TelefonosDID"] = array();
            for ($i = 0; $i < count($telefonosDID); $i++) {
                $sal["TelefonosDID"][$i] = $telefonosDID[$i]->toJSON();
            }
            $this->output->set_output(json_encode($sal));
        }
    }
    //Crear
    public function crearTelefonoDID()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('ivr', "spanish");
                break;
            case "en":
                $this->lang->load('ivr', "english");
                break;
            default:
                $this->lang->load('ivr', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $sal = array();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $sal["Estado"] = "ok";
            //
            $telefonodid = new TelefonoDID(array(
                "didExtension" => $_POST["didExtension"],
                "telefono" => $_POST["telefono"],
                "descripcion" => $_POST["descripcion"],
                "cliente" => $cliente,
                "ruta" => $_POST["ruta"],
                "grabar" => $_POST["grabar"],
                "contextoExtension" => $_POST["contextoExtension"],
                "extension" => $_POST["extension"],
                "agente" => $_POST["agente"],
                "menu" => MenuDatos::getMenuById($_POST["menu"]),
                "voicemail" => $_POST["voicemail"],
                "grupoEntrada" => $_POST["grupoEntrada"],
                "activo" => $_POST["activo"],
                "campana" => $_POST["campana"],
                "lista" => $_POST["lista"],
                "metodoManejo" => $_POST["metodoManejo"],
                "metodoBusqueda" => $_POST["metodoBusqueda"],
            ));

            if (TelefonoDIDDatos::insertTelefonoDID($telefonodid) != 0) {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_registroDID");
            } else {
                $sal["Estado"] = "ok";
            }
            $this->output->set_output(json_encode($sal));
        }
    }
    //Borrar
    public function borrarTelefonoDID()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('ivr', "spanish");
                break;
            case "en":
                $this->lang->load('ivr', "english");
                break;
            default:
                $this->lang->load('ivr', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $sal = array();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $telefonodid = TelefonoDIDDatos::getTelefonoDIDById($_POST["id"]);
            if ($cliente->getId() == "-1" || $cliente->getId() == -1 || $cliente->getId() == $telefonodid->getCliente()->getId()) {
                if (TelefonoDIDDatos::deleteTelefonoDID($telefonodid) == 0) {
                    $sal["Estado"] = "ok";
                } else {
                    $sal["Estado"] = "error";
                }
            } else {
                $sal["Estado"] = "error";
            }
            $this->output->set_output(json_encode($sal));
        }
    }
    //Editar
    public function editarTelefonoDID()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('ivr', "spanish");
                break;
            case "en":
                $this->lang->load('ivr', "english");
                break;
            default:
                $this->lang->load('ivr', "spanish");
                break;
        }
        $sal = array();
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $telefonodid = TelefonoDIDDatos::getTelefonoDIDById($_POST["id"]);
            if ($cliente->getId() == "-1" || $cliente->getId() == -1 || $cliente->getId() == $telefonodid->getCliente()->getId()) {
                $telefonodid->setFromArray(
                    array(
                        "telefono" => $_POST["telefono"],
                        "descripcion" => $_POST["descripcion"],
                        "cliente" => $cliente,
                        "ruta" => $_POST["ruta"],
                        "grabar" => $_POST["grabar"],
                        "contextoExtension" => $_POST["contextoExtension"],
                        "extension" => $_POST["extension"],
                        "agente" => $_POST["agente"],
                        "menu" => MenuDatos::getMenuById($_POST["menu"]),
                        "voicemail" => $_POST["voicemail"],
                        "grupoEntrada" => $_POST["grupoEntrada"],
                        "activo" => $_POST["activo"],
                        "campana" => $_POST["campana"],
                        "lista" => $_POST["lista"],
                        "metodoManejo" => $_POST["metodoManejo"],
                        "metodoBusqueda" => $_POST["metodoBusqueda"],
                    )
                );
                if (TelefonoDIDDatos::updateTelefonoDID($telefonodid) == 0) {
                    $sal["Estado"] = "ok";
                } else {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("desc_actualizarTelefono");
                }
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_encontrarTelefono");
            }
        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($sal));
    }
    //Inhabilitar/habilitar
    public function activarTelefonoDID()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('ivr', "spanish");
                break;
            case "en":
                $this->lang->load('ivr', "english");
                break;
            default:
                $this->lang->load('ivr', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $telefonodid = TelefonoDIDDatos::getTelefonoDIDById($_POST["id"]);
            if ($cliente->getId() == "-1" || $cliente->getId() == -1 || $cliente->getId() == $telefonodid->getCliente()->getId()) {
                if ($telefonodid->getActivo() == 'Y') {
                    $telefonodid->setActivo('N');
                } else {
                    $telefonodid->setActivo('Y');
                }
                if (TelefonoDIDDatos::updateTelefonoDID($telefonodid) == 0) {
                    $sal["Estado"] = "ok";
                } else {
                    $sal["Estado"] = "error";
                }
            } else {
                $sal["Estado"] = "error";
            }
            $this->output->set_output(json_encode($sal));
        }
    }

    public function obtenerTelefonoDID()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('ivr', "spanish");
                break;
            case "en":
                $this->lang->load('ivr', "english");
                break;
            default:
                $this->lang->load('ivr', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $telefonodid = TelefonoDIDDatos::getTelefonoDIDById($_POST["id"]);
            if ($cliente->getId() == "-1" || $cliente->getId() == -1 || $cliente->getId() == $telefonodid->getCliente()->getId()) {
                $sal["Estado"] = "ok";
                $sal["TelefonoDID"] = $telefonodid->toJSON();
            } else {
                $sal["Estado"] = "error";
            }
            $this->output->set_output(json_encode($sal));
        }
    }

}
