<?php
require_once "BASEPATH.php";
include_once RUTA_APP . 'Sesiones.php';
include_once "Clases/CRM/CRMDatos.php";
require_once 'Clases/CRM/CategoriaDatos.php';
require_once 'Clases/CRM/CampoDatos.php';
require_once 'Clases/CRM/GestionDatos.php';
require_once 'Clases/CRM/RespuestaDatos.php';
require_once 'Clases/CRM/PerfilVicidialDatos.php';
require_once 'Clases/ClienteDatos.php';
require_once 'Clases/CampanaDatos.php';
require_once 'Clases/ListaDatos.php';
require_once 'Clases/UsuarioDatos.php';
class CustomerRM extends MY_Controller
{
    public function index()
    {
        $this->load->view('crm/head');
        $this->load->view('crm/vw_crm');
        $this->load->view('crm/foot');
    }
    public function agente()
    {
        $info = array(
            "lead" => $_GET["lead"],
            "phone" => "",
        );
        if (isset($_GET["phone"])) {
            $info["phone"] = $_GET["phone"];
        }
        $this->load->view('crmAgente/main', $info);
    }
    public function vistaAgente()
    {
    }
    ///////////////////////////////////////////////////////////////////////////////////////AQUI EMPIEZAN LOS CRM\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
    /*Esta parte es administrativa de los CRM*/
    public function agregarCRM()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array();
        if (!empty($_SESSION["Usuario"]) && $_SESSION["Grupo"] == GRUPO_ADMINS) {
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $crm = new CRM(null, $cliente, $_POST["Nombre"], $_POST["Color"], $_POST["OcultarInfo"], true);
            $db = CRMDatos::addCRM($crm);
            if ($db > 0) {
                $crm->setId($db);
                $respuestaRequest["Estado"] = "ok";
                $respuestaRequest["CRM"] = $crm->toJSON();
            } else {
                $respuestaRequest["Estado"] = "error";
                $respuestaRequest["Descripcion"] = $this->lang->line("desc_insertarCRM");
                $respuestaRequest["Codigo"] = $db;
            }
        } else {
            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($respuestaRequest));
    }
    public function editarCRM()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array();
        if (!empty($_SESSION["Usuario"]) && $_SESSION["Grupo"] == GRUPO_ADMINS) {
            $crm = CRMDatos::getCRMById($_POST["id"]);
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            if ($cliente->esRoot() || ($crm != null && ClienteDatos::compareCliente($crm, $cliente))) {
                $crm->setNombre($_POST["Nombre"]);
                $crm->setColor($_POST["Color"]);
                $crm->setOcultarInfo($_POST["OcultarInfo"] == "true");
                if ($db = CRMDatos::updateCRM($crm) > 0) {
                    $respuestaRequest["Estado"] = "ok";
                    $respuestaRequest["CRM"] = CRMDatos::getCRMById($crm->getId())->toJSON();
                } else {
                    $respuestaRequest["Estado"] = "error";
                    $respuestaRequest["Descripcion"] = $this->lang->line("desc_editarCRM");
                    $respuestaRequest["Codigo"] = $db;
                }
            } else {
                $respuestaRequest["Estado"] = "error";
                $respuestaRequest["Descripcion"] = $this->lang->line("desc_permisosCRM");
            }
        } else {
            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($respuestaRequest));
    }
    public function eliminarCRM()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array();
        if (!empty($_SESSION["Usuario"]) && $_SESSION["Grupo"] == GRUPO_ADMINS) {
            $crm = CRMDatos::getCRMById($_POST["id"]);
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            if ($cliente->esRoot() || ($crm != null && ClienteDatos::compareCliente($crm, $cliente))) {
                $db = CRMDatos::deleteCRM($crm);
                if ($db > 0) {
                    $respuestaRequest["Estado"] = "ok";
                } else {
                    $respuestaRequest["Estado"] = "error";
                    $respuestaRequest["Descripcion"] = $this->lang->line("desc_eliminarCRM");
                    $respuestaRequest["Codigo"] = $db;
                }
            } else {
                $respuestaRequest["Estado"] = "error";
                $respuestaRequest["Descripcion"] = $this->lang->line("desc_permisosCRM");
            }
        } else {
            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($respuestaRequest));
    }
    public function listarCRMs()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array();
        if (!empty($_SESSION["Usuario"]) && ($_SESSION["Grupo"] == GRUPO_ADMINS || $_SESSION["Grupo"] == GRUPO_SUPERVISORES)) {
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $lista = array();
            if ($cliente->esRoot()) {
                $lista = CRMDatos::listCRMs();
            } else {
                $lista = CRMDatos::listCRMsByCliente($cliente);
            }
            $respuestaRequest["Estado"] = "ok";
            $respuestaRequest["CRMS"] = array();
            for ($i = 0; $i < count($lista); $i++) {
                $respuestaRequest["CRMS"][$i] = $lista[$i]->toJSON();
            }

        } else {
            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($respuestaRequest));
    }
    public function obtenerCRMs()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array();
        if (!empty($_SESSION["Usuario"]) && ($_SESSION["Grupo"] == GRUPO_ADMINS || $_SESSION["Grupo"] == GRUPO_SUPERVISORES)) {
            $pagina = $_POST["pagina"];
            $limite = 15;
            $texto = $_POST["texto"];
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $lista = array();
            $cuenta = 0;
            if ($cliente->esRoot()) {
                $lista = CRMDatos::getCRMS($limite, $pagina, $texto);
                $cuenta = CRMDatos::countCRMS($texto);
            } else {
                $lista = CRMDatos::getCRMSByCliente($cliente, $limite, $pagina, $texto);
                $cuenta = CRMDatos::countCRMSByCliente($cliente, $texto);
            }
            $respuestaRequest["Estado"] = "ok";
            $respuestaRequest["CRMS"] = array();
            $respuestaRequest["Cuenta"] = $cuenta;
            for ($i = 0; $i < count($lista); $i++) {
                $respuestaRequest["CRMS"][$i] = $lista[$i]->toJSON();
            }

        } else {
            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($respuestaRequest));
    }
    /*Esta parte es general de los CRM*/
    public function obtenerCRM()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array();
        if (!empty($_SESSION["Usuario"])) {
            $crm = CRMDatos::getCRMById($_POST["id"]);
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            if ($cliente->esRoot() || ($crm != null && ClienteDatos::compareCliente($crm, $cliente))) {
                $respuestaRequest["Estado"] = "ok";
                $respuestaRequest["CRM"] = $crm->toJSON();
            } else {
                $respuestaRequest["Estado"] = "error";
                $respuestaRequest["Descripcion"] = $this->lang->line("desc_permisosCRM");
            }
        } else {
            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($respuestaRequest));
    }
    ///////////////////////////////////////////////////////////////////////////////////////AQUI EMPIEZAN LAS CATEGORIAS\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
    /*Metodos administrativos*/
    public function agregarCategoria()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array();
        if (!empty($_SESSION["Usuario"]) && $_SESSION["Grupo"] == GRUPO_ADMINS) {
            $crm = CRMDatos::getCRMById($_POST["crm"]);
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            if ($cliente->esRoot() || ($crm != null && ClienteDatos::compareCliente($crm, $cliente))) {
                $categoria = new Categoria(null, $crm, $_POST["Nombre"], $_POST["Posicion"], $_POST["Contraido"], true);
                $id = CategoriaDatos::addCategoria($categoria);
                if ($id > 0) {
                    $categoria->setId($id);
                    $respuestaRequest["Estado"] = "ok";
                    $respuestaRequest["Categoria"] = $categoria->toJSON();
                } else {
                    $respuestaRequest["Estado"] = "error";
                    $respuestaRequest["Descripcion"] = $this->lang->line("desc_errorConsulta");
                }
            } else {
                $respuestaRequest["Estado"] = "error";
                $respuestaRequest["Descripcion"] = $this->lang->line("desc_permisosCRM");
            }
        } else {
            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($respuestaRequest));
    }
    public function generarReportePorLista()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array("Registros" => array());
        if (!empty($_SESSION["Usuario"]) && ($_SESSION["Grupo"] == GRUPO_ADMINS || $_SESSION["Grupo"] == GRUPO_SUPERVISORES)) {
            $list_id = $_GET["list_id"];
            $fechaInicio = $_GET["fechaIni"];
            $fechaFin = $_GET["fechaFin"];
            $crm = CRMDatos::getCRMByLista($list_id);
            $csv = $_GET["csv"];
            $leads = ListaDatos::getLeadsByListId($list_id);
            foreach ($leads as $lead) {
                $gestion = GestionDatos::getLastestGestionByCRMAndLeadByFechas($crm, $lead, $fechaInicio, $fechaFin);
                if (isset($gestion)) {
                    $respuestaSave = array("lead_id" => $lead, "id_gestion" => $gestion->getId(), "Fecha" => $gestion->getFecha());
                    $respuestas = RespuestaDatos::getRespuestasByGestion($gestion);
                    foreach ($respuestas as $respuesta) {
                        $respuestaSave[$respuesta->getCampo()->getNombre()] = $respuesta->getRespuesta();
                    }
                }
                $respuestaRequest["Registros"][] = $respuestaSave;
            }
            if ($csv) {
                header("Content-type: text/csv");
                header("Content-Disposition: attachment; filename=EstadisticasAgente($user)(" . $fechaInicio . "-" . $fechaFin . ").csv");
                ob_clean();
                $out = fopen('php://output', 'w');
                $headers = array("lead_id", $this->lang->line("header_gestion"), "Fecha");
                if (!empty($respuestaRequest["Registros"])) {
                    $primero = $respuestaRequest["Registros"][0];
                    foreach ($primero as $key => $value) {
                        if ($key != "lead_id" && $key != "id_gestion") {
                            $headers[] = $key;
                        }
                    }
                }
                fwrite($out, implode(",", $headers) . "\n");
                foreach ($respuestaRequest["Registros"] as $registro) {
                    foreach ($headers as $header) {
                        fwrite($out, "\"" . $registro[$header] . "\",");
                    }
                    fwrite($out, "\n");
                }
                fclose($out);
            } else {
                header('Content-type: application/json');
                $respuestaRequest["Estado"] = "ok";
                $this->output->set_output(json_encode($respuestaRequest));
            }
        } else {
            header('Content-type: application/json');

            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
    }
    public function generarReportePorCRM()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array("Registros" => array());
        if (!empty($_SESSION["Usuario"]) && ($_SESSION["Grupo"] == GRUPO_ADMINS || $_SESSION["Grupo"] == GRUPO_SUPERVISORES)) {
            $fechaInicio = $_GET["fechaIni"];
            $fechaFin = $_GET["fechaFin"];
            $crm = CRMDatos::getCRMByLista($_GET["crm_id"]);
            $csv = $_GET["csv"];

            $gestiones = GestionDatos::getGestionesByCRMAndFechas($crm, $fechaInicio, $fechaFin);
            foreach ($gestiones as $gestion) {
                if (isset($gestion)) {
                    $respuestaSave = array("lead_id" => $gestion->getLead(), "id_gestion" => $gestion->getId(), "Fecha" => $gestion->getFecha());
                    $respuestas = RespuestaDatos::getRespuestasByGestion($gestion);
                    foreach ($respuestas as $respuesta) {
                        $respuestaSave[$respuesta->getCampo()->getNombre()] = $respuesta->getRespuesta();
                    }

                }
                $respuestaRequest["Registros"][] = $respuestaSave;
            }
            if ($csv) {
                header("Content-type: text/csv");
                header("Content-Disposition: attachment; filename=EstadisticasAgente($user)(" . $fechaInicio . "-" . $fechaFin . ").csv");
                ob_clean();
                $out = fopen('php://output', 'w');
                $headers = array("lead_id", $this->lang->line("header_gestion"), "Fecha");

                if (!empty($respuestaRequest["Registros"])) {
                    $primero = $respuestaRequest["Registros"][0];
                    foreach ($primero as $key => $value) {
                        if ($key != "lead_id" && $key != "id_gestion") {
                            $headers[] = $key;
                        }
                    }
                }
                fwrite($out, implode(",", $headers) . "\n");
                foreach ($respuestaRequest["Registros"] as $registro) {
                    foreach ($headers as $header) {
                        fwrite($out, "\"" . $registro[$header] . "\",");
                    }
                    fwrite($out, "\n");
                }
                fclose($out);
            } else {
                header('Content-type: application/json');
                $respuestaRequest["Estado"] = "ok";
                $this->output->set_output(json_encode($respuestaRequest));
            }
        } else {
            header('Content-type: application/json');

            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
    }
    public function editarCategoria()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array();
        if (!empty($_SESSION["Usuario"]) && $_SESSION["Grupo"] == GRUPO_ADMINS) {
            $categoria = CategoriaDatos::getCategoriaById($_POST["id"]);
            if ($categoria != null) {
                $crm = $categoria->getCRM();
                $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
                if ($cliente->esRoot() || ($crm != null && ClienteDatos::compareCliente($crm, $cliente))) {
                    $categoria->setNombre($_POST["Nombre"]);
                    $categoria->setPosicion($_POST["Posicion"]);
                    $categoria->setContraido($_POST["Contraido"]);
                    if (CategoriaDatos::updateCategoria($categoria) > 0) {
                        $respuestaRequest["Estado"] = "ok";
                        $respuestaRequest["Categoria"] = $categoria->toJSON();
                    } else {
                        $respuestaRequest["Estado"] = "error";
                        $respuestaRequest["Descripcion"] = $this->lang->line("desc_errorConsulta");
                    }
                } else {
                    $respuestaRequest["Estado"] = "error";
                    $respuestaRequest["Descripcion"] = $this->lang->line("desc_permisosCRM");
                }
            } else {
                $respuestaRequest["Estado"] = "error";
                $respuestaRequest["Descripcion"] = $this->lang->line("desc_categoriaInexistente");
            }
        } else {
            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($respuestaRequest));
    }
    public function eliminarCategoria()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array();
        if (!empty($_SESSION["Usuario"]) && $_SESSION["Grupo"] == GRUPO_ADMINS) {
            $categoria = CategoriaDatos::getCategoriaById($_POST["id"]);
            if ($categoria != null) {
                $crm = $categoria->getCRM();
                $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
                if ($cliente->esRoot() || ($crm != null && ClienteDatos::compareCliente($crm, $cliente))) {
                    if (CategoriaDatos::deleteCategoria($categoria) > 0) {
                        $respuestaRequest["Estado"] = "ok";
                    } else {
                        $respuestaRequest["Estado"] = "error";
                        $respuestaRequest["Descripcion"] = $this->lang->line("desc_errorConsulta");
                    }
                } else {
                    $respuestaRequest["Estado"] = "error";
                    $respuestaRequest["Descripcion"] = $this->lang->line("desc_permisosCRM");
                }
            } else {
                $respuestaRequest["Estado"] = "error";
                $respuestaRequest["Descripcion"] = $this->lang->line("desc_categoriaInexistente");
            }
        } else {
            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($respuestaRequest));
    }
    public function listarCategorias()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array();
        if (!empty($_SESSION["Usuario"]) && $_SESSION["Grupo"] == GRUPO_ADMINS) {
            $crm = CRMDatos::getCRMById($_POST["crm"]);
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            if ($cliente->esRoot() || ($crm != null && ClienteDatos::compareCliente($crm, $cliente))) {
                $categorias = CategoriaDatos::listCategoriasByCRM($crm);
                $respuestaRequest["Categorias"] = array();
                for ($i = 0; $i < count($categorias); $i++) {
                    $respuestaRequest["Categorias"][] = $categorias[$i]->toJSON();
                }
                $respuestaRequest["Estado"] = "ok";
            } else {
                $respuestaRequest["Estado"] = "error";
                $respuestaRequest["Descripcion"] = $this->lang->line("desc_permisosCRM");
            }
        } else {
            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($respuestaRequest));
    }
    /*Estos son los metodos generales*/
    public function obtenerCategorias()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array();
        if (!empty($_SESSION["Usuario"])) {
            $crm = CRMDatos::getCRMById($_POST["crm"]);
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            if ($cliente->esRoot() || ($crm != null && ClienteDatos::compareCliente($crm, $cliente))) {
                $categorias = CategoriaDatos::getCategoriasByCRM($crm);
                $respuestaRequest["Categorias"] = array();
                for ($i = 0; $i < count($categorias); $i++) {
                    $respuestaRequest["Categorias"][] = $categorias[$i]->toJSON();
                }
                $respuestaRequest["Estado"] = "ok";
            } else {
                $respuestaRequest["Estado"] = "error";
                $respuestaRequest["Descripcion"] = $this->lang->line("desc_permisosCRM");
            }
        } else {
            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($respuestaRequest));
    }
    ///////////////////////////////////////////////////////////////////////////////////////AQUI EMPIEZAN LOS CAMPOS\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
    /*Metodos administrativos*/
    public function agregarCampo()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array();
        if (!empty($_SESSION["Usuario"]) && $_SESSION["Grupo"] == GRUPO_ADMINS) {
            $categoria = CategoriaDatos::getCategoriaById($_POST["Categoria"]);
            $crm = $categoria->getCRM();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            if ($cliente->esRoot() || ($crm != null && ClienteDatos::compareCliente($crm, $cliente))) {
                $campo = new Campo(null, $categoria, $_POST["Tipo"], $_POST["Edicion"], $_POST["Nombre"], $_POST["Valor"], $_POST["Busqueda"], true,$_POST["Requerido"]);
                $id = CampoDatos::addCampo($campo);
                if ($id > 0) {
                    $campo->setId($id);
                }
                $respuestaRequest["Estado"] = "ok";
                $respuestaRequest["Campo"] = $campo->toJSON();
            } else {
                $respuestaRequest["Estado"] = "error";
                $respuestaRequest["Descripcion"] = $this->lang->line("desc_permisosCRM");
            }
        } else {
            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($respuestaRequest));
    }
    public function editarCampo()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array();
        if (!empty($_SESSION["Usuario"]) && $_SESSION["Grupo"] == GRUPO_ADMINS) {
            $campo = CampoDatos::getCampoById($_POST["id"]);
            $crm = $campo->getCategoria()->getCRM();
            $categoriaNueva = CategoriaDatos::getCategoriaById($_POST["Categoria"]);
            $crm = $categoriaNueva->getCRM();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            if ($cliente->esRoot() || ($crm != null && ClienteDatos::compareCliente($crm, $cliente) && ClienteDatos::compareCliente($crm, $cliente))) {
                $campo->setCategoria($categoriaNueva);
                $campo->setNombre($_POST["Nombre"]);
                $campo->setValor($_POST["Valor"]);
                $campo->setTipo($_POST["Tipo"]);
                $campo->setEdicion($_POST["Edicion"]);
                $campo->setBusqueda($_POST["Busqueda"]);
                $campo->setRequerido($_POST["Requerido"]);
                if (CampoDatos::updateCampo($campo)) {
                    $respuestaRequest["Estado"] = "ok";
                    $respuestaRequest["Campo"] = $campo->toJSON();
                } else {
                    $respuestaRequest["Estado"] = "error";
                    $respuestaRequest["Descripcion"] = $this->lang->line("desc_errorConsulta");
                }
            } else {
                $respuestaRequest["Estado"] = "error";
                $respuestaRequest["Descripcion"] = $this->lang->line("desc_permisosCRM");
            }
        } else {
            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($respuestaRequest));
    }
    public function eliminarCampo()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array();
        if (!empty($_SESSION["Usuario"]) && $_SESSION["Grupo"] == GRUPO_ADMINS) {
            $campo = CampoDatos::getCampoById($_POST["id"]);
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            if ($cliente->esRoot() || ($campo->getCategoria()->getCRM() != null && ClienteDatos::compareCliente($campo->getCategoria()->getCRM(), $cliente))) {
                if (CampoDatos::deleteCampo($campo)) {
                    $respuestaRequest["Estado"] = "ok";
                } else {
                    $respuestaRequest["Estado"] = "error";
                    $respuestaRequest["Descripcion"] = $this->lang->line("desc_errorConsulta");
                }
            } else {
                $respuestaRequest["Estado"] = "error";
                $respuestaRequest["Descripcion"] = $this->lang->line("desc_permisosCRM");
            }
        } else {
            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($respuestaRequest));
    }
    /*Estos son los metodos generales*/
    public function obtenerCamposCRM()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array();
        if (!empty($_SESSION["Usuario"])) {
            $crm = CRMDatos::getCRMById($_POST["id"]);
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            if ($cliente->esRoot() || ($crm != null && ClienteDatos::compareCliente($crm, $cliente))) {
                $campos = CampoDatos::getCamposByCRM($crm);
                $respuestaRequest["Campos"] = array();
                for ($i = 0; $i < count($campos); $i++) {
                    $respuestaRequest["Campos"][] = $campos[$i]->toJSON();
                }
                $respuestaRequest["Estado"] = "ok";
            } else {
                $respuestaRequest["Estado"] = "error";
                $respuestaRequest["Descripcion"] = $this->lang->line("desc_permisosCRM");
            }
        } else {
            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($respuestaRequest));
    }
    ///////////////////////////////////////////////////////////////////////////////////////AQUI EMPIEZAN LAS GESTIONES\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
    /*Metodos administrativos*/
    public function obtenerGestionesPorLead()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array();
        if (!empty($_SESSION["Usuario"])) {
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $crm = CRMDatos::getCRMById($_POST["crm"]);
            $pagina = intval($_POST["Pagina"]) >= 0 ? intval($_POST["Pagina"]) : 0;
            $lead = $_POST["lead"];
            if ($cliente->esRoot() || ($crm != null && ClienteDatos::compareCliente($crm, $cliente))) {
                $gestiones = GestionDatos::getGestionesByLeadAndCRM($lead, $crm, $pagina, 15, true);
                $respuestaRequest["Gestiones"] = array();
                for ($i = 0; $i < count($gestiones); $i++) {
                    $objeto = array();
                    $objeto["Gestion"] = $gestiones[$i]->toJSON();
                    $objeto["Respuestas"] = array();
                    $respuestas = RespuestaDatos::getRespuestasByGestion($gestiones[$i]);
                    for ($j = 0; $j < count($respuestas); $j++) {
                        $objeto["Respuestas"][] = $respuestas[$j]->toJSON();
                    }
                    $respuestaRequest["Gestiones"][] = $objeto;
                }
                $respuestaRequest["Estado"] = "ok";
            } else {
                $respuestaRequest["Estado"] = "error";
                $respuestaRequest["Descripcion"] = $this->lang->line("desc_permisosCRM");
            }
        } else {
            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($respuestaRequest));
    }
    /*Metodos generales*/
    public function listarGestionesPorLead()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array();
        if (!empty($_SESSION["Usuario"])) {
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $crm = CRMDatos::getCRMById($_POST["crm"]);
            $lead = $_POST["lead"];
            if ($cliente->esRoot() || ($crm != null && ClienteDatos::compareCliente($crm, $cliente))) {
                $gestiones = GestionDatos::listGestionesByLeadAndCRM($lead, $crm);
                $respuestaRequest["Gestiones"] = array();
                for ($i = 0; $i < count($gestiones); $i++) {
                    $respuestaRequest["Gestiones"][] = $gestiones[$i]->toJSON();
                }
                $respuestaRequest["Estado"] = "ok";
            } else {
                $respuestaRequest["Estado"] = "error";
                $respuestaRequest["Descripcion"] = $this->lang->line("desc_permisosCRM");
            }
        } else {
            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($respuestaRequest));
    }
    public function listarGestionesPorLeadConRespuestas()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array();
        if (!empty($_SESSION["Usuario"])) {
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $crm = CRMDatos::getCRMById($_POST["crm"]);
            $lead = $_POST["lead"];
            if ($cliente->esRoot() || ($crm != null && ClienteDatos::compareCliente($crm, $cliente))) {
                $gestiones = GestionDatos::listGestionesByLeadAndCRM($lead, $crm);
                $respuestaRequest["Gestiones"] = array();
                for ($i = 0; $i < count($gestiones); $i++) {
                    $respuestasDeGestion = RespuestaDatos::getRespuestasByGestion($gestiones[$i]);
                    $respuestas = array();
                    for ($j = 0; $j < count($respuestasDeGestion); $j++) {
                        $respuestas[] = $respuestasDeGestion[$j]->toJSON();
                    }
                    $respuestaRequest["Gestiones"][] = array(
                        "Gestion" => $gestiones[$i]->toJSON(),
                        "Respuestas" =>  $respuestas
                    );
                }
                $respuestaRequest["Estado"] = "ok";
            } else {
                $respuestaRequest["Estado"] = "error";
                $respuestaRequest["Descripcion"] = $this->lang->line("desc_permisosCRM");
            }
        } else {
            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($respuestaRequest));
    }
    public function agregarGestion()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array();
        if (!empty($_SESSION["Usuario"])) {
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $crm = CRMDatos::getCRMById($_POST["crm"]);
            if ($cliente->esRoot() || ($crm != null && ClienteDatos::compareCliente($crm, $cliente))) {
                $gestion = new Gestion(null, $crm, $_POST["lead"], GestionDatos::getFecha(), $_POST["Telefono"], UsuarioDatos::getUsuarioByUsuario($_SESSION["Usuario"]), "NOCAL");
                $id = GestionDatos::addGestion($gestion);
                if ($id > 0) {
                    $gestion->setId($id);
                    $respuestaRequest["Estado"] = "ok";
                    $respuestaRequest["Gestion"] = $gestion->toJSON();
                } else {
                    $respuestaRequest["Estado"] = "error";
                    $respuestaRequest["Descripcion"] = $this->lang->line("desc_errorConsulta");
                }
            } else {
                $respuestaRequest["Estado"] = "error";
                $respuestaRequest["Descripcion"] = $this->lang->line("desc_permisosCRM");
            }
        } else {
            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($respuestaRequest));
    }
    public function calificarGestion()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array();
        if (!empty($_SESSION["Usuario"])) {
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $agente = UsuarioDatos::getUsuarioByUsuario($_SESSION["Usuario"]);
            $status = $_POST["Estado"];
            $lead = $_POST["lead"];
            $lista = ListaDatos::getListaByLeadId($lead);
            $crm = $lista->getCRM();
            if ($cliente->esRoot() || ($crm != null && ClienteDatos::compareCliente($crm, $cliente))) {
                $gestion = GestionDatos::getLastestGestionByCRMAgenteAndLead($crm, $agente, $lead);
                $gestion->setCalificacion($status);
                $id = GestionDatos::updateGestion($gestion);
                if ($id > 0) {
                    $gestion->setId($id);
                    $respuestaRequest["Estado"] = "ok";
                    $respuestaRequest["Gestion"] = $gestion;
                } else {
                    $respuestaRequest["Estado"] = "error";
                    $respuestaRequest["Descripcion"] = $this->lang->line("desc_errorConsulta");
                }
            } else {
                $respuestaRequest["Estado"] = "error";
                $respuestaRequest["Descripcion"] = $this->lang->line("desc_permisosCRM");
            }
        } else {
            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($respuestaRequest));
    }
    public function obtenerCRMAgente()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array();
        if (!empty($_SESSION["Usuario"])) {
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $lead = $_POST["lead"];
            $lista = ListaDatos::getListaByLeadId($lead);
            $crm = $lista->getCRM();
            if ($cliente->esRoot() || ($crm != null && ClienteDatos::compareCliente($crm, $cliente))) {
                $respuestaRequest["Categorias"] = $respuestaRequest["Campos"] = $respuestaRequest["Respuestas"] = array();
                $categorias = CategoriaDatos::getCategoriasByCRM($crm);
                $campos = CampoDatos::getCamposByCRM($crm);
                $respuestaRequest["CRM"] = $crm->toJSON();
                for ($i = 0; $i < count($categorias); $i++) {
                    $respuestaRequest["Categorias"][] = $categorias[$i]->toJSON();
                }
                for ($i = 0; $i < count($campos); $i++) {
                    $respuestaRequest["Campos"][] = $campos[$i]->toJSON();
                }
                $respuestaRequest["Estado"] = "ok";
                $gestion = GestionDatos::getLastestGestionByCRMAndLead($crm, $lead);
                if ($gestion != null) {
                    $respuestas = RespuestaDatos::getRespuestasByGestion($gestion);
                    $respuestaRequest["UltimaGestion"] = ($gestion != null ? $gestion->toJSON() : null);
                    for ($i = 0; $i < count($respuestas); $i++) {
                        $respuestaRequest["Respuestas"][] = $respuestas[$i]->toJSON();
                    }
                }

                $perfilVicidial = PerfilVicidialDatos::getPerfilVicidialByLeadId($lead);
                if ($perfilVicidial != null) {
                    $respuestaRequest["PerfilVicidial"] = $perfilVicidial->toJSON();
                }

            } else {
                $respuestaRequest["Estado"] = "error";
                $respuestaRequest["Descripcion"] = $this->lang->line("desc_permisosCRM");
                $respuestaRequest["Lista"] = $lista == null ? null : $lista->toJSON();
                $respuestaRequest["CRM"] = $crm == null ? null : $crm->toJSON();
            }
        } else {
            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($respuestaRequest));
    }
    public function guardarRespuestas()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array();
        if (!empty($_SESSION["Usuario"])) {
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $gestion = GestionDatos::getGestionById($_POST["Gestion"]);
            $crm = $gestion->getCRM();
            if ($cliente->esRoot() || ($crm != null && ClienteDatos::compareCliente($crm, $cliente))) {
                $respuestas = $_POST["Respuestas"];
                $respuestasExitosas = 0;
                $respuestasPorGuardar=[];
                $huboError=false;
                $dondeHuboError="";
                for ($i = 0; $i < count($respuestas); $i++) {
                    $campo=CampoDatos::getCampoById($respuestas[$i]["Campo"]);
                    if(!$campo->getRequerido()   ||isset($respuestas[$i]["Respuesta"]) && $respuestas[$i]["Respuesta"]!=""){
                        $nuevaRespuesta = new Respuesta(null, $gestion,$campo , $respuestas[$i]["Respuesta"]);
                        $respuestasPorGuardar[]=$nuevaRespuesta;
                    }else{
                        $dondeHuboError=$respuestas[$i]["Campo"];
                        $huboError=true;
                        break;
                    }
                    
                }
                if($huboError){
                    $respuestaRequest["Estado"] = "error";
                    $respuestaRequest["Descripcion"] = $this->lang->line("desc_camposInexistentes");
                    $respuestaRequest["Campo"] = $dondeHuboError;
                    $respuestaRequest["Respuestas"] = $respuestas;
                }
                else{
                    $respuestaRequest["IdRespuestas"] = array();
                    foreach ($respuestasPorGuardar as $respuesta) {
                        $id = RespuestaDatos::insertRespuesta($respuesta);
                        if ($id > 0) {
                            $respuesta->setId($id);
                            $respuestasExitosas++;
                            $respuestaRequest["IdRespuestas"][] = array("Campo" => $respuesta->getCampo()->getId(), "Id" => $id);
                        }
                    }
                    if ($respuestasExitosas > 0) {
                        $respuestaRequest["Estado"] = "ok";
                        $respuestaRequest["GuardadosExitosos"] = $respuestasExitosas;
                    } else {
                        $respuestaRequest["Estado"] = "error";
                        $respuestaRequest["Descripcion"] = $this->lang->line("desc_ningunGuardado");
                    }
                }
            } else {
                $respuestaRequest["Estado"] = "error";
                $respuestaRequest["Descripcion"] = $this->lang->line("desc_permisosCRM");
            }
        } else {
            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($respuestaRequest));
    }
    public function actualizarRespuestas()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array();
        if (!empty($_SESSION["Usuario"])) {
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $gestion = GestionDatos::getGestionById($_POST["Gestion"]);
            $crm = $gestion->getCRM();
            if ($cliente->esRoot() || ($crm != null && ClienteDatos::compareCliente($crm, $cliente))) {
                $respuestas = $_POST["Respuestas"];
                $respuestasExitosas = 0;
                $respuestasPorGuardar=[];
                $huboError=false;
                $dondeHuboError="";
                for ($i = 0; $i < count($respuestas); $i++) {
                    $campo=CampoDatos::getCampoById($respuestas[$i]["Campo"]);
                    if(!$campo->getRequerido()   ||isset($respuestas[$i]["Respuesta"]) && $respuestas[$i]["Respuesta"]!=""){
                        $nuevaRespuesta = new Respuesta($respuestas[$i]["Id"], $gestion,$campo , $respuestas[$i]["Respuesta"]);
                        $respuestasPorGuardar[]=$nuevaRespuesta;
                    }else{
                        $dondeHuboError=$respuestas[$i]["Campo"];
                        $huboError=true;
                        break;
                    }
                    
                }
                if($huboError){
                    $respuestaRequest["Estado"] = "error";
                    $respuestaRequest["Descripcion"] = $this->lang->line("desc_camposInexistentes");
                    $respuestaRequest["Campo"] = $dondeHuboError;
                }
                else{
                    
                    foreach ($respuestasPorGuardar as $respuesta) {
                        $id = RespuestaDatos::updateRespuesta($respuesta);
                        if ($id > 0) {
                            $respuesta->setId($id);
                            $respuestasExitosas++;
                        }
                    }
                    if ($respuestasExitosas > 0) {
                        GestionDatos::updateFecha(date("Y-m-d H:i:s"), $gestion->getId());

                        $respuestaRequest["Estado"] = "ok";
                        $respuestaRequest["GuardadosExitosos"] = $respuestasExitosas;
                    } else {
                        $respuestaRequest["Estado"] = "error";
                        $respuestaRequest["Descripcion"] = $this->lang->line("desc_ningunGuardado");
                    }
                }
            } else {
                $respuestaRequest["Estado"] = "error";
                $respuestaRequest["Descripcion"] = $this->lang->line("desc_permisosCRM");
            }
        } else {
            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($respuestaRequest));
    }
    public function buscarGestion()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array();
        if (!empty($_SESSION["Usuario"])) {
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $texto = $_POST["Texto"];

            $respuestaRequest["Tiempos"] = array();
            if ($_POST["Campo"] == "") {

                // Cuando no se envia un campo se buscan gestiones
                // por telefono y crms de las listas de las campanas
                $listas = ListaDatos::getListasByCampana($_SESSION["Campana"]);
                $perfiles = PerfilVicidialDatos::getPerfilesVicidialByTelefonoAndListas($texto, $listas);
                $respuestaRequest["Perfiles"] = array();
                for ($i = 0; $i < count($perfiles); $i++) {
                    $respuestaRequest["Perfiles"][] = $perfiles[$i]->toJSON();
                }
                if (RespuestaDatos::countGestionesByPerfiles($perfiles) > 50) {
                    $respuestaRequest["Estado"] = "error";
                    $respuestaRequest["Descripcion"] = $this->lang->line("desc_excesoRegistros");
                } else {

                    $resultadosBusqueda = RespuestaDatos::getGestionesByPerfiles($perfiles);
                    $respuestaRequest["Resultados"] = array();
                    for ($i = 0; $i < count($resultadosBusqueda); $i++) {
                        $objeto = array();
                        $objeto["Gestion"] = $resultadosBusqueda[$i]->toJSON();
                        $objeto["Respuestas"] = array();
                        $respuestasInterno = RespuestaDatos::getRespuestasByGestion($resultadosBusqueda[$i]);
                        for ($j = 0; $j < count($respuestasInterno); $j++) {
                            $objeto["Respuestas"][] = $respuestasInterno[$j]->toJSON();
                        }

                        $objeto["PerfilVicidial"] = PerfilVicidialDatos::getPerfilVicidialByLeadId($resultadosBusqueda[$i]->getLead())->toJSON();
                        $respuestaRequest["Resultados"][] = $objeto;
                    }
                    $respuestaRequest["Estado"] = "ok";
                }

            } else {

                // Si se envia campo se hace una busqueda normal
                $campo = CampoDatos::getCampoById($_POST["Campo"]);
                $crm = $campo->getCategoria()->getCRM();
                if ($cliente->esRoot() || ($crm != null && ClienteDatos::compareCliente($crm, $cliente))) {
                    if (RespuestaDatos::countGestionesByCampoAndResultado($campo, $texto) > 50) {
                        $respuestaRequest["Estado"] = "error";
                        $respuestaRequest["Descripcion"] = $this->lang->line("desc_excesoRegistros");
                    } else {
                        $resultadosBusqueda = RespuestaDatos::getGestionesByCampoAndResultado($campo, $texto);
                        $respuestaRequest["Resultados"] = array();
                        for ($i = 0; $i < count($resultadosBusqueda); $i++) {
                            if (PerfilVicidialDatos::getPerfilVicidialByLeadId($resultadosBusqueda[$i]->getLead()) != null) {
                                $objeto = array();
                                $objeto["Gestion"] = $resultadosBusqueda[$i]->toJSON();
                                $objeto["Respuestas"] = array();
                                $respuestasInterno = RespuestaDatos::getRespuestasByGestion($resultadosBusqueda[$i]);
                                for ($j = 0; $j < count($respuestasInterno); $j++) {
                                    $objeto["Respuestas"][] = $respuestasInterno[$j]->toJSON();
                                }
                                $objeto["PerfilVicidial"] = PerfilVicidialDatos::getPerfilVicidialByLeadId($resultadosBusqueda[$i]->getLead())->toJSON();
                                $respuestaRequest["Resultados"][] = $objeto;
                            }
                        }
                        $respuestaRequest["Estado"] = "ok";
                    }

                } else {
                    $respuestaRequest["Estado"] = "error";
                    $respuestaRequest["Descripcion"] = $this->lang->line("desc_permisosCRM");
                }

            }
        } else {
            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($respuestaRequest));
    }
    public function cargarDeLandingPage()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $respuestaRequest = array();
        if (isset($_POST["usuarioLogin"]) && isset($_POST["passwordLogin"])) {
            $usuarioTXT = $_POST["usuarioLogin"];
            $passwordTXT = base64_decode(base64_decode($_POST["passwordLogin"]));
            $usuarioObj = UsuarioDatos::getUsuarioByUsuarioAndPassword($usuarioTXT, $passwordTXT);
            if ($usuarioObj != null) {
                if (isset($_POST["phone_number"]) && isset($_POST["lista"])) {
                    $telefono = $_POST["phone_number"];
                    $telefonoLimpio = "";
                    for ($i = 0; $i < strlen($telefono); $i++) {
                        if ($telefono[$i] >= '0' && $telefono[$i] <= '9') {
                            $telefonoLimpio .= $telefono[$i];
                        }
                    }
                    if (strlen($telefonoLimpio) >= 1 && strlen($telefonoLimpio) <= TELEFONO_LIMITE) {
                        $telefono = $telefonoLimpio;
                        $lista = ListaDatos::getListaById($_POST["lista"]);
                        if ($lista != null) {
                            $perfilVicidial = new PerfilVicidial(null, "NEW", $lista, (isset($_POST["vendor_lead_code"]) ? $_POST["vendor_lead_code"] : ""), (isset($_POST["name"]) ? $_POST["name"] : ""), (isset($_POST["last_name"]) ? $_POST["last_name"] : ""), (isset($_POST["email"]) ? $_POST["email"] : ""), (isset($_POST["address1"]) ? $_POST["address1"] : ""), (isset($_POST["postal_code"]) ? $_POST["postal_code"] : ""), $telefono, (isset($_POST["alt_phone"]) ? $_POST["alt_phone"] : ""), (isset($_POST["address3"]) ? $_POST["address3"] : ""), (isset($_POST["source_id"]) ? $_POST["source_id"] : ""));
                            $idPerfil = PerfilVicidialDatos::insertPerfilVicidial($perfilVicidial);
                            if ($idPerfil > 0) {
                                $perfilVicidial->setLeadId($idPerfil);
                                $crm = $lista->getCRM();
                                if ($crm != null) {
                                    $gestion = new Gestion(null, $crm, $idPerfil, GestionDatos::getFecha(), "88888888", UsuarioDatos::getUsuarioByUsuario("6666"), "NEW");
                                    $idGestion = GestionDatos::addGestion($gestion);
                                    if ($idGestion > 0) {
                                        $gestion->setId($idGestion);
                                        $campos = CampoDatos::getCamposByCRM($crm);
                                        $cuenta = 0;
                                        for ($i = 0; $i < count($campos); $i++) {
                                            $valor = $campos[$i]->getValor();
                                            if (isset($_POST[$campos[$i]->getId()])) {
                                                $valor = $_POST[$campos[$i]->getId()];
                                            } else if (isset($_POST[$campos[$i]->getNombre()])) {
                                                $valor = $_POST[$campos[$i]->getNombre()];
                                            } else if (isset($_POST[strtolower($campos[$i]->getNombre())])) {
                                                $valor = $_POST[strtolower($campos[$i]->getNombre())];
                                            } else if (isset($_POST[strtoupper($campos[$i]->getNombre())])) {
                                                $valor = $_POST[strtoupper($campos[$i]->getNombre())];
                                            }
                                            $respuesta = new Respuesta(null, $gestion, $campos[$i], $valor);
                                            $idRespuesta = RespuestaDatos::insertRespuesta($respuesta);
                                            if ($idRespuesta > 0) {
                                                $cuenta++;
                                                $respuesta->setId($idRespuesta);
                                            }
                                        }
                                        $respuestaRequest["Estado"] = "ok";
                                    } else {
                                        $respuestaRequest["Estado"] = "error";
                                        $respuestaRequest["Descripcion"] = $this->lang->line("desc_crearGestion");
                                    }
                                } else {
                                    $respuestaRequest["Estado"] = "ok";
                                }
                            } else {
                                $respuestaRequest["Estado"] = "error";
                                $respuestaRequest["Descripcion"] = $this->lang->line("desc_perfilMarcacion");
                            }
                        } else {
                            $respuestaRequest["Estado"] = "error";
                            $respuestaRequest["Descripcion"] = $this->lang->line("desc_listaInexistente");
                        }
                    } else {
                        $respuestaRequest["Estado"] = "error";
                        $respuestaRequest["Descripcion"] = $this->lang->line("desc_telefonoInvalido");
                    }
                } else {
                    $respuestaRequest["Estado"] = "error";
                    $respuestaRequest["Descripcion"] = $this->lang->line("desc_parametros");
                }
            } else {
                $respuestaRequest["Estado"] = "error";
                $respuestaRequest["Descripcion"] = $this->lang->line("desc_usuariosIncorrecto");
            }
        } else {
            $respuestaRequest["Estado"] = "error";
            $respuestaRequest["Descripcion"] = $this->lang->line("desc_parametrosLogin");
        }
        $this->output->set_output(json_encode($respuestaRequest));
    }

    // Closes Issue #497 {
    public function obtenerCamposPorCampana()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('customerrm', "spanish");
                break;
            case "en":
                $this->lang->load('customerrm', "english");
                break;
            default:
                $this->lang->load('customerrm', "spanish");
                break;
        }
        $response = array();
        if (!empty($_SESSION["Usuario"])) {
            $campana = CampanaDatos::getCampanaById($_POST["campana"]);
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);

            // Validacion de pertenencia de la campana
            if ($cliente->esRoot() || ($campana != null && ClienteDatos::compareCliente($campana, $cliente))) {

                $listas = ListaDatos::getListasByCampana($campana->getId());
                $crms = array();

                // Obtencion de los crms
                for ($i = 0; $i < count($listas); $i++) {
                    $crm = $listas[$i]->getCRM();
                    if ($crm != null) {
                        $crms[$crm->getId()] = $crm;
                    }
                }

                // Aqui se obtienen los campos
                $response["Resultados"] = array();
                foreach ($crms as $k => $v) {
                    // La respuesta contiene el CRM y
                    // el campo
                    $resultadoActual = array(
                        "CRM" => $v->toJSON(),
                        "Campos" => array(),
                    );

                    $campos = CampoDatos::getCamposByCRM($v);
                    for ($i = 0; $i < count($campos); $i++) {
                        $resultadoActual["Campos"][] = $campos[$i]->toJSON();
                    }

                    $response["Resultados"][] = $resultadoActual;
                }

                $response["Estado"] = "ok";

            } else {
                $response["Estado"] = "error";
                $response["Descripcion"] = $this->lang->line("desc_permisosCRM");
            }
        } else {
            $response["Estado"] = "error";
            $response["Descripcion"] = $this->lang->line("desc_sinSesion");
        }
        $this->output->set_output(json_encode($response));
    }
    // } Closes Issue #497
}
