<?php
require_once "BASEPATH.php";
include_once RUTA_APP . 'Sesiones.php';
include_once "Clases/Contexto.php";
include_once "Clases/ContextoDatos.php";
include_once "Clases/ClienteDatos.php";
include_once "Clases/Cliente.php";

class Contextos extends MY_Controller
{
    public function index()
    {
        $this->load->view('contextos/head');
        $this->load->view('contextos/vw_contextos');
        $this->load->view('contextos/foot');
    }
    public function getContextos()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('contextos', "spanish");
                break;
            case "en":
                $this->lang->load('contextos', "english");
                break;
            default:
                $this->lang->load('contextos', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $sal["Estado"] = "ok";

            if ($cliente->getId() == "-1" || $cliente->getId() == -1) {
                $sal["Registros"] = ContextoDatos::getContextos($_POST["pagina"], 10, $_POST["texto"]);
                $cuenta["Cant"] = ContextoDatos::countContextos($_POST["texto"]);
            } else {
                $sal["Registros"] = ContextoDatos::getContextosByCliente($cliente, $_POST["pagina"], 10, $_POST["texto"]);
                $sal["Cant"] = ContextoDatos::countContextosByCliente($cliente, $_POST["texto"]);
            }
            $this->output->set_output(json_encode($sal));
        }
    }
    public function deleteContexto()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('contextos', "spanish");
                break;
            case "en":
                $this->lang->load('contextos', "english");
                break;
            default:
                $this->lang->load('contextos', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $contexto = ContextoDatos::getContextoById($_POST["id"]);
            if ($contexto === null) {
                $sal["Estado"] = "ok";
                $sal["Descripcion"] = $this->lang->line("desc_contextoInexistente");
            } else {

                if ($cliente->getId() == "-1" || $cliente->getId() == -1) {
                    ContextoDatos::deleteContexto($contexto);
                    $sal["Estado"] = "ok";
                } else {
                    if ($cliente->getId() == $contexto->getCliente()->getId()) {
                        ContextoDatos::deleteContexto($contexto);
                        $sal["Estado"] = "ok";
                    } else {
                        $sal["Estado"] = "error";
                        $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
                    }
                }
            }
            $this->output->set_output(json_encode($sal));
        }
    }
    public function createContexto()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('contextos', "spanish");
                break;
            case "en":
                $this->lang->load('contextos', "english");
                break;
            default:
                $this->lang->load('contextos', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $contexto = new Contexto($_POST["id"], $_POST["nombre"], $cliente, $_POST["contenido"]);

            $resp = ContextoDatos::insertContexto($contexto);
            if ($resp == 0) {
                $sal["Estado"] = "ok";
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_guardarContexto");
            }
            $this->output->set_output(json_encode($sal));
        }
    }
    public function updateContexto()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('contextos', "spanish");
                break;
            case "en":
                $this->lang->load('contextos', "english");
                break;
            default:
                $this->lang->load('contextos', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $contexto = ContextoDatos::getContextoById($_POST["id"]);
            if ($contexto == null) {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_contextoInexistente");
            } else {
                $contexto->setNombre($_POST["nombre"]);
                $contexto->setContenido($_POST["contenido"]);
                if ($cliente->getId() == $contexto->getCliente()->getId()) {
                    $resp = ContextoDatos::updateContexto($contexto);
                    if (resp == 0) {
                        $sal["Estado"] = "ok";
                    } else {
                        $sal["Estado"] = "error";
                        $sal["Descripcion"] = $this->lang->line("desc_guardarContexto");

                    }
                } else {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");

                }
            }
            $this->output->set_output(json_encode($sal));
        }
    }
    ////////////////////AAAAAAAAAAAAAAAAAAAA
    public function getContexto()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('contextos', "spanish");
                break;
            case "en":
                $this->lang->load('contextos', "english");
                break;
            default:
                $this->lang->load('contextos', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $contexto = ContextoDatos::getContextoById($_POST["id"]);
            $sal["Estado"] = "ok";
            //Alan es bien puto
            if ($cliente->getId() == "-1" || $cliente->getId() == -1) {
                $sal["Contexto"] = $contexto->toJSON();
            } else {
                if ($cliente->getId() == $contexto->getCliente()->getId()) {
                    $sal["Contexto"] = $contexto->toJSON();
                } else {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
                }
            }
            $this->output->set_output(json_encode($sal));
        }
    }
    public function getSelect()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('contextos', "spanish");
                break;
            case "en":
                $this->lang->load('contextos', "english");
                break;
            default:
                $this->lang->load('contextos', "spanish");
                break;
        }
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            $usuario = $_SESSION["Usuario"];
            $sal = array();
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $sal["Estado"] = "ok";
            if ($cliente->getId() == "-1" || $cliente->getId() == -1) {
                $sal["Registros"] = ContextoDatos::getAllContextos($_POST["pagina"], 10, $_POST["texto"]);
            } else {
                $sal["Registros"] = ContextoDatos::getAllContextosByCliente($cliente);
            }
            $this->output->set_output(json_encode($sal));
        }
    }
}
