<?php

require_once RUTA_APP.'Conexion.php';

class SimpleQuery {

    public static function exec($query, $is_insert = FALSE) {
        $con = getConnection();
        $res = sv_mysqli_query($con, $query);
        $r = array();
        if ($res) {
            $id = "-1";
            if ($is_insert) {
                $id = mysqli_insert_id($con);
            }
            $r = array(
                "status" => "ok",
                "result" => $res,
                "id" => $id
            );
        } else {
            $r = array(
                "status" => "error",
                "error" => mysqli_error($con),
                "query" => $query
            );
        }
        sv_mysqli_close($con);
        return $r;
    }

    public static function simpleSelect(
        $fields = "",
        $table = "",
        $conditions = "",
        $skip = 0,
        $limit = 15,
        $group = ""
    ) {
        $query = "SELECT $fields FROM $table";

        if ($conditions !== "") {
            $query .= " WHERE $conditions ";
        }

        if ($limit > 0 && $skip > 0) {
            $query .= " LIMIT $skip, $limit ";
        } else if ($limit > 0) {
            $query .= " LIMIT $limit ";
        } else if ($skip > 0) {
            $query .= " OFFSET $skip ";
        }

        if ($group !== "") {
            $query .= " GROUP BY $group";
        }

        return $query;
    }

    public static function insert(
        $table = "",
        $values = array()
    ) {
        $str_fields = "";
        $str_values = "";
        foreach ($values as $field => $value) {
            if ($str_fields === "") {
                $str_fields .= $field;
            } else {
                $str_fields .= ",$field";
            }
            if (is_string($value)) {
                if ($str_values === "") {
                    $str_values .= "'".limpia($value)."'";
                } else {
                    $str_values .= ",'".limpia($value)."'";
                }
            } else {
                if ($str_values === "") {
                    $str_values .= $value;
                } else {
                    $str_values .= ",$value";
                }
            }
        }
        return "INSERT INTO $table ($str_fields) VALUES ($str_values)";
    }

    public static function update(
        $table = "",
        $values = array(),
        $conditions = ""
    ) {
        $str_values = "";
        foreach ($values as $field => $value) {
            if ($str_values === "") {
                if (is_string($value)) {
                    $str_values .= "$field = '".limpia($value)."'";
                } else {
                    $str_values .= "$field = $value";
                }
            } else {
                if (is_string($value)) {
                    $str_values .= ",$field = '".limpia($value)."'";
                } else {
                    $str_values .= ",$field = $value";
                }
            }
        }
        $query = "UPDATE $table SET $str_values ";
        if ($conditions !== "") {
            $query .= " WHERE $conditions ";
        }
        return $query;
    }

}
