<?php
    namespace Latencia;
    require_once 'Latencia.php';
    include_once RUTA_APP . 'application/controllers/Clases/UsuarioDatos.php'; 
    class LatenciaDatos{
        public static function getLatenciaById(int $id, $conexion):?Latencia{
            $retorno = null;
            $query = "SELECT usuario, latencia_telefonia, latencia_dialvox, latencia_vicidial, ip_telefonia, ip_web, fecha_telefonia, fecha_dialvox, fecha_vicidial FROM dialvox_latencias WHERE id = $id LIMIT 1";                    
            if($result = mysqli_query($conexion, $query)){
                if($row = mysqli_fetch_array($result)){                    
                    $retorno = new Latencia(
                        $id, 
                        \UsuarioDatos::getUsuarioByUsuario($row["usuario"]), 
                        $row["latencia_dialvox"],
                        $row["latencia_vicidial"],
                        $row["latencia_telefonia"],
                        new \DateTime($row["fecha_dialvox"]),
                        new \DateTime($row["fecha_vicidial"]),
                        new \DateTime($row["fecha_telefonia"]),
                        $row["ip_telefonia"],
                        $row["ip_web"]
                    );
                }
            }            
            return $retorno;
        }
        public static function getLatenciaByUsuario(\Usuario $usuario, $conexion):?Latencia{
            $retorno = null;
            $query = "SELECT id,latencia_telefonia, latencia_dialvox, latencia_vicidial, ip_telefonia, ip_web, fecha_telefonia, fecha_dialvox, fecha_vicidial FROM dialvox_latencias WHERE usuario = '".$usuario->getUsuario()."' LIMIT 1";            
            if($result = mysqli_query($conexion, $query)){
                if($row = mysqli_fetch_array($result)){                    
                    $retorno = new Latencia(
                        $row["id"], 
                        $usuario, 
                        $row["latencia_dialvox"],
                        $row["latencia_vicidial"],
                        $row["latencia_telefonia"],
                        new \DateTime($row["fecha_dialvox"]),
                        new \DateTime($row["fecha_vicidial"]),
                        new \DateTime($row["fecha_telefonia"]),
                        $row["ip_telefonia"],
                        $row["ip_web"]
                    );
                }
            }       
            return $retorno;
        }
        public static function getAllLatencias($conexion):?array{
            $retorno = array();
            $query = "SELECT id FROM dialvox_latencias";            
            $ids = array();
            if($result = mysqli_query($conexion, $query)){
                while($row = mysqli_fetch_array($result)){                    
                   $ids[] = $row["id"];
                }                
            }    
            for($i = 0; $i < count($ids); $i++){
                $retorno[] = LatenciaDatos::getLatenciaById($ids[$i], $conexion);
            }   
            return $retorno;
        }
        public static function getAllLatenciasByCliente(\Cliente $cliente, $conexion):?array{
            $retorno = array();
            $clienteSTR = explode("_",$cliente->getId())[0];
            $query = "SELECT id FROM dialvox_latencias WHERE usuario IN (SELECT user FROM vicidial_users WHERE user_group LIKE '".$clienteSTR."%')";
            $ids = array();
            if($result = mysqli_query($conexion, $query)){
                while($row = mysqli_fetch_array($result)){                    
                   $ids[] = $row["id"];
                }                
            }    
            for($i = 0; $i < count($ids); $i++){
                $retorno[] = LatenciaDatos::getLatenciaById($ids[$i], $conexion);
            }   
            return $retorno;
        }
        public static function updateLatencia(Latencia $latencia, $conexion):bool{
            $query = "UPDATE dialvox_latencias SET usuario = '".$latencia->getUsuario()->getUsuario()."', latencia_telefonia = ".$latencia->getLatenciaTelefonia().", latencia_dialvox = ".$latencia->getLatenciaDialvox().", latencia_vicidial = ".$latencia->getLatenciaVicidial().", ip_telefonia = '".$latencia->getIpTelefonia()."', ip_web = '".$latencia->getIpWeb()."', fecha_telefonia = timestamp('".$latencia->getFechaTelefonia()->format("Y-m-d H:i:s")."'), fecha_dialvox = timestamp('".$latencia->getFechaDialvox()->format("Y-m-d H:i:s")."'), fecha_vicidial = timestamp('".$latencia->getFechaVicidial()->format("Y-m-d H:i:s")."') WHERE id = ".$latencia->getId();
            if($result = mysqli_query($conexion, $query)){
                $latencia->setId(mysqli_insert_id($conexion));
                return true;
            }else{
                return false;
            } 
        }
        public static function insertLatencia(Latencia $latencia, $conexion):bool{
            $query = "INSERT INTO dialvox_latencias (usuario, latencia_telefonia, latencia_dialvox, latencia_vicidial, ip_telefonia, ip_web, fecha_telefonia, fecha_dialvox, fecha_vicidial) VALUES ('".$latencia->getUsuario()->getUsuario()."',".$latencia->getLatenciaTelefonia().",".$latencia->getLatenciaDialvox().",".$latencia->getLatenciaVicidial().",'".$latencia->getIpTelefonia()."','".$latencia->getIpWeb()."',timestamp('".$latencia->getFechaTelefonia()->format("Y-m-d H:i:s")."'),timestamp('".$latencia->getFechaDialvox()->format("Y-m-d H:i:s")."'),timestamp('".$latencia->getFechaVicidial()->format("Y-m-d H:i:s")."'))";            
            if($result = mysqli_query($conexion, $query)){
                $latencia->setId(mysqli_insert_id($conexion));
                return true;
            }else{
                return false;
            } 
        }
    }
?>
