<?php
require_once "BASEPATH.php";
require_once 'Clases/IngroupDatos.php';
require_once 'Clases/ClienteDatos.php';
include_once RUTA_APP . 'Sesiones.php';
class GrupoDeEntrada extends MY_Controller
{

    public function index()
    {
        $this->load->view('ingroup/head');
        $this->load->view('ingroup/vw_ingroup');
        $this->load->view('ingroup/foot');
    }
    public function trata(&$out, $arreglo, &$lastLinePrinted)
    {
        $llaves = array_keys($arreglo);
        //fputcsv($out,array_values($llaves));
        $llavesNoArreglos = array();
        for ($i = 0; $i < count($llaves); $i++) {
            if (!is_array($arreglo[$llaves[$i]])) {
                //$this->trata($out,$arreglo[$llaves[$i]]);
                $llavesNoArreglos[] = $llaves[$i];
            }
        }
        $temp = array();
        for ($i = 0; $i < count($llaves); $i++) {
            if (!is_array($arreglo[$llaves[$i]])) {
                $temp[] = $arreglo[$llaves[$i]];
            }
        }
        if (count($temp) > 0) {
            if ($llavesNoArreglos != $lastLinePrinted) {
                fputcsv($out, array_values($llavesNoArreglos));
                $lastLinePrinted = $llavesNoArreglos;
            }
            fputcsv($out, array_values($temp));
        }
        for ($i = 0; $i < count($llaves); $i++) {
            if (is_array($arreglo[$llaves[$i]])) {
                $temp2 = array();
                $temp2[0] = $llaves[$i];
                if (!is_numeric($temp2[0])) {
                    fputcsv($out, array_values($temp2));
                }

                $this->trata($out, $arreglo[$llaves[$i]], $lastLinePrinted);
            }
        }
    }
    public function getInboundReport()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('grupodeentrada', "spanish");
                break;
            case "en":
                $this->lang->load('grupodeentrada', "english");
                break;
            default:
                $this->lang->load('grupodeentrada', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"]) && (strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false)) {
            //header('Content-type: application/json');
            header('Content-Type: application/csv');
            include_once RUTA_APP . 'Sesiones.php';
            $con = getConnection();
            $sal = array();
            $campana = limpia($_GET["campana"]);
            $limiteFechas = "";
            $cliente = $_SESSION["Cliente"];
            $donde = "";
            $archived = false;
            if (isset($_GET["archived"]) && $_GET["archived"] == 1) {
                $archived = true;
            }
            if (isset($_GET["fechaIni"])) {
                $fechaIni = limpia($_GET["fechaIni"]);
                $limiteFechas .= "AND DATE(call_date) >= DATE('$fechaIni')";
            }

            if (isset($_GET["fechaFin"])) {
                $fechaFin = limpia($_GET["fechaFin"]);
                $limiteFechas .= "AND DATE(call_date) <= DATE('$fechaFin')";
            } else if (isset($_GET["fechaIni"])) {
                $fechaIni = limpia($_GET["fechaIni"]);
                $limiteFechas .= "AND DATE(call_date) <= DATE('$fechaIni')";
            }

            if ($cliente != -1) {
                $donde = "AND user_group = '$cliente'";
            }
            $query = "SELECT group_id,group_name FROM vicidial_inbound_groups WHERE group_id = '$campana' $donde LIMIT 1";
            $result = sv_mysqli_query($con, $query);
            $nombreCampana = "";
            if ($row = sv_mysqli_fetch_array($result)) {
                $nombreCampana = $row["group_name"];
                header("Content-Disposition: attachment; filename=\"Registro de llamadas en campaña: $nombreCampana.csv\"");
                $queryIFT = "SELECT tipo FROM dialvox_ift WHERE nirserie=LEFT(vicidial_closer_log.phone_number,6) LIMIT 1";
                $queryIFTArchive = "SELECT tipo FROM dialvox_ift WHERE nirserie=LEFT(vicidial_closer_log_archive.phone_number,6) LIMIT 1";
                $duracionQuery = "SEC_TO_TIME((GREATEST(IF(length_in_sec IS NULL,0,length_in_sec),(SELECT IF(MAX(length_in_sec) IS NULL,0,MAX(length_in_sec)) FROM recording_log WHERE vicidial_id=vicidial_closer_log.uniqueid))))";
                $duracionQueryArchive = "SEC_TO_TIME((GREATEST(IF(length_in_sec IS NULL,0,length_in_sec),(SELECT IF(MAX(length_in_sec) IS NULL,0,MAX(length_in_sec)) FROM recording_log WHERE vicidial_id=vicidial_closer_log_archive.uniqueid))))";
                $query = "SELECT lead_id,(SELECT vendor_lead_code FROM vicidial_list WHERE lead_id = vicidial_closer_log.lead_id) AS vendor_lead_code,(SELECT list_name FROM vicidial_lists WHERE list_id = vicidial_closer_log.list_id) AS list_id,(SELECT source_id FROM vicidial_list WHERE lead_id = vicidial_closer_log.lead_id) AS source_id,call_date,status,phone_number,user,SEC_TO_TIME((GREATEST(IF(length_in_sec IS NULL,0,length_in_sec),(SELECT IF(MAX(length_in_sec) IS NULL,0,MAX(length_in_sec)) FROM recording_log WHERE vicidial_id=vicidial_closer_log.uniqueid)))) AS duracion,  (ADDTIME(TIME_FORMAT(" . $duracionQuery . ",'%H:%i:00'), IF(SECOND(" . $duracionQuery . ")>0,'00:01:00','00:00:00'))) as tiempo_telefonia, (" . $queryIFT . ") AS tipo_telefono,term_reason FROM vicidial_closer_log WHERE campaign_id = '$campana' $limiteFechas";
                if ($archived) {
                    $query .= " UNION SELECT lead_id,(SELECT vendor_lead_code FROM vicidial_list WHERE lead_id = vicidial_closer_log_archive.lead_id) AS vendor_lead_code,(SELECT list_name FROM vicidial_lists WHERE list_id = vicidial_closer_log_archive.list_id) AS list_id,(SELECT source_id FROM vicidial_list WHERE lead_id = vicidial_closer_log_archive.lead_id) AS source_id,call_date,status,phone_number,user,SEC_TO_TIME((GREATEST(IF(length_in_sec IS NULL,0,length_in_sec),(SELECT IF(MAX(length_in_sec) IS NULL,0,MAX(length_in_sec)) FROM recording_log WHERE vicidial_id=vicidial_closer_log_archive.uniqueid)))) AS duracion,(ADDTIME(TIME_FORMAT(" . $duracionQueryArchive . ",'%H:%i:00'), IF (SECOND(" . $duracionQueryArchive . ")>0,'00:01:00','00:00:00'))) as tiempo_telefonia, (" . $queryIFTArchive . ") AS tipo_telefono,term_reason FROM vicidial_closer_log_archive WHERE campaign_id = '$campana' $limiteFechas ";
                }
                $query .= " ORDER BY call_date";
                $result = sv_mysqli_query($con, $query, MYSQLI_ASSOC);
                $out = "";
                $sal["Registros"] = array();
                $stmtNombres = "SELECT 'Causa de colgado' AS label_term_reason,'Llave' AS label_vendor_lead_code, 'id de registro' AS label_lead_id, 'Fecha registro' AS label_entry_date, 'Fecha de modificacion' AS label_modify_date, 'Estado del registro' AS label_status, 'Usuario' AS label_user, 'Nombre de Lista' AS label_list_id, 'Llamado desde el ultimo reinicio' AS label_called_since_last_reset, 'Zona horaria' AS label_gmt_offset_now, 'Codigo telefonico' AS label_phone_code, 'Fecha de nacimiento' AS label_date_of_birth,'Veces llamado' AS label_called_count, 'Fecha del ultimo llamado' AS label_last_local_call_time,'Pais' AS label_country_code,'Rango' AS label_rank, 'Autor' AS label_owner,'Titulo' AS label_title,'Nombre' AS label_first_name,'Segundo Nombre' AS label_middle_initial,'Apellidos' AS label_last_name,'Direccion' AS label_address1,'Direccion 2' AS label_address2,'Telefono alterno 2' AS label_address3,'Ciudad' AS label_city,'Estado' AS label_state,'Provincia' AS label_province,'Codigo Postal' AS label_postal_code,'Genero' AS label_gender,'Telefono' AS label_phone_number,'Telefono alterno' AS label_alt_phone,label_security_phrase,'Email' AS label_email,'Comentarios' AS label_comments, 'Duracion' as label_duracion, 'Minutos telefonia' as label_tiempo_telefonia, 'Tipo de telefono' as label_tipo_telefono,'Origen' as label_source_id from system_settings";
                $resultNombres = sv_mysqli_query($con, $stmtNombres, MYSQLI_ASSOC);
                $rowNombres = sv_mysqli_fetch_array($resultNombres);
                while ($row1 = sv_mysqli_fetch_array($result)) {
                    //$sal["Registros"][] = $row1;
                    $llaves = array_keys($row1);
                    $objeto = array();
                    for ($i = 0; $i < count($llaves); $i++) {
                        $titulo = "label_" . $llaves[$i];
                        if (array_key_exists($titulo, $rowNombres) && $rowNombres[$titulo] != "") {
                            $objeto[$rowNombres[$titulo]] = $row1[$llaves[$i]];
                        } else {
                            $objeto[$llaves[$i]] = $row1[$llaves[$i]];
                        }
                    }
                    $sal["Registros"][] = $objeto;
                }
                foreach ($sal["Registros"] as &$nombre) {
                    if ($nombre["Causa de colgado"] == "CALLER") {
                        $nombre["Causa de colgado"] = "Cliente";
                    }
                    if ($nombre["Causa de colgado"] == "AGENT") {
                        $nombre["Causa de colgado"] = "Agente";
                    }
                    if ($nombre["Causa de colgado"] == "ABANDON") {
                        $nombre["Causa de colgado"] = "Abandonada";
                    }
                    if ($nombre["Causa de colgado"] == "QUEUETIMEOUT") {
                        $nombre["Causa de colgado"] = "Tiempo Excedido en Cola";
                    }
                    if ($nombre["Usuario"] == "VDCL") {
                        $nombre["Usuario"] = "SISTEMA";
                    }
                }
                ob_start();
                $out = fopen('php://output', 'w');
                $test = array();
                $this->trata($out, $sal["Registros"], $test);
                fclose($out);
                $str = ob_get_contents();
                ob_end_clean();
                $this->output->set_output($str);
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_permisosLlamadas");
            }
        }
    }
    public function agregarIngroup()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('grupodeentrada', "spanish");
                break;
            case "en":
                $this->lang->load('grupodeentrada', "english");
                break;
            default:
                $this->lang->load('grupodeentrada', "spanish");
                break;
        }
        $sal = array();
        if (!empty($_SESSION["Usuario"]) && (strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false)) {
            $nombre = $_POST["nombre"];
            $usuario = $_SESSION["Usuario"];
            $activo = $_POST["activo"];
            if ($activo != 'Y') {
                $activo = 'N';
            }

            $nextAgentCall = $_POST["nextAgentCall"];
            $callTime = $_POST["callTime"];
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $ingroup = new Ingroup(null, $cliente, $nombre, $activo, $nextAgentCall, $callTime);
            if (IngroupDatos::addIngroup($ingroup) != 0) {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_crearGrupo");
            } else {
                $sal["Estado"] = "ok";
            }

        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosNecesarios");
        }
        $this->output->set_output(json_encode($sal));
    }
    public function listarIngroups()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('grupodeentrada', "spanish");
                break;
            case "en":
                $this->lang->load('grupodeentrada', "english");
                break;
            default:
                $this->lang->load('grupodeentrada', "spanish");
                break;
        }
        $sal = array();
        if (!empty($_SESSION["Usuario"]) && (strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false || strpos($_SESSION["Grupo"], GRUPO_SUPERVISORES) !== false)) {
            $usuario = $_SESSION["Usuario"];
            $texto = $_POST["texto"];
            $pagina = $_POST["pagina"];
            $limite = 15;
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $ingroups = array();
            $cuenta = 0;
            $sal["Ingroups"] = array();
            if ($cliente->getId() == -1) {
                $ingroups = IngroupDatos::getIngroups($texto, $pagina, $limite);
                $cuenta = IngroupDatos::countIngroups($texto);
            } else {
                $ingroups = IngroupDatos::getIngroupsByCliente($cliente, $texto, $pagina, $limite);
                $cuenta = IngroupDatos::countIngroupsByCliente($cliente, $texto);
            }
            $sal["Estado"] = "ok";
            $sal["Ingroups"] = $ingroups;
            for ($i = 0; $i < count($sal["Ingroups"]); $i++) {
                $sal["Ingroups"][$i] = $sal["Ingroups"][$i]->toJSON();
            }
            $sal["Cuenta"] = $cuenta;

        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosNecesarios");
        }
        $this->output->set_output(json_encode($sal));
    }
    public function seleccionarIngroupsCampana()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('grupodeentrada', "spanish");
                break;
            case "en":
                $this->lang->load('grupodeentrada', "english");
                break;
            default:
                $this->lang->load('grupodeentrada', "spanish");
                break;
        }
        $sal = array();
        if (!empty($_SESSION["Usuario"]) && (strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false || strpos($_SESSION["Grupo"], GRUPO_AGENTES) !== false)) {
            $usuario = $_SESSION["Usuario"];
            $campana = $_POST["campana"];
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $ingroups = array();
            $ingroups = IngroupDatos::getAllIngroupsByCampana($cliente, $campana);
            $sal["Estado"] = "ok";
            $sal["Ingroups"] = $ingroups;
            for ($i = 0; $i < count($sal["Ingroups"]); $i++) {
                $sal["Ingroups"][$i] = $sal["Ingroups"][$i]->toJSON();
            }
        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosNecesarios");
        }
        $this->output->set_output(json_encode($sal));
    }

    public function seleccionarIngroupsTransferenciaCampana()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('grupodeentrada', "spanish");
                break;
            case "en":
                $this->lang->load('grupodeentrada', "english");
                break;
            default:
                $this->lang->load('grupodeentrada', "spanish");
                break;
        }
        $sal = array();
        if (!empty($_SESSION["Usuario"]) && (strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false || strpos($_SESSION["Grupo"], GRUPO_AGENTES) !== false)) {
            $usuario = $_SESSION["Usuario"];
            $campana = $_POST["campana"];
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $ingroups = array();
            $ingroups = IngroupDatos::getAllIngroupsXTransferByCampana($cliente, $campana);
            $sal["Estado"] = "ok";
            $sal["Ingroups"] = $ingroups;
            for ($i = 0; $i < count($sal["Ingroups"]); $i++) {
                $sal["Ingroups"][$i] = $sal["Ingroups"][$i]->toJSON();
            }
        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosNecesarios");
        }
        $this->output->set_output(json_encode($sal));
    }

    public function seleccionarCampanasIngroup()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('grupodeentrada', "spanish");
                break;
            case "en":
                $this->lang->load('grupodeentrada', "english");
                break;
            default:
                $this->lang->load('grupodeentrada', "spanish");
                break;
        }
        $sal = array();
        if (!empty($_SESSION["Usuario"]) && (strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false || strpos($_SESSION["Grupo"], GRUPO_AGENTES) !== false)) {
            $usuario = $_SESSION["Usuario"];
            $ingroup = $_POST["ingroup"];
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $campanas = array();
            $campanas = IngroupDatos::getAllCampanasByIngroup($cliente, $ingroup);
            $sal["Estado"] = "ok";
            $sal["Campanas"] = $campanas;
        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosNecesarios");
        }
        $this->output->set_output(json_encode($sal));
    }
    public function addCampaignToIngroup()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('grupodeentrada', "spanish");
                break;
            case "en":
                $this->lang->load('grupodeentrada', "english");
                break;
            default:
                $this->lang->load('grupodeentrada', "spanish");
                break;
        }
        $sal = array();
        if (!empty($_SESSION["Usuario"]) && strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false) {
            $usuario = $_SESSION["Usuario"];
            $ingroup = $_POST["ingroup"];
            $campana = $_POST["campana"];
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $resp = IngroupDatos::addIngroupByCampana($cliente, $ingroup, $campana);
            if ($resp == -1) {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_permisosNecesarios");
            } elseif ($resp == 0) {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_noActualizo");
            } else {
                $sal["Estado"] = "ok";
            }
        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosNecesarios");
        }
        $this->output->set_output(json_encode($sal));
    }
    public function removeCampaignToIngroup()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('grupodeentrada', "spanish");
                break;
            case "en":
                $this->lang->load('grupodeentrada', "english");
                break;
            default:
                $this->lang->load('grupodeentrada', "spanish");
                break;
        }
        $sal = array();
        if (!empty($_SESSION["Usuario"]) && strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false) {
            $usuario = $_SESSION["Usuario"];
            $ingroup = $_POST["ingroup"];
            $campana = $_POST["campana"];
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $resp = IngroupDatos::removeIngroupByCampana($cliente, $ingroup, $campana);
            if ($resp == -1) {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_permisosNecesarios");
            } elseif ($resp == 0) {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_noActualizo");
            } else {
                $sal["Estado"] = "ok";
            }
        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosNecesarios");
        }
        $this->output->set_output(json_encode($sal));
    }
    public function addUserToIngroup()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('grupodeentrada', "spanish");
                break;
            case "en":
                $this->lang->load('grupodeentrada', "english");
                break;
            default:
                $this->lang->load('grupodeentrada', "spanish");
                break;
        }
        $sal = array();
        if (!empty($_SESSION["Usuario"]) && strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false) {
            $usuarioSession = $_SESSION["Usuario"];
            $usuario = $_POST["usuario"];
            $campana = $_POST["campana"];
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $resp = IngroupDatos::addIngroupByUsuario($cliente, $campana, $usuario);
            if ($resp == -1) {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_permisosNecesarios");
            } elseif ($resp == 0) {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_noActualizo");
            } else {
                $sal["Estado"] = "ok";
            }
        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosNecesarios");
        }
        $this->output->set_output(json_encode($sal));
    }
    public function removeUserToIngroup()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('grupodeentrada', "spanish");
                break;
            case "en":
                $this->lang->load('grupodeentrada', "english");
                break;
            default:
                $this->lang->load('grupodeentrada', "spanish");
                break;
        }
        $sal = array();
        if (!empty($_SESSION["Usuario"]) && strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false) {
            $usuarioSession = $_SESSION["Usuario"];
            $usuario = $_POST["usuario"];
            $campana = $_POST["campana"];
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $resp = IngroupDatos::removeIngroupByUsuario($cliente, $campana, $usuario);
            if ($resp == -1) {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_errorQuery");
            } else if ($resp == 0) {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_noActualizo");
            } else {
                $sal["Estado"] = "ok";
            }
        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosNecesarios");
        }
        $this->output->set_output(json_encode($sal));
    }
    public function seleccionarUsuariosIngroup()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('grupodeentrada', "spanish");
                break;
            case "en":
                $this->lang->load('grupodeentrada', "english");
                break;
            default:
                $this->lang->load('grupodeentrada', "spanish");
                break;
        }
        $sal = array();
        if (!empty($_SESSION["Usuario"]) && (strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false || strpos($_SESSION["Grupo"], GRUPO_AGENTES) !== false)) {
            $usuario = $_SESSION["Usuario"];
            $ingroup = $_POST["ingroup"];
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $usuarios = array();
            $usuarios = IngroupDatos::getAllUsuariosByIngroup($cliente, $ingroup);
            $sal["Estado"] = "ok";
            $sal["Usuarios"] = $usuarios;
        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosNecesarios");
        }
        $this->output->set_output(json_encode($sal));

    }
    public function seleccionarIngroups()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('grupodeentrada', "spanish");
                break;
            case "en":
                $this->lang->load('grupodeentrada', "english");
                break;
            default:
                $this->lang->load('grupodeentrada', "spanish");
                break;
        }
        $sal = array();
        if (!empty($_SESSION["Usuario"]) && (strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false || strpos($_SESSION["Grupo"], GRUPO_SUPERVISORES) !== false)) {
            $usuario = $_SESSION["Usuario"];
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $ingroups = array();
            if ($cliente->getId() == -1) {
                $ingroups = IngroupDatos::getAllIngroups();
            } else {
                $ingroups = IngroupDatos::getAllIngroupsByCliente($cliente);
            }
            $sal["Estado"] = "ok";
            $sal["Ingroups"] = $ingroups;
            for ($i = 0; $i < count($sal["Ingroups"]); $i++) {
                $sal["Ingroups"][$i] = $sal["Ingroups"][$i]->toJSON();
            }

        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosNecesarios");
        }
        $this->output->set_output(json_encode($sal));
    }
    public function obtenerIngroup()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('grupodeentrada', "spanish");
                break;
            case "en":
                $this->lang->load('grupodeentrada', "english");
                break;
            default:
                $this->lang->load('grupodeentrada', "spanish");
                break;
        }
        $sal = array();
        if (!empty($_SESSION["Usuario"]) && (strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false)) {
            $usuario = $_SESSION["Usuario"];
            $id = $_POST["id"];
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $ingroup = IngroupDatos::getIngroupById($id);
            if ($ingroup == null) {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_grupoInexistente");
            } else {
                if ($cliente->getId() == -1 || $cliente->getId() == $ingroup->getCliente()->getId()) {
                    $sal["Estado"] = "ok";
                    $sal["Ingroup"] = $ingroup->toJSON();
                } else {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("desc_permisosGrupo");
                }
            }
        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosNecesarios");
        }
        $this->output->set_output(json_encode($sal));
    }
    public function editarIngroup()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('grupodeentrada', "spanish");
                break;
            case "en":
                $this->lang->load('grupodeentrada', "english");
                break;
            default:
                $this->lang->load('grupodeentrada', "spanish");
                break;
        }
        $sal = array();
        if (!empty($_SESSION["Usuario"]) && (strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false)) {
            $nombre = $_POST["nombre"];
            $usuario = $_SESSION["Usuario"];
            $activo = $_POST["activo"];
            if ($activo != 'Y') {
                $activo = 'N';
            }

            $nextAgentCall = $_POST["nextAgentCall"];
            $callTime = $_POST["callTime"];
            $id = $_POST["id"];
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $ingroup = IngroupDatos::getIngroupById($id);
            if ($ingroup == null) {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_grupoInexistente");
            } else {
                if ($cliente->getId() == -1 || $cliente->getId() == $ingroup->getCliente()->getId()) {
                    $ingroup->setNombre($nombre);
                    $ingroup->setNextAgentCall($nextAgentCall);
                    $ingroup->setActivo($activo);
                    $ingroup->setCallTime($callTime);
                    if (IngroupDatos::editIngroup($ingroup) == 0) {
                        $sal["Estado"] = "ok";
                    } else {
                        $sal["Estado"] = "error";
                        $sal["Descripcion"] = $this->lang->line("desc_noActualizo");
                    }
                } else {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("desc_permisosGrupo");
                }
            }
        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosNecesarios");
        }
        $this->output->set_output(json_encode($sal));
    }
    public function desactivarIngroup()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('grupodeentrada', "spanish");
                break;
            case "en":
                $this->lang->load('grupodeentrada', "english");
                break;
            default:
                $this->lang->load('grupodeentrada', "spanish");
                break;
        }
        $sal = array();
        if (!empty($_SESSION["Usuario"]) && (strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false)) {
            $usuario = $_SESSION["Usuario"];
            $id = $_POST["id"];
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $ingroup = IngroupDatos::getIngroupById($id);
            if ($ingroup == null) {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_grupoInexistente");
            } else {
                if ($cliente->getId() == -1 || $cliente->getId() == $ingroup->getCliente()->getId()) {
                    $activo = $ingroup->getActivo();
                    if ($activo == 'Y') {
                        $activo = 'N';
                    } else {
                        $activo = 'Y';
                    }

                    $ingroup->setActivo($activo);
                    if (IngroupDatos::editIngroup($ingroup) == 0) {
                        $sal["Estado"] = "ok";
                    } else {
                        $sal["Estado"] = "error";
                        $sal["Descripcion"] = $this->lang->line("desc_noActualizo");
                    }
                } else {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("desc_permisosGrupo");
                }
            }
        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosNecesarios");
        }
        $this->output->set_output(json_encode($sal));
    }
    public function eliminarIngroup()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('grupodeentrada', "spanish");
                break;
            case "en":
                $this->lang->load('grupodeentrada', "english");
                break;
            default:
                $this->lang->load('grupodeentrada', "spanish");
                break;
        }
        $sal = array();
        if (!empty($_SESSION["Usuario"]) && (strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false)) {
            $usuario = $_SESSION["Usuario"];
            $id = $_POST["id"];
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $ingroup = IngroupDatos::getIngroupById($id);
            if ($ingroup == null) {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_grupoInexistente");
            } else {
                if ($cliente->getId() == -1 || $cliente->getId() == $ingroup->getCliente()->getId()) {
                    if (IngroupDatos::deleteIngroup($ingroup) == 0) {
                        $sal["Estado"] = "ok";
                    } else {
                        $sal["Estado"] = "error";
                        $sal["Descripcion"] = $this->lang->line("desc_noActualizo");
                    }
                } else {
                    $sal["Estado"] = "error";
                    $sal["Descripcion"] = $this->lang->line("desc_permisosGrupo");
                }
            }
        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosNecesarios");
        }
        $this->output->set_output(json_encode($sal));
    }

    // ================================================
    // Eliminar cuando haya controlador para calltimes
    public function seleccionarCallTimes()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('grupodeentrada', "spanish");
                break;
            case "en":
                $this->lang->load('grupodeentrada', "english");
                break;
            default:
                $this->lang->load('grupodeentrada', "spanish");
                break;
        }
        $sal = array();
        if (!empty($_SESSION["Usuario"]) && (strpos($_SESSION["Grupo"], GRUPO_ADMINS) !== false || strpos($_SESSION["Grupo"], GRUPO_AGENTES) !== false)) {
            $usuario = $_SESSION["Usuario"];
            $cliente = ClienteDatos::getClienteById($_SESSION["Cliente"]);
            $calltimes = array();

            $con = getConnection();
            $query = "SELECT call_time_id,call_time_name FROM vicidial_call_times WHERE user_group IN ('---ALL---', '" . $cliente->getId() . "')";
            $result = sv_mysqli_query($con, $query);
            if ($result !== false) {
                $sal["Estado"] = "ok";
                while ($row = sv_mysqli_fetch_array($result)) {
                    array_push($calltimes, array(
                        "id" => $row["call_time_id"],
                        "Nombre" => $row["call_time_name"],
                    )
                    );
                }
                $sal["CallTimes"] = $calltimes;
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = mysqli_error($con);
            }

            sv_mysqli_close($con);

        } else {
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosNecesarios");
        }
        $this->output->set_output(json_encode($sal));
    }
    // ================================================
}