<?php

require_once "BASEPATH.php";

class Decision extends MY_Controller
{

    public function getDecisionesSelect()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('decision', "spanish");
                break;
            case "en":
                $this->lang->load('decision', "english");
                break;
            default:
                $this->lang->load('decision', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_encuesta = limpia($_POST["id_encuesta"]);
            $sal["Registros"] = array();
            $query = "SELECT id_decision,nombre FROM dialvox_decisiones WHERE id_encuesta='$id_encuesta' ";
            $result = sv_mysqli_query($con, $query);
            while ($row = sv_mysqli_fetch_array($result)) {
                $sal["Registros"][] = $row;
            }
            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function getDecisiones()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('decision', "spanish");
                break;
            case "en":
                $this->lang->load('decision', "english");
                break;
            default:
                $this->lang->load('decision', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $pagina = limpia($_POST["pagina"]) - 1;
            $id_encuesta = limpia($_POST["id_encuesta"]);
            $sal["Registros"] = array();
            $query = "SELECT id_decision,nombre FROM dialvox_decisiones WHERE id_encuesta='$id_encuesta' LIMIT " . ($pagina * 10) . ",10";
            $result = sv_mysqli_query($con, $query);
            while ($row = sv_mysqli_fetch_array($result)) {
                $sal["Registros"][] = $row;
            }

            $query = "SELECT COUNT(id_decision) AS CANT FROM dialvox_decisiones WHERE id_encuesta='$id_encuesta' ";
            $result = sv_mysqli_query($con, $query);
            if ($row = sv_mysqli_fetch_array($result)) {
                $sal["Cant"] = $row["CANT"];
            }
            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function deleteDeciciones()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('decision', "spanish");
                break;
            case "en":
                $this->lang->load('decision', "english");
                break;
            default:
                $this->lang->load('decision', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_decision = limpia($_POST["id_decision"]);
            $id_encuesta = limpia($_POST["id_encuesta"]);

            $query = "DELETE FROM dialvox_decisiones WHERE id_decision='$id_decision' AND id_encuesta='$id_encuesta'";
            sv_mysqli_query($con, $query);

            $query = "DELETE FROM dialvox_rangos WHERE id_decision='$id_decision'";
            sv_mysqli_query($con, $query);

            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function addDecisiones()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('decision', "spanish");
                break;
            case "en":
                $this->lang->load('decision', "english");
                break;
            default:
                $this->lang->load('decision', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_encuesta = limpia($_POST["id_encuesta"]);
            $nombre = limpia($_POST["nombre"]);
            $tipoDeAccionDefecto = limpia($_POST["tipoDeAccionDefecto"]);
            $valorDeAccionDefecto = limpia($_POST["valorDeAccionDefecto"]);

            $query = "INSERT INTO dialvox_decisiones(id_encuesta,nombre,tipoDeAccionDefecto,valorDeAccionDefecto) VALUES('$id_encuesta','$nombre','$tipoDeAccionDefecto','$valorDeAccionDefecto')";
            sv_mysqli_query($con, $query);

            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function editDecisiones()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('decision', "spanish");
                break;
            case "en":
                $this->lang->load('decision', "english");
                break;
            default:
                $this->lang->load('decision', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_decision = limpia($_POST["id_decision"]);
            $id_encuesta = limpia($_POST["id_encuesta"]);
            $nombre = limpia($_POST["nombre"]);
            $tipoDeAccionDefecto = limpia($_POST["tipoDeAccionDefecto"]);
            $valorDeAccionDefecto = limpia($_POST["valorDeAccionDefecto"]);

            $query = "UPDATE dialvox_decisiones SET id_encuesta='$id_encuesta',nombre='$nombre',tipoDeAccionDefecto='$tipoDeAccionDefecto',valorDeAccionDefecto='$valorDeAccionDefecto' WHERE id_decision='$id_decision'";
            sv_mysqli_query($con, $query);

            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function getDecisionDetails()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('decision', "spanish");
                break;
            case "en":
                $this->lang->load('decision', "english");
                break;
            default:
                $this->lang->load('decision', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_decision = limpia($_POST["id_decision"]);
            $query = "SELECT * FROM dialvox_decisiones WHERE id_decision='$id_decision'";
            $result = sv_mysqli_query($con, $query);
            if ($row = sv_mysqli_fetch_array($result)) {
                $sal["Respuesta"] = $row;
                $sal["Estado"] = "ok";

            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");

            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);

        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function getRespuestaLog()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('decision', "spanish");
                break;
            case "en":
                $this->lang->load('decision', "english");
                break;
            default:
                $this->lang->load('decision', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_pregunta = limpia($_POST["id_pregunta"]);
            $query = "SELECT * FROM dialvox_respuesta_log WHERE id_pregunta='$id_pregunta'";
            $result = sv_mysqli_query($con, $query);
            $sal["Registros"] = array();
            while ($row = sv_mysqli_fetch_array($result)) {
                $sal["Registros"][] = $row;
            }
            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);

        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function index()
    {
        $this->load->view('decision/head');
        $this->load->view('decision/vw_categorias');
        $this->load->view('decision/foot');
    }
}
