<?php

class SvConnection {

    private static $instance;
    private $con;

    private function __construct() {
        // Lectura de las constantes de base de datos
        // cambio respecto a los anteriores archivos
        // de constantes
        // ==> require_once '../constantesDB.php';
        if (file_exists("/etc/dialvox/configuracion.json")) {
            $strConstantes = file_get_contents("/etc/dialvox/configuracion.json");
            $jsonContantes = json_decode($strConstantes, true);
            foreach ($jsonContantes["DB"] as $key => $value) {
                defined($key) or define($key, $value);
            }
        } else {
            require_once RUTA_APP . '../constantesDB.php';
        }
    
        $this->con = mysqli_connect(host, user, pass, db, 3306);
        mysqli_set_charset($this->con, "utf8");
    }

    public static function getInstance() {
        if (!isset(self::$instance)) {
            $c = __CLASS__;
            self::$instance = new $c;
        }

        return self::$instance;
    }

    public function getCon() {
        return $this->con;
    }

    public function closeConnection() {
        mysqli_close($this->con);
    }
}

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
function getConnection() {
    return SvConnection::getInstance()->getCon();
}

class SvResultSet {

    private $elems;
    private $num_rows;

    public function __construct($elems, $num_rows) {
        $this->elems = $elems;
        $this->num_rows = $num_rows;
    }

    public function fetch_assoc() {
        $r = current($this->elems);
        next($this->elems);
        return $r;
    }

    public function get_num_rows() {
        return $this->num_rows;
    }

    public function current() {
        return current($this->elems);
    }

    public function next() {
        return next($this->elems);
    }

}

function sv_mysqli_query($con, $query, $mysqli_flag = MYSQLI_BOTH, $flag = FALSE) {
    $result = mysqli_query($con, $query);
    $tmp_result = [];

    if ($flag) {
        echo var_dump($result);
    }

    if (is_bool($result)) {
        return $result;
    }

    $num_rows = mysqli_num_rows($result);
    while($row = mysqli_fetch_array($result, $mysqli_flag)) {
        array_push($tmp_result, $row);
    }

    return new SvResultSet($tmp_result, $num_rows);
}

function sv_mysqli_fetch_array(&$result) {
    $r = $result->current();
    $result->next();
    return $r;
}

function sv_mysqli_num_rows($result) {
    return $result->get_num_rows();
}

function sv_mysqli_close($con) {
    // mysqli_close($con);
    // funcion tan util como Rodolfo
}

function getConnection2()
{

    // Lectura de las constantes de base de datos
    // cambio respecto a los anteriores archivos
    // de constantes
    // ==> require_once '../constantesDB2.php';

    if (file_exists("/etc/dialvox/configuracion.json")) {
        $strConstantes = file_get_contents("/etc/dialvox/configuracion.json");
        $jsonContantes = json_decode($strConstantes, true);
        foreach ($jsonContantes["DB2"] as $key => $value) {
            defined($key) or define($key, $value);
        }
    } else {
        require_once '../constantesDB2.php';
    }

    $con = mysqli_connect(host2, user2, pass2, db2, 3306);
    mysqli_set_charset($con, "utf8");
    return $con;
}

function limpia($cadena)
{
    $con = getConnection();
    $ret = mysqli_real_escape_string($con, $cadena);
    sv_mysqli_close($con);
    return $ret;
}
