<?php

namespace Televox\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class Usuarios extends Controller
{
    public function getUsers(Request $request)
    {
        if ($request->session()->get('modificar', false)) {
            $datos = $request->validate(['pagina' => 'numeric|min:0|required']);
            $offset = ($datos['pagina'] - 1) * 20;
            $results = DB::connection('Televox')->table('tbl_usuario')->offset($offset)->limit(20)->get();
            $cuenta = DB::connection('Televox')->table('tbl_usuario')->count();

            return ['Estado' => 'ok', 'Registros' => $results, 'Cuantos' => $cuenta];
        } else {
            return ['Estado' => 'error', 'Descripcion' => 'No tiene permisos para realizar esta accion'];
        }
    }

    public function retrieveUser(Request $request, $id)
    {
        if ($request->session()->get('modificar', false)) {
            $results = DB::connection('Televox')->table('tbl_usuario')->where('Id', '=', $id)->first();
            if ($results) {
                return ['Estado' => 'ok', 'Usuario' => $results];
            } else {
                return ['Estado' => 'error', 'Descripcion' => 'No se encontro al usuario'];
            }
        } else {
            return ['Estado' => 'error', 'Descripcion' => 'No tiene permisos para realizar esta accion'];
        }
    }

    public function createUser(Request $request)
    {
        if ($request->session()->get('modificar', false)) {
            $datos = $request->validate([
                'usuario' => 'alpha_num|required',
                'password' => 'alpha_num|required',
                'reproducir' => 'boolean|required',
                'log' => 'boolean|required',
                'descargar' => 'boolean|required',
                'eliminar' => 'boolean|required',
                'grafica' => 'boolean|required',
                'modificar' => 'boolean|required',
                'configurar' => 'boolean|required',
                'comentar' => 'boolean|required',
                'status' => 'boolean|required',
                'reportes' => 'boolean|required',
            ]);
            if (DB::connection('Televox')->table('tbl_usuario')->where('usuario', '=', base64_encode(base64_encode($datos['usuario'])))->doesntExist()) {
                $idRecord = DB::connection('Televox')->table('tbl_usuario')->orderBy('Id', 'DESC')->first();
                $id = $idRecord ? $idRecord->Id + 1 : 1;
                DB::connection('Televox')->table('tbl_usuario')->insert([
                    'idClientes' => $request->session()->get('idClientes'),
                    'Id' => $id,
                    'usuario' => base64_encode(base64_encode($datos['usuario'])),
                    'password' => base64_encode(base64_encode($datos['password'])),
                    'reproducir' => $datos['reproducir'] ? 1 : 0,
                    'grafica' => $datos['grafica'] ? 1 : 0,
                    'descargar' => $datos['descargar'] ? 1 : 0,
                    'eliminar' => $datos['eliminar'] ? 1 : 0,
                    'log' => $datos['log'] ? 1 : 0,
                    'modificar' => $datos['modificar'] ? 1 : 0,
                    'configurar' => $datos['configurar'] ? 1 : 0,
                    'comentar' => $datos['comentar'] ? 1 : 0,
                    'status' => $datos['status'] ? 1 : 0,
                    'reportes' => $datos['reportes'] ? 1 : 0,
                ]);
                $query = '[';
                foreach ($datos as $key => $val) {
                    $query .= "$key => $val,";
                }
                $query .= ']';
                DB::connection('Televox')->table('tbl_log')->insertGetId(['idClientes' => $request->session()->get('idClientes'), 'ip' => $request->ip(), 'fecha' => date('Y-m-d H:i:s'), 'id_usuario' => $request->session()->get('id'), 'tipo' => 7, 'detalle' => 'El usuario ' . $request->session()->get('usuario') . " creo un usuario con las siguientes configuraciones: $query"]);

                return ['Estado' => 'ok'];
            } else {
                return ['Estado' => 'error', 'Descripcion' => 'Este usuario ya existe'];
            }

        } else {
            return ['Estado' => 'error', 'Descripcion' => 'No tiene permisos para realizar esta accion'];
        }
    }

    public function editUser(Request $request)
    {
        if ($request->session()->get('modificar', false)) {
            $datos = $request->validate([
                'Id' => 'numeric|required',
                'password' => 'alpha_num|required',
                'reproducir' => 'boolean|required',
                'log' => 'boolean|required',
                'descargar' => 'boolean|required',
                'eliminar' => 'boolean|required',
                'grafica' => 'boolean|required',
                'modificar' => 'boolean|required',
                'configurar' => 'boolean|required',
                'comentar' => 'boolean|required',
                'status' => 'boolean|required',
                'reportes' => 'boolean|required',
            ]);
            if (DB::connection('Televox')->table('tbl_usuario')->where('Id', '=', $datos['Id'])->exists()) {
                DB::connection('Televox')->table('tbl_usuario')->where('Id', '=', $datos['Id'])->update([
                    'password' => base64_encode(base64_encode($datos['password'])),
                    'reproducir' => $datos['reproducir'] ? 1 : 0,
                    'grafica' => $datos['grafica'] ? 1 : 0,
                    'descargar' => $datos['descargar'] ? 1 : 0,
                    'eliminar' => $datos['eliminar'] ? 1 : 0,
                    'log' => $datos['log'] ? 1 : 0,
                    'modificar' => $datos['modificar'] ? 1 : 0,
                    'configurar' => $datos['configurar'] ? 1 : 0,
                    'comentar' => $datos['comentar'] ? 1 : 0,
                    'status' => $datos['status'] ? 1 : 0,
                    'reportes' => $datos['reportes'] ? 1 : 0,
                ]);
                $query = '[';
                foreach ($datos as $key => $val) {
                    $query .= "$key => $val,";
                }
                $query .= ']';
                DB::connection('Televox')->table('tbl_log')->insertGetId(['idClientes' => $request->session()->get('idClientes'), 'ip' => $request->ip(), 'fecha' => date('Y-m-d H:i:s'), 'id_usuario' => $request->session()->get('id'), 'tipo' => 8, 'detalle' => 'El usuario ' . $request->session()->get('usuario') . " modifico un usuario con las siguientes configuraciones: $query"]);

                return ['Estado' => 'ok'];
            } else {
                return ['Estado' => 'error', 'Descripcion' => 'No existe el usuario'];
            }

        } else {
            return ['Estado' => 'error', 'Descripcion' => 'No tiene permisos para realizar esta accion'];
        }
    }

    public function deleteUser(Request $request, $id)
    {
        if ($request->session()->get('modificar', false)) {
            if (DB::connection('Televox')->table('tbl_usuario')->where('Id', '=', $id)->exists()) {
                DB::connection('Televox')->table('tbl_usuario')->where('Id', '=', $id)->delete();
                DB::connection('Televox')->table('tbl_log')->insertGetId(['idClientes' => $request->session()->get('idClientes'), 'ip' => $request->ip(), 'fecha' => date('Y-m-d H:i:s'), 'id_usuario' => $request->session()->get('id'), 'tipo' => 9, 'detalle' => 'El usuario ' . $request->session()->get('usuario') . " elimino un usuario con el Id :$id"]);

                return ['Estado' => 'ok'];
            } else {
                return ['Estado' => 'error', 'Descripcion' => 'No se encontro al usuario'];
            }
        } else {
            return ['Estado' => 'error', 'Descripcion' => 'No tiene permisos para realizar esta accion'];
        }
    }
}
