<?php

namespace Televox\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class Login extends Controller
{

    public function logout(Request $request)
    {
        $userId = $request->session()->get('id');
        $userName = $request->session()->get('usuario');
        if ($request->session()->has('logueado')) {
            $duracion = DB::connection('Televox')->table('tbl_log')
                ->where([['tipo', '=', 0], ['id_usuario', '=', $userId]])
                ->addSelect(DB::raw("sec_to_time(TIME_TO_SEC(TIME(NOW()))-TIME_TO_SEC(TIME(fecha))) as 'duracion'"))
                ->first()->duracion;
            DB::connection('Televox')->table('tbl_log')->insertGetId([
                'idClientes' => $request->session()->get('idClientes'),
                'ip' => $request->ip(),
                'fecha' => date('Y-m-d H:i:s'),
                'id_usuario' => $userId,
                'tipo' => 1,
                'detalle' => 'El usuario ' . $userName . " cerro sesion con una duracion de $duracion"
            ]);
        }
        $request->session()->flush();

        return redirect('/');
    }

    private function doubleBase64Encode($value)
    {
        return base64_encode(base64_encode($value));
    }

    public function entra(Request $request)
    {
        $datos = $request->validate([
            'usuario' => 'alpha_num|required|string',
            'password' => 'alpha_num|required|string',
        ]);
        $datos['usuario'] = $this->doubleBase64Encode($datos['usuario']);
        $datos['password'] = $this->doubleBase64Encode($datos['password']);
        $builder = DB::connection('Televox')->table('tbl_usuario')->where([['usuario', $datos['usuario']], ['password', $datos['password']]]);

        $result = $builder->first();
        if ($result) {
            $request->session()->put('id', $result->Id);
            $decodedUser = base64_decode(base64_decode($result->usuario));
            $request->session()->put('usuario', $decodedUser);
            $request->session()->put('log', $result->log);
            $request->session()->put('reproducir', $result->reproducir);
            $request->session()->put('descargar', $result->descargar);
            $request->session()->put('eliminar', $result->eliminar);
            $request->session()->put('grafica', $result->grafica);
            $request->session()->put('modificar', $result->modificar);
            $request->session()->put('configurar', $result->configurar);
            $request->session()->put('comentar', $result->comentar);
            $request->session()->put('status', $result->status);
            $request->session()->put('reportes', $result->reportes);
            $request->session()->put('idClientes', $result->idClientes);

            $request->session()->put('logueado', true);
            DB::connection('Televox')->table('tbl_log')->insertGetId(['idClientes' => $request->session()->get('idClientes'), 'ip' => $request->ip(), 'fecha' => date('Y-m-d H:i:s'), 'id_usuario' => $result->Id, 'tipo' => 0, 'detalle' => 'El usuario ' . $request->session()->get('usuario') . ' inicio sesion']);

            return ['Estado' => 'ok'];
        } else {
            return ['Estado' => 'error', 'Descripcion' => 'El usuario no existe o no coinciden las credenciales'];
        }
    }
}
