<?php

namespace Televox\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class Dashboard extends Controller
{
    public function dash(Request $request)
    {
        if ($request->session()->get('logueado', false)) {
            $logs = DB::connection('Televox')
                ->table('tbl_log')
                ->count();

            $grabaciones = DB::connection('Dialvox')
                ->table('recording_log as rl')
                ->join('vicidial_list AS vl', 'rl.lead_id', '=', 'vl.lead_id')
                ->count();

            return [
                'Estado' => 'ok',
                'grabaciones' => $grabaciones,
                'logs' => $logs
            ];
        } else {
            return [
                'Estado' => 'ok',
                'Descripcion' => 'No estas logueado'
            ];
        }
    }

    public function getCampaignsByClient(Request $request)
    {
        $results = DB::connection('Dialvox')
            ->table('vicidial_campaigns')
            ->where('user_group', $request->session()->get('idClientes'))
            ->select('campaign_id', 'campaign_name')
            ->get();

        return ['Estado' => 'ok', 'Registros' => $results];
    }

    public function getUsersByClient(Request $request)
    {
        $results = DB::connection('Dialvox')
            ->table('vicidial_users')
            ->where('user_group', 'LIKE', '%' . $request->session()->get('idClientes') . '%')
            ->select('user_id', 'full_name', 'user')
            ->get();

        return ['Estado' => 'ok', 'Registros' => $results];
    }

    public function getStatusesByClient(Request $request)
    {
        $datos = $request->validate(['campaign_id' => 'required|string']);
        $results = DB::connection('Dialvox')
            ->table('vicidial_campaign_statuses AS VCS')
            ->join('vicidial_campaigns AS VC', 'VC.campaign_id', '=', 'VCS.campaign_id')
            ->where([
                ['VC.user_group', $request->session()->get('idClientes')],
                ['VCS.campaign_id', $datos['campaign_id']]
            ])
            ->select('VCS.status', 'VCS.status_name')
            ->get();

        return ['Estado' => 'ok', 'Registros' => $results];
    }

    public function getListsByClient(Request $request)
    {
        $datos = $request->validate(['campaign_id' => 'required|string']);
        $results = DB::connection('Dialvox')
            ->table('vicidial_lists AS VLS')

            ->join('vicidial_campaigns AS VC', 'VC.campaign_id', '=', 'VLS.campaign_id')
            ->where([
                ['VC.user_group', $request->session()->get('idClientes')],
                ['VLS.campaign_id', $datos['campaign_id']]
            ])
            ->select('VLS.list_id', 'VLS.list_name')
            ->get();

        return ['Estado' => 'ok', 'Registros' => $results];
    }
}

