<?php

namespace Televox\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use DirectoryIterator;
class CleanFiles extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'cleanFiles:all';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Se encarga de eliminar todas las grabaciones que se encuentren en /ZIP y en /audios';

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $archivos = array_merge(
            glob(public_path('ZIP/') . '*.zip'),
            glob(public_path('audios/') . '*.wav')
        );
        foreach ($archivos as $archivo) {
            if (!\unlink($archivo)) {
                Log::error("El archivo '$archivo' no se pudo borrar, esto se intento a las" . date('d-m-Y H:i:s:v') . " \n");
            }
        }
    }
}
