<?php
use Televox\Http\Controllers\Comentarios;
use Televox\Http\Controllers\Dashboard;
use Televox\Http\Controllers\DescargaArchivos;
use Televox\Http\Controllers\EliminarArchivos;
use Televox\Http\Controllers\Grabaciones;
use Televox\Http\Controllers\GraficasLlamadas;
use Televox\Http\Controllers\Login;
use Televox\Http\Controllers\Logs;
use Televox\Http\Controllers\Reportes;
use Televox\Http\Controllers\ReproducirArchivos;
use Televox\Http\Controllers\SpeechRecognition;
use Televox\Http\Controllers\Status;
use Televox\Http\Controllers\Usuarios;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */

Route::redirect('/', config('app.url') . '/login');
Route::prefix('login')->group(function () {
    Route::view('/', "login")->middleware('logged');
    Route::post('entra', [Login::class, "entra"])->middleware('logged');

});
Route::any('logout', [Login::class, "logout"]);
Route::prefix('Grabaciones')->group(function () {
    Route::view('/', "main")->middleware('notlogged');
    Route::post('list', [Grabaciones::class, "getRegistros"])->middleware('notlogged');
    Route::post('getDetails', [Grabaciones::class, "getDetails"])->middleware('notlogged');
    Route::get('downloadReport', [Grabaciones::class, "getReport"])->middleware('notlogged');
});
Route::prefix('Usuarios')->group(function () {
    Route::view('/', "welcome")->middleware('notlogged');
    Route::post('list', [Usuarios::class, "getUsers"])->middleware('notlogged');
    Route::post('retrieve/{id}', [Usuarios::class, "retrieveUser"])->middleware('notlogged');
    Route::post('change', [Usuarios::class, "editUser"])->middleware('notlogged');
    Route::post('create', [Usuarios::class, "createUser"])->middleware('notlogged');
    Route::post('delete/{id}', [Usuarios::class, "deleteUser"])->middleware('notlogged');
});
Route::prefix('status')->group(function () {
    Route::view('/', "welcome")->middleware('notlogged');
    Route::post('list', [Status::class, "list"])->middleware('notlogged');
    Route::post('assoc', [Status::class, "assoc"])->middleware('notlogged');
    Route::post('create', [Status::class, "create"])->middleware('notlogged');
    Route::post('change', [Status::class, "update"])->middleware('notlogged');
    Route::post('select', [Status::class, "getSelect"])->middleware('notlogged');
    Route::post('delete/{id}', [Status::class, "delete"])->middleware('notlogged');
});
Route::prefix('comments')->group(function () {
    Route::view('/', "welcome")->middleware('notlogged');
    Route::post('assoc', [Comentarios::class, "assoc"])->middleware('notlogged');
});
Route::get('/reproduce/{id}', [ReproducirArchivos::class, "reproducir"])->middleware('notlogged');
Route::get('/descarga/{id}', [DescargaArchivos::class, "download"])->middleware('notlogged');
Route::post('/reproduceW', [DescargaArchivos::class, "reproduceW"])->middleware('notlogged');
Route::get('/descargaVarios', [DescargaArchivos::class, "downloadFiles"])->middleware('notlogged');
Route::get('/reporteRepro', [Reportes::class, "downloadListenUsers"])->middleware('notlogged');
Route::get('/getCampaigns', [Dashboard::class, "getCampaignsByClient"])->middleware('notlogged');
Route::post('/getUsers', [Dashboard::class, "getUsersByClient"])->middleware('notlogged');
Route::post('/getStatuses', [Dashboard::class, "getStatusesByClient"])->middleware('notlogged');
Route::post('/getLists', [Dashboard::class, "getListsByClient"])->middleware('notlogged');
Route::post('/eliminar/{id}', [EliminarArchivos::class, "eliminar"])->middleware('notlogged');
Route::post('/eliminarVarios', [EliminarArchivos::class, "eliminarVarios"])->middleware('notlogged');
Route::post('/generaGraficas', [GraficasLlamadas::class, "getRegistros"])->middleware('notlogged');
Route::prefix('logs')->group(function () {
    Route::view('/', "welcome")->middleware('notlogged');
    Route::post('/list', [Logs::class, "getLogs"])->middleware('notlogged');
});
Route::prefix('speech_recognition')->group(function () {
    Route::view('/', "reporte")->middleware('notlogged');
    Route::get('/report', [SpeechRecognition::class, "generateReport"])->middleware('notlogged');
    Route::get('/load', [SpeechRecognition::class, "load"])->middleware('notlogged');
});
