<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">


    <!-- Bootstrap CSS -->

    <link rel="shortcut icon" type="image/png" href="{{ asset('favicon.png') }}">
    <link rel="shortcut icon" href="{{ asset('favicon.png') }}">
    <link href="{{ asset('iconfont/material-icons.css') }}" rel="stylesheet">

    <link href="{{ asset('css/app.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('css/bootstrap.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('css/dark.css') }}" rel="stylesheet" type="text/css">


    <meta charset="utf-8" name="csrf-token" content="{{ csrf_token() }}">

    <link href="{{ asset('css/main.css') }}" rel="stylesheet" type="text/css">

    <title>Televox</title>
</head>

<body class="letraFinal superCentro">
    <div id="app">
        <button class="btn btn-sm superBoton" data-toggle="tooltip" data-placement="top" id="botonMagicoMenu"
            onclick="ocultarMostrar();">
            <i class="material-icons">arrow_drop_up</i>
        </button>

        <div class="cargandoWolfFade" id="fadeLoad"></div>
        <div class="cargandoWolf" id="loadImg"></div>

        <div style="width: 100;text-align: center;" id="menuOcultame">

            <ul class="nav justify-content-center text-white letraFinal"
                style="background-color:rgba(0, 0, 0, 0.87);width: 100;text-align: center;">
                <li class="nav-item ">
                    <a class="nav-link active" href="#">
                        <h1 style="color:white;">TeleV<span style="color:red;">o</span>x</h1>
                    </a>
                </li>
                <ul class="menu cf">
                    <li style="z-index: 10000000;">
                        <a href="#" class="orange"><i class="material-icons">record_voice_over</i>
                            @{{ traducirFrase("Grabaciones") }}
                        </a>
                        <ul class="submenu" style="z-index: 10000000;">
                            <li>
                                <a href="#" onClick="app.showRecords();">
                                    <i class="material-icons">format_list_bulleted</i> @{{ traducirFrase("Listado") }}
                                </a>
                            </li>
                        </ul>
                    </li>
                    @if (Session::get('status'))
                        <li style="z-index: 10000000;">
                            <a href="#" class="green">
                                <i class="material-icons">border_color</i>
                                @{{ traducirFrase("Calificaciones") }}</a>
                            <ul class="submenu" style="z-index: 10000000;">
                                <li>
                                    <a href="#" onClick="app.loadStatus();">
                                        <i class="material-icons">format_list_bulleted</i> @{{ traducirFrase("Listado") }}
                                    </a>
                                </li>
                            </ul>
                        </li>
                    @endif
                    @if (Session::get('log'))
                        <li style="z-index: 10000000;">
                            <a href="#" class="green"><i class="material-icons">format_indent_increase</i>
                                @{{ traducirFrase("Logs") }}</a>
                            <ul class="submenu" style="z-index: 10000000;">
                                <li><a href="#" onClick="app.showLogs();"><i
                                            class="material-icons">format_list_bulleted</i> @{{ traducirFrase("Listado") }}</a>
                                </li>
                            </ul>
                        </li>
                    @endif
                    <li style="z-index: 10000000;">
                        <a class="green">
                            <select id="televox_lang" @change="cambiaridioma"
                                :value="localStorage.getItem('idioma') ? localStorage.getItem('idioma') : 'es'">
                                <option value="en" id="en">@{{ traducirFrase("USA - Ingles") }}</option>
                                <option value="es" id="es">@{{ traducirFrase("MEX - Español") }}</option>
                            </select>
                        </a>
                    </li>
                </ul>
            </ul>

        </div>


        <!--<div class="row" style="margin: 0 auto">
        <div class="menuholder" style="margin: 0 auto">
            <ul class="menu slide" style="text-align: center;">
                <li><a href="#" class="red"><i class="material-icons">account_box</i> Usuarios</a>
                    <div class="subs">
                        <dl>
                            <dd><a href="#" onClick="app.showUsers();"><i class="material-icons">format_list_bulleted</i> Listado</a></dd>
                        </dl>
                    </div>
                </li>
                <li><a href="#" class="orange"><i class="material-icons">record_voice_over</i> Grabaciones</a>
                    <div class="subs">
                        <dl>
                            <dd><a href="#" onClick="app.showRecords();"><i class="material-icons">format_list_bulleted</i> Listado</a></dd>
                        </dl>
                    </div>
                </li>
                <li><a href="#" class="yellow"><i class="material-icons">settings</i> Configuraci&oacute;n</a>
                    <div class="subs">
                        <dl>
                            <dd><a href="#" onClick="app.handleSettings();"><i class="material-icons">remove_red_eye</i> Ver</a></dd>
                        </dl>
                    </div>
                </li>
                <li><a href="#" class="green"><i class="material-icons">format_indent_increase</i> Logs</a>
                    <div class="subs">
                        <dl>
                            <dd><a href="#" onClick="app.showLogs();"><i class="material-icons">format_list_bulleted</i> Listado</a></dd>
                        </dl>
                    </div>
                </li>
            </ul>
            <div class="back"></div>
            <div class="shadow"></div>
        </div>
    </div>-->
        <div class="letraFinal" style="width: 90%; margin-left: 5%;">
            <div class="" id="recordingsTab" style="text-align: center; width: 100%;">

                <div id="showSet" class="row" v-show="showSettings"
                    style="padding-top:0.5%;width: 90%; margin-left: 5%; ">
                    <table class="table table-striped table-sm" style="border: solid 3px #000000;font-size: 11px; ">
                        <tr>
                            <th colspan="8" style="text-align:center;">@{{ traducirFrase("Opciones de búsqueda") }}</th>
                        </tr>
                        <tr>
                            <th style="text-align:center;width:5%;">@{{ traducirFrase("Cuenta") }}:</th>
                            <th style="text-align:center;width:20%;">
                                <input type="text" id="opcionesCuenta" class="form-control">
                            </th>
                            <th style="text-align:center;width:5%;">@{{ traducirFrase("Filtro") }}:</th>
                            <th style="text-align:center;width:20%;" nowrap>
                                <label>
                                    <input type="radio" name="tipoLlam" value='0' checked="checked" />
                                    <span>@{{ traducirFrase("Todas") }}&nbsp;&nbsp;&nbsp;</span>
                                </label>
                                <label>
                                    <input type="radio" value='1' name="tipoLlam" />
                                    <span>@{{ traducirFrase("Entrada") }}&nbsp;&nbsp;&nbsp;</span>
                                </label>
                                <label>
                                    <input type="radio" value="-1" name="tipoLlam" />
                                    <span>@{{ traducirFrase("Salida") }}&nbsp;&nbsp;&nbsp;</span>
                                </label>
                            </th>
                            <th style="text-align:center;width:5%;">@{{ traducirFrase("Calificaciones") }}:</th>
                            <th style="text-align:center;width:20%;">
                                <select id="estadosFiltro" class="form-control form-control-sm">
                                    <option value="0">@{{ traducirFrase("Todos") }}</option>
                                    <option v-for="list in ListaEstatus" :value="list.idStatus">@{{ list.Nombre }}
                                    </option>
                                </select>
                            </th>
                            <th style="text-align:center;width:5%;">.</th>
                            <th style="text-align:center;width:20%;">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" value=""
                                        id="audiosReproducidos">
                                    <label class="form-check-label" for="defaultCheck1">
                                        @{{ traducirFrase("Audios reproducidos") }}
                                    </label>
                                </div>
                            </th>
                        </tr>
                        <tr>
                            <th style="text-align:center;">@{{ traducirFrase("Identificador") }}:</th>
                            <th style="text-align:center;">
                                <input type="text" id="opcionesIdentificador" class="form-control">
                            </th>
                            <th style="text-align:center;">@{{ traducirFrase("Nombre") }}:</th>
                            <th style="text-align:center;">
                                <input type="text" id="opcionesNombre" class="form-control">
                            </th>
                            <th style="text-align:center;">@{{ traducirFrase("Telefono") }}:</th>
                            <th style="text-align:center;">
                                <input type="text" id="opcionesTelefono" class="form-control">
                            </th>
                            <th style="text-align:center;">@{{ traducirFrase("Usuario") }}:</th>
                            <th style="text-align:center;">
                                <select v-model="usuarioActual" class="form-control form-control-sm">
                                    <option value="">@{{ traducirFrase("Cualquier usuario") }}</option>
                                    <option v-for="usuario in usuarios" v-bind:value="usuario.user">
                                        @{{ usuario.full_name }}
                                    </option>
                                </select>
                            </th>
                        </tr>
                        <tr>
                            <th style="text-align:center;">@{{ traducirFrase("Campaña") }}:</th>
                            <th style="text-align:center;">
                                <select v-model="campanaActual" class="form-control form-control-sm">
                                    <option value="">@{{ traducirFrase("Cualquier campaña") }}</option>
                                    <option v-for="campana in campanas" v-bind:value="campana.campaign_id">
                                        @{{ campana.campaign_name }}
                                    </option>
                                </select>
                            </th>
                            <th v-if="campanaActual!==''" style="text-align:center;">@{{ traducirFrase("Lista") }}:</th>
                            <th v-if="campanaActual!==''" style="text-align:center;">
                                <select v-model="listaActual" class="form-control form-control-sm">
                                    <option value="">Cualquier lista</option>
                                    <option v-for="lista in listas" v-bind:value="lista.list_id">
                                        @{{ lista.list_name }}
                                    </option>
                                </select>
                            </th>
                            <th v-if="campanaActual!==''" style="text-align:center;">@{{ traducirFrase("Codigo de calificación") }}:</th>
                            <th v-if="campanaActual!==''" style="text-align:center;">
                                <select v-model="codigoCalificacionActual" class="form-control form-control-sm">
                                    <option value="">@{{ traducirFrase("Cualquier codigo") }}</option>
                                    <option v-for="codigo in codigosCalificacion" v-bind:value="codigo.status">
                                        @{{ codigo.status_name }}
                                    </option>
                                </select>
                            </th>
                        </tr>
                        <tr>
                            <th colspan="4" style="text-align:center;" nowrap>

                                <div class="row">

                                    <div class="col-2">
                                        @{{ traducirFrase("Fecha de") }}:
                                    </div>
                                    <div class="col-4">
                                        <input type="date" id="opcionesFechaInicio" class="form-control"
                                            style="font-size:10px;">
                                    </div>
                                    <div class="col-2">
                                        <select id="opcionesInicioHH" class="form-control form-control-sm">
                                            @for ($i = 0; $i < 25; $i++)
                                                <option value="{{ $i < 10 ? "0$i" : $i }}"> {{ $i }}
                                                </option>
                                            @endfor
                                        </select> HH
                                    </div>
                                    <div class="col-2">
                                        <select id="opcionesInicioMM" class="form-control form-control-sm">
                                            @for ($i = 0; $i < 60; $i++)
                                                <option value="{{ $i < 10 ? "0$i" : $i }}"> {{ $i }}
                                                </option>
                                            @endfor
                                        </select> MM
                                    </div>
                                    <div class="col-2">
                                        <select id="opcionesInicioSS" class="form-control form-control-sm">
                                            @for ($i = 0; $i < 60; $i++)
                                                <option value="{{ $i < 10 ? "0$i" : $i }}"> {{ $i }}
                                                </option>
                                            @endfor
                                        </select> SS
                                    </div>

                                </div>

                            </th>
                            <th colspan="4" style="text-align:center;" nowrap>

                                <div class="row">

                                    <div class="col-2">
                                        @{{ traducirFrase("Fecha hasta") }}:
                                    </div>
                                    <div class="col-4">
                                        <input type="date" id="opcionesFechaFin" class="form-control"
                                            style="font-size:10px;">
                                    </div>
                                    <div class="col-2">
                                        <select id="opcionesFinalHH" class="form-control form-control-sm">
                                            @for ($i = 0; $i < 25; $i++)
                                                <option value="{{ $i < 10 ? "0$i" : $i }}"> {{ $i }}
                                                </option>
                                            @endfor
                                        </select> HH
                                    </div>
                                    <div class="col-2">
                                        <select id="opcionesFinalMM" class="form-control form-control-sm">
                                            @for ($i = 0; $i < 60; $i++)
                                                <option value="{{ $i < 10 ? "0$i" : $i }}"> {{ $i }}
                                                </option>
                                            @endfor
                                        </select> MM
                                    </div>
                                    <div class="col-2">
                                        <select id="opcionesFinalSS" class="form-control form-control-sm">
                                            @for ($i = 0; $i < 60; $i++)
                                                <option value="{{ $i < 10 ? "0$i" : $i }}"> {{ $i }}
                                                </option>
                                            @endfor
                                        </select> SS
                                    </div>

                                </div>

                            </th>
                        </tr>
                        <tr>
                            <th colspan="4" style="text-align:center;" nowrap>

                                <div class="row" style="text-align:center;width: 100%;">

                                    <div class="col-3">
                                        @{{ traducirFrase("Duración de") }} (HH:MM:SS):
                                    </div>
                                    <div class="col-3">
                                        <select id="opcionesDuracionInicialHH" class="form-control form-control-sm">
                                            @for ($i = 0; $i < 25; $i++)
                                                <option value="{{ $i < 10 ? "0$i" : $i }}"> {{ $i }}
                                                </option>
                                            @endfor
                                        </select>
                                    </div>
                                    <div class="col-3">
                                        <select id="opcionesDuracionInicialMM" class="form-control form-control-sm">
                                            @for ($i = 0; $i < 60; $i++)
                                                <option value="{{ $i < 10 ? "0$i" : $i }}"> {{ $i }}
                                                </option>
                                            @endfor
                                        </select>
                                    </div>
                                    <div class="col-3">
                                        <select id="opcionesDuracionInicialSS" class="form-control form-control-sm">
                                            @for ($i = 0; $i < 60; $i++)
                                                <option value="{{ $i < 10 ? "0$i" : $i }}"> {{ $i }}
                                                </option>
                                            @endfor
                                        </select>
                                    </div>

                                </div>
                            </th>
                            <th colspan="4" style="text-align:center;" nowrap>

                                <div class="row" style="text-align:center;width: 100%;">

                                    <div class="col-3">
                                        @{{ traducirFrase("Duración hasta") }} (HH:MM:SS):
                                    </div>
                                    <div class="col-3">
                                        <select id="opcionesDuracionFinalHH" class="form-control form-control-sm">
                                            @for ($i = 0; $i < 25; $i++)
                                                <option value="{{ $i < 10 ? "0$i" : $i }}"> {{ $i }}
                                                </option>
                                            @endfor
                                        </select>
                                    </div>
                                    <div class="col-3">
                                        <select id="opcionesDuracionFinalMM" class="form-control form-control-sm">
                                            @for ($i = 0; $i < 60; $i++)
                                                <option value="{{ $i < 10 ? "0$i" : $i }}"> {{ $i }}
                                                </option>
                                            @endfor
                                        </select>
                                    </div>
                                    <div class="col-3">
                                        <select id="opcionesDuracionFinalSS" class="form-control form-control-sm">
                                            @for ($i = 0; $i < 60; $i++)
                                                <option value="{{ $i < 10 ? "0$i" : $i }}"> {{ $i }}
                                                </option>
                                            @endfor
                                        </select>
                                    </div>

                                </div>
                            </th>
                        </tr>
                        <tr>
                            <th colspan="8" style="text-align:center;" nowrap>
                                <div class="form-check">
                                    <input type="checkbox" id="grabacionesArchivadas" class="form-check-input" />
                                    <label for="grabacionesArchivadas" class="form-check-label">
                                        @{{ traducirFrase("Aplicar sobre las grabaciones archivadas") }}
                                    </label>
                                </div>
                            </th>
                        </tr>
                        <!--<tr>
                        <th colspan="4" style="text-align:center;" nowrap>

                            <div class="row" style="text-align:center;width: 100%;">

                                <div class="col-4">
                                    Estados:
                                </div>
                                <div class="col-8">
                                    <select id="estadosFiltro" class="form-control form-control-sm">
                                        <option value="0">Todos</option>
                                        <option v-for="list in ListaEstatus"
                                                :value="list.idStatus">@{{ list.Nombre }} </option>
                                    </select>
                                </div>


                            </div>
                        </th>

                        <th colspan="4" style="text-align:center;" nowrap>

                            <div class="row" style="text-align:center;width: 100%;">

                                <div class="col-12">
                                    <div class="form-check">
                                      <input class="form-check-input" type="checkbox" value="" id="audiosReproducidos">
                                      <label class="form-check-label" for="defaultCheck1">
                                        Audios reproducidos
                                      </label>
                                    </div>
                                </div>



                            </div>
                        </th>

                    </tr>-->
                        <tr>
                            <th colspan="8" style="text-align:center;">
                                <a class="btn btn-primary" href="#" role="button"
                                    onClick="app.pagina = 1;app.loadParams();app.loadEntries();">@{{ traducirFrase("Buscar") }}
                                    <i class="material-icons">search</i></a>
                                @if (Session::get('descargar'))
                                    <a class="btn btn-success" href="#" role="button"
                                        v-on:click="descargaArchivos()">@{{ traducirFrase("Descarga") }}r <i
                                            class="material-icons">file_download</i></a>
                                @endif
                                @if (Session::get('eliminar'))
                                    <a class="btn btn-danger" href="#" role="button"
                                        v-on:click="borraArchivos()">@{{ traducirFrase("Eliminar grabaciones permanentemente") }} <i
                                            class="material-icons">delete_forever</i></a>
                                @endif
                                <button type="button" v-on:click="loadGraph" class="btn btn-primary"
                                    data-toggle="modal" data-target="#modal-grafica">
                                    @{{ traducirFrase("Grafica de llamadas calificadas") }} <i class="material-icons">pie_chart</i>
                                </button>
                                <a class="btn btn-info" href="#" role="button"
                                    v-on:click="descargaReporte()">@{{ traducirFrase("Descargar reporte") }} <i
                                        class="material-icons">donut_small</i></a>
                            </th>
                        </tr>
                    </table>
                </div>

                <div class="row" id="tab1" style="width: 90%; padding-left: 0%; margin-left: 5%;">


                    <div class="col-12">
                        <table class="table table-striped table-sm"
                            style=" font-size: 11px;border: solid 3px #000000; text-align: center; ">
                            <thead class="thead-dark">
                                <tr>
                                    <th v-for="(t,key) in Titulos" v-if="key<8">@{{ traducirFrase(t) }}</th>
                                    <th>@{{ traducirFrase(Titulos[8]) }}</th>
                                    <th>@{{ traducirFrase(Titulos[10]) }}</th>
                                    <th style="text-align:center;"><a class="btn btn-primary" href="#"
                                            role="button" onClick="app.handleSettings();">@{{ traducirFrase("Filtros") }}</a>
                                    </th>
                                </tr>
                            </thead>

                            <tbody>
                                <tr v-for="r in Registros" v-bind:style="'background-color : #'+r.ColorStatus"
                                    v-bind:id="'table'+r.GRAB_ID">
                                    <td nowrap v-for="(i,key,index) in r" v-if="index<8">@{{ i }}</td>
                                    <td nowrap v-if="r.NombreStatus==null">@{{ traducirFrase("Sin calificar") }}</td>
                                    <td nowrap v-else>@{{ r.NombreStatus }}</td>
                                    <td nowrap v-if="r.listened==-1"><i class="material-icons">cancel</i></td>
                                    <td nowrap v-else><i class="material-icons">done</i></td>
                                    <td nowrap>
                                        @if (Session::get('descargar'))
                                            <a download class="btn btn-sm btn-primary"
                                                v-bind:href="RUTA_MAESTRA+'/descarga/'+r.Nombre+'?archive='+params.archive"
                                                role="button" :title="traducirFrase('Descarga')"
                                                style="border: solid 3px #000000;">
                                                <i class="material-icons">archive</i>
                                            </a>
                                        @endif
                                        @if (Session::get('reproducir'))
                                            <button type="button" class="btn btn-sm btn-success" data-toggle="modal"
                                                style="border: solid 3px #000000;" data-target="#modalPlayer"
                                                v-on:click="reproduce(r.Nombre)" :title="traducirFrase('Reproducir')">
                                                <i class="material-icons">ondemand_video</i>
                                            </button>
                                        @endif
                                        @if (env('AI_ENABLED', false))
                                            <button type="button" class="btn btn-sm btn-success"
                                                style="border: solid 3px #000000;" v-on:click="showAI(r.Nombre)"
                                                :title="traducirFrase('Speech Analitics')">
                                                <i class="material-icons">psychology</i>
                                            </button>
                                        @endif
                                        @if (Session::get('comentar') && Session::get('status'))
                                            <button class="btn btn-sm btn-success"
                                                v-on:click="abrecalificaMod( r.GRAB_ID );" data-toggle="tooltip"
                                                data-placement="top" style="border: solid 3px #000000;"
                                                :title="traducirFrase('Editar estatus')">
                                                <i class="material-icons">check</i>
                                            </button>
                                        @endif
                                        @if (Session::get('eliminar'))
                                            <button class="btn btn-sm btn-danger" data-toggle="tooltip"
                                                data-placement="top" v-on:click="deleteGrabs( r.Nombre );"
                                                style="border: solid 3px #000000;"
                                                :title="traducirFrase('Eliminar grabación')">
                                                <i class="material-icons">delete</i>
                                            </button>
                                        @endif
                                    </td>

                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <nav aria-label="Page navigation example">
                        <ul class="pagination">
                            <li class="page-item">
                                <a class="page-link" onClick="cambiaPagGrab(0);" href="#">
                                    @{{ traducirFrase("Primera") }}
                                </a>
                            </li>
                            <li class="page-item">
                                <a class="page-link" onClick="cambiaPagGrab(1);" href="#">

                                    <i class="material-icons">
                                        chevron_left
                                    </i>
                                </a>
                            </li>
                            <li class="page-item">
                                <a class="page-link" onClick="cambiaPagGrab(1);" href="#">
                                    <span id="paginaGrabAct0">-</span>
                                </a>
                            </li>
                            <li class="page-item" style="border: solid 3px #000000;">
                                <a class="page-link" href="#"><span id="paginaGrabAct">1</span></a>
                            </li>
                            <li class="page-item">
                                <a class="page-link" onClick="cambiaPagGrab(2);" href="#"><span
                                        id="paginaGrabAct2">-</span>
                                </a>
                            </li>
                            <li class="page-item">
                                <a class="page-link" onClick="cambiaPagGrab(2);" href="#">
                                    <i class="material-icons">
                                        chevron_right
                                    </i>
                                </a>
                            </li>
                        </ul>
                    </nav>

                    <!--<center>
                  <ul class="pagination">
                    <li class="disabled"><a href="#!"><i class="material-icons">chevron_left</i></a></li>
                    <li class="active"><a href="#!">1</a></li>
                    <li class="waves-effect"><a href="#!">2</a></li>
                    <li class="waves-effect"><a href="#!">3</a></li>
                    <li class="waves-effect"><a href="#!">4</a></li>
                    <li class="waves-effect"><a href="#!">5</a></li>
                    <li class="waves-effect"><a href="#!"><i class="material-icons">chevron_right</i></a></li>
                  </ul>
                </center>-->

                </div>

                <div class="" id="tabEst" style="display:none;">

                    <div class="row">
                        <div class="col-12">
                            <table class="table table-striped table-sm" style="border: solid 3px #000000; ">
                                <thead class="thead-dark">
                                    <tr>
                                        <th style="text-align:center;width:25%;"> @{{ traducirFrase("Id") }} </th>
                                        <th style="text-align:center;width:50%;"> @{{ traducirFrase("Nombre") }} </th>
                                        <th style="text-align:center;width:25%;">
                                            @{{ traducirFrase("Acciones") }}
                                        </th>
                                    </tr>
                                </thead>

                                <tbody>
                                    <tr v-for="r in Estatus">
                                        <td style="text-align:center;width:25%;">@{{ r.idStatus }}</td>
                                        <td style="text-align:center;width:50%;">@{{ r.Nombre }}</td>
                                        <td nowrap style="text-align:center;width:25%;">
                                            <button class="btn btn-sm btn-success"
                                                v-on:click="abreEditaMod( r.idStatus ,  r.Nombre ,r.Color);"
                                                data-toggle="tooltip" data-placement="top" title="Editar estatus">
                                                <i class="material-icons">mode_edit</i>
                                            </button>
                                            <button class="btn btn-sm btn-danger" data-toggle="tooltip"
                                                data-placement="top" v-on:click="app.deleteStatus( r.idStatus );"
                                                style="border: solid 3px #000000;" title="Eliminar estatus">
                                                <i class="material-icons">delete</i>
                                            </button>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="row">

                        <div class="col-4">

                            <nav aria-label="Page navigation example">
                                <ul class="pagination">
                                    <li class="page-item"><a class="page-link" onClick="cambiaPagEst(0);"
                                            href="#">@{{ traducirFrase("Primera") }}</a></li>
                                    <li class="page-item"><a class="page-link" onClick="cambiaPagEst(1);"
                                            href="#">
                                            << /a>
                                    </li>
                                    <li class="page-item"><a class="page-link" onClick="cambiaPagEst(1);"
                                            href="#"><span id="paginaEstAct0">-</span></a></li>
                                    <li class="page-item" style="border: solid 3px #000000;"><a class="page-link"
                                            href="#"><span id="paginaEstAct">1</span></a></li>
                                    <li class="page-item"><a class="page-link" onClick="cambiaPagEst(2);"
                                            href="#"><span id="paginaEstAct2">-</span></a></li>
                                    <li class="page-item"><a class="page-link" onClick="cambiaPagEst(2);"
                                            href="#">></a></li>
                                    <li class="page-item"><a class="page-link" onClick="cambiaPagEst(3);"
                                            href="#">@{{ traducirFrase("Ultima") }}</a></li>
                                </ul>
                            </nav>

                        </div>

                        <div class="col-4" style="text-align: center;">

                            <button class="btn btn-sm btn-primary" data-toggle="modal"
                                data-target="#modalStatusCreate" title="Nuevo estatus">
                                <!--<i class="material-icons">add</i>-->@{{ traducirFrase("Crear nuevo estatus de calificación") }}
                            </button>

                        </div>



                        <div class="col-4"></div>

                    </div>

                    <!--<center>
                  <ul class="pagination">
                    <li class="disabled"><a href="#!"><i class="material-icons">chevron_left</i></a></li>
                    <li class="active"><a href="#!">1</a></li>
                    <li class="waves-effect"><a href="#!">2</a></li>
                    <li class="waves-effect"><a href="#!">3</a></li>
                    <li class="waves-effect"><a href="#!">4</a></li>
                    <li class="waves-effect"><a href="#!">5</a></li>
                    <li class="waves-effect"><a href="#!"><i class="material-icons">chevron_right</i></a></li>
                  </ul>
                </center>-->

                </div>

                <div class="" id="tab2" style="width: 90%; margin-left: 5%;">
                    <div class="row centerWolf">

                        <div class="row"
                            style="border: solid 3px #000000;font-size:15px; width:100%; padding-top:0.5%;
                    padding-bottom:0.5%; margin-top: 0.5%;margin-bottom: 0.5%;">
                            <div class="col-2"></div>
                            <div class="col-2">
                                @{{ traducirFrase("Fecha de") }}:
                            </div>
                            <div class="col-4">
                                <input type="date" id="fechaLogW" class="form-control" style="font-size:9px;">
                            </div>
                            <div class="col-2">
                                <a class="btn btn-primary" href="#" role="button"
                                    onClick="paginaLogs = 1;app.loadLogs();">@{{ traducirFrase("Buscar") }}</a>
                            </div>
                            <div class="col-2"></div>
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-12">
                            <table class="table table-striped table-sm" style="border: solid 3px #000000; ">
                                <thead class="thead-dark">
                                    <tr>
                                        <th style="text-align:center;width:10%;"> @{{ traducirFrase("Id") }} </th>
                                        <th style="text-align:center;width:50%;"> @{{ traducirFrase("Detalle") }} </th>
                                        <th style="text-align:center;width:10%;"> @{{ traducirFrase("Fecha") }} </th>
                                        <th style="text-align:center;width:10%;"> @{{ traducirFrase("Hora") }} </th>
                                        <th style="text-align:center;width:10%;"> @{{ traducirFrase("Direccion IP") }} </th>
                                        <th style="text-align:center;width:10%;"> @{{ traducirFrase("Tipo") }} </th>
                                        <th style="text-align:center;width:10%;"> @{{ traducirFrase("Usuario") }} </th>
                                    </tr>
                                </thead>

                                <tbody>
                                    <tr v-for="r in Logs">
                                        <td style="text-align:center;">@{{ r.id }}</td>
                                        <td style="text-align:center;">@{{ r.detalle }}</td>
                                        <td style="text-align:center;">@{{ r.fecha }}</td>
                                        <td style="text-align:center;">@{{ r.hora }}</td>
                                        <td style="text-align:center;">@{{ r.ip }}</td>
                                        <td style="text-align:center;">@{{ getNombreTipo(r.tipo) }}</td>
                                        <td style="text-align:center;">@{{ r.usuario }}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="row">

                        <nav aria-label="">
                            <ul class="pagination">
                                <li class="page-item"><a class="page-link" onClick="cambiaPagLogs(0);"
                                        href="#">@{{ traducirFrase("Primera") }}</a></li>
                                <li class="page-item"><a class="page-link" onClick="cambiaPagLogs(1);"
                                        href="#">
                                        << /a>
                                </li>
                                <li class="page-item"><a class="page-link" onClick="cambiaPagLogs(1);"
                                        href="#"><span id="paginaLogsAct0">-</span></a></li>
                                <li class="page-item" style="border: solid 3px #000000;"><a class="page-link"
                                        href="#"><span id="paginaLogsAct">1</span></a></li>
                                <li class="page-item"><a class="page-link" onClick="cambiaPagLogs(2);"
                                        href="#"><span id="paginaLogsAct2">-</span></a></li>
                                <li class="page-item"><a class="page-link" onClick="cambiaPagLogs(2);"
                                        href="#">></a></li>
                                <li class="page-item"><a class="page-link" onClick="cambiaPagLogs(3);"
                                        href="#">@{{ traducirFrase("Ultima") }}</a></li>
                            </ul>
                        </nav>

                    </div>
                </div>
            </div>

            <!-- acaba -->

            <div class="row" id="tab3">
                <div class="col-12">
                    <div class="container">
                        <div class="">
                            <div class="row centerWolf">

                                <h1>@{{ traducirFrase("Usuarios") }}</h1>

                            </div><br>
                            <div class="row">
                                <div class="col-8 offset-sm-2">
                                    <table class="table table-striped"
                                        style="border: solid 3px #000000; font-size: 8px;">
                                        <thead class="thead-dark">
                                            <tr>
                                                <th>@{{ traducirFrase("Usuario") }}</th>
                                                <th colspan="">@{{ traducirFrase("Acciones") }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr v-for="u in Usuarios">
                                                <td>@{{ atob(atob(u.usuario)) }}</td>
                                                <td>
                                                    <button class="btn btn-sm btn-success editar"
                                                        data-toggle="tooltip" data-placement="top"
                                                        style="border: solid 3px #000000; " title="Editar">
                                                        <i class="material-icons">mode_edit</i>
                                                    </button>
                                                    <button class="btn btn-sm btn-danger borrar" data-toggle="tooltip"
                                                        data-placement="top" style="border: solid 3px #000000; "
                                                        title="Eliminar">
                                                        <i class="material-icons">delete</i>
                                                    </button>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>

                            </div>

                        </div>
                    </div>
                </div>

                <div class="modal" tabindex="-1" role="dialog" id="modalModUsers">
                    <div class="modal-dialog modal-dialog-centered" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">@{{ traducirFrase("Modificar Usuario") }}</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-6"><label class="active">@{{ traducirFrase("Usuario") }}</label><input
                                            type="text"></div>
                                    <div class="col-6"><label class="active">@{{ traducirFrase("Contraseña") }}</label><input
                                            type="password"></div>
                                </div>
                                <div class="col-2">
                                    <label class="active"></label>
                                    <select class="browser-default" name="">
                                        <option value="">@{{ traducirFrase("Permitir") }}</option>
                                        <option value="">@{{ traducirFrase("Prohibir") }}</option>
                                    </select>
                                </div>
                                <div class="col-2">
                                    <label class="active"></label>
                                    <select class="browser-default" name="">
                                        <option value="">@{{ traducirFrase("Permitir") }}</option>
                                        <option value="">@{{ traducirFrase("Prohibir") }}</option>
                                    </select>
                                </div>
                                <div class="col-2">
                                    <label class="active"></label>
                                    <select class="browser-default" name="">
                                        <option value="">@{{ traducirFrase("Permitir") }}</option>
                                        <option value="">@{{ traducirFrase("Prohibir") }}</option>
                                    </select>
                                </div>
                                <div class="col-2">
                                    <label class="active"></label>
                                    <select class="browser-default" name="">
                                        <option value="">@{{ traducirFrase("Permitir") }}</option>
                                        <option value="">@{{ traducirFrase("Prohibir") }}</option>
                                    </select>
                                </div>
                                <div class="col-2">
                                    <label class="active"></label>
                                    <select class="browser-default" name="">
                                        <option value="">@{{ traducirFrase("Permitir") }}</option>
                                        <option value="">@{{ traducirFrase("Prohibir") }}</option>
                                    </select>
                                </div>
                                <div class="col-2">
                                    <label class="active"></label>
                                    <select class="browser-default" name="">
                                        <option value="">@{{ traducirFrase("Permitir") }}</option>
                                        <option value="">@{{ traducirFrase("Prohibir") }}</option>
                                    </select>
                                </div>
                                <div class="col-2">
                                    <label class="active"></label>
                                    <select class="browser-default" name="">
                                        <option value="">@{{ traducirFrase("Permitir") }}</option>
                                        <option value="">@{{ traducirFrase("Prohibir") }}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary"
                                    data-dismiss="modal">@{{ traducirFrase("Cancelar") }}</button>
                                <button type="button" class="btn btn-primary">@{{ traducirFrase("Guardar") }}</button>
                            </div>
                        </div>
                    </div>
                </div>


                <!--<div id="modalModUsers" class="modal" style="height:60vh;">
                <div class="modal-content">
                    <h4>Modificar Usuario</h4>
                    <div class="row">
                      <div class="col s6"><label class="active">Usuario</label><input type="text"></div>
                     <div class="col s6"><label class="active">Contraseña</label><input type="password"></div>
                    </div>
                    <div class="col s2">
                      <label class="active"></label>
                      <select class="browser-default" name="">
                        <option value="">Permitir</option>
                        <option value="">Prohibir</option>
                      </select>
                    </div>
                    <div class="col s2">
                      <label class="active"></label>
                      <select class="browser-default" name="">
                        <option value="">Permitir</option>
                        <option value="">Prohibir</option>
                      </select>
                    </div>
                    <div class="col s2">
                      <label class="active"></label>
                      <select class="browser-default" name="">
                        <option value="">Permitir</option>
                        <option value="">Prohibir</option>
                      </select>
                    </div>
                    <div class="col s2">
                      <label class="active"></label>
                      <select class="browser-default" name="">
                        <option value="">Permitir</option>
                        <option value="">Prohibir</option>
                      </select>
                    </div>
                    <div class="col s2">
                      <label class="active"></label>
                      <select class="browser-default" name="">
                        <option value="">Permitir</option>
                        <option value="">Prohibir</option>
                      </select>
                    </div>
                    <div class="col s2">
                      <label class="active"></label>
                      <select class="browser-default" name="">
                        <option value="">Permitir</option>
                        <option value="">Prohibir</option>
                      </select>
                    </div>
                    <div class="col s2">
                      <label class="active"></label>
                      <select class="browser-default" name="">
                        <option value="">Permitir</option>
                        <option value="">Prohibir</option>
                      </select>
                    </div>
                    <br><br>
                </div>
                <div class="modal-footer">
                  <a href="#!" class="modal-close waves-effect waves-green btn-flat">Guardar</a>
                    <a href="#!" class="modal-close waves-effect waves-green btn-flat">Cancelar</a>
                </div>
            </div>-->

            </div>

            <div class="row" id="IATab">
                <div class="col-12">
                    <div class="container">
                        <div class="">
                            <div class="row centerWolf">

                                <h1>@{{ traducirFrase("Speech Analitics") }}</h1>

                            </div><br>
                            <div class="row">
                                <div class="col-8 offset-sm-2">
                                    <table class="table table-striped"
                                        style="border: solid 3px #000000; font-size: 8px;">
                                        <thead class="thead-light">
                                            <tr>
                                                <th>
                                                    @{{ traducirFrase("Grabacion") }}</th>
                                                <th>
                                                    @{{ tiempoActual2 }}/@{{ tiempoTotal2 }}
                                                    <div id="waveform2"></div>
                                                    <button class="btn btn-sm btn-info" v-on:click="PlayPause2()">
                                                        <i class="material-icons" id="playpause2"></i>
                                                    </button>
                                                    <button class="btn btn-sm btn-danger" v-on:click="stop2()">
                                                        <i class="material-icons">stop</i>
                                                    </button>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    Transcipcion
                                                </td>
                                                <td>
                                                    <span
                                                        style="white-space: pre-line;">@{{ (IARegistro.Transcripcion ?? "").trim() }}</span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    Resumen
                                                </td>
                                                <td>
                                                    @{{ IARegistro.Resumen }}
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    Sentimiento
                                                </td>
                                                <td>
                                                    @{{ IARegistro.Sentimiento }}
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    Magnitud
                                                </td>
                                                <td>
                                                    @{{ IARegistro.Magnitud }}
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    Oraciones
                                                </td>
                                                <td>
                                                    <ul v-html="ordenaOraciones"></ul>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    Problemas clave y soluciones
                                                </td>
                                                <td>
                                                    <ul v-html="ordenaProblemasClave"></ul>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>

                            </div>

                        </div>
                    </div>
                </div>
            </div>

            <!--<div id="modalPlayer" class="modal grey">
          <div class="modal-content">
          <div id="waveform"></div>
          </div>
          <div class="modal-footer">
            <a href="#!" class="modal-close waves-effect waves-green btn-flat">Agree</a>
          </div>
        </div>-->

            <div class="modal" tabindex="-1" role="dialog" id="modalPlayer">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">@{{ traducirFrase("Reproduccion de Grabación") }}</h5>
                        </div>
                        <div class="modal-body">
                            @{{ tiempoActual }}/@{{ tiempoTotal }}
                            <div id="waveform"></div>
                            <button class="btn btn-sm btn-info" v-on:click="PlayPause()"><i class="material-icons"
                                    id="playpause"></i></button>
                            <button class="btn btn-sm btn-danger" v-on:click="stop()"><i
                                    class="material-icons">stop</i></button>
                        </div>
                        <div class="modal-footer">
                            <button type="button" v-on:click="limpiar()" class="btn btn-secondary"
                                data-dismiss="modal">@{{ traducirFrase("Cerrar") }}</button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="modal" tabindex="-1" role="dialog" id="modalStatusCreate">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">@{{ traducirFrase("Crear estatus de calificación") }}</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <label for="nombreCreaEst">@{{ traducirFrase("Nombre del estatus de calificación") }}</label>
                                <input type="text" class="form-control" id="nombreCreaEst">
                            </div>
                            <div class="form-group">
                                <label for="colorpickerHolder">
                                    @{{ traducirFrase("Color de la calificaión") }}
                                </label>
                                <input id="colorCrea" class="jscolor">
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-primary"
                                onClick="app.createStatus();">@{{ traducirFrase("Guardar") }}</button>
                            <button type="button" class="btn btn-secondary"
                                data-dismiss="modal">@{{ traducirFrase("Cerrar") }}</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal" tabindex="-1" role="dialog" id="modalStatusEdita">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">@{{ traducirFrase("Editar estatus de calificación") }}</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <label for="nombreEditaEst">@{{ traducirFrase("Nombre del estatus de calificación") }}</label>
                                <input type="text" class="form-control" id="nombreEditaEst">
                            </div>
                            <div class="form-group">
                                <label for="colorpickerHolder">
                                    @{{ traducirFrase("Color de la calificación") }}
                                </label>
                                <input id="colorEdi" class="jscolor">
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-primary"
                                onClick="app.changeStatus();">@{{ traducirFrase("Guardar") }}</button>
                            <button type="button" class="btn btn-secondary"
                                data-dismiss="modal">@{{ traducirFrase("Cerrar") }}</button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="modal" tabindex="-1" role="dialog" id="modalStatusCalifica">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">@{{ traducirFrase("Califica grabación") }}: <span id="titGrabCal"></span> </h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <!--<div class="form-group">
                  <label for="nombreEditaEst">Calificaci&oacute;n</label>
                  <select class="form-control" id="estadoCalifId">
                      <option v-for="list in ListaEstatus"
                                :value="list.idStatus">@{{ list.Nombre }} </option>
                  </select>
                </div>-->

                            <div class="row">

                                <div v-for="list in ListaEstatus" class="divSelB col-4">
                                    <input type="radio" name="radio" v-bind:id="'radio'+list.idStatus"
                                        v-bind:value="list.idStatus" class="radio" />
                                    <label class="labelEsp"
                                        v-bind:for="'radio'+list.idStatus">@{{ list.Nombre }}</label>
                                </div>

                            </div>
                            <div class="row">

                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="comentarioCalifica">@{{ traducirFrase("Comentario") }}</label>
                                        <textarea class="form-control" id="comentarioCalifica" rows="2"></textarea>
                                    </div>
                                </div>



                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-primary"
                                onClick="app.calificaGrabStat();">@{{ traducirFrase("Guardar") }}</button>
                            <button type="button" class="btn btn-secondary"
                                data-dismiss="modal">@{{ traducirFrase("Cerrar") }}</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Ventana modal de la grafica de las llamadas -->
        <div class="modal fade" id="modal-grafica" data-backdrop="static" data-keyboard="false" tabindex="-1"
            role="dialog" aria-labelledby="modal-graficas-etiqueta" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modal-graficas-etiqueta">@{{ traducirFrase("Llamadas calificadas") }}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <canvas id="chart-llamadas" width="400" height="400"></canvas>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                            data-dismiss="modal">@{{ traducirFrase("Cerrar") }}</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="{{ asset('js/vue.js') }}"></script>
    <script src="{{ asset('js/vue-paginate.js') }}"></script>
    <script src="{{ asset('js/wavesurfer.js') }}"></script>
    <script src="{{ asset('js/jquery.js') }}"></script>
    <script src="{{ asset('js/popper.js') }}"></script>
    <script src="{{ asset('js/bootstrap.js') }}"></script>
    <script src="{{ asset('js/sweetalert2@9.js') }}"></script>
    <script type="text/javascript">
        const RUTA_MAESTRA = "{{ config('app.url') }}";
    </script>
    <script src="{{ asset('js/gettext.js') }}"></script>
    <script src="{{ asset('js/traduccion.js') }}"></script>
    <script>
        seleccionarIdioma(localStorage.getItem("idioma") ? localStorage.getItem("idioma") : "es")
    </script>
    <script src="{{ asset('js/codigoMaestro.js') }}"></script>

    <script type="text/javascript" src="{{ asset('js/jscolor.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/Chart.bundle.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/Chart.min.js') }}"></script>
</body>

</html>
