let actualTab = 1;
let idEstatusEdita = 0;
let idGrabCal = 0;
let configActive = 0;
let paginaActivaGrabaciones = 1;
let paginaActivaEstados = 1;
let grafica;

function abreEditaMod(id, estatus, color) {
    idEstatusEdita = id;

    $("#nombreEditaEst").val(estatus);
    $("#colorEdi").val(color)
    $("#modalStatusEdita").modal({
        keyboard: false,
        backdrop: 'static'
    });
}

function abrecalificaMod(id) {
    idGrabCal = id;
    $("#titGrabCal").html(id);
    $("#modalStatusCalifica").modal({
        keyboard: false,
        backdrop: 'static'
    });

}

function cambiaPagGrab(acc) {
    let accE = parseInt(acc);
    switch (accE) {
        case 1:
            //retrocede
            if (app.pagina == 1) {
                return false;
            } else {
                app.pagina--;
                app.params.pagina = app.pagina;
                app.loadEntries();
            }
            break;
        case 2:
            //avanza
            if (app.maxPagGrab <= app.pagina) {
                return false;
            }
            app.pagina++;
            app.params.pagina = app.pagina;
            app.loadEntries();
            break;

        case 0:
            //retrocede por completo
            app.pagina = 1;
            app.params.pagina = app.pagina;
            app.loadEntries();
            break;
        case 3:
            //avanza por completo
            app.pagina = app.maxPagGrab;
            app.params.pagina = app.pagina;
            app.loadEntries();
            break;
    }

    if (app.pagina > 1) {
        $("#paginaGrabAct0").html(app.pagina - 1);
    } else {
        $("#paginaGrabAct0").html('-');
    }

    $("#paginaGrabAct").html(app.pagina);

    if (app.pagina != app.maxPagGrab && app.maxPagGrab != 0) {
        $("#paginaGrabAct2").html(app.pagina + 1);
    } else {
        $("#paginaGrabAct2").html('-');
    }

}

function cambiaPagEst(acc) {

    let accE = parseInt(acc);
    switch (accE) {
        case 1:
            //retrocede
            if (app.paginaEst == 1) {
                return false;
            } else {
                app.paginaEst--;
                app.loadStatus();
            }
            break;
        case 2:
            //avanza
            if (app.maxPagEst <= app.paginaEst) {
                return false;
            }
            app.paginaEst++;
            app.loadStatus();
            break;
        case 0:
            //retrocede al inicio
            app.paginaEst = 1;
            app.loadStatus();
            break;
        case 3:
            //avanza al final
            app.paginaEst = app.maxPagEst;
            app.loadStatus();
            break;

    }

    if (app.paginaEst > 1) {
        $("#paginaEstAct0").html(app.paginaEst - 1);
    } else {
        $("#paginaEstAct0").html('-');
    }
    $("#paginaEstAct").html(app.paginaEst);
    if (app.paginaEst != app.maxPagEst && app.maxPagEst != 0) {
        $("#paginaEstAct2").html(app.paginaEst + 1);
    } else {
        $("#paginaEstAct2").html('-');
    }
}

function cambiaPagLogs(acc) {
    let accE = parseInt(acc);
    switch (accE) {
        case 1:
            //retrocede
            if (app.paginaLogs == 1) {
                return false;
            } else {
                app.paginaLogs--;
                app.loadLogs();
            }
            break;
        case 2:
            //avanza
            if (app.maxPagLogs <= app.paginaLogs) {
                return false;
            }
            app.paginaLogs++;
            app.loadLogs();
            break;
        case 0:
            //retrocede por completo
            app.paginaLogs = 1;
            app.loadLogs();
            break;
        case 3:
            //avanza por completo
            app.paginaLogs = app.maxPagLogs;
            app.loadLogs();
            break;
    }
    if (app.paginaLogs > 1) {
        $("#paginaLogsAct0").html(app.paginaLogs - 1);
    } else {
        $("#paginaLogsAct0").html('-');
    }

    $("#paginaLogsAct").html(app.paginaLogs);

    if (app.paginaLogs != app.maxPagLogs && app.maxPagLogs != 0) {
        $("#paginaLogsAct2").html(app.paginaLogs + 1);
    } else {
        $("#paginaLogsAct2").html('-');
    }

}
let ocultaMenu = 1;
function ocultarMostrar() {
    if (ocultaMenu == 2) {
        $("#menuOcultame").show("slow");
        $("#botonMagicoMenu").html('<i class="material-icons">arrow_drop_up</i>');
        ocultaMenu = 1;
    } else {
        $("#menuOcultame").hide("slow");
        $("#botonMagicoMenu").html('<i class="material-icons">arrow_drop_down</i>');
        ocultaMenu = 2;
    }
}

function actualizaPagGrabs() {
    if (app.pagina > 1) {
        $("#paginaGrabAct0").html(app.pagina - 1);
    } else {
        $("#paginaGrabAct0").html('-');
    }

    $("#paginaGrabAct").html(app.pagina);

    if (app.pagina != app.maxPagGrab && app.maxPagGrab != 0) {
        $("#paginaGrabAct2").html(app.pagina + 1);
    } else {
        $("#paginaGrabAct2").html('-');
    }

}

function hexToRgbA(hex) {
    if (/^#([A-Fa-f0-9]{3}){1,2}$/.test(hex)) {
        let c = hex.substring(1).split('');
        if (c.length == 3) {
            c = [c[0], c[0], c[1], c[1], c[2], c[2]];
        }
        c = '0x' + c.join('');
        return 'rgba(' + [(c >> 16) & 255, (c >> 8) & 255, c & 255].join(',') + ',1)';
    }
    throw new Error('Bad Hex');
}

function getRandomColor() {
    let letters = '0123456789ABCDEF';
    let color = '#';
    for (let i = 0; i < 6; i++) {
        color += letters[Math.floor(Math.random() * 16)];
    }
    return hexToRgbA(color);
}

function actualizaPagEst() {
    if (app.paginaEst > 1) {
        $("#paginaEstAct0").html(app.paginaEst - 1);
    } else {
        $("#paginaEstAct0").html('-');
    }

    $("#paginaEstAct").html(app.paginaEst);

    if (app.paginaEst != app.maxPagEst && app.maxPagEst != 0) {
        $("#paginaEstAct2").html(app.paginaEst + 1);
    } else {
        $("#paginaEstAct2").html('-');
    }

}

function actualizaPagLogs() {
    if (app.paginaLogs > 1) {
        $("#paginaLogsAct0").html(app.paginaLogs - 1);
    } else {
        $("#paginaLogsAct0").html('-');
    }

    $("#paginaLogsAct").html(app.paginaLogs);

    if (app.paginaLogs != app.maxPagLogs && app.maxPagLogs != 0) {
        $("#paginaLogsAct2").html(app.paginaLogs + 1);
    } else {
        $("#paginaLogsAct2").html('-');
    }

}

let app = new Vue({
    el: '#app',
    data: {
        showSettings: false,
        Registros: [],
        Estatus: [],
        Logs: [],
        Titulos: [],
        ListaEstatus: [],
        params: {},
        Usuarios: [],
        pagina: 1,
        maxPagGrab: 0,
        paginaEst: 1,
        maxPagEst: 0,
        paginaLogs: 1,
        maxPagLogs: 0,
        id: '',
        wavesurfer: null,
        wavesurfer2: null,
        tiempoActual: "00:00:00",
        tiempoTotal: "00:00:00",
        tiempoActual2: "00:00:00",
        tiempoTotal2: "00:00:00",
        campanas: [],
        usuarios: [],
        listas: [],
        codigosCalificacion: [],
        campanaActual: "",
        usuarioActual: "",
        listaActual: "",
        codigoCalificacionActual: "",
        IARegistro: {
            Oraciones: [],
            Problemas: []
        }
    },
    watch: {
        campanaActual: function (val) {
            if (val !== "") {
                app.cargaCodigos();
                app.cargaListas();
            }
        }
    },
    computed: {
        ordenaOraciones: function () {
            const Oraciones = this.IARegistro.Oraciones || []
            const oraciones_ordenadas = Oraciones.sort((a, b) => a.Orden - b.Orden)

            let cadena = `<ol type="1">`;
            for (const oracion of oraciones_ordenadas) {
                cadena = cadena.concat(`<li>
                                            <ul>
                                                <li> Oracion: <b>${oracion.Oracion}</b> </li>
                                                <li> Sentimiento: <b>${oracion.Sentimiento}</b> </li>
                                                <li> Magnitud: <b>${oracion.Magnitud}</b> </li>
                                            </ul>
                                        </li>
                `)
            }

            cadena = cadena.concat(`</ol>`)
            return cadena;
        },

        ordenaProblemasClave: function () {
            const Problemas = this.IARegistro.Problemas || []
            const problemas_ordenados = Problemas.sort((a, b) => a.Orden - b.Orden)

            let cadena = `<ol type="1">`;
            for (const oracion of problemas_ordenados) {
                cadena = cadena.concat(`<li>
                                            <ul>
                                                <li> Problema: <b>${oracion.Problema}</b> </li>
                                                <li> Solucion: <b>${oracion.Solucion}</b> </li>
                                            </ul>
                                        </li>
                `)
            }

            cadena = cadena.concat(`</ol>`)
            return cadena;
        },
    },
    methods: {
        cargaCodigos: function () {
            if (app.campanaActual !== "") {
                let data = {
                    campaign_id: app.campanaActual,
                    _token: $('meta[name="csrf-token"]').attr('content')
                }
                $.post(RUTA_MAESTRA + "/getStatuses", data).done(resp => {
                    if (resp.Estado === "ok") {
                        app.codigosCalificacion = resp.Registros;
                    }
                    else {
                        Swal.fire(
                            'Error',
                            'Hubo un error cargando las listas',
                            'success'
                        )
                    }
                }).catch(err => {
                    console.log(err);
                })
            }
        },
        cargaListas: function () {
            if (app.campanaActual !== "") {
                let data = {
                    campaign_id: app.campanaActual,
                    _token: $('meta[name="csrf-token"]').attr('content')
                }
                $.post(RUTA_MAESTRA + "/getLists", data).done(resp => {
                    if (resp.Estado === "ok") {
                        app.listas = resp.Registros;
                    }
                    else {
                        Swal.fire(
                            'Error',
                            'Hubo un error cargando las listas',
                            'success'
                        )
                    }
                }).catch(err => {
                    console.log(err);
                })
            }
        },
        cargaCampanas: function () {
            let data = {
                _token: $('meta[name="csrf-token"]').attr('content')
            }
            $.get(RUTA_MAESTRA + "/getCampaigns", data).done(resp => {
                if (resp.Estado === "ok") {
                    app.campanas = resp.Registros;
                }
                else {
                    Swal.fire(
                        'Error',
                        'Hubo un error cargando las campañas',
                        'success'
                    )
                }
            }).catch(err => {
                console.log(err);
            })
        },
        cargaUsuarios: function () {
            let data = {
                _token: $('meta[name="csrf-token"]').attr('content')
            }
            $.post(RUTA_MAESTRA + "/getUsers", data).done(resp => {
                if (resp.Estado === "ok") {
                    app.usuarios = resp.Registros;
                }
                else {
                    Swal.fire(
                        'Error',
                        'Hubo un error cargando las campañas',
                        'success'
                    )
                }
            }).catch(err => {
                console.log(err);
            })
        },
        descargaArchivos: function () {
            let nuevo = {};
            for (const property in this.params) {
                if (this.params[property] !== "" && this.params[property] != null)
                    nuevo[property] = this.params[property];
            }
            let data = new URLSearchParams(nuevo);
            window.open(RUTA_MAESTRA + "/descargaVarios?" + data.toString());
        },
        borraArchivos: function () {
            this.params._token = $('meta[name="csrf-token"]').attr('content');
            Swal.fire({
                title: 'Advertencia',
                text: "No se podran recuperar los archivos borrados. ¿Estas seguro?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: 'red',
                confirmButtonText: 'Si, estoy seguro',
                cancelButtonText: 'No'
            }).then((result) => {
                if (result.value) {
                    $.post(RUTA_MAESTRA + "/eliminarVarios", this.params).done(resp => {
                        if (resp.Estado == "ok") {
                            Swal.fire(
                                'Borrado',
                                'Todas las grabaciones han sido borradas.',
                                'success'
                            )
                            app.loadEntries()
                        }
                        else {
                            let lista = document.createElement("ul");
                            resp.Errores.forEach(val => {
                                let itemList = document.createElement("li");
                                itemList.innerText = val;
                                lista.appendChild(itemList)
                            })
                            Swal.fire({
                                title: "Hubo problemas mientras se borraban las siguientes grabaciones",
                                icon: "info",
                                html: lista.outerHTML
                            })
                        }
                    })
                }
            })
        },
        PlayPause: function () {
            if (this.wavesurfer.isPlaying()) {
                $("#playpause").html("play_arrow");
            }
            else {
                $("#playpause").html("pause");
            }

            this.wavesurfer.playPause();
        },
        PlayPause2: function () {
            if (this.wavesurfer2.isPlaying()) {
                $("#playpause2").html("play_arrow");
            }
            else {
                $("#playpause2").html("pause");
            }
            this.wavesurfer2.playPause();
        },
        stop: function () {
            $("#playpause").html("play_arrow");
            this.wavesurfer.stop();
            app.tiempoActual = "00:00:00"
        },
        stop2: function () {
            $("#playpause2").html("play_arrow");
            this.wavesurfer2.stop();
            this.tiempoActual2 = "00:00:00"
        },
        limpiar: function () {
            app.tiempoActual = "00:00:00"
            app.tiempoTotal = "00:00:00"
            this.wavesurfer.empty();
        },
        limpiar2: function () {
            this.tiempoActual2 = "00:00:00"
            this.tiempoTotal2 = "00:00:00"
            this.wavesurfer2.empty();
        },
        handleSettings: function () {
            //alert('config');
            //this.showSettings = !this.showSettings;
            //$("#tab1").hide();

            if (configActive == 0) {

                $("#showSet").show();
                configActive = 1;

            } else {

                $("#showSet").hide();
                configActive = 0;

            }


        },
        showRecords: function () {
            //alert('grabaciones');
            $("#tab1").show();
            $("#btnFiltro").show();
            $("#tab2").hide();
            $("#tab3").hide();
            $("#showSet").hide();
            $("#tabEst").hide();
            $("#IATab").hide();
        },
        showAI: function (id) {
            this.id = id;
            app.wavesurfer2.load(RUTA_MAESTRA + '/descarga/' + id + '?reproducir=1&archive=' + this.params.archive);
            this.tiempoActual2 = "Cargando";
            this.tiempoTotal2 = "Cargando";
            this.wavesurfer2.on('ready', () => {
                this.wavesurfer2.on("audioprocess", () => {
                    this.tiempoActual2 = this.calcularTiempo(this.wavesurfer2.getCurrentTime());
                })
                this.tiempoActual2 = this.calcularTiempo(0)
                this.tiempoTotal2 = this.calcularTiempo(this.wavesurfer2.getDuration());
                $("#playpause2").html("play_arrow");
            });
            $("#tab1").hide();
            $("#btnFiltro").hide();
            $("#tab2").hide();
            $("#tab3").hide();
            $("#showSet").hide();
            $("#tabEst").hide();
            $("#IATab").show();

            $.get(RUTA_MAESTRA + "/speech_recognition/load", {
                identificador: id
            }, 'text').done((data) => {
                this.IARegistro = data;
            });

        },



        reproduce: function (id) {

            this.id = id;
            app.wavesurfer.load(RUTA_MAESTRA + '/descarga/' + id + '?reproducir=1&archive=' + this.params.archive);
            app.tiempoActual = "Cargando";
            app.tiempoTotal = "Cargando";
            app.wavesurfer.on('ready', function () {
                app.loadEntries();
                app.wavesurfer.play();
                app.wavesurfer.on("audioprocess", function () {
                    app.tiempoActual = app.calcularTiempo(app.wavesurfer.getCurrentTime());
                })
                app.tiempoTotal = app.calcularTiempo(app.wavesurfer.getDuration());
                $("#playpause").html("pause");
            });

        },
        showLogs: function () {
            //alert('logs');
            $("#tab1").hide();
            $("#btnFiltro").hide();
            $("#tab2").show();
            $("#tab3").hide();
            $("#tabEst").hide();
            $("#showSet").hide();
            $("#IATab").hide();
        },
        loadEntries: function () {
            this.params._token = $('meta[name="csrf-token"]').attr('content');

            $("#loadImg").show();
            $("#fadeLoad").show();

            $.post(RUTA_MAESTRA + "/Grabaciones/list", this.params, 'text').catch(data => {
                console.log(data);
            }).done((data) => {
                let modul = data.Registros.length % 20;

                let maxPagG = app.pagina + 1;

                if (data.Registros.length > 0 && modul !== 0) {
                    maxPagG--;
                }

                this.Registros = data.Registros;
                this.Titulos = data.titulos;
                this.maxPagGrab = maxPagG;

                actualizaPagGrabs();



            });
            $("#loadImg").hide();
            $("#fadeLoad").hide();
            let paramsUsers = {
                _token: $('meta[name="csrf-token"]').attr('content'),
                pagina: 1
            }

            $.post(RUTA_MAESTRA + "/Usuarios/list", paramsUsers, 'text').done((data) => {
                this.Usuarios = data.Registros;
            });
        },
        loadGraph: function () {
            if (grafica)
                grafica.destroy()
            $.post(RUTA_MAESTRA + "/generaGraficas", this.params, 'text').catch(data => {
                console.log(data);
            }).done((data) => {
                let labels_chart = [];
                let data_chart = [];
                let colors = [];
                data.Registros.forEach(val => {
                    data_chart.push(val.CANT);
                    labels_chart.push(val.NombreStatus);
                    colors.push(getRandomColor())
                });

                let ctx_llamadas = document.getElementById('chart-llamadas').getContext('2d');

                let chart_llamadas = new Chart(ctx_llamadas, {
                    type: 'pie',
                    data: {
                        datasets: [{
                            label: "Llamadas filtradas y calificadas",
                            data: data_chart,
                            backgroundColor: colors,
                        }],
                        labels: labels_chart,
                    },
                    options: {
                        responsive: true
                    }
                });
                grafica = chart_llamadas;
            });



        },

        descargaReporte: function () {
            let copia = { ...app.params };
            delete copia.pagina;
            for (const key in copia) {
                if (copia[key] === null || copia[key] === undefined || copia[key] === "") {
                    delete copia[key]
                }
            }
            let urlparams = new URLSearchParams(copia).toString();
            window.location.assign(RUTA_MAESTRA + "/Grabaciones/downloadReport?" + urlparams);
        },
        loadStatus: function () {

            let paramsEstatus = {
                _token: $('meta[name="csrf-token"]').attr('content'),
                pagina: app.paginaEst
            };

            $("#loadImg").show();
            $("#fadeLoad").show();

            $.post(RUTA_MAESTRA + "/status/list", paramsEstatus, 'text').catch(data => {
                console.log(data);
            }).done((data) => {

                let modul = parseInt(data.Cuantos) % 20;

                let maxPagG = (parseInt(data.Cuantos) - modul) / 20;

                if (modul > 0) {

                    maxPagG++;
                }

                this.maxPagEst = maxPagG;

                this.Estatus = data.Registros;

                $("#tab1").hide();
                $("#btnFiltro").hide();
                $("#tab2").hide();
                $("#tab3").hide();
                $("#showSet").hide();
                $("#IATab").hide();
                $("#tabEst").show();

                actualizaPagEst();

                $("#loadImg").hide();
                $("#fadeLoad").hide();

            });
        },
        loadLogs: function () {

            let fechaLog = $("#fechaLogW").val();

            let spl = fechaLog.split('-');

            let fechaLogF = spl[2] + '-' + spl[1] + '-' + spl[0];

            //alert(fechaLogF);

            $("#loadImg").show();
            $("#fadeLoad").show();

            let paramsEstatus = {
                _token: $('meta[name="csrf-token"]').attr('content'),
                pagina: app.paginaLogs,
                fecha: fechaLogF
            };

            $.post(RUTA_MAESTRA + "/logs/list", paramsEstatus, 'text').catch(data => {
                console.log(data);
            }).done((data) => {

                let modul = parseInt(data.Cuantos) % 20;

                let maxPagG = (parseInt(data.Cuantos) - modul) / 20;

                if (modul > 0) {

                    maxPagG++;
                }

                this.maxPagLogs = maxPagG;

                this.Logs = data.Registros;

                actualizaPagLogs();

                $("#loadImg").hide();
                $("#fadeLoad").hide();

            });


        },
        createStatus: function () {

            $("#loadImg").show();
            $("#fadeLoad").show();

            let nombreEstatus = $("#nombreCreaEst").val();

            //alert(nombreEstatus);

            let paramsEstatusC = {
                _token: $('meta[name="csrf-token"]').attr('content'),
                nombre: nombreEstatus,
                color: $("#colorCrea").val()
            };

            $.post(RUTA_MAESTRA + "/status/create", paramsEstatusC, 'text').catch(data => {
                console.log(data);
            }).done((data) => {

                if (data.Estado == "ok") {

                    //alert("Se dio de alta correctamente el estatus");
                    Swal.fire({
                        title: 'Exito',
                        text: 'Se dio de alta correctamente el estatus',
                        icon: 'success'
                    });

                } else {

                    //alert("Ocurrio un error");
                    Swal.fire({
                        title: 'Error',
                        text: 'Ocurrio un error',
                        icon: 'error'
                    });

                }

                $("#loadImg").hide();
                $("#fadeLoad").hide();

                $('#modalStatusCreate').modal('toggle');

                app.loadStatus();

            })


        },
        getNombreTipo: function (tipoLog) {
            switch (tipoLog) {
                case 0:
                    return "Inicio de sesión";
                case 1:
                    return "Cierre de sesión";
                case 2:
                    return "Consulta de grabaciones";
                case 3:
                    return "Descarga de grabación";
                case 4:
                    return "Reproduccion de grabación";
                case 5:
                    return "Grafica de grabación";
                case 6:
                    return "Eliminación de grabación";
                case 7:
                    return "Creacion de usuario";
                case 8:
                    return "Actualización de usuario";
                case 9:
                    return "Eliminación de usuario";
                case 10:
                    return "Cambiar la configuracion del sistema";
                case 11:
                    return "Consulta de logs";
                case 12:
                    return "Consulta de estatus";
                case 13:
                    return "Creación de estatus";
                case 14:
                    return "Actualización de estatus";
                case 15:
                    return "Eliminacion de estatus";
                case 16:
                    return "Calificación de grabación";
                case 17:
                    return "Comentar grabación";
                case 18:
                    return "Graficas de grabaciones";
                default:
                    return tipoLog;

            }
        },
        changeStatus: function () {

            $("#loadImg").show();
            $("#fadeLoad").show();

            let nombreEstatus = $("#nombreEditaEst").val();

            let paramsEstatusC = {
                _token: $('meta[name="csrf-token"]').attr('content'),
                nombre: nombreEstatus,
                idStatus: idEstatusEdita,
                color: $("#colorEdi").val()
            };

            $.post(RUTA_MAESTRA + "/status/change", paramsEstatusC, 'text').catch(data => {
                console.log(data);
            }).done((data) => {

                if (data.Estado == "ok") {

                    //alert("Se edito correctamente el estatus");
                    Swal.fire({
                        title: 'Exito',
                        text: 'Se edito correctamente el estatus',
                        icon: 'success'
                    });

                } else {

                    //alert("Ocurrio un error");
                    Swal.fire({
                        title: 'Error',
                        text: 'Ocurrio un error',
                        icon: 'error'
                    });

                }

                $("#loadImg").hide();
                $("#fadeLoad").hide();

                $('#modalStatusEdita').modal('toggle');

                app.loadStatus();

            });


        },
        calificaGrabStat: function () {

            $("#loadImg").show();
            $("#fadeLoad").show();

            let radioValue = $("input[name='radio']:checked").val();

            let idEstatus = parseInt(radioValue);

            //alert(idEstatus);

            let paramsEstatusC = {
                _token: $('meta[name="csrf-token"]').attr('content'),
                id_grab: idGrabCal,
                idStatus: idEstatus
            };


            $.post(RUTA_MAESTRA + "/status/assoc", paramsEstatusC, 'text').catch(data => {
                console.log(data);
            }).done((data) => {

                if (data.Estado == "ok") {
                    app.loadEntries();
                    //alert("Se califico correctamente el estatus");
                    Swal.fire({
                        title: 'Exito',
                        text: 'Se califico correctamente el estatus',
                        icon: 'success'
                    });

                } else {

                    //alert("Ocurrio un error");
                    Swal.fire({
                        title: 'Error',
                        text: 'Ocurrio un error',
                        icon: 'error'
                    });

                }

                $("#loadImg").hide();
                $("#fadeLoad").hide();

                $('#modalStatusCalifica').modal('toggle');

            });


        },
        deleteStatus: function (idBorra) {

            let paramsEstatusC = {
                _token: $('meta[name="csrf-token"]').attr('content')
            };

            let idStatus = idBorra;

            let confirmBoxResult = confirm("¿Desea eliminar este estatus de calificación ? ");

            if (confirmBoxResult) {

                $.post(RUTA_MAESTRA + "/status/delete/" + idStatus, paramsEstatusC, 'text').catch(data => {
                    console.log(data);
                }).done((data) => {

                    if (data.Estado == "ok") {

                        //alert("Se elimino correctamente el estatus");
                        Swal.fire({
                            title: 'Exito',
                            text: 'Se elimino correctamente el estatus',
                            icon: 'success'
                        });


                    } else {

                        //alert("Ocurrio un error");
                        Swal.fire({
                            title: 'Error',
                            text: 'Ocurrio un error',
                            icon: 'error'
                        });

                    }

                    app.loadStatus();

                });

            } else {

                return false;

            }


        },
        deleteGrabs: function (idBorra) {

            let paramsEstatusC = {
                _token: $('meta[name="csrf-token"]').attr('content'),
                archive: this.params.archive,
            };

            let confirmBoxResult = confirm("¿Desea eliminar esta grabación ? ");

            if (confirmBoxResult) {

                $.post(RUTA_MAESTRA + "/eliminar/" + idBorra, paramsEstatusC, 'text').catch(data => {
                    console.log(data);
                }).done((data) => {

                    if (data.Estado == "ok") {

                        //alert("Se elimino correctamente el estatus");
                        Swal.fire({
                            title: 'Exito',
                            text: 'Se elimino correctamente la grabación',
                            icon: 'success'
                        });


                    } else {

                        //alert("Ocurrio un error");
                        Swal.fire({
                            title: 'Error',
                            text: 'Ocurrio un error',
                            icon: 'error'
                        });

                    }

                    app.loadParams();
                    app.loadEntries();

                });

            } else {

                return false;

            }


        }, listaStatus: function () {

            let paramsEstatusC = {
                _token: $('meta[name="csrf-token"]').attr('content')
            };

            $.post(RUTA_MAESTRA + "/status/select/", paramsEstatusC, 'text').catch(data => {
                console.log(data);
            }).done((data) => {
                this.ListaEstatus = data.Registros;

            });


        }, loadParams: function () {
            this.params = {
                nombre: '',
                extension: '',
                origen: '',
                destino: '',
                horasinicial: 0,
                minutosinicial: 0,
                segundosinicial: 0,
                horasfinal: 0,
                minutosfinal: 0,
                segundosfinal: 0,
                inicio: '',
                fin: '',
                fhorasinicial: 0,
                fminutosinicial: 0,
                fsegundosinicial: 0,
                fhorasfinal: '',
                fminutosfinal: '',
                fsegundosfinal: '',
                pagina: this.pagina,
                status: 0,
                escuchando: false,
                archive: 0,
            }
            if (this.campanaActual !== "") {
                this.params.campaign_id = this.campanaActual;
                this.params.list_id = this.listaActual !== "" ? this.listaActual : null;
                this.params.status_id = this.codigoCalificacionActual !== "" ? this.codigoCalificacionActual : null;
            }
            this.params.nombre = $("#opcionesNombre").val();
            this.params.cuenta = $("#opcionesCuenta").val();
            this.params.telefono = $("#opcionesTelefono").val();
            this.params.usuario = this.usuarioActual
            this.params.identificador = $("#opcionesIdentificador").val();
            this.params.tipoLlam = $("input[name='tipoLlam']:checked").val()
            //alert($("#opcionesFechaInicio").val());

            this.params.inicio = $("#opcionesFechaInicio").val();

            //alert($("#opcionesFechaFin").val());

            this.params.archive = $("#grabacionesArchivadas")[0].checked ? 1 : 0;

            this.params.fin = $("#opcionesFechaFin").val();
            this.params.horasinicial = $("#opcionesDuracionInicialHH").val();
            this.params.minutosinicial = $("#opcionesDuracionInicialMM").val();
            this.params.segundosinicial = $("#opcionesDuracionInicialSS").val();
            this.params.horasfinal = $("#opcionesDuracionFinalHH").val();
            this.params.minutosfinal = $("#opcionesDuracionFinalMM").val();
            this.params.segundosfinal = $("#opcionesDuracionFinalSS").val();
            this.params.fhorasinicial = $("#opcionesInicioHH").val();
            this.params.fminutosinicial = $("#opcionesInicioMM").val();
            this.params.fsegundosinicial = $("#opcionesInicioSS").val();
            this.params.fhorasfinal = $("#opcionesFinalHH").val();
            this.params.fminutosfinal = $("#opcionesFinalMM").val();
            this.params.fsegundosfinal = $("#opcionesFinalSS").val();
            this.params.status = $("#estadosFiltro").val();
            this.params.escuchando = document.getElementById("audiosReproducidos").checked ? 1 : 0;
        },
        initializeParams: function () {
            let today = new Date();
            let inicio = new Date();
            inicio.setDate(inicio.getDate() - 7);
            let dd = today.getDate();
            let mm = today.getMonth() + 1; //January is 0!

            let yyyy = today.getFullYear();
            if (dd < 10) {
                dd = '0' + dd;
            }
            if (mm < 10) {
                mm = '0' + mm;
            }
            let dd2 = inicio.getDate();
            let mm2 = inicio.getMonth() + 1; //January is 0!

            let yyyy2 = inicio.getFullYear();
            if (dd2 < 10) {
                dd2 = '0' + dd2;
            }
            if (mm2 < 10) {
                mm2 = '0' + mm2;
            }
            //let today = dd + '-' + mm + '-' + yyyy;

            let todayStr = yyyy + '-' + mm + '-' + dd;
            let inicio2 = yyyy2 + "-" + mm2 + "-" + dd2;
            $("#opcionesNombre").val("")
            $("#opcionesFechaInicio").val(inicio2);
            $("#opcionesFechaFin").val(todayStr);

            $("#opcionesInicioHH").val("00");
            $("#opcionesInicioMM").val("00");
            $("#opcionesInicioSS").val("00");

            $("#opcionesFinalHH").val("23");
            $("#opcionesFinalMM").val("59");
            $("#opcionesFinalSS").val("59");

            $("#opcionesDuracionInicialHH").val("00");
            $("#opcionesDuracionInicialMM").val("00");
            $("#opcionesDuracionInicialSS").val("00");

            $("#opcionesDuracionFinalHH").val("01");
            $("#opcionesDuracionFinalMM").val("00");
            $("#opcionesDuracionFinalSS").val("00");
        },
        calcularTiempo: function (segundos) {
            if (Number.isFinite(segundos)) {
                segundos = parseInt(segundos);
                let horas = parseInt(segundos / 3600);
                segundos %= 3600;
                let minutos = parseInt(segundos / 60);
                segundos %= 60;
                return (horas < 10 ? "0".concat(horas) : "".concat(horas)).concat(":", (minutos < 10 ? "0".concat(minutos) : "".concat(minutos))).concat(":", (segundos < 10 ? "0".concat(segundos) : "".concat(segundos)))
            }
            else {
                return "00:00:00";
            }
        }
    },
    mounted: function () {
        this.initializeParams();
        this.loadParams();
        this.showRecords();

        this.listaStatus();

        this.loadEntries();
        $("#tab1").show();
        this.cargaCampanas();
        this.cargaUsuarios();
        setTimeout(() => {
            this.wavesurfer = WaveSurfer.create({
                container: '#waveform'
            });
            this.wavesurfer2 = WaveSurfer.create({
                container: '#waveform2'
            });
        }, 3000);
    }
});
