<?php

namespace Televox\Http\Middleware;

use Closure;

class ChangeResponseJsonText
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $response = $next($request);
        if ($request->input('format') == 'json') {

            $response->setContent(
                $this->getDataFromResponse($response)
            );

        }

        return $response;

    }

    /**
     * Get the data that was pasted to the view
     *
     * @param  \Illuminate\Http\Response  $response
     */
    protected function getDataFromResponse($response)
    {
        $content = $response->getOriginalContent();

        return $content->getData();
    }
}
