<?php

namespace Televox\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class Status extends Controller
{
    public function list(Request $request)
    {
        if ($request->session()->get('status', false)) {
            $datos = $request->validate(['pagina' => 'numeric|min:0|required']);
            $query = json_encode($datos);
            DB::connection('Televox')->table('tbl_log')->insertGetId(['idClientes' => $request->session()->get('idClientes'), 'ip' => $request->ip(), 'fecha' => date('Y-m-d H:i:s'), 'id_usuario' => $request->session()->get('id'), 'tipo' => 12, 'detalle' => 'El usuario ' . $request->session()->get('usuario') . " hizo una consulta a los estatuses con los parametros: $query"]);

            $offset = ($datos['pagina'] - 1) * 20;
            $result = DB::connection('Televox')->table('tbl_status')->where('idClientes', '=', $request->session()->get('idClientes'))->offset($offset)->limit(20)->get();
            $cuenta = DB::connection('Televox')->table('tbl_status')->where('idClientes', '=', $request->session()->get('idClientes'))->count();

            return ['Estado' => 'ok', 'Registros' => $result, 'Cuantos' => $cuenta];
        } else {
            return ['Estado' => 'error', 'Descripcion' => 'No tienes los permisos necesarios'];
        }
    }

    public function create(Request $request)
    {
        if ($request->session()->get('status', false)) {
            $datos = $request->validate([
                'nombre' => 'string|required',
                'color' => 'alpha_num|size:6|required'
            ]);
            $query = json_encode($datos);
            DB::connection('Televox')->table('tbl_log')->insertGetId(['idClientes' => $request->session()->get('idClientes'), 'ip' => $request->ip(), 'fecha' => date('Y-m-d H:i:s'), 'id_usuario' => $request->session()->get('id'), 'tipo' => 13, 'detalle' => 'El usuario ' . $request->session()->get('usuario') . " creo un estatus con los parametros: $query"]);
            DB::connection('Televox')->table('tbl_status')->insertGetId(['idClientes' => $request->session()->get('idClientes'), 'Nombre' => $datos['nombre'], 'Color' => $datos['color']]);

            return ['Estado' => 'ok'];
        } else {
            return ['Estado' => 'error', 'Descripcion' => 'No tienes los permisos necesarios'];
        }

    }

    public function getSelect(Request $request)
    {
        if ($request->session()->get('status', false)) {
            $result = DB::connection('Televox')->table('tbl_status')->where('idClientes', '=', $request->session()->get('idClientes'))->get();

            return ['Estado' => 'ok', 'Registros' => $result];
        } else {
            return ['Estado' => 'error', 'Descripcion' => 'No tienes los permisos necesarios'];
        }
    }

    public function update(Request $request)
    {
        if ($request->session()->get('status', false)) {
            $datos = $request->validate([
                'idStatus' => 'numeric|required',
                'nombre' => 'string|required',
                'color' => 'alpha_num|size:6|required'
            ]);
            $query = json_encode($datos);
            DB::connection('Televox')->table('tbl_log')->insertGetId(['idClientes' => $request->session()->get('idClientes'), 'ip' => $request->ip(), 'fecha' => date('Y-m-d H:i:s'), 'id_usuario' => $request->session()->get('id'), 'tipo' => 14, 'detalle' => 'El usuario ' . $request->session()->get('usuario') . " actualizo el estatus con los parametros: $query"]);
            DB::connection('Televox')->table('tbl_status')->where('idStatus', '=', $datos['idStatus'])->update(['Nombre' => $datos['nombre'], 'Color' => $datos['color']]);

            return ['Estado' => 'ok'];
        } else {
            return ['Estado' => 'error', 'Descripcion' => 'No tienes los permisos necesarios'];
        }
    }

    public function delete(Request $request, $id)
    {
        if ($request->session()->get('status', false)) {
            DB::connection('Televox')->table('tbl_log')->insertGetId(['idClientes' => $request->session()->get('idClientes'), 'ip' => $request->ip(), 'fecha' => date('Y-m-d H:i:s'), 'id_usuario' => $request->session()->get('id'), 'tipo' => 15, 'detalle' => 'El usuario ' . $request->session()->get('usuario') . " borro el estatus con el id: $id"]);
            DB::connection('Televox')->table('tbl_status')->where('idStatus', '=', $id)->delete();

            return ['Estado' => 'ok'];
        } else {
            return ['Estado' => 'error', 'Descripcion' => 'No tienes los permisos necesarios'];
        }
    }

    public function assoc(Request $request)
    {
        if ($request->session()->get('status', false)) {
            $datos = $request->validate(['id_grab' => 'string|required', 'idStatus' => 'numeric|min:0|required']);
            $query = json_encode($datos);
            DB::connection('Televox')->table('tbl_log')->insertGetId(['idClientes' => $request->session()->get('idClientes'), 'ip' => $request->ip(), 'fecha' => date('Y-m-d H:i:s'), 'id_usuario' => $request->session()->get('id'), 'tipo' => 16, 'detalle' => 'El usuario ' . $request->session()->get('usuario') . " asocio una grabacion a un status con los parametros: $query"]);
            DB::connection('Televox')->table('tbl_status_grab')->updateOrInsert(['id_grab' => $datos['id_grab']], ['id_status' => $datos['idStatus']]);

            return ['Estado' => 'ok'];
        } else {
            return ['Estado' => 'error', 'Descripcion' => 'No tienes los permisos necesarios'];
        }
    }
}
