<?php

namespace Televox\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class SpeechRecognition extends Controller
{
    public function load(Request $req)
    {
        $datos = $req->validate([
            'identificador' => ['numeric', 'nullable', "required"],
        ]);

        $recording_id = $datos["identificador"];

        $salida = [];

        $connection = DB::connection("Televox");

        $transcripcion = $connection
            ->table("tbl_transcripcion")
            ->where("recording_id", $recording_id)
            ->first();

        if ($transcripcion) {
            $salida["Transcripcion"] = $transcripcion->transcripcion;
        }


        $resumen = $connection
            ->table("tbl_resumen")
            ->where("recording_id", $recording_id)
            ->first();

        if ($resumen) {
            $salida["Resumen"] = $resumen->resumen;
        }


        $sentimientos = $connection
            ->table("tbl_sentimiento")
            ->where("recording_id", $recording_id)
            ->first();

        if ($sentimientos) {
            $salida["Sentimiento"] = $sentimientos->sentimiento;
            $salida["Magnitud"] = $sentimientos->magnitud;
        }



        $oraciones = $connection
            ->table("tbl_oracion")
            ->where("recording_id", $recording_id)
            ->get();

        if ($oraciones->count() > 0) {
            $salida["Oraciones"] = [];
            foreach ($oraciones as $oracion) {
                $salida["Oraciones"][] = [
                    "Orden" => $oracion->orden,
                    "Oracion" => $oracion->oracion,
                    "Sentimiento" => $oracion->sentimiento,
                    "Magnitud" => $oracion->magnitud,
                ];
            }
        }


        $problemas_claves = $connection
            ->table("tbl_problema_clave")
            ->where("recording_id", $recording_id)
            ->get();

        if ($problemas_claves->count() > 0) {
            $salida["Problemas"] = [];
            foreach ($problemas_claves as $problema) {
                $salida["Problemas"][] = [
                    "Orden" => $problema->orden,
                    "Problema" => $problema->problema,
                    "Solucion" => $problema->solucion,
                ];
            }
        }



        return $salida;
    }

    public function generateReport(Request $req)
    {
        $archived = $req->boolean('archived', false);
        $connection = DB::connection("Televox");

        if (!$archived) {
            $start = $req->input('start_date', Carbon::now()->subDays(7)->toDateString());
            $end = $req->input('end_date', Carbon::now()->toDateString());

            $lineData = $connection->table('recording_log as r')
                ->join('tbl_sentimiento as s', 'r.recording_id', '=', 's.recording_id')
                ->selectRaw('DATE(r.start_time) as dia,
                    SUM(IF(s.sentimiento=1,1,0)) as pos,
                    SUM(IF(s.sentimiento=0,1,0)) as neu,
                    SUM(IF(s.sentimiento=-1,1,0)) as neg')
                ->whereBetween('r.start_time', ["$start 00:00:00", "$end 23:59:59"])
                ->groupBy('dia')
                ->orderBy('dia')
                ->get();

            $lineLabels = [];
            $linePos = [];
            $lineNeu = [];
            $lineNeg = [];
            foreach ($lineData as $row) {
                $lineLabels[] = $row->dia;
                $linePos[] = $row->pos;
                $lineNeu[] = $row->neu;
                $lineNeg[] = $row->neg;
            }

            $pieRow = $connection->table('recording_log as r')
                ->join('tbl_sentimiento as s', 'r.recording_id', '=', 's.recording_id')
                ->selectRaw('
                    SUM(IF(s.sentimiento=1,1,0)) as pos,
                    SUM(IF(s.sentimiento=0,1,0)) as neu,
                    SUM(IF(s.sentimiento=-1,1,0)) as neg')
                ->whereBetween('r.start_time', ["$start 00:00:00", "$end 23:59:59"])
                ->first();

            $probs = $connection->table('tbl_problema_clave as p')
                ->join('recording_log as r', 'p.recording_id', '=', 'r.recording_id')
                ->selectRaw('p.problema as name, COUNT(*) as total')
                ->whereBetween('r.start_time', ["$start 00:00:00", "$end 23:59:59"])
                ->groupBy('p.problema')
                ->orderByDesc('total')
                ->limit(5)
                ->get();

            $topProblemsLabels = [];
            $topProblemsData = [];
            foreach ($probs as $row) {
                $topProblemsLabels[] = $row->name;
                $topProblemsData[] = $row->total;
            }

            $topWordsLabels = array_fill(0, 5, 'SinDatos');
            $topWordsData = array_fill(0, 5, 0);

            return response()->json([
                'line' => [
                    'labels' => $lineLabels,
                    'pos' => $linePos,
                    'neu' => $lineNeu,
                    'neg' => $lineNeg
                ],
                'pie' => [
                    'pos' => $pieRow->pos ?? 0,
                    'neu' => $pieRow->neu ?? 0,
                    'neg' => $pieRow->neg ?? 0
                ],
                'topProblems' => [
                    'labels' => $topProblemsLabels,
                    'values' => $topProblemsData
                ],
                'topWords' => [
                    'labels' => $topWordsLabels,
                    'values' => $topWordsData
                ]
            ]);
        } else {
            // Para la tabla archivada, no existe 'start_time', así que devolvemos datos simples.
            $archData = $connection->table('recording_log_archive as r')
                ->join('tbl_sentimiento as s', 'r.recording_id', '=', 's.recording_id')
                ->selectRaw('COUNT(IF(s.sentimiento=1,1,NULL)) as pos,
                             COUNT(IF(s.sentimiento=0,1,NULL)) as neu,
                             COUNT(IF(s.sentimiento=-1,1,NULL)) as neg')
                ->first();

            $pieRow = $archData;
            $lineLabels = ['Archivado'];
            $linePos = [$archData->pos];
            $lineNeu = [$archData->neu];
            $lineNeg = [$archData->neg];

            $probs = $connection->table('tbl_problema_clave as p')
                ->join('recording_log_archive as r', 'p.recording_id', '=', 'r.recording_id')
                ->selectRaw('p.problema as name, COUNT(*) as total')
                ->groupBy('p.problema')
                ->orderByDesc('total')
                ->limit(5)
                ->get();

            $topProblemsLabels = [];
            $topProblemsData = [];
            foreach ($probs as $row) {
                $topProblemsLabels[] = $row->name;
                $topProblemsData[] = $row->total;
            }

            $topWordsLabels = array_fill(0, 5, 'SinDatos');
            $topWordsData = array_fill(0, 5, 0);

            return response()->json([
                'line' => [
                    'labels' => $lineLabels,
                    'pos' => $linePos,
                    'neu' => $lineNeu,
                    'neg' => $lineNeg
                ],
                'pie' => [
                    'pos' => $pieRow->pos ?? 0,
                    'neu' => $pieRow->neu ?? 0,
                    'neg' => $pieRow->neg ?? 0
                ],
                'topProblems' => [
                    'labels' => $topProblemsLabels,
                    'values' => $topProblemsData
                ],
                'topWords' => [
                    'labels' => $topWordsLabels,
                    'values' => $topWordsData
                ]
            ]);
        }
    }
}
