<?php

namespace Televox\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class Logs extends Controller
{
    public function getLogs(Request $request)
    {
        if ($request->session()->get('log', false)) {
            $datos = $request->validate([
                'fecha' => 'before_or_equal:today|date|required',
                'pagina' => 'min:0|numeric|required'
            ]);
            $query = '[';
            foreach ($datos as $key => $val) {
                $query .= "$key => $val,";
            }
            $query .= ']';
            DB::connection('Televox')->table('tbl_log')->insertGetId(['ip' => $request->ip(), 'fecha' => date('Y-m-d H:i:s'), 'id_usuario' => $request->session()->get('id'), 'tipo' => 11, 'detalle' => 'El usuario ' . $request->session()->get('usuario') . "hizo una consulta a los logs con los parametros: $query"]);
            $connection = DB::connection('Televox');
            $fecha = date('Y-m-d', strtotime($datos['fecha']));
            $offset = ($datos['pagina'] - 1) * 20;
            $cuantos = $connection->table('tbl_log as tl')
                ->join('tbl_usuario AS tu', 'tu.id', '=', 'tl.id_usuario')
                ->whereDate('tl.fecha', $fecha)
                ->count();
            $results = $connection->table('tbl_log as tl')
                ->join('tbl_usuario AS tu', 'tu.id', '=', 'tl.id_usuario')
                ->whereDate('tl.fecha', $fecha)
                ->offset($offset)
                ->limit(20)
                ->orderBy('id', 'DESC')
                ->addSelect(DB::raw("DATE(tl.fecha) as 'fecha'"))
                ->addSelect(DB::raw("TIME(tl.fecha) as 'hora'"))
                ->addSelect('tl.ip')
                ->addSelect('tl.id')
                ->addSelect('tl.detalle')
                ->addSelect('tl.tipo')
                ->addSelect('tu.usuario AS usuario')
                ->get();
            foreach ($results as $result) {
                $result->usuario = base64_decode(\base64_decode($result->usuario));
            }

            return ['Estado' => 'ok', 'Registros' => $results, 'Cuantos' => $cuantos];
        } else {
            return ['Estado' => 'error', 'Descripcion' => 'No tiene permisos para esta accion'];
        }
    }
}
