<?php

namespace Televox\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class Comentarios extends Controller
{
    public function assoc(Request $request)
    {
        if ($request->session()->get('comentar', false)) {
            $datos = $request->validate([
                'id_grab' => 'string|required',
                'texto' => 'string|required'
            ]);

            $query = json_encode($datos);
            $usuario = $request->session()->get('usuario');
            $idUsuario = $request->session()->get('id');

            DB::connection('Televox')
                ->table('tbl_log')
                ->insertGetId([
                    'ip' => $request->ip(),
                    'fecha' => now(),
                    'id_usuario' => $idUsuario,
                    'tipo' => 17,
                    'detalle' => "El usuario $usuario asocio un comentario a una grabacion: $query"
                ]);

            DB::connection('Televox')
                ->table('tbl_comentarios')
                ->updateOrInsert(
                    ['id_grab' => $datos['id_grab']],
                    ['text_comment' => $datos['texto']]
                );

            return ['Estado' => 'ok'];
        } else {
            return [
                'Estado' => 'error',
                'Descripcion' => 'No tienes los permisos necesarios'
            ];
        }
    }
}
