<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">


    <!-- Bootstrap CSS -->

    <link rel="shortcut icon" type="image/png" href="{{ asset('favicon.png') }}">
    <link rel="shortcut icon" href="{{ asset('favicon.png') }}">
    <link href="{{ asset('iconfont/material-icons.css') }}" rel="stylesheet">

    <link href="{{ asset('css/app.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('css/bootstrap.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('css/dark.css') }}" rel="stylesheet" type="text/css">


    <meta charset="utf-8" name="csrf-token" content="{{ csrf_token() }}">

    <link href="{{ asset('css/main.css') }}" rel="stylesheet" type="text/css">

    <title>Televox</title>
</head>

<body class="letraFinal superCentro">
    <div class="container" style="margin-top: 2rem;">
        <form id="formFechas">
            <input type="date" id="start_date" name="start_date">
            <input type="date" id="end_date" name="end_date">
        </form>
        <h3>Reporte de Análisis de Grabaciones</h3>
        <div class="row">
            <div class="col-12 col-md-6">
                <canvas id="lineChart"></canvas>
            </div>
            <div class="col-12 col-md-6">
                <canvas id="pieChart"></canvas>
            </div>
        </div>
        <div class="row" style="margin-top: 2rem;">
            <div class="col-12 col-md-6">
                <canvas id="topProblemasChart"></canvas>
            </div>
            <div class="col-12 col-md-6">
                <canvas id="topPalabrasChart"></canvas>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            let endDateInput = document.getElementById('end_date');
            let startDateInput = document.getElementById('start_date');
            endDateInput.value = new Date().toISOString().substr(0, 10);
            let sevenDaysAgo = new Date();
            sevenDaysAgo.setDate(sevenDaysAgo.getDate() - 7);
            startDateInput.value = sevenDaysAgo.toISOString().substr(0, 10);

            const lineCtx = document.getElementById('lineChart').getContext('2d');
            const pieCtx = document.getElementById('pieChart').getContext('2d');
            const barProblemasCtx = document.getElementById('topProblemasChart').getContext('2d');
            const barPalabrasCtx = document.getElementById('topPalabrasChart').getContext('2d');

            let params = new URLSearchParams({
                start_date: startDateInput.value,
                end_date: endDateInput.value
            });

            fetch('/speech/generateReport?' + params)
                .then(res => res.json())
                .then(data => {
                    new Chart(lineCtx, {
                        type: 'line',
                        data: {
                            labels: data.line.labels,
                            datasets: [{
                                    label: 'Positivo',
                                    data: data.line.pos,
                                    borderColor: 'green'
                                },
                                {
                                    label: 'Neutro',
                                    data: data.line.neu,
                                    borderColor: 'blue'
                                },
                                {
                                    label: 'Negativo',
                                    data: data.line.neg,
                                    borderColor: 'red'
                                }
                            ]
                        },
                        options: {
                            responsive: true
                        }
                    });

                    new Chart(pieCtx, {
                        type: 'pie',
                        data: {
                            labels: ['Positivo', 'Neutro', 'Negativo'],
                            datasets: [{
                                data: [data.pie.pos, data.pie.neu, data.pie.neg]
                            }]
                        },
                        options: {
                            responsive: true
                        }
                    });

                    new Chart(barProblemasCtx, {
                        type: 'bar',
                        data: {
                            labels: data.topProblems.labels,
                            datasets: [{
                                label: 'Problemas',
                                data: data.topProblems.values
                            }]
                        },
                        options: {
                            responsive: true
                        }
                    });

                    new Chart(barPalabrasCtx, {
                        type: 'bar',
                        data: {
                            labels: data.topWords.labels,
                            datasets: [{
                                label: 'Palabras',
                                data: data.topWords.values
                            }]
                        },
                        options: {
                            responsive: true
                        }
                    });
                });
        });
    </script>
    <script src="{{ asset('js/vue.js') }}"></script>
    <script src="{{ asset('js/vue-paginate.js') }}"></script>
    <script src="{{ asset('js/wavesurfer.js') }}"></script>
    <script src="{{ asset('js/jquery.js') }}"></script>
    <script src="{{ asset('js/popper.js') }}"></script>
    <script src="{{ asset('js/bootstrap.js') }}"></script>
    <script src="{{ asset('js/sweetalert2@9.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/jscolor.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/Chart.bundle.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('js/Chart.min.js') }}"></script>
</body>

</html>
