<modal-dialvox v-model="targets.addQuestion" :send="traducirFrase('Guardar')" small @submit="addPregunta">
    <h4>{{traducirFrase("Agregar Pregunta")}}</h4>
    <br>
    <div class="container">
        <div class="row dv-flex dv-centered noBottomMargin">
            <div class="input-field no-margin col dv-flex-grow-1">
                <input type="text" v-bind:placeholder="traducirFrase('Nombre')" class="nombreInput" v-model="pregunta.nombre" id="nombre">
                <label for="nombre" class="active">{{traducirFrase("Nombre")}}</label>
            </div>
            <div class="input-field no-margin col row dv-flex" style="flex-direction: column;">
                <div class="col s12">
                    <label for="">{{traducirFrase("Tipo de pregunta")}}</label>
                </div>
                <div class="col s12">
                    <p class="radioPregunta">
                        <label> 
                            <input name="group1" type="radio" :value="1" v-model="pregunta.tipoPregunta"/>
                            <span>{{traducirFrase("Normal")}}</span>
                        </label>
                    </p>
                    <p class="radioPregunta">
                        <label>
                            <input name="group1" type="radio" v-model="pregunta.tipoPregunta" :value="2" />
                            <span>{{traducirFrase("Abierta")}}</span>
                        </label>
                    </p>
                </div>
            </div>
        </div>
        <?php if (isset($_SESSION["allowFiles"]) && $_SESSION["allowFiles"] == 1) {?>
        <div class="row dv-flex noBottomMargin noTopMargin">
            <div class="col s12">
                <p>
                    <label>
                        <input type="checkbox" v-model="pregunta.tieneArchivo" class="archivoInput"/>
                        <span>{{traducirFrase("Subir archivo de audio")}}</span>
                    </label>
                </p>
            </div>
        </div>
        <?php }?>
        <div class="row noBottomMargin">
            <div class="input-field col s12 no-margin noPadding">
                <!-- <input v-if="!pregunta.tieneArchivo" type="text" placeholder="Texto de la Pregunta" v-model="pregunta.texto"> -->
                <div class="input-field col s12" v-if="!pregunta.tieneArchivo" >
                    <textarea id="textarea1" class="materialize-textarea" rows="3" v-model="pregunta.texto"></textarea>
                    <label class="active" for="textarea1">{{traducirFrase("Texto de la pregunta")}}</label>
                </div>
                <div class="col s12 noPadding no-margin row dv-flex" style="justify-content: start; flex-wrap: wrap; gap: 6px;" v-if="!pregunta.tieneArchivo">
                    <a class="waves-effect waves-light btn-small no-margin" value = "Nombre" href="#" v-on:click="appendButtonText('Nombre', $event)">{{traducirFrase("Nombre")}}</a>
                    <a class="waves-effect waves-light btn-small no-margin" href="#" v-on:click="appendButtonText('Apellidos', $event)">{{traducirFrase("Apellidos")}}</a>
                    <a class="waves-effect waves-light btn-small no-margin" href="#" v-on:click="appendButtonText('Telefono', $event)">{{traducirFrase("Teléfono")}}</a>
                    <a class="waves-effect waves-light btn-small no-margin" href="#" v-on:click="appendButtonText('Direccion', $event)">{{traducirFrase("Dirección")}}</a>
                    <a class="waves-effect waves-light btn-small no-margin" href="#" v-on:click="appendButtonText('Correo Electronico', $event)">{{traducirFrase("Correo electrónico")}}</a>
                    <a class="waves-effect waves-light btn-small no-margin" href="#" v-on:click="appendButtonText('Ciudad', $event)">{{traducirFrase("Ciudad")}}</a>
                    <a class="waves-effect waves-light btn-small no-margin" href="#" v-on:click="appendButtonText('Pais', $event)">{{traducirFrase("País")}}</a>
                </div>
                <div v-if="pregunta.tieneArchivo" class="no-margin">
                    <div class = "file-field input-field">
                        <div class="btn-small noBottomMargin">
                            <span>{{traducirFrase("Buscar")}}</span>
                            <input type="file" id="archivoAudio" />
                        </div>
                        <div class = "file-path-wrapper noBottomMargin">
                            <input class="file-path validate" type = "text"
                            v-bind:placeholder="traducirFrase('Selecciona el archivo de audio')" />
                        </div>
                    </div>
                </div>
            </div>
            <div class="col input-field col s12 no-margin" v-if="!pregunta.tieneArchivo">
                <p>
                    <label>
                        <input type="checkbox" v-model="pregunta.esPregenerado" class="archivoInput"/>
                        <span>{{traducirFrase("El TTS es pregenerado (El texto no debe incluir variables).")}}</span>
                    </label>
                </p>
            </div>
        </div>
        <div class="row dv-flex dv-centered noBottomMargin" v-if="pregunta.tipoPregunta === 1">
            <div class="dv-flex-grow-1 input-field col">
                <input type="number" v-bind:placeholder="traducirFrase('Duración')" id="duracion" v-model="pregunta.duracion">
                <label for="duracion" class="active">{{traducirFrase("Duración")}}</label>
            </div>
            <div class="dv-flex-grow-1 input-field col">
                <input type="number" v-bind:placeholder="traducirFrase('Número Máximo de Intentos')" id="numeroMax" v-model="pregunta.numeroMaximoIntentos">
                <label for="numeroMax" class="active">{{traducirFrase("Número Máximo de Intentos")}}</label>
            </div>
        </div>
        <div class="row dv-flex dv-centered noBottomMargin" >
            <div class="dv-flex-grow-1 input-field col" v-if="pregunta.tipoPregunta === 1">
                <select name="" id="selectorTipoRespuesta" class="browser-default" v-model="pregunta.tipoDeRespuestas" >
                    <option :value="1" selected>DTMF</option>
                    <option :value="2">{{traducirFrase("Palabra clave")}}</option>
                </select>
                <label for="selectorTipoRespuesta" class="active">{{traducirFrase("Tipo de respuesta")}}
                </label>
            </div>
            <div class="dv-flex-grow-1 input-field col">
                <select name="" id="selectorTipoAccion" class="browser-default" v-model="pregunta.tipoDeAccionDefecto">
                    <option :value="1">{{traducirFrase("Colgar")}}</option>
                    <option :value="2">{{traducirFrase("Transferir")}}</option>
                    <option :value="3">{{traducirFrase("Pregunta")}}</option>
                    <option :value="4">{{traducirFrase("Decisión")}}</option>
                </select>
                <label for="selectorTipoRespuesta" class="active">{{traducirFrase("Acción por defecto")}}</label>
            </div>
        </div>
        <div class="row dv-flex dv-centered no-margin">
            <div class="dv-flex-grow-1 input-field col" v-if="pregunta.tipoDeAccionDefecto === 2">
                <input type="text" id="telefonoInput" v-model="pregunta.valorDeAccionDefecto">
                <label for="telefonoInput" class="active">{{traducirFrase("Teléfono")}}</label>
            </div>
            <div class="dv-flex-grow-1 input-field col" v-if="pregunta.tipoDeAccionDefecto === 3">
                <select name="" id="selectorValorPregunta" class="browser-default" v-model="pregunta.valorDeAccionDefecto">
                    <option :value="-1">
                        {{traducirFrase("A sí misma")}}
                    </option>
                    <option v-for="v in preguntas" :key="v.value" :value="v.value">
                        {{ v.label }}
                    </option>
                </select>
                <label for="selectorValorPregunta" class="active">{{traducirFrase("Pregunta")}}</label>
            </div>
            <div class="dv-flex-grow-1 input-field col" v-if="pregunta.tipoDeAccionDefecto === 4">
                <select name="" id="selectorValorDecision" class="browser-default" v-model="pregunta.valorDeAccionDefecto">
                    <option v-for="v in decisiones" :key="v.value" :value="v.value">
                        {{ v.label }}
                    </option>
                </select>
                <label for="selectorValorDecision" class="active">{{traducirFrase("Decisión")}}</label>
            </div>
        </div>
    </div>
</modal-dialvox>