/*
switch (did.ruta) {
	case 'AGENT':
		did.menu = null;
		did.voicemail = '';
		did.telefono = '';
		did.extension = '';
		did.contextoExtension = '';
		did.grupoEntrada = '';
		did.metodoManejo = 'CID';
		did.metodoBusqueda = 'LB';
		did.campana = '';
		did.lista = '';
		break;
	case 'EXTEN':
		did.agente = '';
		did.menu = null;
		did.voicemail = '';
		did.telefono = '';
		did.grupoEntrada = '';
		did.metodoManejo = 'CID';
		did.metodoBusqueda = 'LB';
		did.campana = '';
		did.lista = '';
		break;
	case 'VOICEMAIL':
		did.agente = '';
		did.menu = null;
		did.telefono = '';
		did.extension = '';
		did.contextoExtension = '';
		did.grupoEntrada = '';
		did.metodoManejo = 'CID';
		did.metodoBusqueda = 'LB';
		did.campana = '';
		did.lista = '';
		break;
	case 'PHONE':
		did.agente = '';
		did.menu = null;
		did.voicemail = '';
		did.extension = '';
		did.contextoExtension = '';
		did.grupoEntrada = '';
		did.metodoManejo = 'CID';
		did.metodoBusqueda = 'LB';
		did.campana = '';
		did.lista = '';
		break;
	case 'IN_GROUP':
		did.agente = '';
		did.menu = null;
		did.voicemail = '';
		did.telefono = '';
		did.extension = '';
		did.contextoExtension = '';
		break;
	case 'CALLMENU':
		did.agente = '';
		did.voicemail = '';
		did.telefono = '';
		did.extension = '';
		did.contextoExtension = '';
		did.grupoEntrada = '';
		did.metodoManejo = 'CID';
		did.metodoBusqueda = 'LB';
		did.campana = '';
		did.lista = '';
		break;
}
*/
(function () {
	const newDID = () => {
		return {
			id: '',
			didExtension: '',
			descripcion: '',
			grabar: false,
			activo: false,
			ruta: '',
			agente: '',
			menu: null,
			voicemail: '',
			telefono: '',
			extension: '',
			contextoExtension: 'default',
			grupoEntrada: '',
			metodoManejo: 'CID',
			metodoBusqueda: 'LB',
			campana: '',
			lista: '',
			valorExtension: '',
			carrier: '',
		};
	};
	const app = new Vue({
		el: '#main',
		data() {
			return {
				// Variables para la tabla
				registros: [],
				loading: true,
				headers: [
					{ label: traducirFrase('Telefono'), key: 'DIDExtension' },
					{ label: traducirFrase('Alias'), key: 'Descripcion' },
					{ label: traducirFrase('Ruta'), key: 'Ruta' },
				],
				options: [
					{
						action: 'edit',
						tooltip: traducirFrase('Editar el telefono'),
						icon: 'edit',
					},
					{
						action: 'delete',
						tooltip: traducirFrase('Eliminar el telefono'),
						icon: 'delete',
					},
				],
				// Variables para los modales
				targets: {
					add: false,
					edit: false,
				},
				// Registrar
				one: newDID(),
				// Editar
				// Paginacion
				pagina: 1,
				cuenta: 1,
				texto: '',
				// Arreglos para los selects
				contextos: [


					{ value: 'default', label: 'Contexto por defecto' },
				],
				agentes: [],
				menus: [],
				campanas: [],
				listas: [],
				gruposEntrada: [],
				carriers: [],
				extensiones: [],
				metodosManejo: [
					{
						value: 'CID',
						label: traducirFrase(
							'Agregar un registro todo el tiempo'
						),
					},
					{
						value: 'CIDLOOKUPRL',
						label: traducirFrase('Buscar registro en una lista'),
					},
					{
						value: 'CIDLOOKUPRC',
						label: traducirFrase('Buscar registro en una campaña'),
					},
				],
				metodosBusqueda: [
					{ value: 'LB', label: 'LB - Load Balanced' },
					{ value: 'LO', label: 'Load Balanced Overflow' },
					{ value: 'SO', label: 'SO - Server Only' },
				],
			};
		},
		methods: {
			load() {
				let self = this;
				if (this.pagina > this.cuenta) {
					this.pagina = this.cuenta;
				}
				gen_rpost('IVR/listarTelefonosDID', {
					pagina: this.pagina - 1, //pagina: this.pagina - 1,
					texto: this.texto,
				})
					.then((results) => {
						self.registros = results.TelefonosDID;
						self.cuenta = Math.floor(+results.Cuenta / 15 + 1);
						if (results.Cuenta % 15 == 0) {
							self.cuenta--;
						}
						self.loading = false;
					})
					.catch((err) => {
						console.log(err);
					});
			},
			sendData(url, toggle) {
				let self = this;
				const did = {};
				Object.assign(did, this.one);
				did.activo = did.activo ? 'Y' : 'N';
				did.grabar = did.grabar ? 'Y' : 'N';
				if (did.extension === '') {
					did.extension = did.carrier + '' + did.valorExtension;
					did.contextoExtension = 'default';
				}
				handled_rpost(`IVR/${url}`, did)
					.then((res) => {
						if (self.pagina === 0) {
							window.location.reload();
						}
						self.load();
						self.toggle(toggle);
					})
					.catch((err) => console.log(err));
			},
			add(url, toggle) {
				this.sendData(url, toggle);
			},
			edit($evt) {
				let {
					id,
					DIDExtension: didExtension,
					Descripcion: descripcion,
					Grabar: grabar,
					Activo: activo,
					Ruta: ruta,
					Agente: agente,
					Menu: menu,
					Voicemail: voicemail,
					Telefono: telefono,
					Extension: extension,
					Contexto_Extension: contextoExtension,
					GrupoEntrada: grupoEntrada,
					MetodoManejo: metodoManejo,
					MetodoBusqueda: metodoBusqueda,
					Campana: campana,
					Lista: lista,
				} = $evt;
				this.one = {
					id,
					didExtension,
					descripcion,
					ruta,
					agente,
					menu,
					voicemail,
					telefono,
					extension,
					contextoExtension,
					grupoEntrada,
					metodoManejo,
					metodoBusqueda,
					campana,
					lista,
					grabar: grabar === 'Y',
					activo: activo === 'Y',
					valorExtension: '',
					carrier: '',
				};

				this.toggle('edit');
			},
			del($evt) {
				let self = this;
				conf_rpost(
					'IVR/borrarTelefonoDID',
					{
						id: $evt.id,
					},
					traducirFrase(
						'Continuar esta accion eliminara el telefono seleccionado'
					)
				)
					.then((result) => {
						self.load();
					})
					.catch((err) => {
						console.log(err);
					});
			},
			disable($evt) {
				gen_rpost('IVR/activarTelefonoDID', {
					id: $evt.id,
				})
					.then((result) => {})
					.catch((err) => {
						console.log(err);
					});
			},
			toggle(target) {
				const self = this;
				this.obtenetSelects(({ extensiones, carriers }) => {
					if (target == 'add') {
						self.one = newDID();
					} else {
						const extension = extensiones.find(
							(v) => v.value === self.one.extension
						);
						if (!extension) {
							for (let i = 0; i < carriers.length; i++) {
								const carrier = carriers[i];
								if (
									self.one.extension.indexOf(
										carrier.value
									) === 0
								) {
									self.one.carrier = carrier.value;
									self.one.valorExtension =
										self.one.extension.replace(
											carrier.value,
											''
										);
									self.one.extension = '';
									break;
								}
							}
							if (self.one.valorExtension === '') {
								self.one.valorExtension = self.one.extension;
								self.one.extension = '';
							}
						}
					}
					app.targets[target] = !app.targets[target];
				});
			},
			obtenetSelects(handle) {
				const self = this;
				const data = Promise.all([
					gen_rpost('Campanas/getCampaignsSelect', {}).then((r) => {
						const campana = r.Campanas.map((campana) => ({
							value: campana.campaign_id,
							label: campana.campaign_name,
						}));
						return campana;
					}),
					gen_rpost('Listas/getListsSelect', {}).then((r) => {
						const lista = r.Listas.map((lista) => ({
							value: lista.list_id,
							label: lista.list_name,
						}));
						return lista;
					}),
					gen_rpost('IVR/seleccionarMenus', {}).then((r) => {
						const menu = r.Menus.map((menu) => ({
							value: menu.id,
							label: menu.Nombre,
						}));
						return menu;
					}),
					gen_rpost('Usuarios/getUserSelect', {}).then((r) => {
						const usuario = r.usuarios.map((usuario) => ({
							value: usuario.user,
							label: usuario.full_name,
						}));
						return usuario;
					}),
					gen_rpost('GrupoDeEntrada/seleccionarIngroups', {}).then(
						(r) => {
							const menu = r.Ingroups.map((menu) => ({
								value: menu.id,
								label: menu.Nombre,
							}));
							return menu;
						}
					),
					gen_rpost('campanas/getCarriersSelect', {}).then((r) => {
						const ops = r.Registros.map((v) => ({
							value: v.id,
							label: v.nombre,
						}));
						return ops;
					}),
					gen_rpost('Telefono/seleccionarExtensiones', {}).then(
						(r) => {
							const ops = r.Extensiones.map((v) => ({
								value: v.Extension,
								label: v.Extension,
							}));
							return ops;
						}
					),
				]);
				data.then(
					([
						campanas,
						listas,
						menus,
						agentes,
						gruposEntrada,
						carriers,
						extensiones,
					]) => {
						self.campanas = campanas;
						self.listas = listas;
						self.menus = menus;
						self.agentes = agentes;
						self.gruposEntrada = gruposEntrada;
						self.carriers = carriers;
						self.extensiones = extensiones;
						if (handle) {
							handle({
								campanas,
								listas,
								menus,
								agentes,
								gruposEntrada,
								carriers,
								extensiones,
							});
						}
					}
				);
			},
		},
		computed: {
			validForm() {
				return this.one.didExtension !== '';
			},
		},
		watch: {
			pagina() {
				this.load();
			},
		},
		updated() {
			$('.tooltipped').tooltip();
		},
		mounted() {
			$('select').formSelect();
			let self = this;
			setInterval(self.load, 2000);
		},
	});

	app.load();
})();
