<?php

require_once "BASEPATH.php";

class ReporteHorarioAgente extends MY_Controller
{
    public function trata(&$out, $arreglo, &$lastLinePrinted)
    {
        $llaves = array_keys($arreglo);
        $llavesNoArreglos = array();
        $temp = array();
        for ($i = 0; $i < count($llaves); $i++) {
            if (!is_array($arreglo[$llaves[$i]])) {
                $llavesNoArreglos[] = $llaves[$i];
                $temp[] = $arreglo[$llaves[$i]];
            }
        }
        if (count($temp) > 0) {
            if ($llavesNoArreglos != $lastLinePrinted) {
                fputcsv($out, array_values($llavesNoArreglos));
                $lastLinePrinted = $llavesNoArreglos;
            }
            fputcsv($out, array_values($temp));
        }
        for ($i = 0; $i < count($llaves); $i++) {
            if (is_array($arreglo[$llaves[$i]])) {
                $temp2 = array();
                $temp2[0] = $llaves[$i];
                if (!is_numeric($temp2[0])) {
                    fputcsv($out, array_values($temp2));
                }

                $this->trata($out, $arreglo[$llaves[$i]], $lastLinePrinted);
            }
        }
    }
    private function ponZero($Cant)
    {
        return $Cant < 10 ? "0$Cant" : $Cant;
    }

    private function convertTime($tiempoSeg)
    {
        $Horas = intval($tiempoSeg / 3600);
        $tiempoSeg -= $Horas * 3600;
        $Minutos = intval($tiempoSeg / 60);
        $tiempoSeg -= $Minutos * 60;
        return $this->ponZero($Horas) . ":" . $this->ponZero($Minutos) . ":" . $this->ponZero($tiempoSeg);
    }

    private function sec_format($secs) {
        $secs = floor($secs);

        $Horas = intval($secs / 3600);
        $secs -= $Horas * 3600;
        $Minutos = intval($secs / 60);
        $secs -= $Minutos * 60;

        return $this->ponZero($Horas) . ":" . $this->ponZero($Minutos) . ":" . $this->ponZero($secs);
    }

    private function diffEventos($primer, $ultimo) {
        if ($primer == "-" || $ultimo == "-") {
            return array(
                "val" => 0,
                "format" => "00:00:00"
            );
        }

        $t_primer = new DateTime($primer);
        $t_ultimo = new DateTime($ultimo);
        $diff_eventos = $t_ultimo->diff($t_primer);
        if ($diff_eventos == FALSE) {
            $diff_eventos = DateInterval::createFromDateString("0 seconds");
        }

        $diff_hora = $diff_eventos->format("%H") * 3600;
        $diff_minutos = $diff_eventos->format("%I") * 60;
        $diff_segundos = $diff_eventos->format("%S");

        return array(
            "val" => $diff_hora + $diff_minutos + $diff_segundos,
            "format" => $diff_eventos->format("%H:%I:%S")
        );
    }

    private function itemTimeFormat($name, $seconds, $calls) {
        $prom = $calls == 0 ? 0 : floor($seconds / $calls);
        return array(
            $name => $seconds,
            $name . "_format" => $this->sec_format($seconds),
            $name . "_prom" => $prom,
            $name . "_prom_format" => $this->sec_format($prom)
        );
    }

    private function itemFormat($item) {
        return array_merge(
            $this->itemTimeFormat("talk", $item["talk"], $item["calls"]),
            $this->itemTimeFormat("pause", $item["pause"], $item["calls"]),
            $this->itemTimeFormat("wait", $item["wait"], $item["calls"]),
            $this->itemTimeFormat("wrapup", $item["wrapup"], $item["calls"]),
            $this->itemTimeFormat("total", $item["total"], $item["calls"]),
        );
    }

    private function trataResultado($item) {
        $item["acumulado_semana"]["diferencia_format"] = $this->sec_format(
            $item["acumulado_semana"]["diferencia"]
        );

        array_push(
            $item["fechas"],
            $item["acumulado_semana"]
        );

        foreach ($item["fechas"] as $i => $fecha) {
            $item["fechas"][$i] = array_merge(
                $this->itemFormat($fecha),
                array(
                    "llamadas" => $fecha["calls"],
                    "jornada" => $fecha["diferencia"],
                    "jornada_format" => $this->sec_format($fecha["diferencia"]),
                    "primer_login" => $fecha["primer_evento"],
                    "ultimo_logout" => $fecha["ultimo_evento"],
                    "agente" => "",
                    "nombre" => $fecha["fecha"]
                )
            );
        }

        $item["diferencia_formato"] = $this->sec_format($item["diferencia"]);

        return array_merge(
            $this->itemFormat($item),
            array(
                "llamadas" => $item["calls"],
                "jornada" => $item["diferencia"],
                "jornada_format" => $item["diferencia_formato"],
                "primer_login" => $item["primer_evento"],
                "ultimo_logout" => $item["ultimo_evento"],
                "porDia" => $item["fechas"],
                "agente" => isset($item["agente"]) ? $item["agente"] : "",
                "nombre" => isset($item["nombre"]) ? $item["nombre"] : ""
            )
        );
    }

    private function resultadoToCsv($item) {
        /*
            array(
                "Agente",
                "Nombre",
                "Total en llamada",
                "Promedio en llamada",
                "Total en pausa",
                "Promedio en pausa",
                "Total en espera",
                "Promedio en espera",
                "Total calificando",
                "Promedio calificando",
                "Primer login",
                "Ultimo logout",
                "Tiempo total conectado",
                "Jornada laboral",
                "Total de llamadas realizadas"
            )
        */

        return array(
            $item["agente"],
            $item["nombre"],
            $item["fecha"],
            $item["talk_format"],
            $item["talk_prom_format"],
            $item["pause_format"],
            $item["pause_prom_format"],
            $item["wait_format"],
            $item["wait_prom_format"],
            $item["wrapup_format"],
            $item["wrapup_prom_format"],
            $item["primer_login"],
            $item["ultimo_logout"],
            $item["total_format"],
            $item["jornada_format"],
            $item["llamadas"]
        );
    }

    public function agentTimeSheet()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";

        switch ($idioma) {
            case "es":
                $this->lang->load('reportehorarioagente', "spanish");
                break;
            case "en":
                $this->lang->load('reportehorarioagente', "english");
                break;
            default:
                $this->lang->load('reportehorarioagente', "spanish");
                break;
        }

        include_once RUTA_APP . 'Conexion.php';

        if (!empty($_SESSION["Usuario"]) && ($_SESSION["Grupo"] == GRUPO_ADMINS || $_SESSION["Grupo"] == GRUPO_SUPERVISORES)) {

            include_once RUTA_APP . 'Sesiones.php';
            $con = getConnection();

            $cliente = $_SESSION["Cliente"];

            $fechaInicio = limpia($_GET["fechaInicial"]);
            $fechaFin = limpia($_GET["fechaFinal"]);
            $agente = limpia($_GET["agente"]);
            $campana = limpia($_GET["campana"]);
            $archived = false;

            $sal = array();

            if (isset($_GET["archived"]) && limpia($_GET["archived"]) == 1) {
                $archived = true;
            }

            $queryCampanas = "SELECT campaign_id FROM vicidial_campaigns WHERE user_group='$cliente'";
            $queryAgente = "SELECT user FROM vicidial_users WHERE user_group LIKE '" . $cliente . "_%'";
            if ($_SESSION["Cliente"] == -1) {
                $queryCampanas = "SELECT campaign_id FROM vicidial_campaigns";
                $queryAgente = "SELECT user FROM vicidial_users";
            }

            if ($campana != -1 || $campana != "-1") {
                $queryCampanas .= " AND campaign_id = '$campana'";
            }
            if ($agente != -1 || $agente != "-1") {
                $queryAgente .= " AND user = '$agente'";
            }

            $tabla_query = "vicidial_agent_log";
            if ($archived) {
                $tabla_query = "vicidial_agent_log_archive";
            }

            $p_calls = "SUM(IF(lead_id > 0 AND status IS NOT NULL AND LENGTH(status) > 0, 1, 0 ))";
            $p_talk = "IF( val.talk_sec < 65000, val.talk_sec, 0 )";
            $p_pause = "IF( val.pause_sec < 65000, val.pause_sec, 0 )";
            $p_wait = "IF( val.wait_sec < 65000, val.wait_sec, 0 )";
            $p_dispo = "IF( val.dispo_sec < 65000, val.dispo_sec, 0 )";

            $query = "SELECT
                $p_calls as calls,
                SUM( $p_talk ) as talk_time,
                SUM( $p_pause ) as pause_time,
                SUM( $p_wait ) as wait_time,
                SUM( $p_dispo ) as wrapup_time,
                val.user as user,
                IFNULL(vu.full_name, val.user) as nombre,
                DATE(val.event_time) as fecha,
                WEEKDAY(val.event_time) as dia_semana
            FROM
                $tabla_query as val
            LEFT JOIN
                vicidial_users as vu
            ON
                val.user = vu.user
            WHERE
                DATE(event_time) <= DATE('$fechaFin') AND
                DATE(event_time) >= DATE('$fechaInicio') AND
                val.user IN ($queryAgente) AND
                campaign_id IN ($queryCampanas) 
            GROUP BY
                DATE(val.event_time), val.user
            ORDER BY
                DATE(val.event_time) ASC,
                val.user
            ";

            $sal["Resultados"] = array();
            $result = sv_mysqli_query($con, $query);

            $donde = 0;
            $totalLlamadas = $totalTiempoCharla = $totalTiempoPausa = $totalTiempoWrapup = $totalTiempoEspera = $totalTiempoEnActivo = 0;

            $mapa_resultados = array();
            $total_global = array(
                "agente" => "Total",
                "nombre" => "",
                "calls" => 0,
                "talk" => 0,
                "pause" => 0,
                "wait" => 0,
                "wrapup" => 0,
                "total" => 0,
                "primer_evento" => "-",
                "ultimo_evento" => "-",
                "diferencia_formato" => "-",
                "diferencia" => 0,
                "dia_semana" => -1,
                "fechas" => array(),
                "indices_fechas" => array(),
                "acumulado_semana" => array(
                    "fecha" => "Semana",
                    "calls" => 0,
                    "talk" => 0,
                    "pause" => 0,
                    "wait" => 0,
                    "wrapup" => 0,
                    "total" => 0,
                    "primer_evento" => "-",
                    "ultimo_evento" => "-",
                    "diferencia_formato" => "-",
                    "diferencia" => 0,
                    "dia_semana" => -1
                )
            );

            while ($row = sv_mysqli_fetch_array($result)) {

                $agente = $row["user"];
                $nombre = $row["nombre"];
                $fecha = $row["fecha"];
                $calls = $row["calls"];
                $talk_time = $row["talk_time"];
                $pause_time = $row["pause_time"];
                $wait_time = $row["wait_time"];
                $wrapup_time = $row["wrapup_time"];

                $dia_semana = $row["dia_semana"];

                $info = array();
                if (isset($mapa_resultados[$agente])) {
                    $info = $mapa_resultados[$agente];
                } else {
                    // ? Setup cuando se agregar al agente por primera vez
                    $info = array(
                        "agente" => $agente,
                        "nombre" => $nombre,
                        "calls" => 0,
                        "talk" => 0,
                        "pause" => 0,
                        "wait" => 0,
                        "wrapup" => 0,
                        "total" => 0,
                        "primer_evento" => "-",
                        "ultimo_evento" => "-",
                        "diferencia_formato" => "-",
                        "diferencia" => 0,
                        "dia_semana" => -1,
                        "fechas" => array(),
                        "acumulado_semana" => array(
                            "fecha" => "Semana",
                            "calls" => 0,
                            "talk" => 0,
                            "pause" => 0,
                            "wait" => 0,
                            "wrapup" => 0,
                            "total" => 0,
                            "primer_evento" => "-",
                            "ultimo_evento" => "-",
                            "diferencia_formato" => "-",
                            "diferencia" => 0,
                            "dia_semana" => -1
                        )
                    );

                    // ? Aqui se consultan los logins/logouts y se ponen en un mapa
                    $querySesiones = "SELECT
                        DATE(event_date) as fecha,
                        MAX(event_date) as ultimo_evento,
                        MIN(event_date) as primer_evento
                    FROM
                        vicidial_user_log as vul
                    WHERE
                        event IN ('LOGIN','LOGOUT') AND
                        user = '$agente' AND
                        DATE(event_date) >= DATE('$fechaInicio') AND
                        DATE(event_date) <= DATE('$fechaFin')
                    GROUP BY
                        DATE(event_date)
                    ORDER BY
                        DATE(event_date) ASC
                    ";
                    $resultadoSesiones = sv_mysqli_query($con, $querySesiones);

                    $mapa_sesiones = array();
                    while ($rowSesiones = sv_mysqli_fetch_array($resultadoSesiones)) {
                        $sesion_fecha = $rowSesiones["fecha"];
                        $ultimo_evento = $rowSesiones["ultimo_evento"];
                        $primer_evento = $rowSesiones["primer_evento"];

                        $diff = $this->diffEventos(
                            $primer_evento,
                            $ultimo_evento
                        );

                        $mapa_sesiones[$sesion_fecha] = array(
                            "primer_evento" => $primer_evento,
                            "ultimo_evento" => $ultimo_evento,
                            "diferencia_formato" => $diff["format"],
                            "diferencia" => $diff["val"]
                        );
                    }
                    $info["sesiones"] = $mapa_sesiones;
                }

                // ? Se revisa info de las sesiones
                    $sesion_del_dia = array(
                        "primer_evento" => "-",
                        "ultimo_evento" => "-",
                        "diferencia_formato" => "-",
                        "diferencia" => 0
                    );
                    if (isset($info["sesiones"][$fecha])) {
                        $sesion_del_dia = $info["sesiones"][$fecha];
                    }

                // ? Sumar info por semana

                // ? - Si el dia de la semana es mayor, se sigue acumulando, si no
                // ? - se agrega a los dias
                    if ($dia_semana > $info["acumulado_semana"]["dia_semana"]) {
                        $info["acumulado_semana"]["dia_semana"] = $dia_semana;
                    } else {
                        // ? - Formatear la diferencia
                            $diff = $info["acumulado_semana"]["diferencia"];
                            $diff_format = DateInterval::createFromDateString("$diff seconds");

                            $info["acumulado_semana"]["diferencia_formato"] = $diff_format->format("%H:%I:%S");

                        // ? - Agregar acumulado al array de dias
                            array_push(
                                $info["fechas"], 
                                $info["acumulado_semana"]
                            );

                        // ? - Vaciar acumulado de semana
                            $info["acumulado_semana"] = array(
                                "fecha" => "Semana",
                                "calls" => 0,
                                "talk" => 0,
                                "pause" => 0,
                                "wait" => 0,
                                "wrapup" => 0,
                                "total" => 0,
                                "primer_evento" => "-",
                                "ultimo_evento" => "-",
                                "diferencia_formato" => "-",
                                "diferencia" => 0,
                                "dia_semana" => $dia_semana
                            );
                    }

                // ? - Se actualiza la sesion de ultimo evento,
                // ? - si es nuevo se pone el primer y ultimo evento
                    if ($info["acumulado_semana"]["calls"] == 0) {
                        $info["acumulado_semana"] = array_merge(
                            $info["acumulado_semana"],
                            array(
                                "diferencia" => 0,
                                "diferencia_formato" => "-",
                                "primer_evento" => $sesion_del_dia["primer_evento"],
                                "ultimo_evento" => $sesion_del_dia["ultimo_evento"]
                            )
                        );
                    }
                    $info["acumulado_semana"]["ultimo_evento"] = $sesion_del_dia["ultimo_evento"];
                    $info["acumulado_semana"]["diferencia"] += $sesion_del_dia["diferencia"];

                // ? - Se agregan al acumulado semanal
                    $info["acumulado_semana"]["calls"] += $calls;
                    $info["acumulado_semana"]["talk"] += $talk_time;
                    $info["acumulado_semana"]["pause"] += $pause_time;
                    $info["acumulado_semana"]["wait"] += $wait_time;
                    $info["acumulado_semana"]["wrapup"] += $wrapup_time;
                    $info["acumulado_semana"]["total"] += $talk_time + $wait_time;


                // ? Sumar info total
                    $info["calls"] += $calls;
                    $info["talk"] += $talk_time;
                    $info["pause"] += $pause_time;
                    $info["wait"] += $wait_time;
                    $info["wrapup"] += $wrapup_time;
                    $info["total"] += $talk_time + $wait_time;

                // ? - Se guardan el primer y ultimo evento
                    if ($info["primer_evento"] == "-") {
                        $info["primer_evento"] = $sesion_del_dia["primer_evento"];
                    }
                    $info["ultimo_evento"] = $sesion_del_dia["ultimo_evento"];
                    $info["diferencia"] += $sesion_del_dia["diferencia"];

                // ? Info del dia
                    array_push(
                        $info["fechas"], 
                        array_merge(
                            array(
                                "fecha" => $fecha,
                                "calls" => $calls,
                                "talk" => $talk_time,
                                "pause" => $pause_time,
                                "wait" => $wait_time,
                                "wrapup" => $wrapup_time,
                                "total" => $talk_time + $wait_time,
                            ),
                            $sesion_del_dia
                        )
                    );

                // ? Guardar en Info
                $mapa_resultados[$agente] = $info;
                
                // ? Suma para los totales globales
                // ? - Cambio de semana
                    if ($dia_semana >= $total_global["acumulado_semana"]["dia_semana"]) {
                        $total_global["acumulado_semana"]["dia_semana"] = $dia_semana;
                    } else {
                        // ? - Agregar acumulado al array de dias
                            array_push(
                                $total_global["fechas"], 
                                $total_global["acumulado_semana"]
                            );
                        // ? - Vaciar acumulado
                            $total_global["acumulado_semana"] = array(
                                "fecha" => "Semana",
                                "calls" => 0,
                                "talk" => 0,
                                "pause" => 0,
                                "wait" => 0,
                                "wrapup" => 0,
                                "total" => 0,
                                "primer_evento" => "-",
                                "ultimo_evento" => "-",
                                "diferencia_formato" => "-",
                                "diferencia" => 0,
                                "dia_semana" => $dia_semana
                            );                            
                    }

                // ? - Agregar a semana
                    $total_global["acumulado_semana"]["calls"] += $calls;
                    $total_global["acumulado_semana"]["talk"] += $talk_time;
                    $total_global["acumulado_semana"]["pause"] += $pause_time;
                    $total_global["acumulado_semana"]["wait"] += $wait_time;
                    $total_global["acumulado_semana"]["wrapup"] += $wrapup_time;
                    $total_global["acumulado_semana"]["total"] += $talk_time + $wait_time;

                // ? - Saco el indice del arreglo para la fecha
                    $indice_fecha = count($total_global["fechas"]);
                    if (isset($total_global["indices_fechas"][$fecha])) {
                        $indice_fecha = $total_global["indices_fechas"][$fecha];
                    } else {
                        $total_global["indices_fechas"][$fecha] = $indice_fecha;
                    }

                    $total_global["calls"] += $calls;
                    $total_global["talk"] += $talk_time;
                    $total_global["pause"] += $pause_time;
                    $total_global["wait"] += $wait_time;
                    $total_global["wrapup"] += $wrapup_time;
                    $total_global["total"] += $talk_time + $wait_time;
                    $total_global["diferencia"] += $sesion_del_dia["diferencia"];

                // ? - Setup del dia/fecha actual
                    if (!isset($total_global["fechas"][$indice_fecha])) {
                        $total_global["fechas"][$indice_fecha] = array(
                            "fecha" => $fecha,
                            "calls" => 0,
                            "talk" => 0,
                            "pause" => 0,
                            "wait" => 0,
                            "wrapup" => 0,
                            "total" => 0,
                            "primer_evento" => "-",
                            "ultimo_evento" => "-",
                            "diferencia_formato" => "-",
                            "diferencia" => 0
                        );
                    }

                    $total_global["fechas"][$indice_fecha]["fecha"] = $fecha;
                    $total_global["fechas"][$indice_fecha]["calls"] += $calls;
                    $total_global["fechas"][$indice_fecha]["talk"] += $talk_time;
                    $total_global["fechas"][$indice_fecha]["pause"] += $pause_time;
                    $total_global["fechas"][$indice_fecha]["wait"] += $wait_time;
                    $total_global["fechas"][$indice_fecha]["wrapup"] += $wrapup_time;
                    $total_global["fechas"][$indice_fecha]["total"] += $talk_time + $wait_time;

                /*
                    $TOTAL_TIME = $row[8];

                    //Actualmente calcula el tiempo conectado,pero no coincide con
                    //el tiempo entre el primer inicio de sesión y el último cierre de sesión
                    // Dado que el tiempo conectado es mayor que el tiempo entre el primer inicio de sesión y el último cierre de sesión

                    $TOTAL_TIME_HMS = $row[1] + $row[5];
                    $TALK_TIME_HMS = $row[1];
                    $PAUSE_TIME_HMS = $row[3];
                    $WAIT_TIME_HMS = $row[5];
                    $WRAPUP_TIME_HMS = $row[7];

                    // $TOTAL_TIME_HMS = $TALK_TIME_HMS + $PAUSE_TIME_HMS + $WAIT_TIME_HMS + $WRAPUP_TIME_HMS;

                    $TALK_AVG_MS = $row[2];
                    $PAUSE_AVG_MS = $row[4];
                    $WAIT_AVG_MS = $row[6];
                    $WRAPUP_AVG_MS = $row[9];
                    $user = $sal["Resultados"][$donde]["usuario"] = $row[10];

                    $query2 = "SELECT DATE(event_date) as fecha,MAX(event_date) as maximo,MIN(event_date) as minimo  FROM vicidial_user_log AS vul WHERE event  IN ('LOGIN','LOGOUT') AND user='$user' AND DATE(event_date) BETWEEN DATE('$fechaInicio') AND DATE('$fechaFin')  GROUP BY DATE(event_date) ORDER BY DATE(event_date) DESC";
                    $sal["Resultados"][$donde]["HoraEntradaSalida"] = array();
                    $result2 = sv_mysqli_query($con, $query2);
                    while ($row2 = sv_mysqli_fetch_array($result2)) {
                        $tiempoInicio = new DateTime($row2["maximo"]);
                        $tiempoFinal = new DateTime($row2["minimo"]);
                        $resultado = $tiempoInicio->diff($tiempoFinal);
                        if ($resultado === false) {
                            $resultado = "Ay drake, valio verga";
                        }

                        $sal["Resultados"][$donde]["HoraEntradaSalida"][] = array_merge($row2,
                        array(
                            "Diferencia" => $resultado->format("%H:%I:%S"),
                            //Esto debe devolver la cantidad de segundos
                            "DiferenciaTiempo" =>  $resultado->format("%H")*3600 + $resultado->format("%I")*60 + $resultado->format("%S"),
                            )
                        );
                    }
                    $sal["Resultados"][$donde]["nombre"] = $row[11];
                    $sal["Resultados"][$donde]["total"] = $row[0];
                    $sal["Resultados"][$donde]["tiempoCharla"] = $TALK_TIME_HMS;
                    $sal["Resultados"][$donde]["promedioTiempoCharla"] = $TALK_AVG_MS;
                    $sal["Resultados"][$donde]["tiempoPausa"] = $PAUSE_TIME_HMS;
                    $sal["Resultados"][$donde]["promedioTiempoPausa"] = $PAUSE_AVG_MS;
                    $sal["Resultados"][$donde]["tiempoWrapup"] = $WRAPUP_TIME_HMS;
                    $sal["Resultados"][$donde]["promedioTiempoWrapup"] = $WRAPUP_AVG_MS;
                    $sal["Resultados"][$donde]["tiempoEspera"] = $WAIT_TIME_HMS;
                    $sal["Resultados"][$donde]["promedioTiempoEspera"] = $WAIT_AVG_MS;
                    $sal["Resultados"][$donde++]["tiempoTotalEnActivo"] = $TOTAL_TIME_HMS;
                    $totalTiempoCharla += $TALK_TIME_HMS;
                    $totalTiempoPausa += $PAUSE_TIME_HMS;
                    $totalTiempoWrapup += $WRAPUP_TIME_HMS;
                    $totalTiempoEspera += $WAIT_TIME_HMS;
                    $totalTiempoEnActivo += $TOTAL_TIME_HMS;
                    $totalLlamadas += $row[0];
                */
            }

            $resultados = array();
            foreach (array_values($mapa_resultados) as $k => $resultado) {
                array_push(
                    $resultados,
                    $this->trataResultado($resultado)
                );
            }

            $total_global = $this->trataResultado($total_global);
            
            $sal["Resultados"] = array(
                "registros" => $resultados,
                "total" => $total_global
            );

            // $sal["TotalTiempoCharla"] = $totalTiempoCharla;
            // $sal["TotalTiempoPausa"] = $totalTiempoPausa;
            // $sal["TotalTiempoWrapup"] = $totalTiempoWrapup;
            // $sal["TotalTiempoEspera"] = $totalTiempoEspera;
            // $sal["TotalTiempoEnActivo"] = $totalTiempoEnActivo;
            // $sal["TotalLlamadasHechas"] = $totalLlamadas;
            sv_mysqli_close($con);
            if (!isset($_GET["csv"])) {
                $sal["Estado"] = "ok";
                $this->output->set_output(json_encode($sal));
            } else {
                header('Content-Type: application/csv');
                header("Content-Disposition: attachment; filename=ReporteHorarioAgente.csv");
                ob_clean();
                $out = fopen('php://output', 'w');

                fputcsv($out, array(
                    "Agente",
                    "Nombre",
                    "Fecha",
                    "Total en llamada",
                    "Promedio en llamada",
                    "Total en pausa",
                    "Promedio en pausa",
                    "Total en espera",
                    "Promedio en espera",
                    "Total calificando",
                    "Promedio calificando",
                    "Primer login",
                    "Ultimo logout",
                    "Tiempo total conectado",
                    "Jornada laboral",
                    "Total de llamadas realizadas"
                ));

                foreach ($resultados as $resultado) {
                    foreach ($resultado["porDia"] as $fecha) {
                        $fecha["agente"] = $resultado["agente"];
                        $fecha["fecha"] = $fecha["nombre"];
                        $fecha["nombre"] = $resultado["nombre"];

                        if ($fecha["fecha"] == "Semana") {
                            $fecha["fecha"] = "Total semanal";
                        }

                        fputcsv(
                            $out,
                            $this->resultadoToCsv($fecha)
                        );
                    }
                }

                $total_global["fecha"] = "";
                fputcsv(
                    $out,
                    $this->resultadoToCsv($total_global)
                );

                fclose($out);

                /*
                    $sal["TotalTiempoEnActivo"] = $this->convertTime($sal["TotalTiempoEnActivo"]);
                    $sal["TotalTiempoPausa"] = $this->convertTime($sal["TotalTiempoPausa"]);
                    $sal["TotalTiempoCharla"] = $this->convertTime($sal["TotalTiempoCharla"]);
                    $sal["TotalTiempoWrapup"] = $this->convertTime($sal["TotalTiempoWrapup"]);
                    $sal["TotalTiempoEspera"] = $this->convertTime($sal["TotalTiempoEspera"]);
                    foreach ($sal["Resultados"] as &$reg) {
                        $reg["tiempoCharla"] = $this->convertTime($reg["tiempoCharla"]);
                        $reg["promedioTiempoCharla"] = $this->convertTime($reg["promedioTiempoCharla"]);
                        $reg["tiempoPausa"] = $this->convertTime($reg["tiempoPausa"]);
                        $reg["promedioTiempoPausa"] = $this->convertTime($reg["promedioTiempoPausa"]);
                        $reg["tiempoWrapup"] = $this->convertTime($reg["tiempoWrapup"]);
                        $reg["promedioTiempoWrapup"] = $this->convertTime($reg["promedioTiempoWrapup"]);
                        $reg["tiempoEspera"] = $this->convertTime($reg["tiempoEspera"]);
                        $reg["promedioTiempoEspera"] = $this->convertTime($reg["promedioTiempoEspera"]);
                        $reg["tiempoTotalEnActivo"] = $this->convertTime($reg["tiempoTotalEnActivo"]);
                    }
                    header('Content-Type: application/csv');
                    header("Content-Disposition: attachment; filename=ReporteHorarioAgente.csv");
                    ob_clean();
                    $out = fopen('php://output', 'w');
                    fwrite($out, "{$this->lang->line('header_1')},{$this->lang->line('header_2')},{$this->lang->line('header_3')},{$this->lang->line('header_4')},{$this->lang->line('header_5')},{$this->lang->line('header_6')},{$this->lang->line('header_7')},{$this->lang->line('header_8')},{$this->lang->line('header_9')},{$this->lang->line('header_10')},{$this->lang->line('header_11')},{$this->lang->line('header_12')}\n");
                    foreach ($sal["Resultados"] as $value) {
                        fwrite($out, "{$value['usuario']},{$value['nombre']},{$value['tiempoCharla']},{$value['promedioTiempoCharla']},{$value['tiempoPausa']},{$value['promedioTiempoPausa']},{$value['tiempoEspera']},{$value['promedioTiempoEspera']},{$value['tiempoWrapup']},{$value['promedioTiempoWrapup']},{$value['tiempoTotalEnActivo']},{$value['total']}\n");
                    }
                    fwrite($out, ",,{$sal['TotalTiempoCharla']},,{$sal['TotalTiempoPausa']},,{$sal['TotalTiempoEspera']},,{$sal['TotalTiempoWrapup']},,{$sal['TotalTiempoEnActivo']},{$sal['TotalLlamadasHechas']}\n");
                    fclose($out);
                */
            }
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_SinPermisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function index()
    {
        $this->load->view('reporteHorarioAgente/head');
        $this->load->view('reporteHorarioAgente/vw_reporte_horario_agente');
        $this->load->view('reporteHorarioAgente/foot');
    }
}
