<?php

require_once "BASEPATH.php";

class Encuestas extends MY_Controller
{

    public function assocInboundEncuesta()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('encuestas', "spanish");
                break;
            case "en":
                $this->lang->load('encuestas', "english");
                break;
            default:
                $this->lang->load('encuestas', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $group_id = limpia($_POST["group_id"]);
            $id_encuesta = limpia($_POST["id_encuesta"]);

            $donde = "";
            $cliente = $_SESSION["Cliente"];
            if ($cliente != -1) {
                $donde = " AND cliente = '$cliente'";
            }
            $query = "SELECT id_encuesta FROM dialvox_encuestas WHERE id_encuesta='$id_encuesta' $donde LIMIT 1";
            $result = sv_mysqli_query($con, $query);
            if (sv_mysqli_num_rows($result) == 1) {
                $sal["Estado"] = "ok";
                $query = "INSERT dialvox_inbound_encuesta(group_id,id_encuesta) VALUES('$group_id','$id_encuesta')";
                sv_mysqli_query($con, $query);
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_noExisteEncuesta");
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }

    public function desassocInboundEncuesta()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('encuestas', "spanish");
                break;
            case "en":
                $this->lang->load('encuestas', "english");
                break;
            default:
                $this->lang->load('encuestas', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $group_id = limpia($_POST["group_id"]);
            $id_encuesta = limpia($_POST["id_encuesta"]);

            $donde = "";
            $cliente = $_SESSION["Cliente"];
            if ($cliente != -1) {
                $donde = " AND cliente = '$cliente'";
            }
            $sal["Estado"] = "ok";
            $query = "DELETE FROM dialvox_inbound_encuesta WHERE id_encuesta='$id_encuesta' AND group_id='$group_id'";
            sv_mysqli_query($con, $query);
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }

    public function assocCampaignEncuesta()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('encuestas', "spanish");
                break;
            case "en":
                $this->lang->load('encuestas', "english");
                break;
            default:
                $this->lang->load('encuestas', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $campaign_id = limpia($_POST["campaign_id"]);
            $id_encuesta = limpia($_POST["id_encuesta"]);

            $donde = "";
            $cliente = $_SESSION["Cliente"];
            if ($cliente != -1) {
                $donde = " AND cliente = '$cliente'";
            }
            $query = "SELECT id_encuesta FROM dialvox_encuestas WHERE id_encuesta='$id_encuesta' $donde LIMIT 1";
            $result = sv_mysqli_query($con, $query);
            if (sv_mysqli_num_rows($result) == 1) {
                $sal["Estado"] = "ok";
                $query = "INSERT dialvox_campaign_encuesta(campaign_id,id_encuesta) VALUES('$campaign_id','$id_encuesta')";
                sv_mysqli_query($con, $query);
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_noExisteEncuesta");
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }

    public function desassocCampaignEncuesta()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('encuestas', "spanish");
                break;
            case "en":
                $this->lang->load('encuestas', "english");
                break;
            default:
                $this->lang->load('encuestas', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $campaign_id = limpia($_POST["campaign_id"]);
            $id_encuesta = limpia($_POST["id_encuesta"]);

            $donde = "";
            $cliente = $_SESSION["Cliente"];
            if ($cliente != -1) {
                $donde = " AND cliente = '$cliente'";
            }
            $sal["Estado"] = "ok";
            $query = "DELETE FROM dialvox_campaign_encuesta WHERE id_encuesta='$id_encuesta' AND campaign_id='$campaign_id'";
            sv_mysqli_query($con, $query);
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }

    public function defaultCampaignEncuesta()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('encuestas', "spanish");
                break;
            case "en":
                $this->lang->load('encuestas', "english");
                break;
            default:
                $this->lang->load('encuestas', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $campaign_id = limpia($_POST["campaign_id"]);
            $id_encuesta = limpia($_POST["id_encuesta"]);

            $donde = "";
            $cliente = $_SESSION["Cliente"];
            if ($cliente != -1) {
                $donde = " AND cliente = '$cliente'";
            }
            $query = "SELECT id_encuesta FROM dialvox_encuestas WHERE id_encuesta='$id_encuesta' $donde LIMIT 1";
            $result = sv_mysqli_query($con, $query);
            if (sv_mysqli_num_rows($result) == 1) {

                $query = "SELECT * FROM dialvox_campaign_encuesta WHERE id_encuesta='$id_encuesta' AND campaign_id='$campaign_id' AND is_default=TRUE";
                $result = sv_mysqli_query($con, $query);

                if (sv_mysqli_num_rows($result) == 1) {
                    $query = "UPDATE dialvox_campaign_encuesta SET is_default=FALSE WHERE campaign_id='$campaign_id' AND id_encuesta='$id_encuesta'";
                    sv_mysqli_query($con, $query);
                } else {
                    $query = "UPDATE dialvox_campaign_encuesta SET is_default=FALSE WHERE campaign_id='$campaign_id'";
                    sv_mysqli_query($con, $query);
                    $query = "UPDATE dialvox_campaign_encuesta SET is_default=TRUE WHERE campaign_id='$campaign_id' AND id_encuesta='$id_encuesta'";
                    sv_mysqli_query($con, $query);
                }
                $sal["Estado"] = "ok";
            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_noExisteEncuesta");
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }

    public function getEncuestasByCampaign()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('encuestas', "spanish");
                break;
            case "en":
                $this->lang->load('encuestas', "english");
                break;
            default:
                $this->lang->load('encuestas', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $campaign_id = limpia($_GET["campaign_id"]);

            $donde = "";
            $cliente = $_SESSION["Cliente"];
            if ($cliente != -1) {
                $donde = " AND cliente = '$cliente'";
            }
            $sal["Registros"] = array();
            $sal["Estado"] = "ok";
            $query = "SELECT DCE.id_encuesta as id_encuesta,DE.nombre as nombre, DCE.is_default as is_default FROM dialvox_campaign_encuesta AS DCE INNER JOIN dialvox_encuestas AS DE ON DE.id_encuesta=DCE.id_encuesta WHERE DCE.campaign_id='$campaign_id' $donde";
            $result = sv_mysqli_query($con, $query);
            while ($row = sv_mysqli_fetch_array($result)) {
                $sal["Registros"][] = $row;
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function getEncuestasByInbound()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('encuestas', "spanish");
                break;
            case "en":
                $this->lang->load('encuestas', "english");
                break;
            default:
                $this->lang->load('encuestas', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $group_id = limpia($_GET["group_id"]);

            $donde = "";
            $cliente = $_SESSION["Cliente"];
            if ($cliente != -1) {
                $donde = " AND cliente = '$cliente'";
            }
            $sal["Registros"] = array();
            $sal["Estado"] = "ok";
            $query = "SELECT DIE.id_encuesta as id_encuesta , DE.nombre as nombre FROM dialvox_inbound_encuesta AS DIE INNER JOIN dialvox_encuestas AS DE ON DE.id_encuesta=DIE.id_encuesta WHERE DIE.group_id='$group_id' $donde";
            $result = sv_mysqli_query($con, $query);
            while ($row = sv_mysqli_fetch_array($result)) {
                $sal["Registros"][] = $row;
            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function getEncuestas()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('encuestas', "spanish");
                break;
            case "en":
                $this->lang->load('encuestas', "english");
                break;
            default:
                $this->lang->load('encuestas', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $pagina = limpia($_GET["pagina"]) - 1;
            $donde = "";
            $cliente = $_SESSION["Cliente"];
            if ($cliente != -1) {
                $donde = "WHERE cliente = '$cliente'";
            }
            $sal["Registros"] = array();
            $sal["Estado"] = "ok";
            $query = "SELECT id_encuesta,nombre FROM dialvox_encuestas $donde LIMIT " . ($pagina * 10) . ", 10";
            $result = sv_mysqli_query($con, $query);
            while ($row = sv_mysqli_fetch_array($result)) {
                $sal["Registros"][] = $row;
            }

            $query = "SELECT COUNT(id_encuesta) AS CANT FROM dialvox_encuestas $donde ";
            $result = sv_mysqli_query($con, $query);
            if ($row = sv_mysqli_fetch_array($result)) {
                $sal["Cant"] = $row["CANT"];
            }

            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function getEncuestasSelect()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('encuestas', "spanish");
                break;
            case "en":
                $this->lang->load('encuestas', "english");
                break;
            default:
                $this->lang->load('encuestas', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $donde = "";
            $cliente = $_SESSION["Cliente"];
            if ($cliente != -1) {
                $donde = "WHERE cliente = '$cliente'";
            }
            $sal["Registros"] = array();
            $sal["Estado"] = "ok";
            $query = "SELECT id_encuesta,nombre,id_pregunta FROM dialvox_encuestas $donde ";
            $result = sv_mysqli_query($con, $query);
            while ($row = sv_mysqli_fetch_array($result)) {
                $sal["Registros"][] = $row;
            }

            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function addEncuesta()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('encuestas', "spanish");
                break;
            case "en":
                $this->lang->load('encuestas', "english");
                break;
            default:
                $this->lang->load('encuestas', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $nombre = limpia($_POST["nombre"]);
            $cliente = $_SESSION["Cliente"];
            $voz = limpia($_POST["voz"]);
            $query = "INSERT INTO dialvox_encuestas(nombre,cliente,voz) VALUES ('$nombre','$cliente','$voz')";
            sv_mysqli_query($con, $query);
            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }

    public function getEncuestaDetails()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('encuestas', "spanish");
                break;
            case "en":
                $this->lang->load('encuestas', "english");
                break;
            default:
                $this->lang->load('encuestas', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_encuesta = limpia($_POST["id_encuesta"]);
            $query = "SELECT * FROM dialvox_encuestas WHERE id_encuesta='$id_encuesta' AND cliente='$cliente'";
            $result = sv_mysqli_query($con, $query);
            if ($row = sv_mysqli_fetch_array($result)) {
                $sal["Encuesta"] = $row;
                $sal["Estado"] = "ok";

            } else {
                $sal["Estado"] = "error";
                $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");

            }
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);

        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function deleteEncuesta()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('encuestas', "spanish");
                break;
            case "en":
                $this->lang->load('encuestas', "english");
                break;
            default:
                $this->lang->load('encuestas', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_encuesta = limpia($_POST["id_encuesta"]);
            $query = "DELETE FROM dialvox_encuestas WHERE id_encuesta='$id_encuesta' AND cliente='$cliente'";
            sv_mysqli_query($con, $query);

            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }
    public function editEncuesta()
    {
        $idioma = isset($_COOKIE["idioma"]) ? $_COOKIE["idioma"] : "es";
        switch ($idioma) {
            case "es":
                $this->lang->load('encuestas', "spanish");
                break;
            case "en":
                $this->lang->load('encuestas', "english");
                break;
            default:
                $this->lang->load('encuestas', "spanish");
                break;
        }
        include_once RUTA_APP . 'Conexion.php';
        if (!empty($_SESSION["Usuario"])) {
            header('Content-type: application/json');
            include_once RUTA_APP . 'Sesiones.php';
            $sal = array();
            $con = getConnection();
            $cliente = $_SESSION["Cliente"];
            $id_encuesta = limpia($_POST["id_encuesta"]);
            $nombre = limpia($_POST["nombre"]);
            $query = "UPDATE dialvox_encuestas SET nombre='$nombre' WHERE id_encuesta='$id_encuesta' AND cliente='$cliente'";
            sv_mysqli_query($con, $query);

            $sal["Estado"] = "ok";
            $this->output->set_output(json_encode($sal));
            sv_mysqli_close($con);
        } else {
            $sal = array();
            $sal["Estado"] = "error";
            $sal["Descripcion"] = $this->lang->line("desc_permisosAccion");
            $this->output->set_output(json_encode($sal));
        }
    }

    public function index()
    {
        $this->load->view("encuestas/head");
        $this->load->view('encuestas/vw_encuestas');
        $this->load->view('encuestas/foot');
    }
}
