<?php
require_once 'TelefonoDID.php';
require_once RUTA_APP . 'Conexion.php';
class TelefonoDIDDatos
{
    public static function getTelefonosDIDByCliente($cliente, $pagina, $limite, $texto)
    {
        $con = getConnection();
        $query = "SELECT * FROM vicidial_inbound_dids WHERE user_group = '" . limpia($cliente->getId()) . "' AND did_pattern LIKE '%" . limpia($texto) . "%' LIMIT " . limpia($pagina * $limite) . "," . limpia($limite);
        $resp = [];
        $result = sv_mysqli_query($con, $query);
        while ($row = sv_mysqli_fetch_array($result)) {
            array_push($resp, new TelefonoDID(
                $row["did_id"],
                $row["did_pattern"],
                $row["phone"],
                $row["did_description"],
                ClienteDatos::getClienteById($row["user_group"]),
                $row["did_route"],
                $row["record_call"],
                $row["exten_context"],
                $row["extension"],
                $row["user"],
                MenuDatos::getMenuById($row["menu_id"]),
                $row["voicemail_ext"],
                $row["group_id"],
                $row["did_active"],
                $row["campaign_id"],
                $row["list_id"]
            ));
        }
        sv_mysqli_close($con);
        return $resp;
    }
    public static function countTelefonosDIDByCliente($cliente, $texto)
    {
        $con = getConnection();
        $query = "SELECT COUNT(did_id) AS CUENTA FROM vicidial_inbound_dids WHERE user_group = '" . limpia($cliente->getId()) . "' AND did_pattern LIKE '%" . limpia($texto) . "%'";
        if ($result = sv_mysqli_query($con, $query)) {
            if ($row = sv_mysqli_fetch_array($result)) {
                $resp = $row["CUENTA"];
                sv_mysqli_close($con);
                return $resp;
            } else {
                sv_mysqli_close($con);
                return -1;
            }
        } else {
            sv_mysqli_close($con);
            return -1;
        }
    }

    public static function getTelefonosDID($pagina, $limite, $texto)
    {
        $con = getConnection();
        $query = "SELECT * FROM vicidial_inbound_dids WHERE did_pattern LIKE '%" . limpia($texto) . "%' LIMIT " . limpia($pagina * $limite) . "," . limpia($limite);
        $resp = [];
        $result = sv_mysqli_query($con, $query);
        while ($row = sv_mysqli_fetch_array($result)) {
            array_push($resp, new TelefonoDID(
                $row["did_id"],
                $row["did_pattern"],
                $row["phone"],
                $row["did_description"],
                ClienteDatos::getClienteById($row["user_group"]),
                $row["did_route"],
                $row["record_call"],
                $row["exten_context"],
                $row["extension"],
                $row["user"],
                MenuDatos::getMenuById($row["menu_id"]),
                $row["voicemail_ext"],
                $row["group_id"],
                $row["did_active"],
                $row["campaign_id"],
                $row["list_id"]
            ));
        }
        sv_mysqli_close($con);
        return $resp;
    }
    public static function getAllTelefonosDID()
    {
        $con = getConnection();
        $query = "SELECT * FROM vicidial_inbound_dids";
        $resp = [];
        $result = sv_mysqli_query($con, $query);
        while ($row = sv_mysqli_fetch_array($result)) {
            array_push($resp, new TelefonoDID(
                $row["did_id"],
                $row["did_pattern"],
                $row["did_description"],
                $row["did_active"]
            ));
        }
        sv_mysqli_close($con);
        return $resp;
    }
    public static function getAllTelefonosDIDByCliente($cliente)
    {
        $con = getConnection();
        $query = "SELECT * FROM vicidial_inbound_dids WHERE user_group = '" . limpia($cliente->getId()) . "'";
        $resp = [];
        $result = sv_mysqli_query($con, $query);
        while ($row = sv_mysqli_fetch_array($result)) {
            array_push($resp, new TelefonoDID(
                $row["did_id"],
                $row["did_pattern"],
                $row["did_description"],
                $row["did_active"]
            ));
        }
        sv_mysqli_close($con);
        return $resp;
    }
    public static function getTelefonoDIDById($id)
    {
        $con = getConnection();
        $query = "SELECT * FROM vicidial_inbound_dids WHERE did_id = '" . $id . "'";
        $resp = null;
        $result = sv_mysqli_query($con, $query);
        if ($row = sv_mysqli_fetch_array($result)) {
            $resp = new TelefonoDID(
                $row["did_id"],
                $row["did_pattern"],
                $row["phone"],
                $row["did_description"],
                ClienteDatos::getClienteById($row["user_group"]),
                $row["did_route"],
                $row["record_call"],
                $row["exten_context"],
                $row["extension"],
                $row["user"],
                MenuDatos::getMenuById($row["menu_id"]),
                $row["voicemail_ext"],
                $row["group_id"],
                $row["did_active"],
                $row["campaign_id"],
                $row["list_id"]
            );
        }
        sv_mysqli_close($con);
        return $resp;
    }
    public static function countTelefonosDID($texto)
    {
        $con = getConnection();
        $query = "SELECT COUNT(did_id)  AS CUENTA FROM vicidial_inbound_dids WHERE  phone LIKE '%" . limpia($texto) . "%'";
        if ($result = sv_mysqli_query($con, $query)) {
            if ($row = sv_mysqli_fetch_array($result)) {
                $resp = $row["CUENTA"];
                sv_mysqli_close($con);
                return $resp;
            } else {
                sv_mysqli_close($con);
                return -1;
            }
        } else {
            sv_mysqli_close($con);
            return -1;
        }
    }
    public static function getLastId()
    {
        $con = getConnection();
        $query = "SELECT did_id FROM vicidial_inbound_dids ORDER BY did_id DESC LIMIT 1";
        $result = sv_mysqli_query($con, $query);
        $id = 10;
        if ($row = sv_mysqli_fetch_array($result)) {
            $id = $row["did_id"];
        }
        sv_mysqli_close($con);
        return $id;
    }
    public static function updateTelefonoDID($telefonodid)
    {
        $con = getConnection();
        $id = self::getLastId() + 1;
        $menu = $telefonodid->getMenu();
        if ($menu == null) {
            $menu = "NONE";
        } else {
            $menu = $menu->getId();
        }
        $query = "UPDATE vicidial_inbound_dids SET
				phone = '" . limpia($telefonodid->getTelefono()) . "',
				did_description = '" . limpia($telefonodid->getDescripcion()) . "',
				did_route = '" . limpia($telefonodid->getRuta()) . "',
				record_call = '" . limpia($telefonodid->getGrabar()) . "',
				exten_context = '" . limpia($telefonodid->getExtencionContext()) . "',
				extension = '" . limpia($telefonodid->getExtencion()) . "',
				user = '" . limpia($telefonodid->getAgente()) . "',
				menu_id = '" . $menu . "',
				voicemail_ext = '" . limpia($telefonodid->getVoicemail()) . "',
				group_id = '" . limpia($telefonodid->getCampana()) . "',
				did_active = '" . limpia($telefonodid->getActivo()) . "',
				list_id = '" . limpia($telefonodid->getListId()) . "',
				campaign_id = '" . limpia($telefonodid->getRealCampana()) . "',

			WHERE did_id = '" . limpia($telefonodid->getId()) . "'
			LIMIT 1";
        $resp = 0;
        if (sv_mysqli_query($con, $query)) {
            $resp = 0;
            sv_mysqli_query($con, "UPDATE servers set rebuild_conf_files='Y' where generate_vicidial_conf='Y' and active_asterisk_server='Y'");
        } else {
            $resp = -1;
        }
        sv_mysqli_close($con);
        return $resp;
    }
    public static function insertTelefonoDID($telefonodid)
    {
        $con = getConnection();
        $id = self::getLastId() + 1;
        $menu = $telefonodid->getMenu();
        if ($menu == null) {
            $menu = "NONE";
        } else {
            $menu = $menu->getId();
        }
        $query = "INSERT INTO vicidial_inbound_dids  (did_id,did_pattern, phone, did_description, user_group, did_route, record_call, exten_context, extension, user, menu_id, voicemail_ext, group_id, did_active,list_id,campaign_id,server_ip) VALUES (
				'$id',
				'" . limpia($telefonodid->getDidExtencion()) . "',
				'" . limpia($telefonodid->getTelefono()) . "',
				'" . limpia($telefonodid->getDescripcion()) . "',
				'" . limpia($telefonodid->getCliente()->getId()) . "',
				'" . limpia($telefonodid->getRuta()) . "',
				'" . limpia($telefonodid->getGrabar()) . "',
				'" . limpia($telefonodid->getExtencionContext()) . "',
				'" . limpia($telefonodid->getExtencion()) . "',
				'" . limpia($telefonodid->getAgente()) . "',
				'" . limpia($menu) . "',
				'" . limpia($telefonodid->getVoicemail()) . "',
				'" . limpia($telefonodid->getCampana()) . "',
				'" . limpia($telefonodid->getActivo()) . "',
				'" . limpia($telefonodid->getListId()) . "',
				'" . limpia($telefonodid->getRealCampana()) . "',
				'" . limpia(SERVER_IP_REAL) . "'
			)";
        $resp = 0;
        if (sv_mysqli_query($con, $query)) {
            $resp = 0;
            sv_mysqli_query($con, "UPDATE servers set rebuild_conf_files='Y' where generate_vicidial_conf='Y' and active_asterisk_server='Y'");
        } else {
            $resp = -1;
        }
        sv_mysqli_close($con);
        return $resp;
    }
    public static function deleteTelefonoDID($telefonodid)
    {
        $con = getConnection();
        $query = "DELETE FROM vicidial_inbound_dids WHERE did_id = '" . $telefonodid->getId() . "' LIMIT 1 ";
        $resp = 0;
        if (sv_mysqli_query($con, $query)) {
            $resp = 0;
            sv_mysqli_query($con, "UPDATE servers set rebuild_conf_files='Y' where generate_vicidial_conf='Y' and active_asterisk_server='Y'");
        } else {
            $resp = -1;
        }
        sv_mysqli_close($con);
        return $resp;
    }
}
