<?php
namespace Encuesta;

class PreguntaDatos
{
    public static function getPreguntaById(int $id, $conexion): ?Pregunta
    {
        $respuesta = null;
        if ($stmt = $conexion->prepare("SELECT id_pregunta, nombre, tipoDePregunta, textoORutaArchivo,tieneArchivo,esPregenerado,duracion,maximoIntentos,idAudio,tipoDeRespuestas,tipoDeAccionDefecto,valorDeAccionDefecto FROM dialvox_pregunta WHERE id_pregunta = ? LIMIT 1")) {
            $stmt->bind_param("i", $id);
            $stmt->execute();
            $stmt->bind_result($id_pregunta, $nombre, $tipoDePregunta, $textoORutaArchivo, $tieneArchivo, $esPregenerado, $duracion, $maximoIntentos, $idAudio, $tipoDeRespuestas, $tipoDeAccionDefecto, $valorDeAccionDefecto);
            if ($stmt->fetch()) {
                $respuesta = new Pregunta($id_pregunta, null, $nombre, $tipoDePregunta, $textoORutaArchivo, $tieneArchivo, $esPregenerado, $duracion, $maximoIntentos, $idAudio, $tipoDeRespuestas, $tipoDeAccionDefecto, $valorDeAccionDefecto);
            }
            $stmt->close();
        } else {
            echo ("1" . $conexion->error);
        }
        return $respuesta;
    }
    public static function getPreguntasByEncuesta(Encuesta $encuesta, $conexion): array
    {
        $respuesta = [];
        if ($stmt = $conexion->prepare("SELECT id_pregunta FROM dialvox_pregunta WHERE id_encuesta = ? ORDER BY id_pregunta ASC")) {
            $idEncuesta = $encuesta->getId();
            $stmt->bind_param("i", $idEncuesta);
            $stmt->execute();
            $stmt->bind_result($id_pregunta);
            $ids = array();
            while ($stmt->fetch()) {
                $ids[] = $id_pregunta;
            }
            $stmt->close();
            for ($i = 0; $i < count($ids); $i++) {
                $p = PreguntaDatos::getPreguntaById($ids[$i], $conexion);
                $p->setEncuesta($encuesta);
                $respuesta[] = $p;
            }
        }
        return $respuesta;
    }
}
